/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.thermal.V2_0;

import android.hardware.thermal.V2_0.TemperatureType;
import android.os.HidlSupport;
import android.os.HwBlob;
import android.os.HwParcel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;

public final class TemperatureThreshold {
    public int type;
    public String name = new String();
    public float[] hotThrottlingThresholds = new float[7];
    public float[] coldThrottlingThresholds = new float[7];
    public float vrThrottlingThreshold;

    public final boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (otherObject == null) {
            return false;
        }
        if (otherObject.getClass() != TemperatureThreshold.class) {
            return false;
        }
        TemperatureThreshold other = (TemperatureThreshold)otherObject;
        if (this.type != other.type) {
            return false;
        }
        if (!HidlSupport.deepEquals(this.name, other.name)) {
            return false;
        }
        if (!HidlSupport.deepEquals(this.hotThrottlingThresholds, other.hotThrottlingThresholds)) {
            return false;
        }
        if (!HidlSupport.deepEquals(this.coldThrottlingThresholds, other.coldThrottlingThresholds)) {
            return false;
        }
        return this.vrThrottlingThreshold == other.vrThrottlingThreshold;
    }

    public final int hashCode() {
        return Objects.hash(HidlSupport.deepHashCode(this.type), HidlSupport.deepHashCode(this.name), HidlSupport.deepHashCode(this.hotThrottlingThresholds), HidlSupport.deepHashCode(this.coldThrottlingThresholds), HidlSupport.deepHashCode(Float.valueOf(this.vrThrottlingThreshold)));
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append(".type = ");
        builder.append(TemperatureType.toString(this.type));
        builder.append(", .name = ");
        builder.append(this.name);
        builder.append(", .hotThrottlingThresholds = ");
        builder.append(Arrays.toString(this.hotThrottlingThresholds));
        builder.append(", .coldThrottlingThresholds = ");
        builder.append(Arrays.toString(this.coldThrottlingThresholds));
        builder.append(", .vrThrottlingThreshold = ");
        builder.append(this.vrThrottlingThreshold);
        builder.append("}");
        return builder.toString();
    }

    public final void readFromParcel(HwParcel parcel) {
        HwBlob blob = parcel.readBuffer(88L);
        this.readEmbeddedFromParcel(parcel, blob, 0L);
    }

    public static final ArrayList<TemperatureThreshold> readVectorFromParcel(HwParcel parcel) {
        ArrayList<TemperatureThreshold> _hidl_vec = new ArrayList<TemperatureThreshold>();
        HwBlob _hidl_blob = parcel.readBuffer(16L);
        int _hidl_vec_size = _hidl_blob.getInt32(8L);
        HwBlob childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 88, _hidl_blob.handle(), 0L, true);
        _hidl_vec.clear();
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            TemperatureThreshold _hidl_vec_element = new TemperatureThreshold();
            _hidl_vec_element.readEmbeddedFromParcel(parcel, childBlob, _hidl_index_0 * 88);
            _hidl_vec.add(_hidl_vec_element);
        }
        return _hidl_vec;
    }

    public final void readEmbeddedFromParcel(HwParcel parcel, HwBlob _hidl_blob, long _hidl_offset) {
        this.type = _hidl_blob.getInt32(_hidl_offset + 0L);
        this.name = _hidl_blob.getString(_hidl_offset + 8L);
        parcel.readEmbeddedBuffer(this.name.getBytes().length + 1, _hidl_blob.handle(), _hidl_offset + 8L + 0L, false);
        long _hidl_array_offset_0 = _hidl_offset + 24L;
        _hidl_blob.copyToFloatArray(_hidl_array_offset_0, this.hotThrottlingThresholds, 7);
        _hidl_array_offset_0 += 28L;
        _hidl_array_offset_0 = _hidl_offset + 52L;
        _hidl_blob.copyToFloatArray(_hidl_array_offset_0, this.coldThrottlingThresholds, 7);
        _hidl_array_offset_0 += 28L;
        this.vrThrottlingThreshold = _hidl_blob.getFloat(_hidl_offset + 80L);
    }

    public final void writeToParcel(HwParcel parcel) {
        HwBlob _hidl_blob = new HwBlob(88);
        this.writeEmbeddedToBlob(_hidl_blob, 0L);
        parcel.writeBuffer(_hidl_blob);
    }

    public static final void writeVectorToParcel(HwParcel parcel, ArrayList<TemperatureThreshold> _hidl_vec) {
        HwBlob _hidl_blob = new HwBlob(16);
        int _hidl_vec_size = _hidl_vec.size();
        _hidl_blob.putInt32(8L, _hidl_vec_size);
        _hidl_blob.putBool(12L, false);
        HwBlob childBlob = new HwBlob(_hidl_vec_size * 88);
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            _hidl_vec.get(_hidl_index_0).writeEmbeddedToBlob(childBlob, _hidl_index_0 * 88);
        }
        _hidl_blob.putBlob(0L, childBlob);
        parcel.writeBuffer(_hidl_blob);
    }

    public final void writeEmbeddedToBlob(HwBlob _hidl_blob, long _hidl_offset) {
        _hidl_blob.putInt32(_hidl_offset + 0L, this.type);
        _hidl_blob.putString(_hidl_offset + 8L, this.name);
        long _hidl_array_offset_0 = _hidl_offset + 24L;
        float[] _hidl_array_item_0 = this.hotThrottlingThresholds;
        if (_hidl_array_item_0 == null || _hidl_array_item_0.length != 7) {
            throw new IllegalArgumentException("Array element is not of the expected length");
        }
        _hidl_blob.putFloatArray(_hidl_array_offset_0, _hidl_array_item_0);
        _hidl_array_offset_0 += 28L;
        _hidl_array_offset_0 = _hidl_offset + 52L;
        _hidl_array_item_0 = this.coldThrottlingThresholds;
        if (_hidl_array_item_0 == null || _hidl_array_item_0.length != 7) {
            throw new IllegalArgumentException("Array element is not of the expected length");
        }
        _hidl_blob.putFloatArray(_hidl_array_offset_0, _hidl_array_item_0);
        _hidl_array_offset_0 += 28L;
        _hidl_blob.putFloat(_hidl_offset + 80L, this.vrThrottlingThreshold);
    }
}

