/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.usb;

import android.hardware.usb.UsbAccessory;
import com.android.internal.util.dump.DualDumpOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class AccessoryFilter {
    public final String mManufacturer;
    public final String mModel;
    public final String mVersion;

    public AccessoryFilter(String manufacturer, String model, String version) {
        this.mManufacturer = manufacturer;
        this.mModel = model;
        this.mVersion = version;
    }

    public AccessoryFilter(UsbAccessory accessory) {
        this.mManufacturer = accessory.getManufacturer();
        this.mModel = accessory.getModel();
        this.mVersion = accessory.getVersion();
    }

    public static AccessoryFilter read(XmlPullParser parser) throws XmlPullParserException, IOException {
        String manufacturer = null;
        String model = null;
        String version = null;
        int count = parser.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if ("manufacturer".equals(name)) {
                manufacturer = value;
                continue;
            }
            if ("model".equals(name)) {
                model = value;
                continue;
            }
            if (!"version".equals(name)) continue;
            version = value;
        }
        return new AccessoryFilter(manufacturer, model, version);
    }

    public void write(XmlSerializer serializer) throws IOException {
        serializer.startTag(null, "usb-accessory");
        if (this.mManufacturer != null) {
            serializer.attribute(null, "manufacturer", this.mManufacturer);
        }
        if (this.mModel != null) {
            serializer.attribute(null, "model", this.mModel);
        }
        if (this.mVersion != null) {
            serializer.attribute(null, "version", this.mVersion);
        }
        serializer.endTag(null, "usb-accessory");
    }

    public boolean matches(UsbAccessory acc) {
        if (this.mManufacturer != null && !acc.getManufacturer().equals(this.mManufacturer)) {
            return false;
        }
        if (this.mModel != null && !acc.getModel().equals(this.mModel)) {
            return false;
        }
        return this.mVersion == null || acc.getVersion().equals(this.mVersion);
    }

    public boolean contains(AccessoryFilter accessory) {
        if (this.mManufacturer != null && !Objects.equals(accessory.mManufacturer, this.mManufacturer)) {
            return false;
        }
        if (this.mModel != null && !Objects.equals(accessory.mModel, this.mModel)) {
            return false;
        }
        return this.mVersion == null || Objects.equals(accessory.mVersion, this.mVersion);
    }

    public boolean equals(Object obj) {
        if (this.mManufacturer == null || this.mModel == null || this.mVersion == null) {
            return false;
        }
        if (obj instanceof AccessoryFilter) {
            AccessoryFilter filter = (AccessoryFilter)obj;
            return this.mManufacturer.equals(filter.mManufacturer) && this.mModel.equals(filter.mModel) && this.mVersion.equals(filter.mVersion);
        }
        if (obj instanceof UsbAccessory) {
            UsbAccessory accessory = (UsbAccessory)obj;
            return this.mManufacturer.equals(accessory.getManufacturer()) && this.mModel.equals(accessory.getModel()) && this.mVersion.equals(accessory.getVersion());
        }
        return false;
    }

    public int hashCode() {
        return (this.mManufacturer == null ? 0 : this.mManufacturer.hashCode()) ^ (this.mModel == null ? 0 : this.mModel.hashCode()) ^ (this.mVersion == null ? 0 : this.mVersion.hashCode());
    }

    public String toString() {
        return "AccessoryFilter[mManufacturer=\"" + this.mManufacturer + "\", mModel=\"" + this.mModel + "\", mVersion=\"" + this.mVersion + "\"]";
    }

    public void dump(DualDumpOutputStream dump, String idName, long id2) {
        long token = dump.start(idName, id2);
        dump.write("manufacturer", 0x10900000001L, this.mManufacturer);
        dump.write("model", 1138166333442L, this.mModel);
        dump.write("version", 1138166333443L, this.mVersion);
        dump.end(token);
    }
}

