/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.usb.V1_2;

import android.hardware.usb.V1_1.PortStatus_1_1;
import android.hardware.usb.V1_2.ContaminantDetectionStatus;
import android.hardware.usb.V1_2.ContaminantProtectionMode;
import android.hardware.usb.V1_2.ContaminantProtectionStatus;
import android.os.HidlSupport;
import android.os.HwBlob;
import android.os.HwParcel;
import java.util.ArrayList;
import java.util.Objects;

public final class PortStatus {
    public PortStatus_1_1 status_1_1 = new PortStatus_1_1();
    public int supportedContaminantProtectionModes;
    public boolean supportsEnableContaminantPresenceProtection;
    public int contaminantProtectionStatus;
    public boolean supportsEnableContaminantPresenceDetection;
    public int contaminantDetectionStatus;

    public final boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (otherObject == null) {
            return false;
        }
        if (otherObject.getClass() != PortStatus.class) {
            return false;
        }
        PortStatus other = (PortStatus)otherObject;
        if (!HidlSupport.deepEquals(this.status_1_1, other.status_1_1)) {
            return false;
        }
        if (!HidlSupport.deepEquals(this.supportedContaminantProtectionModes, other.supportedContaminantProtectionModes)) {
            return false;
        }
        if (this.supportsEnableContaminantPresenceProtection != other.supportsEnableContaminantPresenceProtection) {
            return false;
        }
        if (this.contaminantProtectionStatus != other.contaminantProtectionStatus) {
            return false;
        }
        if (this.supportsEnableContaminantPresenceDetection != other.supportsEnableContaminantPresenceDetection) {
            return false;
        }
        return this.contaminantDetectionStatus == other.contaminantDetectionStatus;
    }

    public final int hashCode() {
        return Objects.hash(HidlSupport.deepHashCode(this.status_1_1), HidlSupport.deepHashCode(this.supportedContaminantProtectionModes), HidlSupport.deepHashCode(this.supportsEnableContaminantPresenceProtection), HidlSupport.deepHashCode(this.contaminantProtectionStatus), HidlSupport.deepHashCode(this.supportsEnableContaminantPresenceDetection), HidlSupport.deepHashCode(this.contaminantDetectionStatus));
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append(".status_1_1 = ");
        builder.append(this.status_1_1);
        builder.append(", .supportedContaminantProtectionModes = ");
        builder.append(ContaminantProtectionMode.dumpBitfield(this.supportedContaminantProtectionModes));
        builder.append(", .supportsEnableContaminantPresenceProtection = ");
        builder.append(this.supportsEnableContaminantPresenceProtection);
        builder.append(", .contaminantProtectionStatus = ");
        builder.append(ContaminantProtectionStatus.toString(this.contaminantProtectionStatus));
        builder.append(", .supportsEnableContaminantPresenceDetection = ");
        builder.append(this.supportsEnableContaminantPresenceDetection);
        builder.append(", .contaminantDetectionStatus = ");
        builder.append(ContaminantDetectionStatus.toString(this.contaminantDetectionStatus));
        builder.append("}");
        return builder.toString();
    }

    public final void readFromParcel(HwParcel parcel) {
        HwBlob blob = parcel.readBuffer(72L);
        this.readEmbeddedFromParcel(parcel, blob, 0L);
    }

    public static final ArrayList<PortStatus> readVectorFromParcel(HwParcel parcel) {
        ArrayList<PortStatus> _hidl_vec = new ArrayList<PortStatus>();
        HwBlob _hidl_blob = parcel.readBuffer(16L);
        int _hidl_vec_size = _hidl_blob.getInt32(8L);
        HwBlob childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 72, _hidl_blob.handle(), 0L, true);
        _hidl_vec.clear();
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            PortStatus _hidl_vec_element = new PortStatus();
            _hidl_vec_element.readEmbeddedFromParcel(parcel, childBlob, _hidl_index_0 * 72);
            _hidl_vec.add(_hidl_vec_element);
        }
        return _hidl_vec;
    }

    public final void readEmbeddedFromParcel(HwParcel parcel, HwBlob _hidl_blob, long _hidl_offset) {
        this.status_1_1.readEmbeddedFromParcel(parcel, _hidl_blob, _hidl_offset + 0L);
        this.supportedContaminantProtectionModes = _hidl_blob.getInt32(_hidl_offset + 48L);
        this.supportsEnableContaminantPresenceProtection = _hidl_blob.getBool(_hidl_offset + 52L);
        this.contaminantProtectionStatus = _hidl_blob.getInt32(_hidl_offset + 56L);
        this.supportsEnableContaminantPresenceDetection = _hidl_blob.getBool(_hidl_offset + 60L);
        this.contaminantDetectionStatus = _hidl_blob.getInt32(_hidl_offset + 64L);
    }

    public final void writeToParcel(HwParcel parcel) {
        HwBlob _hidl_blob = new HwBlob(72);
        this.writeEmbeddedToBlob(_hidl_blob, 0L);
        parcel.writeBuffer(_hidl_blob);
    }

    public static final void writeVectorToParcel(HwParcel parcel, ArrayList<PortStatus> _hidl_vec) {
        HwBlob _hidl_blob = new HwBlob(16);
        int _hidl_vec_size = _hidl_vec.size();
        _hidl_blob.putInt32(8L, _hidl_vec_size);
        _hidl_blob.putBool(12L, false);
        HwBlob childBlob = new HwBlob(_hidl_vec_size * 72);
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            _hidl_vec.get(_hidl_index_0).writeEmbeddedToBlob(childBlob, _hidl_index_0 * 72);
        }
        _hidl_blob.putBlob(0L, childBlob);
        parcel.writeBuffer(_hidl_blob);
    }

    public final void writeEmbeddedToBlob(HwBlob _hidl_blob, long _hidl_offset) {
        this.status_1_1.writeEmbeddedToBlob(_hidl_blob, _hidl_offset + 0L);
        _hidl_blob.putInt32(_hidl_offset + 48L, this.supportedContaminantProtectionModes);
        _hidl_blob.putBool(_hidl_offset + 52L, this.supportsEnableContaminantPresenceProtection);
        _hidl_blob.putInt32(_hidl_offset + 56L, this.contaminantProtectionStatus);
        _hidl_blob.putBool(_hidl_offset + 60L, this.supportsEnableContaminantPresenceDetection);
        _hidl_blob.putInt32(_hidl_offset + 64L, this.contaminantDetectionStatus);
    }
}

