/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.weaver.V1_0;

import android.os.HidlSupport;
import android.os.HwBlob;
import android.os.HwParcel;
import java.util.ArrayList;
import java.util.Objects;

public final class WeaverReadResponse {
    public int timeout;
    public ArrayList<Byte> value = new ArrayList();

    public final boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (otherObject == null) {
            return false;
        }
        if (otherObject.getClass() != WeaverReadResponse.class) {
            return false;
        }
        WeaverReadResponse other = (WeaverReadResponse)otherObject;
        if (this.timeout != other.timeout) {
            return false;
        }
        return HidlSupport.deepEquals(this.value, other.value);
    }

    public final int hashCode() {
        return Objects.hash(HidlSupport.deepHashCode(this.timeout), HidlSupport.deepHashCode(this.value));
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append(".timeout = ");
        builder.append(this.timeout);
        builder.append(", .value = ");
        builder.append(this.value);
        builder.append("}");
        return builder.toString();
    }

    public final void readFromParcel(HwParcel parcel) {
        HwBlob blob = parcel.readBuffer(24L);
        this.readEmbeddedFromParcel(parcel, blob, 0L);
    }

    public static final ArrayList<WeaverReadResponse> readVectorFromParcel(HwParcel parcel) {
        ArrayList<WeaverReadResponse> _hidl_vec = new ArrayList<WeaverReadResponse>();
        HwBlob _hidl_blob = parcel.readBuffer(16L);
        int _hidl_vec_size = _hidl_blob.getInt32(8L);
        HwBlob childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 24, _hidl_blob.handle(), 0L, true);
        _hidl_vec.clear();
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            WeaverReadResponse _hidl_vec_element = new WeaverReadResponse();
            _hidl_vec_element.readEmbeddedFromParcel(parcel, childBlob, _hidl_index_0 * 24);
            _hidl_vec.add(_hidl_vec_element);
        }
        return _hidl_vec;
    }

    public final void readEmbeddedFromParcel(HwParcel parcel, HwBlob _hidl_blob, long _hidl_offset) {
        this.timeout = _hidl_blob.getInt32(_hidl_offset + 0L);
        int _hidl_vec_size = _hidl_blob.getInt32(_hidl_offset + 8L + 8L);
        HwBlob childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 1, _hidl_blob.handle(), _hidl_offset + 8L + 0L, true);
        this.value.clear();
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            byte _hidl_vec_element = childBlob.getInt8(_hidl_index_0 * 1);
            this.value.add(_hidl_vec_element);
        }
    }

    public final void writeToParcel(HwParcel parcel) {
        HwBlob _hidl_blob = new HwBlob(24);
        this.writeEmbeddedToBlob(_hidl_blob, 0L);
        parcel.writeBuffer(_hidl_blob);
    }

    public static final void writeVectorToParcel(HwParcel parcel, ArrayList<WeaverReadResponse> _hidl_vec) {
        HwBlob _hidl_blob = new HwBlob(16);
        int _hidl_vec_size = _hidl_vec.size();
        _hidl_blob.putInt32(8L, _hidl_vec_size);
        _hidl_blob.putBool(12L, false);
        HwBlob childBlob = new HwBlob(_hidl_vec_size * 24);
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            _hidl_vec.get(_hidl_index_0).writeEmbeddedToBlob(childBlob, _hidl_index_0 * 24);
        }
        _hidl_blob.putBlob(0L, childBlob);
        parcel.writeBuffer(_hidl_blob);
    }

    public final void writeEmbeddedToBlob(HwBlob _hidl_blob, long _hidl_offset) {
        _hidl_blob.putInt32(_hidl_offset + 0L, this.timeout);
        int _hidl_vec_size = this.value.size();
        _hidl_blob.putInt32(_hidl_offset + 8L + 8L, _hidl_vec_size);
        _hidl_blob.putBool(_hidl_offset + 8L + 12L, false);
        HwBlob childBlob = new HwBlob(_hidl_vec_size * 1);
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            childBlob.putInt8(_hidl_index_0 * 1, this.value.get(_hidl_index_0));
        }
        _hidl_blob.putBlob(_hidl_offset + 8L + 0L, childBlob);
    }
}

