/*
 * Decompiled with CFR 0.152.
 */
package android.hidl.base.V1_0;

import android.os.HidlSupport;
import android.os.HwBlob;
import android.os.HwParcel;
import java.util.ArrayList;
import java.util.Objects;

public final class DebugInfo {
    public int pid;
    public long ptr;
    public int arch;

    public final boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (otherObject == null) {
            return false;
        }
        if (otherObject.getClass() != DebugInfo.class) {
            return false;
        }
        DebugInfo other = (DebugInfo)otherObject;
        if (this.pid != other.pid) {
            return false;
        }
        if (this.ptr != other.ptr) {
            return false;
        }
        return this.arch == other.arch;
    }

    public final int hashCode() {
        return Objects.hash(HidlSupport.deepHashCode(this.pid), HidlSupport.deepHashCode(this.ptr), HidlSupport.deepHashCode(this.arch));
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append(".pid = ");
        builder.append(this.pid);
        builder.append(", .ptr = ");
        builder.append(this.ptr);
        builder.append(", .arch = ");
        builder.append(Architecture.toString(this.arch));
        builder.append("}");
        return builder.toString();
    }

    public final void readFromParcel(HwParcel parcel) {
        HwBlob blob = parcel.readBuffer(24L);
        this.readEmbeddedFromParcel(parcel, blob, 0L);
    }

    public static final ArrayList<DebugInfo> readVectorFromParcel(HwParcel parcel) {
        ArrayList<DebugInfo> _hidl_vec = new ArrayList<DebugInfo>();
        HwBlob _hidl_blob = parcel.readBuffer(16L);
        int _hidl_vec_size = _hidl_blob.getInt32(8L);
        HwBlob childBlob = parcel.readEmbeddedBuffer(_hidl_vec_size * 24, _hidl_blob.handle(), 0L, true);
        _hidl_vec.clear();
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            DebugInfo _hidl_vec_element = new DebugInfo();
            _hidl_vec_element.readEmbeddedFromParcel(parcel, childBlob, _hidl_index_0 * 24);
            _hidl_vec.add(_hidl_vec_element);
        }
        return _hidl_vec;
    }

    public final void readEmbeddedFromParcel(HwParcel parcel, HwBlob _hidl_blob, long _hidl_offset) {
        this.pid = _hidl_blob.getInt32(_hidl_offset + 0L);
        this.ptr = _hidl_blob.getInt64(_hidl_offset + 8L);
        this.arch = _hidl_blob.getInt32(_hidl_offset + 16L);
    }

    public final void writeToParcel(HwParcel parcel) {
        HwBlob _hidl_blob = new HwBlob(24);
        this.writeEmbeddedToBlob(_hidl_blob, 0L);
        parcel.writeBuffer(_hidl_blob);
    }

    public static final void writeVectorToParcel(HwParcel parcel, ArrayList<DebugInfo> _hidl_vec) {
        HwBlob _hidl_blob = new HwBlob(16);
        int _hidl_vec_size = _hidl_vec.size();
        _hidl_blob.putInt32(8L, _hidl_vec_size);
        _hidl_blob.putBool(12L, false);
        HwBlob childBlob = new HwBlob(_hidl_vec_size * 24);
        for (int _hidl_index_0 = 0; _hidl_index_0 < _hidl_vec_size; ++_hidl_index_0) {
            _hidl_vec.get(_hidl_index_0).writeEmbeddedToBlob(childBlob, _hidl_index_0 * 24);
        }
        _hidl_blob.putBlob(0L, childBlob);
        parcel.writeBuffer(_hidl_blob);
    }

    public final void writeEmbeddedToBlob(HwBlob _hidl_blob, long _hidl_offset) {
        _hidl_blob.putInt32(_hidl_offset + 0L, this.pid);
        _hidl_blob.putInt64(_hidl_offset + 8L, this.ptr);
        _hidl_blob.putInt32(_hidl_offset + 16L, this.arch);
    }

    public static final class Architecture {
        public static final int UNKNOWN = 0;
        public static final int IS_64BIT = 1;
        public static final int IS_32BIT = 2;

        public static final String toString(int o) {
            if (o == 0) {
                return "UNKNOWN";
            }
            if (o == 1) {
                return "IS_64BIT";
            }
            if (o == 2) {
                return "IS_32BIT";
            }
            return "0x" + Integer.toHexString(o);
        }

        public static final String dumpBitfield(int o) {
            ArrayList<String> list = new ArrayList<String>();
            int flipped = 0;
            list.add("UNKNOWN");
            if ((o & 1) == 1) {
                list.add("IS_64BIT");
                flipped |= 1;
            }
            if ((o & 2) == 2) {
                list.add("IS_32BIT");
                flipped |= 2;
            }
            if (o != flipped) {
                list.add("0x" + Integer.toHexString(o & ~flipped));
            }
            return String.join((CharSequence)" | ", list);
        }
    }
}

