/*
 * Decompiled with CFR 0.152.
 */
package android.inputmethodservice;

import android.graphics.Rect;
import android.inputmethodservice.MultiClientInputMethodServiceDelegate;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.ResultReceiver;
import android.view.InputChannel;
import android.view.InputEvent;
import android.view.InputEventReceiver;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.inputmethod.CompletionInfo;
import android.view.inputmethod.CursorAnchorInfo;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.ExtractedText;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.inputmethod.IMultiClientInputMethodSession;
import com.android.internal.os.SomeArgs;
import com.android.internal.util.function.pooled.PooledLambda;
import com.android.internal.view.IInputContext;
import com.android.internal.view.IInputMethodSession;
import com.android.internal.view.InputConnectionWrapper;
import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicBoolean;

final class MultiClientInputMethodClientCallbackAdaptor {
    static final boolean DEBUG = false;
    static final String TAG = MultiClientInputMethodClientCallbackAdaptor.class.getSimpleName();
    private final Object mSessionLock = new Object();
    @GuardedBy(value={"mSessionLock"})
    CallbackImpl mCallbackImpl;
    @GuardedBy(value={"mSessionLock"})
    InputChannel mReadChannel;
    @GuardedBy(value={"mSessionLock"})
    KeyEvent.DispatcherState mDispatcherState;
    @GuardedBy(value={"mSessionLock"})
    Handler mHandler;
    @GuardedBy(value={"mSessionLock"})
    InputEventReceiver mInputEventReceiver;
    private final AtomicBoolean mFinished = new AtomicBoolean(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IInputMethodSession.Stub createIInputMethodSession() {
        Object object = this.mSessionLock;
        synchronized (object) {
            return new InputMethodSessionImpl(this.mSessionLock, this.mCallbackImpl, this.mHandler, this.mFinished);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IMultiClientInputMethodSession.Stub createIMultiClientInputMethodSession() {
        Object object = this.mSessionLock;
        synchronized (object) {
            return new MultiClientInputMethodSessionImpl(this.mSessionLock, this.mCallbackImpl, this.mHandler, this.mFinished);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MultiClientInputMethodClientCallbackAdaptor(MultiClientInputMethodServiceDelegate.ClientCallback clientCallback, Looper looper, KeyEvent.DispatcherState dispatcherState, InputChannel readChannel) {
        Object object = this.mSessionLock;
        synchronized (object) {
            this.mCallbackImpl = new CallbackImpl(this, clientCallback);
            this.mDispatcherState = dispatcherState;
            this.mHandler = new Handler(looper, null, true);
            this.mReadChannel = readChannel;
            this.mInputEventReceiver = new ImeInputEventReceiver(this.mReadChannel, this.mHandler.getLooper(), this.mFinished, this.mDispatcherState, this.mCallbackImpl.mOriginalCallback);
        }
    }

    private static void reportNotSupported() {
    }

    private static final class CallbackImpl {
        private final MultiClientInputMethodClientCallbackAdaptor mCallbackAdaptor;
        private final MultiClientInputMethodServiceDelegate.ClientCallback mOriginalCallback;
        private boolean mFinished = false;

        CallbackImpl(MultiClientInputMethodClientCallbackAdaptor callbackAdaptor, MultiClientInputMethodServiceDelegate.ClientCallback callback) {
            this.mCallbackAdaptor = callbackAdaptor;
            this.mOriginalCallback = callback;
        }

        void updateSelection(SomeArgs args) {
            try {
                if (this.mFinished) {
                    return;
                }
                this.mOriginalCallback.onUpdateSelection(args.argi1, args.argi2, args.argi3, args.argi4, args.argi5, args.argi6);
            }
            finally {
                args.recycle();
            }
        }

        void displayCompletions(CompletionInfo[] completions) {
            if (this.mFinished) {
                return;
            }
            this.mOriginalCallback.onDisplayCompletions(completions);
        }

        void appPrivateCommand(String action, Bundle data) {
            if (this.mFinished) {
                return;
            }
            this.mOriginalCallback.onAppPrivateCommand(action, data);
        }

        void toggleSoftInput(int showFlags, int hideFlags) {
            if (this.mFinished) {
                return;
            }
            this.mOriginalCallback.onToggleSoftInput(showFlags, hideFlags);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void finishSession() {
            if (this.mFinished) {
                return;
            }
            this.mFinished = true;
            this.mOriginalCallback.onFinishSession();
            Object object = this.mCallbackAdaptor.mSessionLock;
            synchronized (object) {
                this.mCallbackAdaptor.mDispatcherState = null;
                if (this.mCallbackAdaptor.mReadChannel != null) {
                    this.mCallbackAdaptor.mReadChannel.dispose();
                    this.mCallbackAdaptor.mReadChannel = null;
                }
                this.mCallbackAdaptor.mInputEventReceiver = null;
            }
        }

        void updateCursorAnchorInfo(CursorAnchorInfo info) {
            if (this.mFinished) {
                return;
            }
            this.mOriginalCallback.onUpdateCursorAnchorInfo(info);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void startInputOrWindowGainedFocus(SomeArgs args) {
            try {
                if (this.mFinished) {
                    return;
                }
                InputConnectionWrapper inputConnection = (InputConnectionWrapper)args.arg1;
                EditorInfo editorInfo = (EditorInfo)args.arg2;
                int startInputFlags = args.argi1;
                int softInputMode = args.argi2;
                int windowHandle = args.argi3;
                this.mOriginalCallback.onStartInputOrWindowGainedFocus(inputConnection, editorInfo, startInputFlags, softInputMode, windowHandle);
            }
            finally {
                args.recycle();
            }
        }

        void showSoftInput(int flags, ResultReceiver resultReceiver) {
            if (this.mFinished) {
                return;
            }
            this.mOriginalCallback.onShowSoftInput(flags, resultReceiver);
        }

        void hideSoftInput(int flags, ResultReceiver resultReceiver) {
            if (this.mFinished) {
                return;
            }
            this.mOriginalCallback.onHideSoftInput(flags, resultReceiver);
        }
    }

    private static final class MultiClientInputMethodSessionImpl
    extends IMultiClientInputMethodSession.Stub {
        private final Object mSessionLock;
        @GuardedBy(value={"mSessionLock"})
        private CallbackImpl mCallbackImpl;
        @GuardedBy(value={"mSessionLock"})
        private Handler mHandler;
        private final AtomicBoolean mSessionFinished;

        MultiClientInputMethodSessionImpl(Object lock, CallbackImpl callback, Handler handler, AtomicBoolean sessionFinished) {
            this.mSessionLock = lock;
            this.mCallbackImpl = callback;
            this.mHandler = handler;
            this.mSessionFinished = sessionFinished;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void startInputOrWindowGainedFocus(IInputContext inputContext, int missingMethods, EditorInfo editorInfo, int controlFlags, int softInputMode, int windowHandle) {
            Object object = this.mSessionLock;
            synchronized (object) {
                if (this.mCallbackImpl == null || this.mHandler == null) {
                    return;
                }
                SomeArgs args = SomeArgs.obtain();
                WeakReference<Object> fakeIMS = new WeakReference<Object>(null);
                args.arg1 = inputContext == null ? null : new InputConnectionWrapper(fakeIMS, inputContext, missingMethods, this.mSessionFinished);
                args.arg2 = editorInfo;
                args.argi1 = controlFlags;
                args.argi2 = softInputMode;
                args.argi3 = windowHandle;
                this.mHandler.sendMessage(PooledLambda.obtainMessage(CallbackImpl::startInputOrWindowGainedFocus, this.mCallbackImpl, args));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void showSoftInput(int flags, ResultReceiver resultReceiver) {
            Object object = this.mSessionLock;
            synchronized (object) {
                if (this.mCallbackImpl == null || this.mHandler == null) {
                    return;
                }
                this.mHandler.sendMessage(PooledLambda.obtainMessage(CallbackImpl::showSoftInput, this.mCallbackImpl, flags, resultReceiver));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void hideSoftInput(int flags, ResultReceiver resultReceiver) {
            Object object = this.mSessionLock;
            synchronized (object) {
                if (this.mCallbackImpl == null || this.mHandler == null) {
                    return;
                }
                this.mHandler.sendMessage(PooledLambda.obtainMessage(CallbackImpl::hideSoftInput, this.mCallbackImpl, flags, resultReceiver));
            }
        }
    }

    private static final class InputMethodSessionImpl
    extends IInputMethodSession.Stub {
        private final Object mSessionLock;
        @GuardedBy(value={"mSessionLock"})
        private CallbackImpl mCallbackImpl;
        @GuardedBy(value={"mSessionLock"})
        private Handler mHandler;
        private final AtomicBoolean mSessionFinished;

        InputMethodSessionImpl(Object lock, CallbackImpl callback, Handler handler, AtomicBoolean sessionFinished) {
            this.mSessionLock = lock;
            this.mCallbackImpl = callback;
            this.mHandler = handler;
            this.mSessionFinished = sessionFinished;
        }

        @Override
        public void updateExtractedText(int token, ExtractedText text) {
            MultiClientInputMethodClientCallbackAdaptor.reportNotSupported();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void updateSelection(int oldSelStart, int oldSelEnd, int newSelStart, int newSelEnd, int candidatesStart, int candidatesEnd) {
            Object object = this.mSessionLock;
            synchronized (object) {
                if (this.mCallbackImpl == null || this.mHandler == null) {
                    return;
                }
                SomeArgs args = SomeArgs.obtain();
                args.argi1 = oldSelStart;
                args.argi2 = oldSelEnd;
                args.argi3 = newSelStart;
                args.argi4 = newSelEnd;
                args.argi5 = candidatesStart;
                args.argi6 = candidatesEnd;
                this.mHandler.sendMessage(PooledLambda.obtainMessage(CallbackImpl::updateSelection, this.mCallbackImpl, args));
            }
        }

        @Override
        public void viewClicked(boolean focusChanged) {
            MultiClientInputMethodClientCallbackAdaptor.reportNotSupported();
        }

        @Override
        public void updateCursor(Rect newCursor) {
            MultiClientInputMethodClientCallbackAdaptor.reportNotSupported();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void displayCompletions(CompletionInfo[] completions) {
            Object object = this.mSessionLock;
            synchronized (object) {
                if (this.mCallbackImpl == null || this.mHandler == null) {
                    return;
                }
                this.mHandler.sendMessage(PooledLambda.obtainMessage(CallbackImpl::displayCompletions, this.mCallbackImpl, completions));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void appPrivateCommand(String action, Bundle data) {
            Object object = this.mSessionLock;
            synchronized (object) {
                if (this.mCallbackImpl == null || this.mHandler == null) {
                    return;
                }
                this.mHandler.sendMessage(PooledLambda.obtainMessage(CallbackImpl::appPrivateCommand, this.mCallbackImpl, action, data));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void toggleSoftInput(int showFlags, int hideFlags) {
            Object object = this.mSessionLock;
            synchronized (object) {
                if (this.mCallbackImpl == null || this.mHandler == null) {
                    return;
                }
                this.mHandler.sendMessage(PooledLambda.obtainMessage(CallbackImpl::toggleSoftInput, this.mCallbackImpl, showFlags, hideFlags));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void finishSession() {
            Object object = this.mSessionLock;
            synchronized (object) {
                if (this.mCallbackImpl == null || this.mHandler == null) {
                    return;
                }
                this.mSessionFinished.set(true);
                this.mHandler.sendMessage(PooledLambda.obtainMessage(CallbackImpl::finishSession, this.mCallbackImpl));
                this.mCallbackImpl = null;
                this.mHandler = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void updateCursorAnchorInfo(CursorAnchorInfo info) {
            Object object = this.mSessionLock;
            synchronized (object) {
                if (this.mCallbackImpl == null || this.mHandler == null) {
                    return;
                }
                this.mHandler.sendMessage(PooledLambda.obtainMessage(CallbackImpl::updateCursorAnchorInfo, this.mCallbackImpl, info));
            }
        }

        @Override
        public final void notifyImeHidden() {
            MultiClientInputMethodClientCallbackAdaptor.reportNotSupported();
        }
    }

    private static final class ImeInputEventReceiver
    extends InputEventReceiver {
        private final AtomicBoolean mFinished;
        private final KeyEvent.DispatcherState mDispatcherState;
        private final MultiClientInputMethodServiceDelegate.ClientCallback mClientCallback;
        private final KeyEventCallbackAdaptor mKeyEventCallbackAdaptor;

        ImeInputEventReceiver(InputChannel readChannel, Looper looper, AtomicBoolean finished, KeyEvent.DispatcherState dispatcherState, MultiClientInputMethodServiceDelegate.ClientCallback callback) {
            super(readChannel, looper);
            this.mFinished = finished;
            this.mDispatcherState = dispatcherState;
            this.mClientCallback = callback;
            this.mKeyEventCallbackAdaptor = new KeyEventCallbackAdaptor(callback);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onInputEvent(InputEvent event) {
            if (this.mFinished.get()) {
                this.finishInputEvent(event, false);
                return;
            }
            boolean handled = false;
            try {
                if (event instanceof KeyEvent) {
                    KeyEvent keyEvent = (KeyEvent)event;
                    handled = keyEvent.dispatch(this.mKeyEventCallbackAdaptor, this.mDispatcherState, this.mKeyEventCallbackAdaptor);
                } else {
                    MotionEvent motionEvent = (MotionEvent)event;
                    handled = motionEvent.isFromSource(4) ? this.mClientCallback.onTrackballEvent(motionEvent) : this.mClientCallback.onGenericMotionEvent(motionEvent);
                }
            }
            finally {
                this.finishInputEvent(event, handled);
            }
        }
    }

    private static final class KeyEventCallbackAdaptor
    implements KeyEvent.Callback {
        private final MultiClientInputMethodServiceDelegate.ClientCallback mLocalCallback;

        KeyEventCallbackAdaptor(MultiClientInputMethodServiceDelegate.ClientCallback callback) {
            this.mLocalCallback = callback;
        }

        @Override
        public boolean onKeyDown(int keyCode, KeyEvent event) {
            return this.mLocalCallback.onKeyDown(keyCode, event);
        }

        @Override
        public boolean onKeyLongPress(int keyCode, KeyEvent event) {
            return this.mLocalCallback.onKeyLongPress(keyCode, event);
        }

        @Override
        public boolean onKeyUp(int keyCode, KeyEvent event) {
            return this.mLocalCallback.onKeyUp(keyCode, event);
        }

        @Override
        public boolean onKeyMultiple(int keyCode, int count, KeyEvent event) {
            return this.mLocalCallback.onKeyMultiple(keyCode, event);
        }
    }
}

