/*
 * Decompiled with CFR 0.152.
 */
package android.inputmethodservice;

import android.content.Context;
import android.content.Intent;
import android.inputmethodservice.MultiClientInputMethodClientCallbackAdaptor;
import android.inputmethodservice.MultiClientInputMethodServiceDelegate;
import android.os.IBinder;
import android.os.Looper;
import android.util.Log;
import android.view.InputChannel;
import android.view.KeyEvent;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.inputmethod.IMultiClientInputMethod;
import com.android.internal.inputmethod.IMultiClientInputMethodPrivilegedOperations;
import com.android.internal.inputmethod.MultiClientInputMethodPrivilegedOperations;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;

final class MultiClientInputMethodServiceDelegateImpl {
    private static final String TAG = "MultiClientInputMethodServiceDelegateImpl";
    private final Object mLock = new Object();
    @GuardedBy(value={"mLock"})
    private int mInitializationPhase = 1;
    private final MultiClientInputMethodPrivilegedOperations mPrivOps = new MultiClientInputMethodPrivilegedOperations();
    private final MultiClientInputMethodServiceDelegate.ServiceCallback mServiceCallback;
    private final Context mContext;

    MultiClientInputMethodServiceDelegateImpl(Context context, MultiClientInputMethodServiceDelegate.ServiceCallback serviceCallback) {
        this.mContext = context;
        this.mServiceCallback = serviceCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onDestroy() {
        Object object = this.mLock;
        synchronized (object) {
            switch (this.mInitializationPhase) {
                case 1: 
                case 4: {
                    this.mInitializationPhase = 5;
                    break;
                }
                default: {
                    Log.e(TAG, "unexpected state=" + this.mInitializationPhase);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IBinder onBind(Intent intent) {
        Object object = this.mLock;
        synchronized (object) {
            switch (this.mInitializationPhase) {
                case 1: {
                    this.mInitializationPhase = 2;
                    return new ServiceImpl(this);
                }
            }
            Log.e(TAG, "unexpected state=" + this.mInitializationPhase);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean onUnbind(Intent intent) {
        Object object = this.mLock;
        synchronized (object) {
            switch (this.mInitializationPhase) {
                case 2: 
                case 3: {
                    this.mInitializationPhase = 4;
                    this.mPrivOps.dispose();
                    break;
                }
                default: {
                    Log.e(TAG, "unexpected state=" + this.mInitializationPhase);
                }
            }
        }
        return false;
    }

    IBinder createInputMethodWindowToken(int displayId) {
        return this.mPrivOps.createInputMethodWindowToken(displayId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void acceptClient(int clientId, MultiClientInputMethodServiceDelegate.ClientCallback clientCallback, KeyEvent.DispatcherState dispatcherState, Looper looper) {
        InputChannel[] channels = InputChannel.openInputChannelPair("MSIMS-session");
        InputChannel writeChannel = channels[0];
        InputChannel readChannel = channels[1];
        try {
            MultiClientInputMethodClientCallbackAdaptor callbackAdaptor = new MultiClientInputMethodClientCallbackAdaptor(clientCallback, looper, dispatcherState, readChannel);
            this.mPrivOps.acceptClient(clientId, callbackAdaptor.createIInputMethodSession(), callbackAdaptor.createIMultiClientInputMethodSession(), writeChannel);
        }
        finally {
            writeChannel.dispose();
        }
    }

    void reportImeWindowTarget(int clientId, int targetWindowHandle, IBinder imeWindowToken) {
        this.mPrivOps.reportImeWindowTarget(clientId, targetWindowHandle, imeWindowToken);
    }

    boolean isUidAllowedOnDisplay(int displayId, int uid) {
        return this.mPrivOps.isUidAllowedOnDisplay(displayId, uid);
    }

    void setActive(int clientId, boolean active) {
        this.mPrivOps.setActive(clientId, active);
    }

    private static final class ServiceImpl
    extends IMultiClientInputMethod.Stub {
        private final WeakReference<MultiClientInputMethodServiceDelegateImpl> mImpl;

        ServiceImpl(MultiClientInputMethodServiceDelegateImpl service) {
            this.mImpl = new WeakReference<MultiClientInputMethodServiceDelegateImpl>(service);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void initialize(IMultiClientInputMethodPrivilegedOperations privOps) {
            MultiClientInputMethodServiceDelegateImpl service = (MultiClientInputMethodServiceDelegateImpl)this.mImpl.get();
            if (service == null) {
                return;
            }
            Object object = service.mLock;
            synchronized (object) {
                switch (service.mInitializationPhase) {
                    case 2: {
                        service.mPrivOps.set(privOps);
                        service.mInitializationPhase = 3;
                        service.mServiceCallback.initialized();
                        break;
                    }
                    default: {
                        Log.e(MultiClientInputMethodServiceDelegateImpl.TAG, "unexpected state=" + service.mInitializationPhase);
                    }
                }
            }
        }

        @Override
        public void addClient(int clientId, int uid, int pid, int selfReportedDisplayId) {
            MultiClientInputMethodServiceDelegateImpl service = (MultiClientInputMethodServiceDelegateImpl)this.mImpl.get();
            if (service == null) {
                return;
            }
            service.mServiceCallback.addClient(clientId, uid, pid, selfReportedDisplayId);
        }

        @Override
        public void removeClient(int clientId) {
            MultiClientInputMethodServiceDelegateImpl service = (MultiClientInputMethodServiceDelegateImpl)this.mImpl.get();
            if (service == null) {
                return;
            }
            service.mServiceCallback.removeClient(clientId);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface InitializationPhase {
        public static final int INSTANTIATED = 1;
        public static final int ON_BIND_CALLED = 2;
        public static final int INITIALIZE_CALLED = 3;
        public static final int ON_UNBIND_CALLED = 4;
        public static final int ON_DESTROY_CALLED = 5;
    }
}

