/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.annotation.SystemApi;

@SystemApi
public final class GnssCapabilities {
    public static final long LOW_POWER_MODE = 1L;
    public static final long SATELLITE_BLACKLIST = 2L;
    public static final long GEOFENCING = 4L;
    public static final long MEASUREMENTS = 8L;
    public static final long NAV_MESSAGES = 16L;
    public static final long MEASUREMENT_CORRECTIONS = 32L;
    public static final long MEASUREMENT_CORRECTIONS_LOS_SATS = 64L;
    public static final long MEASUREMENT_CORRECTIONS_EXCESS_PATH_LENGTH = 128L;
    public static final long MEASUREMENT_CORRECTIONS_REFLECTING_PLANE = 256L;
    public static final long INVALID_CAPABILITIES = -1L;
    private final long mGnssCapabilities;

    public static GnssCapabilities of(long gnssCapabilities) {
        return new GnssCapabilities(gnssCapabilities);
    }

    private GnssCapabilities(long gnssCapabilities) {
        this.mGnssCapabilities = gnssCapabilities;
    }

    public boolean hasLowPowerMode() {
        return this.hasCapability(1L);
    }

    public boolean hasSatelliteBlacklist() {
        return this.hasCapability(2L);
    }

    public boolean hasGeofencing() {
        return this.hasCapability(4L);
    }

    public boolean hasMeasurements() {
        return this.hasCapability(8L);
    }

    public boolean hasNavMessages() {
        return this.hasCapability(16L);
    }

    public boolean hasMeasurementCorrections() {
        return this.hasCapability(32L);
    }

    public boolean hasMeasurementCorrectionsLosSats() {
        return this.hasCapability(64L);
    }

    public boolean hasMeasurementCorrectionsExcessPathLength() {
        return this.hasCapability(128L);
    }

    public boolean hasMeasurementCorrectionsReflectingPane() {
        return this.hasCapability(256L);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("GnssCapabilities: ( ");
        if (this.hasLowPowerMode()) {
            sb.append("LOW_POWER_MODE ");
        }
        if (this.hasSatelliteBlacklist()) {
            sb.append("SATELLITE_BLACKLIST ");
        }
        if (this.hasGeofencing()) {
            sb.append("GEOFENCING ");
        }
        if (this.hasMeasurements()) {
            sb.append("MEASUREMENTS ");
        }
        if (this.hasNavMessages()) {
            sb.append("NAV_MESSAGES ");
        }
        if (this.hasMeasurementCorrections()) {
            sb.append("MEASUREMENT_CORRECTIONS ");
        }
        if (this.hasMeasurementCorrectionsLosSats()) {
            sb.append("MEASUREMENT_CORRECTIONS_LOS_SATS ");
        }
        if (this.hasMeasurementCorrectionsExcessPathLength()) {
            sb.append("MEASUREMENT_CORRECTIONS_EXCESS_PATH_LENGTH ");
        }
        if (this.hasMeasurementCorrectionsReflectingPane()) {
            sb.append("MEASUREMENT_CORRECTIONS_REFLECTING_PLANE ");
        }
        sb.append(")");
        return sb.toString();
    }

    private boolean hasCapability(long capability) {
        return (this.mGnssCapabilities & capability) == capability;
    }
}

