/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.os.Parcel;
import android.os.Parcelable;

public final class GnssClock
implements Parcelable {
    private static final int HAS_NO_FLAGS = 0;
    private static final int HAS_LEAP_SECOND = 1;
    private static final int HAS_TIME_UNCERTAINTY = 2;
    private static final int HAS_FULL_BIAS = 4;
    private static final int HAS_BIAS = 8;
    private static final int HAS_BIAS_UNCERTAINTY = 16;
    private static final int HAS_DRIFT = 32;
    private static final int HAS_DRIFT_UNCERTAINTY = 64;
    private static final int HAS_ELAPSED_REALTIME_NANOS = 128;
    private static final int HAS_ELAPSED_REALTIME_UNCERTAINTY_NANOS = 256;
    private int mFlags;
    private int mLeapSecond;
    private long mTimeNanos;
    private double mTimeUncertaintyNanos;
    private long mFullBiasNanos;
    private double mBiasNanos;
    private double mBiasUncertaintyNanos;
    private double mDriftNanosPerSecond;
    private double mDriftUncertaintyNanosPerSecond;
    private int mHardwareClockDiscontinuityCount;
    private long mElapsedRealtimeNanos;
    private double mElapsedRealtimeUncertaintyNanos;
    public static final Parcelable.Creator<GnssClock> CREATOR = new Parcelable.Creator<GnssClock>(){

        @Override
        public GnssClock createFromParcel(Parcel parcel) {
            GnssClock gpsClock = new GnssClock();
            gpsClock.mFlags = parcel.readInt();
            gpsClock.mLeapSecond = parcel.readInt();
            gpsClock.mTimeNanos = parcel.readLong();
            gpsClock.mTimeUncertaintyNanos = parcel.readDouble();
            gpsClock.mFullBiasNanos = parcel.readLong();
            gpsClock.mBiasNanos = parcel.readDouble();
            gpsClock.mBiasUncertaintyNanos = parcel.readDouble();
            gpsClock.mDriftNanosPerSecond = parcel.readDouble();
            gpsClock.mDriftUncertaintyNanosPerSecond = parcel.readDouble();
            gpsClock.mHardwareClockDiscontinuityCount = parcel.readInt();
            gpsClock.mElapsedRealtimeNanos = parcel.readLong();
            gpsClock.mElapsedRealtimeUncertaintyNanos = parcel.readDouble();
            return gpsClock;
        }

        public GnssClock[] newArray(int size) {
            return new GnssClock[size];
        }
    };

    public GnssClock() {
        this.initialize();
    }

    public void set(GnssClock clock) {
        this.mFlags = clock.mFlags;
        this.mLeapSecond = clock.mLeapSecond;
        this.mTimeNanos = clock.mTimeNanos;
        this.mTimeUncertaintyNanos = clock.mTimeUncertaintyNanos;
        this.mFullBiasNanos = clock.mFullBiasNanos;
        this.mBiasNanos = clock.mBiasNanos;
        this.mBiasUncertaintyNanos = clock.mBiasUncertaintyNanos;
        this.mDriftNanosPerSecond = clock.mDriftNanosPerSecond;
        this.mDriftUncertaintyNanosPerSecond = clock.mDriftUncertaintyNanosPerSecond;
        this.mHardwareClockDiscontinuityCount = clock.mHardwareClockDiscontinuityCount;
        this.mElapsedRealtimeNanos = clock.mElapsedRealtimeNanos;
        this.mElapsedRealtimeUncertaintyNanos = clock.mElapsedRealtimeUncertaintyNanos;
    }

    public void reset() {
        this.initialize();
    }

    public boolean hasLeapSecond() {
        return this.isFlagSet(1);
    }

    public int getLeapSecond() {
        return this.mLeapSecond;
    }

    public void setLeapSecond(int leapSecond) {
        this.setFlag(1);
        this.mLeapSecond = leapSecond;
    }

    public void resetLeapSecond() {
        this.resetFlag(1);
        this.mLeapSecond = Integer.MIN_VALUE;
    }

    public long getTimeNanos() {
        return this.mTimeNanos;
    }

    public void setTimeNanos(long timeNanos) {
        this.mTimeNanos = timeNanos;
    }

    public boolean hasTimeUncertaintyNanos() {
        return this.isFlagSet(2);
    }

    public double getTimeUncertaintyNanos() {
        return this.mTimeUncertaintyNanos;
    }

    public void setTimeUncertaintyNanos(double timeUncertaintyNanos) {
        this.setFlag(2);
        this.mTimeUncertaintyNanos = timeUncertaintyNanos;
    }

    public void resetTimeUncertaintyNanos() {
        this.resetFlag(2);
        this.mTimeUncertaintyNanos = Double.NaN;
    }

    public boolean hasFullBiasNanos() {
        return this.isFlagSet(4);
    }

    public long getFullBiasNanos() {
        return this.mFullBiasNanos;
    }

    public void setFullBiasNanos(long value) {
        this.setFlag(4);
        this.mFullBiasNanos = value;
    }

    public void resetFullBiasNanos() {
        this.resetFlag(4);
        this.mFullBiasNanos = Long.MIN_VALUE;
    }

    public boolean hasBiasNanos() {
        return this.isFlagSet(8);
    }

    public double getBiasNanos() {
        return this.mBiasNanos;
    }

    public void setBiasNanos(double biasNanos) {
        this.setFlag(8);
        this.mBiasNanos = biasNanos;
    }

    public void resetBiasNanos() {
        this.resetFlag(8);
        this.mBiasNanos = Double.NaN;
    }

    public boolean hasBiasUncertaintyNanos() {
        return this.isFlagSet(16);
    }

    public double getBiasUncertaintyNanos() {
        return this.mBiasUncertaintyNanos;
    }

    public void setBiasUncertaintyNanos(double biasUncertaintyNanos) {
        this.setFlag(16);
        this.mBiasUncertaintyNanos = biasUncertaintyNanos;
    }

    public void resetBiasUncertaintyNanos() {
        this.resetFlag(16);
        this.mBiasUncertaintyNanos = Double.NaN;
    }

    public boolean hasDriftNanosPerSecond() {
        return this.isFlagSet(32);
    }

    public double getDriftNanosPerSecond() {
        return this.mDriftNanosPerSecond;
    }

    public void setDriftNanosPerSecond(double driftNanosPerSecond) {
        this.setFlag(32);
        this.mDriftNanosPerSecond = driftNanosPerSecond;
    }

    public void resetDriftNanosPerSecond() {
        this.resetFlag(32);
        this.mDriftNanosPerSecond = Double.NaN;
    }

    public boolean hasDriftUncertaintyNanosPerSecond() {
        return this.isFlagSet(64);
    }

    public double getDriftUncertaintyNanosPerSecond() {
        return this.mDriftUncertaintyNanosPerSecond;
    }

    public void setDriftUncertaintyNanosPerSecond(double driftUncertaintyNanosPerSecond) {
        this.setFlag(64);
        this.mDriftUncertaintyNanosPerSecond = driftUncertaintyNanosPerSecond;
    }

    public void resetDriftUncertaintyNanosPerSecond() {
        this.resetFlag(64);
        this.mDriftUncertaintyNanosPerSecond = Double.NaN;
    }

    public boolean hasElapsedRealtimeNanos() {
        return this.isFlagSet(128);
    }

    public long getElapsedRealtimeNanos() {
        return this.mElapsedRealtimeNanos;
    }

    public void setElapsedRealtimeNanos(long elapsedRealtimeNanos) {
        this.setFlag(128);
        this.mElapsedRealtimeNanos = elapsedRealtimeNanos;
    }

    public void resetElapsedRealtimeNanos() {
        this.resetFlag(128);
        this.mElapsedRealtimeNanos = 0L;
    }

    public boolean hasElapsedRealtimeUncertaintyNanos() {
        return this.isFlagSet(256);
    }

    public double getElapsedRealtimeUncertaintyNanos() {
        return this.mElapsedRealtimeUncertaintyNanos;
    }

    public void setElapsedRealtimeUncertaintyNanos(double elapsedRealtimeUncertaintyNanos) {
        this.setFlag(256);
        this.mElapsedRealtimeUncertaintyNanos = elapsedRealtimeUncertaintyNanos;
    }

    public void resetElapsedRealtimeUncertaintyNanos() {
        this.resetFlag(256);
        this.mElapsedRealtimeUncertaintyNanos = Double.NaN;
    }

    public int getHardwareClockDiscontinuityCount() {
        return this.mHardwareClockDiscontinuityCount;
    }

    public void setHardwareClockDiscontinuityCount(int value) {
        this.mHardwareClockDiscontinuityCount = value;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeInt(this.mFlags);
        parcel.writeInt(this.mLeapSecond);
        parcel.writeLong(this.mTimeNanos);
        parcel.writeDouble(this.mTimeUncertaintyNanos);
        parcel.writeLong(this.mFullBiasNanos);
        parcel.writeDouble(this.mBiasNanos);
        parcel.writeDouble(this.mBiasUncertaintyNanos);
        parcel.writeDouble(this.mDriftNanosPerSecond);
        parcel.writeDouble(this.mDriftUncertaintyNanosPerSecond);
        parcel.writeInt(this.mHardwareClockDiscontinuityCount);
        parcel.writeLong(this.mElapsedRealtimeNanos);
        parcel.writeDouble(this.mElapsedRealtimeUncertaintyNanos);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String toString() {
        String format = "   %-15s = %s\n";
        String formatWithUncertainty = "   %-15s = %-25s   %-26s = %s\n";
        StringBuilder builder = new StringBuilder("GnssClock:\n");
        builder.append(String.format("   %-15s = %s\n", "LeapSecond", this.hasLeapSecond() ? Integer.valueOf(this.mLeapSecond) : null));
        builder.append(String.format("   %-15s = %-25s   %-26s = %s\n", "TimeNanos", this.mTimeNanos, "TimeUncertaintyNanos", this.hasTimeUncertaintyNanos() ? Double.valueOf(this.mTimeUncertaintyNanos) : null));
        builder.append(String.format("   %-15s = %s\n", "FullBiasNanos", this.hasFullBiasNanos() ? Long.valueOf(this.mFullBiasNanos) : null));
        builder.append(String.format("   %-15s = %-25s   %-26s = %s\n", "BiasNanos", this.hasBiasNanos() ? Double.valueOf(this.mBiasNanos) : null, "BiasUncertaintyNanos", this.hasBiasUncertaintyNanos() ? Double.valueOf(this.mBiasUncertaintyNanos) : null));
        builder.append(String.format("   %-15s = %-25s   %-26s = %s\n", "DriftNanosPerSecond", this.hasDriftNanosPerSecond() ? Double.valueOf(this.mDriftNanosPerSecond) : null, "DriftUncertaintyNanosPerSecond", this.hasDriftUncertaintyNanosPerSecond() ? Double.valueOf(this.mDriftUncertaintyNanosPerSecond) : null));
        builder.append(String.format("   %-15s = %s\n", "HardwareClockDiscontinuityCount", this.mHardwareClockDiscontinuityCount));
        builder.append(String.format("   %-15s = %s\n", "ElapsedRealtimeNanos", this.hasElapsedRealtimeNanos() ? Long.valueOf(this.mElapsedRealtimeNanos) : null));
        builder.append(String.format("   %-15s = %s\n", "ElapsedRealtimeUncertaintyNanos", this.hasElapsedRealtimeUncertaintyNanos() ? Double.valueOf(this.mElapsedRealtimeUncertaintyNanos) : null));
        return builder.toString();
    }

    private void initialize() {
        this.mFlags = 0;
        this.resetLeapSecond();
        this.setTimeNanos(Long.MIN_VALUE);
        this.resetTimeUncertaintyNanos();
        this.resetFullBiasNanos();
        this.resetBiasNanos();
        this.resetBiasUncertaintyNanos();
        this.resetDriftNanosPerSecond();
        this.resetDriftUncertaintyNanosPerSecond();
        this.setHardwareClockDiscontinuityCount(Integer.MIN_VALUE);
        this.resetElapsedRealtimeNanos();
        this.resetElapsedRealtimeUncertaintyNanos();
    }

    private void setFlag(int flag) {
        this.mFlags |= flag;
    }

    private void resetFlag(int flag) {
        this.mFlags &= ~flag;
    }

    private boolean isFlagSet(int flag) {
        return (this.mFlags & flag) == flag;
    }
}

