/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.annotation.UnsupportedAppUsage;
import android.location.GnssStatus;
import android.location.GpsSatellite;
import android.util.SparseArray;
import java.util.Iterator;
import java.util.NoSuchElementException;

@Deprecated
public final class GpsStatus {
    private static final int NUM_SATELLITES = 255;
    private static final int GLONASS_SVID_OFFSET = 64;
    private static final int BEIDOU_SVID_OFFSET = 200;
    private static final int SBAS_SVID_OFFSET = -87;
    private int mTimeToFirstFix;
    private final SparseArray<GpsSatellite> mSatellites = new SparseArray();
    private Iterable<GpsSatellite> mSatelliteList = new Iterable<GpsSatellite>(){

        @Override
        public Iterator<GpsSatellite> iterator() {
            return new SatelliteIterator();
        }
    };
    public static final int GPS_EVENT_STARTED = 1;
    public static final int GPS_EVENT_STOPPED = 2;
    public static final int GPS_EVENT_FIRST_FIX = 3;
    public static final int GPS_EVENT_SATELLITE_STATUS = 4;

    GpsStatus() {
    }

    private void setStatus(int svCount, int[] svidWithFlags, float[] cn0s, float[] elevations, float[] azimuths) {
        this.clearSatellites();
        for (int i = 0; i < svCount; ++i) {
            int constellationType = svidWithFlags[i] >> 4 & 0xF;
            int prn = svidWithFlags[i] >> 8;
            if (constellationType == 3) {
                prn += 64;
            } else if (constellationType == 5) {
                prn += 200;
            } else if (constellationType == 2) {
                prn -= 87;
            } else if (constellationType != 1 && constellationType != 4) continue;
            if (prn <= 0 || prn > 255) continue;
            GpsSatellite satellite = this.mSatellites.get(prn);
            if (satellite == null) {
                satellite = new GpsSatellite(prn);
                this.mSatellites.put(prn, satellite);
            }
            satellite.mValid = true;
            satellite.mSnr = cn0s[i];
            satellite.mElevation = elevations[i];
            satellite.mAzimuth = azimuths[i];
            satellite.mHasEphemeris = (svidWithFlags[i] & 1) != 0;
            satellite.mHasAlmanac = (svidWithFlags[i] & 2) != 0;
            satellite.mUsedInFix = (svidWithFlags[i] & 4) != 0;
        }
    }

    void setStatus(GnssStatus status, int timeToFirstFix) {
        this.mTimeToFirstFix = timeToFirstFix;
        this.setStatus(status.mSvCount, status.mSvidWithFlags, status.mCn0DbHz, status.mElevations, status.mAzimuths);
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    void setTimeToFirstFix(int ttff) {
        this.mTimeToFirstFix = ttff;
    }

    public int getTimeToFirstFix() {
        return this.mTimeToFirstFix;
    }

    public Iterable<GpsSatellite> getSatellites() {
        return this.mSatelliteList;
    }

    public int getMaxSatellites() {
        return 255;
    }

    private void clearSatellites() {
        int satellitesCount = this.mSatellites.size();
        for (int i = 0; i < satellitesCount; ++i) {
            GpsSatellite satellite = this.mSatellites.valueAt(i);
            satellite.mValid = false;
        }
    }

    @Deprecated
    public static interface NmeaListener {
        public void onNmeaReceived(long var1, String var3);
    }

    @Deprecated
    public static interface Listener {
        public void onGpsStatusChanged(int var1);
    }

    private final class SatelliteIterator
    implements Iterator<GpsSatellite> {
        private final int mSatellitesCount;
        private int mIndex = 0;

        SatelliteIterator() {
            this.mSatellitesCount = GpsStatus.this.mSatellites.size();
        }

        @Override
        public boolean hasNext() {
            while (this.mIndex < this.mSatellitesCount) {
                GpsSatellite satellite = (GpsSatellite)GpsStatus.this.mSatellites.valueAt(this.mIndex);
                if (satellite.mValid) {
                    return true;
                }
                ++this.mIndex;
            }
            return false;
        }

        @Override
        public GpsSatellite next() {
            while (this.mIndex < this.mSatellitesCount) {
                GpsSatellite satellite = (GpsSatellite)GpsStatus.this.mSatellites.valueAt(this.mIndex);
                ++this.mIndex;
                if (!satellite.mValid) continue;
                return satellite;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

