/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.annotation.SystemApi;
import android.media.AudioAttributes;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Objects;

@SystemApi
public final class AudioFocusInfo
implements Parcelable {
    private final AudioAttributes mAttributes;
    private final int mClientUid;
    private final String mClientId;
    private final String mPackageName;
    private final int mSdkTarget;
    private int mGainRequest;
    private int mLossReceived;
    private int mFlags;
    private long mGenCount = -1L;
    public static final Parcelable.Creator<AudioFocusInfo> CREATOR = new Parcelable.Creator<AudioFocusInfo>(){

        @Override
        public AudioFocusInfo createFromParcel(Parcel in) {
            AudioFocusInfo afi = new AudioFocusInfo(AudioAttributes.CREATOR.createFromParcel(in), in.readInt(), in.readString(), in.readString(), in.readInt(), in.readInt(), in.readInt(), in.readInt());
            afi.setGen(in.readLong());
            return afi;
        }

        public AudioFocusInfo[] newArray(int size) {
            return new AudioFocusInfo[size];
        }
    };

    public AudioFocusInfo(AudioAttributes aa, int clientUid, String clientId, String packageName, int gainRequest, int lossReceived, int flags, int sdk) {
        this.mAttributes = aa == null ? new AudioAttributes.Builder().build() : aa;
        this.mClientUid = clientUid;
        this.mClientId = clientId == null ? "" : clientId;
        this.mPackageName = packageName == null ? "" : packageName;
        this.mGainRequest = gainRequest;
        this.mLossReceived = lossReceived;
        this.mFlags = flags;
        this.mSdkTarget = sdk;
    }

    public void setGen(long g) {
        this.mGenCount = g;
    }

    public long getGen() {
        return this.mGenCount;
    }

    public AudioAttributes getAttributes() {
        return this.mAttributes;
    }

    public int getClientUid() {
        return this.mClientUid;
    }

    public String getClientId() {
        return this.mClientId;
    }

    public String getPackageName() {
        return this.mPackageName;
    }

    public int getGainRequest() {
        return this.mGainRequest;
    }

    public int getLossReceived() {
        return this.mLossReceived;
    }

    public int getSdkTarget() {
        return this.mSdkTarget;
    }

    public void clearLossReceived() {
        this.mLossReceived = 0;
    }

    public int getFlags() {
        return this.mFlags;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        this.mAttributes.writeToParcel(dest, flags);
        dest.writeInt(this.mClientUid);
        dest.writeString(this.mClientId);
        dest.writeString(this.mPackageName);
        dest.writeInt(this.mGainRequest);
        dest.writeInt(this.mLossReceived);
        dest.writeInt(this.mFlags);
        dest.writeInt(this.mSdkTarget);
        dest.writeLong(this.mGenCount);
    }

    public int hashCode() {
        return Objects.hash(this.mAttributes, this.mClientUid, this.mClientId, this.mPackageName, this.mGainRequest, this.mFlags);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AudioFocusInfo other = (AudioFocusInfo)obj;
        if (!this.mAttributes.equals(other.mAttributes)) {
            return false;
        }
        if (this.mClientUid != other.mClientUid) {
            return false;
        }
        if (!this.mClientId.equals(other.mClientId)) {
            return false;
        }
        if (!this.mPackageName.equals(other.mPackageName)) {
            return false;
        }
        if (this.mGainRequest != other.mGainRequest) {
            return false;
        }
        if (this.mLossReceived != other.mLossReceived) {
            return false;
        }
        if (this.mFlags != other.mFlags) {
            return false;
        }
        return this.mSdkTarget == other.mSdkTarget;
    }
}

