/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.AudioAttributes;
import android.media.AudioFormat;
import android.media.audiopolicy.AudioMix;
import android.media.audiopolicy.AudioMixingRule;
import android.media.projection.MediaProjection;
import android.os.RemoteException;
import com.android.internal.util.Preconditions;
import java.util.function.ToIntFunction;

public final class AudioPlaybackCaptureConfiguration {
    private final AudioMixingRule mAudioMixingRule;
    private final MediaProjection mProjection;

    private AudioPlaybackCaptureConfiguration(AudioMixingRule audioMixingRule, MediaProjection projection) {
        this.mAudioMixingRule = audioMixingRule;
        this.mProjection = projection;
    }

    public MediaProjection getMediaProjection() {
        return this.mProjection;
    }

    public int[] getMatchingUsages() {
        return this.getIntPredicates(1, criterion -> criterion.getAudioAttributes().getUsage());
    }

    public int[] getMatchingUids() {
        return this.getIntPredicates(4, criterion -> criterion.getIntProp());
    }

    public int[] getExcludeUsages() {
        return this.getIntPredicates(32769, criterion -> criterion.getAudioAttributes().getUsage());
    }

    public int[] getExcludeUids() {
        return this.getIntPredicates(32772, criterion -> criterion.getIntProp());
    }

    private int[] getIntPredicates(int rule, ToIntFunction<AudioMixingRule.AudioMixMatchCriterion> getPredicate) {
        return this.mAudioMixingRule.getCriteria().stream().filter(criterion -> criterion.getRule() == rule).mapToInt(getPredicate).toArray();
    }

    AudioMix createAudioMix(AudioFormat audioFormat) {
        return new AudioMix.Builder(this.mAudioMixingRule).setFormat(audioFormat).setRouteFlags(3).build();
    }

    public static final class Builder {
        private static final int MATCH_TYPE_UNSPECIFIED = 0;
        private static final int MATCH_TYPE_INCLUSIVE = 1;
        private static final int MATCH_TYPE_EXCLUSIVE = 2;
        private static final String ERROR_MESSAGE_MISMATCHED_RULES = "Inclusive and exclusive usage rules cannot be combined";
        private static final String ERROR_MESSAGE_START_ACTIVITY_FAILED = "startActivityForResult failed";
        private static final String ERROR_MESSAGE_NON_AUDIO_PROJECTION = "MediaProjection can not project audio";
        private final AudioMixingRule.Builder mAudioMixingRuleBuilder;
        private final MediaProjection mProjection;
        private int mUsageMatchType = 0;
        private int mUidMatchType = 0;

        public Builder(MediaProjection projection) {
            Preconditions.checkNotNull(projection);
            try {
                Preconditions.checkArgument(projection.getProjection().canProjectAudio(), ERROR_MESSAGE_NON_AUDIO_PROJECTION);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            this.mProjection = projection;
            this.mAudioMixingRuleBuilder = new AudioMixingRule.Builder();
        }

        public Builder addMatchingUsage(int usage) {
            Preconditions.checkState(this.mUsageMatchType != 2, ERROR_MESSAGE_MISMATCHED_RULES);
            this.mAudioMixingRuleBuilder.addRule(new AudioAttributes.Builder().setUsage(usage).build(), 1);
            this.mUsageMatchType = 1;
            return this;
        }

        public Builder addMatchingUid(int uid) {
            Preconditions.checkState(this.mUidMatchType != 2, ERROR_MESSAGE_MISMATCHED_RULES);
            this.mAudioMixingRuleBuilder.addMixRule(4, uid);
            this.mUidMatchType = 1;
            return this;
        }

        public Builder excludeUsage(int usage) {
            Preconditions.checkState(this.mUsageMatchType != 1, ERROR_MESSAGE_MISMATCHED_RULES);
            this.mAudioMixingRuleBuilder.excludeRule(new AudioAttributes.Builder().setUsage(usage).build(), 1);
            this.mUsageMatchType = 2;
            return this;
        }

        public Builder excludeUid(int uid) {
            Preconditions.checkState(this.mUidMatchType != 1, ERROR_MESSAGE_MISMATCHED_RULES);
            this.mAudioMixingRuleBuilder.excludeMixRule(4, uid);
            this.mUidMatchType = 2;
            return this;
        }

        public AudioPlaybackCaptureConfiguration build() {
            return new AudioPlaybackCaptureConfiguration(this.mAudioMixingRuleBuilder.build(), this.mProjection);
        }
    }
}

