/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.annotation.UnsupportedAppUsage;
import android.media.AudioDeviceInfo;
import android.media.AudioFormat;
import android.media.AudioManager;
import android.media.AudioPatch;
import android.media.AudioPortConfig;
import android.media.MediaRecorder;
import android.media.audiofx.AudioEffect;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public final class AudioRecordingConfiguration
implements Parcelable {
    private static final String TAG = new String("AudioRecordingConfiguration");
    private final int mClientSessionId;
    private final int mClientSource;
    private final AudioFormat mDeviceFormat;
    private final AudioFormat mClientFormat;
    private final String mClientPackageName;
    private final int mClientUid;
    private final int mPatchHandle;
    private final int mClientPortId;
    private boolean mClientSilenced;
    private final int mDeviceSource;
    private final AudioEffect.Descriptor[] mClientEffects;
    private final AudioEffect.Descriptor[] mDeviceEffects;
    public static final Parcelable.Creator<AudioRecordingConfiguration> CREATOR = new Parcelable.Creator<AudioRecordingConfiguration>(){

        @Override
        public AudioRecordingConfiguration createFromParcel(Parcel p) {
            return new AudioRecordingConfiguration(p);
        }

        public AudioRecordingConfiguration[] newArray(int size) {
            return new AudioRecordingConfiguration[size];
        }
    };

    public AudioRecordingConfiguration(int uid, int session, int source, AudioFormat clientFormat, AudioFormat devFormat, int patchHandle, String packageName, int clientPortId, boolean clientSilenced, int deviceSource, AudioEffect.Descriptor[] clientEffects, AudioEffect.Descriptor[] deviceEffects) {
        this.mClientUid = uid;
        this.mClientSessionId = session;
        this.mClientSource = source;
        this.mClientFormat = clientFormat;
        this.mDeviceFormat = devFormat;
        this.mPatchHandle = patchHandle;
        this.mClientPackageName = packageName;
        this.mClientPortId = clientPortId;
        this.mClientSilenced = clientSilenced;
        this.mDeviceSource = deviceSource;
        this.mClientEffects = clientEffects;
        this.mDeviceEffects = deviceEffects;
    }

    public AudioRecordingConfiguration(int uid, int session, int source, AudioFormat clientFormat, AudioFormat devFormat, int patchHandle, String packageName) {
        this(uid, session, source, clientFormat, devFormat, patchHandle, packageName, 0, false, 0, new AudioEffect.Descriptor[0], new AudioEffect.Descriptor[0]);
    }

    public void dump(PrintWriter pw) {
        pw.println("  " + AudioRecordingConfiguration.toLogFriendlyString(this));
    }

    public static String toLogFriendlyString(AudioRecordingConfiguration arc) {
        String clientEffects = new String();
        for (AudioEffect.Descriptor desc : arc.mClientEffects) {
            clientEffects = clientEffects + "'" + desc.name + "' ";
        }
        String deviceEffects = new String();
        for (AudioEffect.Descriptor desc : arc.mDeviceEffects) {
            deviceEffects = deviceEffects + "'" + desc.name + "' ";
        }
        return new String("session:" + arc.mClientSessionId + " -- source client=" + MediaRecorder.toLogFriendlyAudioSource(arc.mClientSource) + ", dev=" + arc.mDeviceFormat.toLogFriendlyString() + " -- uid:" + arc.mClientUid + " -- patch:" + arc.mPatchHandle + " -- pack:" + arc.mClientPackageName + " -- format client=" + arc.mClientFormat.toLogFriendlyString() + ", dev=" + arc.mDeviceFormat.toLogFriendlyString() + " -- silenced:" + arc.mClientSilenced + " -- effects client=" + clientEffects + ", dev=" + deviceEffects);
    }

    public static AudioRecordingConfiguration anonymizedCopy(AudioRecordingConfiguration in) {
        return new AudioRecordingConfiguration(-1, in.mClientSessionId, in.mClientSource, in.mClientFormat, in.mDeviceFormat, in.mPatchHandle, "", in.mClientPortId, in.mClientSilenced, in.mDeviceSource, in.mClientEffects, in.mDeviceEffects);
    }

    public int getClientAudioSource() {
        return this.mClientSource;
    }

    public int getClientAudioSessionId() {
        return this.mClientSessionId;
    }

    public AudioFormat getFormat() {
        return this.mDeviceFormat;
    }

    public AudioFormat getClientFormat() {
        return this.mClientFormat;
    }

    @UnsupportedAppUsage
    public String getClientPackageName() {
        return this.mClientPackageName;
    }

    @UnsupportedAppUsage
    public int getClientUid() {
        return this.mClientUid;
    }

    public AudioDeviceInfo getAudioDevice() {
        ArrayList<AudioPatch> patches = new ArrayList<AudioPatch>();
        if (AudioManager.listAudioPatches(patches) != 0) {
            Log.e(TAG, "Error retrieving list of audio patches");
            return null;
        }
        for (int i = 0; i < patches.size(); ++i) {
            AudioPatch patch = patches.get(i);
            if (patch.id() != this.mPatchHandle) continue;
            AudioPortConfig[] sources = patch.sources();
            if (sources == null || sources.length <= 0) break;
            int devId = sources[0].port().id();
            AudioDeviceInfo[] devices = AudioManager.getDevicesStatic(1);
            for (int j = 0; j < devices.length; ++j) {
                if (devices[j].getId() != devId) continue;
                return devices[j];
            }
            break;
        }
        Log.e(TAG, "Couldn't find device for recording, did recording end already?");
        return null;
    }

    public int getClientPortId() {
        return this.mClientPortId;
    }

    public boolean isClientSilenced() {
        return this.mClientSilenced;
    }

    public int getAudioSource() {
        return this.mDeviceSource;
    }

    public List<AudioEffect.Descriptor> getClientEffects() {
        return new ArrayList<AudioEffect.Descriptor>(Arrays.asList(this.mClientEffects));
    }

    public List<AudioEffect.Descriptor> getEffects() {
        return new ArrayList<AudioEffect.Descriptor>(Arrays.asList(this.mDeviceEffects));
    }

    public int hashCode() {
        return Objects.hash(this.mClientSessionId, this.mClientSource);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        int i;
        dest.writeInt(this.mClientSessionId);
        dest.writeInt(this.mClientSource);
        this.mClientFormat.writeToParcel(dest, 0);
        this.mDeviceFormat.writeToParcel(dest, 0);
        dest.writeInt(this.mPatchHandle);
        dest.writeString(this.mClientPackageName);
        dest.writeInt(this.mClientUid);
        dest.writeInt(this.mClientPortId);
        dest.writeBoolean(this.mClientSilenced);
        dest.writeInt(this.mDeviceSource);
        dest.writeInt(this.mClientEffects.length);
        for (i = 0; i < this.mClientEffects.length; ++i) {
            this.mClientEffects[i].writeToParcel(dest);
        }
        dest.writeInt(this.mDeviceEffects.length);
        for (i = 0; i < this.mDeviceEffects.length; ++i) {
            this.mDeviceEffects[i].writeToParcel(dest);
        }
    }

    private AudioRecordingConfiguration(Parcel in) {
        int i;
        this.mClientSessionId = in.readInt();
        this.mClientSource = in.readInt();
        this.mClientFormat = AudioFormat.CREATOR.createFromParcel(in);
        this.mDeviceFormat = AudioFormat.CREATOR.createFromParcel(in);
        this.mPatchHandle = in.readInt();
        this.mClientPackageName = in.readString();
        this.mClientUid = in.readInt();
        this.mClientPortId = in.readInt();
        this.mClientSilenced = in.readBoolean();
        this.mDeviceSource = in.readInt();
        this.mClientEffects = new AudioEffect.Descriptor[in.readInt()];
        for (i = 0; i < this.mClientEffects.length; ++i) {
            this.mClientEffects[i] = new AudioEffect.Descriptor(in);
        }
        this.mDeviceEffects = new AudioEffect.Descriptor[in.readInt()];
        for (i = 0; i < this.mDeviceEffects.length; ++i) {
            this.mDeviceEffects[i] = new AudioEffect.Descriptor(in);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof AudioRecordingConfiguration)) {
            return false;
        }
        AudioRecordingConfiguration that = (AudioRecordingConfiguration)o;
        return this.mClientUid == that.mClientUid && this.mClientSessionId == that.mClientSessionId && this.mClientSource == that.mClientSource && this.mPatchHandle == that.mPatchHandle && this.mClientFormat.equals(that.mClientFormat) && this.mDeviceFormat.equals(that.mDeviceFormat) && this.mClientPackageName.equals(that.mClientPackageName) && this.mClientPortId == that.mClientPortId && this.mClientSilenced == that.mClientSilenced && this.mDeviceSource == that.mDeviceSource && Arrays.equals(this.mClientEffects, that.mClientEffects) && Arrays.equals(this.mDeviceEffects, that.mDeviceEffects);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AudioSource {
    }
}

