/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.media.AudioAttributes;
import android.media.AudioFormat;
import android.media.AudioPatch;
import android.media.AudioPort;
import android.media.AudioPortConfig;
import android.media.MicrophoneInfo;
import android.media.audiofx.AudioEffect;
import android.media.audiopolicy.AudioMix;
import android.util.Log;
import java.util.ArrayList;
import java.util.Map;

public class AudioSystem {
    private static final boolean DEBUG_VOLUME = false;
    private static final String TAG = "AudioSystem";
    public static final int STREAM_DEFAULT = -1;
    public static final int STREAM_VOICE_CALL = 0;
    public static final int STREAM_SYSTEM = 1;
    public static final int STREAM_RING = 2;
    public static final int STREAM_MUSIC = 3;
    public static final int STREAM_ALARM = 4;
    public static final int STREAM_NOTIFICATION = 5;
    public static final int STREAM_BLUETOOTH_SCO = 6;
    @UnsupportedAppUsage
    public static final int STREAM_SYSTEM_ENFORCED = 7;
    public static final int STREAM_DTMF = 8;
    public static final int STREAM_TTS = 9;
    public static final int STREAM_ACCESSIBILITY = 10;
    public static final int NUM_STREAMS = 5;
    public static final int OUT_CHANNEL_COUNT_MAX = AudioSystem.native_get_FCC_8();
    private static final int NUM_STREAM_TYPES = 11;
    public static final String[] STREAM_NAMES = new String[]{"STREAM_VOICE_CALL", "STREAM_SYSTEM", "STREAM_RING", "STREAM_MUSIC", "STREAM_ALARM", "STREAM_NOTIFICATION", "STREAM_BLUETOOTH_SCO", "STREAM_SYSTEM_ENFORCED", "STREAM_DTMF", "STREAM_TTS", "STREAM_ACCESSIBILITY"};
    public static final int MODE_INVALID = -2;
    public static final int MODE_CURRENT = -1;
    public static final int MODE_NORMAL = 0;
    public static final int MODE_RINGTONE = 1;
    public static final int MODE_IN_CALL = 2;
    public static final int MODE_IN_COMMUNICATION = 3;
    public static final int NUM_MODES = 4;
    public static final int AUDIO_FORMAT_INVALID = -1;
    public static final int AUDIO_FORMAT_DEFAULT = 0;
    public static final int AUDIO_FORMAT_AAC = 0x4000000;
    public static final int AUDIO_FORMAT_SBC = 0x1F000000;
    public static final int AUDIO_FORMAT_APTX = 0x20000000;
    public static final int AUDIO_FORMAT_APTX_HD = 0x21000000;
    public static final int AUDIO_FORMAT_LDAC = 0x23000000;
    @Deprecated
    public static final int ROUTE_EARPIECE = 1;
    @Deprecated
    public static final int ROUTE_SPEAKER = 2;
    @Deprecated
    public static final int ROUTE_BLUETOOTH = 4;
    @Deprecated
    public static final int ROUTE_BLUETOOTH_SCO = 4;
    @Deprecated
    public static final int ROUTE_HEADSET = 8;
    @Deprecated
    public static final int ROUTE_BLUETOOTH_A2DP = 16;
    @Deprecated
    public static final int ROUTE_ALL = -1;
    public static final int AUDIO_SESSION_ALLOCATE = 0;
    public static final int AUDIO_STATUS_OK = 0;
    public static final int AUDIO_STATUS_ERROR = 1;
    public static final int AUDIO_STATUS_SERVER_DIED = 100;
    private static ErrorCallback mErrorCallback;
    private static final int DYNAMIC_POLICY_EVENT_MIX_STATE_UPDATE = 0;
    private static DynamicPolicyCallback sDynPolicyCallback;
    private static AudioRecordingCallback sRecordingCallback;
    public static final int SUCCESS = 0;
    public static final int ERROR = -1;
    public static final int BAD_VALUE = -2;
    public static final int INVALID_OPERATION = -3;
    public static final int PERMISSION_DENIED = -4;
    public static final int NO_INIT = -5;
    public static final int DEAD_OBJECT = -6;
    public static final int WOULD_BLOCK = -7;
    public static final int DEVICE_NONE = 0;
    public static final int DEVICE_BIT_IN = Integer.MIN_VALUE;
    public static final int DEVICE_BIT_DEFAULT = 0x40000000;
    @UnsupportedAppUsage
    public static final int DEVICE_OUT_EARPIECE = 1;
    @UnsupportedAppUsage
    public static final int DEVICE_OUT_SPEAKER = 2;
    @UnsupportedAppUsage
    public static final int DEVICE_OUT_WIRED_HEADSET = 4;
    @UnsupportedAppUsage
    public static final int DEVICE_OUT_WIRED_HEADPHONE = 8;
    @UnsupportedAppUsage
    public static final int DEVICE_OUT_BLUETOOTH_SCO = 16;
    @UnsupportedAppUsage
    public static final int DEVICE_OUT_BLUETOOTH_SCO_HEADSET = 32;
    @UnsupportedAppUsage
    public static final int DEVICE_OUT_BLUETOOTH_SCO_CARKIT = 64;
    @UnsupportedAppUsage
    public static final int DEVICE_OUT_BLUETOOTH_A2DP = 128;
    @UnsupportedAppUsage
    public static final int DEVICE_OUT_BLUETOOTH_A2DP_HEADPHONES = 256;
    @UnsupportedAppUsage
    public static final int DEVICE_OUT_BLUETOOTH_A2DP_SPEAKER = 512;
    @UnsupportedAppUsage
    public static final int DEVICE_OUT_AUX_DIGITAL = 1024;
    public static final int DEVICE_OUT_HDMI = 1024;
    @UnsupportedAppUsage
    public static final int DEVICE_OUT_ANLG_DOCK_HEADSET = 2048;
    @UnsupportedAppUsage
    public static final int DEVICE_OUT_DGTL_DOCK_HEADSET = 4096;
    @UnsupportedAppUsage
    public static final int DEVICE_OUT_USB_ACCESSORY = 8192;
    @UnsupportedAppUsage
    public static final int DEVICE_OUT_USB_DEVICE = 16384;
    @UnsupportedAppUsage
    public static final int DEVICE_OUT_REMOTE_SUBMIX = 32768;
    @UnsupportedAppUsage
    public static final int DEVICE_OUT_TELEPHONY_TX = 65536;
    public static final int DEVICE_OUT_LINE = 131072;
    public static final int DEVICE_OUT_HDMI_ARC = 262144;
    public static final int DEVICE_OUT_SPDIF = 524288;
    @UnsupportedAppUsage
    public static final int DEVICE_OUT_FM = 0x100000;
    public static final int DEVICE_OUT_AUX_LINE = 0x200000;
    public static final int DEVICE_OUT_SPEAKER_SAFE = 0x400000;
    public static final int DEVICE_OUT_IP = 0x800000;
    public static final int DEVICE_OUT_BUS = 0x1000000;
    public static final int DEVICE_OUT_PROXY = 0x2000000;
    public static final int DEVICE_OUT_USB_HEADSET = 0x4000000;
    public static final int DEVICE_OUT_HEARING_AID = 0x8000000;
    public static final int DEVICE_OUT_DEFAULT = 0x40000000;
    public static final int DEVICE_OUT_ALL = 0x4FFFFFFF;
    public static final int DEVICE_OUT_ALL_A2DP = 896;
    public static final int DEVICE_OUT_ALL_SCO = 112;
    @UnsupportedAppUsage
    public static final int DEVICE_OUT_ALL_USB = 0x4006000;
    public static final int DEVICE_OUT_ALL_HDMI_SYSTEM_AUDIO = 0x2C0000;
    public static final int DEVICE_ALL_HDMI_SYSTEM_AUDIO_AND_SPEAKER = 0x2C0002;
    @UnsupportedAppUsage
    public static final int DEVICE_IN_COMMUNICATION = -2147483647;
    @UnsupportedAppUsage
    public static final int DEVICE_IN_AMBIENT = -2147483646;
    @UnsupportedAppUsage
    public static final int DEVICE_IN_BUILTIN_MIC = -2147483644;
    @UnsupportedAppUsage
    public static final int DEVICE_IN_BLUETOOTH_SCO_HEADSET = -2147483640;
    @UnsupportedAppUsage
    public static final int DEVICE_IN_WIRED_HEADSET = -2147483632;
    @UnsupportedAppUsage
    public static final int DEVICE_IN_AUX_DIGITAL = -2147483616;
    public static final int DEVICE_IN_HDMI = -2147483616;
    @UnsupportedAppUsage
    public static final int DEVICE_IN_VOICE_CALL = -2147483584;
    public static final int DEVICE_IN_TELEPHONY_RX = -2147483584;
    @UnsupportedAppUsage
    public static final int DEVICE_IN_BACK_MIC = -2147483520;
    @UnsupportedAppUsage
    public static final int DEVICE_IN_REMOTE_SUBMIX = -2147483392;
    @UnsupportedAppUsage
    public static final int DEVICE_IN_ANLG_DOCK_HEADSET = -2147483136;
    @UnsupportedAppUsage
    public static final int DEVICE_IN_DGTL_DOCK_HEADSET = -2147482624;
    @UnsupportedAppUsage
    public static final int DEVICE_IN_USB_ACCESSORY = -2147481600;
    @UnsupportedAppUsage
    public static final int DEVICE_IN_USB_DEVICE = -2147479552;
    public static final int DEVICE_IN_FM_TUNER = -2147475456;
    public static final int DEVICE_IN_TV_TUNER = -2147467264;
    public static final int DEVICE_IN_LINE = -2147450880;
    public static final int DEVICE_IN_SPDIF = -2147418112;
    @UnsupportedAppUsage
    public static final int DEVICE_IN_BLUETOOTH_A2DP = -2147352576;
    public static final int DEVICE_IN_LOOPBACK = -2147221504;
    public static final int DEVICE_IN_IP = -2146959360;
    public static final int DEVICE_IN_BUS = -2146435072;
    public static final int DEVICE_IN_PROXY = -2130706432;
    public static final int DEVICE_IN_USB_HEADSET = -2113929216;
    public static final int DEVICE_IN_BLUETOOTH_BLE = -2080374784;
    public static final int DEVICE_IN_HDMI_ARC = -2013265920;
    public static final int DEVICE_IN_ECHO_REFERENCE = -1879048192;
    @UnsupportedAppUsage
    public static final int DEVICE_IN_DEFAULT = -1073741824;
    public static final int DEVICE_IN_ALL = -551550977;
    public static final int DEVICE_IN_ALL_SCO = -2147483640;
    public static final int DEVICE_IN_ALL_USB = -2113923072;
    @UnsupportedAppUsage
    public static final int DEVICE_STATE_UNAVAILABLE = 0;
    @UnsupportedAppUsage
    public static final int DEVICE_STATE_AVAILABLE = 1;
    private static final int NUM_DEVICE_STATES = 1;
    public static final String DEVICE_OUT_EARPIECE_NAME = "earpiece";
    public static final String DEVICE_OUT_SPEAKER_NAME = "speaker";
    public static final String DEVICE_OUT_WIRED_HEADSET_NAME = "headset";
    public static final String DEVICE_OUT_WIRED_HEADPHONE_NAME = "headphone";
    public static final String DEVICE_OUT_BLUETOOTH_SCO_NAME = "bt_sco";
    public static final String DEVICE_OUT_BLUETOOTH_SCO_HEADSET_NAME = "bt_sco_hs";
    public static final String DEVICE_OUT_BLUETOOTH_SCO_CARKIT_NAME = "bt_sco_carkit";
    public static final String DEVICE_OUT_BLUETOOTH_A2DP_NAME = "bt_a2dp";
    public static final String DEVICE_OUT_BLUETOOTH_A2DP_HEADPHONES_NAME = "bt_a2dp_hp";
    public static final String DEVICE_OUT_BLUETOOTH_A2DP_SPEAKER_NAME = "bt_a2dp_spk";
    public static final String DEVICE_OUT_AUX_DIGITAL_NAME = "aux_digital";
    public static final String DEVICE_OUT_HDMI_NAME = "hdmi";
    public static final String DEVICE_OUT_ANLG_DOCK_HEADSET_NAME = "analog_dock";
    public static final String DEVICE_OUT_DGTL_DOCK_HEADSET_NAME = "digital_dock";
    public static final String DEVICE_OUT_USB_ACCESSORY_NAME = "usb_accessory";
    public static final String DEVICE_OUT_USB_DEVICE_NAME = "usb_device";
    public static final String DEVICE_OUT_REMOTE_SUBMIX_NAME = "remote_submix";
    public static final String DEVICE_OUT_TELEPHONY_TX_NAME = "telephony_tx";
    public static final String DEVICE_OUT_LINE_NAME = "line";
    public static final String DEVICE_OUT_HDMI_ARC_NAME = "hmdi_arc";
    public static final String DEVICE_OUT_SPDIF_NAME = "spdif";
    public static final String DEVICE_OUT_FM_NAME = "fm_transmitter";
    public static final String DEVICE_OUT_AUX_LINE_NAME = "aux_line";
    public static final String DEVICE_OUT_SPEAKER_SAFE_NAME = "speaker_safe";
    public static final String DEVICE_OUT_IP_NAME = "ip";
    public static final String DEVICE_OUT_BUS_NAME = "bus";
    public static final String DEVICE_OUT_PROXY_NAME = "proxy";
    public static final String DEVICE_OUT_USB_HEADSET_NAME = "usb_headset";
    public static final String DEVICE_OUT_HEARING_AID_NAME = "hearing_aid_out";
    public static final String DEVICE_IN_COMMUNICATION_NAME = "communication";
    public static final String DEVICE_IN_AMBIENT_NAME = "ambient";
    public static final String DEVICE_IN_BUILTIN_MIC_NAME = "mic";
    public static final String DEVICE_IN_BLUETOOTH_SCO_HEADSET_NAME = "bt_sco_hs";
    public static final String DEVICE_IN_WIRED_HEADSET_NAME = "headset";
    public static final String DEVICE_IN_AUX_DIGITAL_NAME = "aux_digital";
    public static final String DEVICE_IN_TELEPHONY_RX_NAME = "telephony_rx";
    public static final String DEVICE_IN_BACK_MIC_NAME = "back_mic";
    public static final String DEVICE_IN_REMOTE_SUBMIX_NAME = "remote_submix";
    public static final String DEVICE_IN_ANLG_DOCK_HEADSET_NAME = "analog_dock";
    public static final String DEVICE_IN_DGTL_DOCK_HEADSET_NAME = "digital_dock";
    public static final String DEVICE_IN_USB_ACCESSORY_NAME = "usb_accessory";
    public static final String DEVICE_IN_USB_DEVICE_NAME = "usb_device";
    public static final String DEVICE_IN_FM_TUNER_NAME = "fm_tuner";
    public static final String DEVICE_IN_TV_TUNER_NAME = "tv_tuner";
    public static final String DEVICE_IN_LINE_NAME = "line";
    public static final String DEVICE_IN_SPDIF_NAME = "spdif";
    public static final String DEVICE_IN_BLUETOOTH_A2DP_NAME = "bt_a2dp";
    public static final String DEVICE_IN_LOOPBACK_NAME = "loopback";
    public static final String DEVICE_IN_IP_NAME = "ip";
    public static final String DEVICE_IN_BUS_NAME = "bus";
    public static final String DEVICE_IN_PROXY_NAME = "proxy";
    public static final String DEVICE_IN_USB_HEADSET_NAME = "usb_headset";
    public static final String DEVICE_IN_BLUETOOTH_BLE_NAME = "bt_ble";
    public static final String DEVICE_IN_ECHO_REFERENCE_NAME = "echo_reference";
    public static final String DEVICE_IN_HDMI_ARC_NAME = "hdmi_arc";
    public static final int PHONE_STATE_OFFCALL = 0;
    public static final int PHONE_STATE_RINGING = 1;
    public static final int PHONE_STATE_INCALL = 2;
    @UnsupportedAppUsage
    public static final int FORCE_NONE = 0;
    public static final int FORCE_SPEAKER = 1;
    public static final int FORCE_HEADPHONES = 2;
    public static final int FORCE_BT_SCO = 3;
    public static final int FORCE_BT_A2DP = 4;
    public static final int FORCE_WIRED_ACCESSORY = 5;
    @UnsupportedAppUsage
    public static final int FORCE_BT_CAR_DOCK = 6;
    @UnsupportedAppUsage
    public static final int FORCE_BT_DESK_DOCK = 7;
    @UnsupportedAppUsage
    public static final int FORCE_ANALOG_DOCK = 8;
    @UnsupportedAppUsage
    public static final int FORCE_DIGITAL_DOCK = 9;
    public static final int FORCE_NO_BT_A2DP = 10;
    public static final int FORCE_SYSTEM_ENFORCED = 11;
    public static final int FORCE_HDMI_SYSTEM_AUDIO_ENFORCED = 12;
    public static final int FORCE_ENCODED_SURROUND_NEVER = 13;
    public static final int FORCE_ENCODED_SURROUND_ALWAYS = 14;
    public static final int FORCE_ENCODED_SURROUND_MANUAL = 15;
    public static final int NUM_FORCE_CONFIG = 16;
    public static final int FORCE_DEFAULT = 0;
    public static final int FOR_COMMUNICATION = 0;
    public static final int FOR_MEDIA = 1;
    public static final int FOR_RECORD = 2;
    public static final int FOR_DOCK = 3;
    public static final int FOR_SYSTEM = 4;
    public static final int FOR_HDMI_SYSTEM_AUDIO = 5;
    public static final int FOR_ENCODED_SURROUND = 6;
    public static final int FOR_VIBRATE_RINGING = 7;
    private static final int NUM_FORCE_USE = 8;
    public static final int SYNC_EVENT_NONE = 0;
    public static final int SYNC_EVENT_PRESENTATION_COMPLETE = 1;
    public static final int AUDIO_HW_SYNC_INVALID = 0;
    public static final int PLAY_SOUND_DELAY = 300;
    public static final String IN_VOICE_COMM_FOCUS_ID = "AudioFocus_For_Phone_Ring_And_Calls";
    public static int[] DEFAULT_STREAM_VOLUME;
    public static final int PLATFORM_DEFAULT = 0;
    public static final int PLATFORM_VOICE = 1;
    public static final int PLATFORM_TELEVISION = 2;
    public static final int DEFAULT_MUTE_STREAMS_AFFECTED = 111;
    static final int NATIVE_EVENT_ROUTING_CHANGE = 1000;

    private static native int native_get_FCC_8();

    @UnsupportedAppUsage
    public static final int getNumStreamTypes() {
        return 11;
    }

    @UnsupportedAppUsage
    public static native int muteMicrophone(boolean var0);

    @UnsupportedAppUsage
    public static native boolean isMicrophoneMuted();

    public static String modeToString(int mode) {
        switch (mode) {
            case -1: {
                return "MODE_CURRENT";
            }
            case 2: {
                return "MODE_IN_CALL";
            }
            case 3: {
                return "MODE_IN_COMMUNICATION";
            }
            case -2: {
                return "MODE_INVALID";
            }
            case 0: {
                return "MODE_NORMAL";
            }
            case 1: {
                return "MODE_RINGTONE";
            }
        }
        return "unknown mode (" + mode + ")";
    }

    public static int audioFormatToBluetoothSourceCodec(int audioFormat) {
        switch (audioFormat) {
            case 0x4000000: {
                return 1;
            }
            case 0x1F000000: {
                return 0;
            }
            case 0x20000000: {
                return 2;
            }
            case 0x21000000: {
                return 3;
            }
            case 0x23000000: {
                return 4;
            }
        }
        return 1000000;
    }

    @UnsupportedAppUsage
    public static native boolean isStreamActive(int var0, int var1);

    public static native boolean isStreamActiveRemotely(int var0, int var1);

    @UnsupportedAppUsage
    public static native boolean isSourceActive(int var0);

    public static native int newAudioSessionId();

    public static native int newAudioPlayerId();

    public static native int newAudioRecorderId();

    @UnsupportedAppUsage
    public static native int setParameters(String var0);

    @UnsupportedAppUsage
    public static native String getParameters(String var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public static void setErrorCallback(ErrorCallback cb) {
        Class<AudioSystem> clazz = AudioSystem.class;
        synchronized (AudioSystem.class) {
            mErrorCallback = cb;
            if (cb != null) {
                cb.onError(AudioSystem.checkAudioFlinger());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    private static void errorCallbackFromNative(int error) {
        ErrorCallback errorCallback = null;
        Class<AudioSystem> clazz = AudioSystem.class;
        synchronized (AudioSystem.class) {
            if (mErrorCallback != null) {
                errorCallback = mErrorCallback;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (errorCallback != null) {
                errorCallback.onError(error);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDynamicPolicyCallback(DynamicPolicyCallback cb) {
        Class<AudioSystem> clazz = AudioSystem.class;
        synchronized (AudioSystem.class) {
            sDynPolicyCallback = cb;
            AudioSystem.native_register_dynamic_policy_callback();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    private static void dynamicPolicyCallbackFromNative(int event, String regId, int val) {
        DynamicPolicyCallback cb = null;
        Class<AudioSystem> clazz = AudioSystem.class;
        synchronized (AudioSystem.class) {
            if (sDynPolicyCallback != null) {
                cb = sDynPolicyCallback;
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            if (cb != null) {
                switch (event) {
                    case 0: {
                        cb.onDynamicPolicyMixStateUpdate(regId, val);
                        break;
                    }
                    default: {
                        Log.e(TAG, "dynamicPolicyCallbackFromNative: unknown event " + event);
                    }
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setRecordingCallback(AudioRecordingCallback cb) {
        Class<AudioSystem> clazz = AudioSystem.class;
        synchronized (AudioSystem.class) {
            sRecordingCallback = cb;
            AudioSystem.native_register_recording_callback();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    private static void recordingCallbackFromNative(int event, int riid, int uid, int session, int source, int portId, boolean silenced, int[] recordingFormat, AudioEffect.Descriptor[] clientEffects, AudioEffect.Descriptor[] effects, int activeSource) {
        AudioRecordingCallback cb = null;
        Class<AudioSystem> clazz = AudioSystem.class;
        synchronized (AudioSystem.class) {
            String effectName;
            cb = sRecordingCallback;
            // ** MonitorExit[var12_12] (shouldn't be in output)
            String clientEffectName = clientEffects.length == 0 ? "None" : clientEffects[0].name;
            String string2 = effectName = effects.length == 0 ? "None" : effects[0].name;
            if (cb != null) {
                cb.onRecordingConfigurationChanged(event, riid, uid, session, source, portId, silenced, recordingFormat, clientEffects, effects, activeSource, "");
            }
            return;
        }
    }

    public static String deviceStateToString(int state) {
        switch (state) {
            case 0: {
                return "DEVICE_STATE_UNAVAILABLE";
            }
            case 1: {
                return "DEVICE_STATE_AVAILABLE";
            }
        }
        return "unknown state (" + state + ")";
    }

    @UnsupportedAppUsage
    public static String getOutputDeviceName(int device) {
        switch (device) {
            case 1: {
                return DEVICE_OUT_EARPIECE_NAME;
            }
            case 2: {
                return DEVICE_OUT_SPEAKER_NAME;
            }
            case 4: {
                return "headset";
            }
            case 8: {
                return DEVICE_OUT_WIRED_HEADPHONE_NAME;
            }
            case 16: {
                return DEVICE_OUT_BLUETOOTH_SCO_NAME;
            }
            case 32: {
                return "bt_sco_hs";
            }
            case 64: {
                return DEVICE_OUT_BLUETOOTH_SCO_CARKIT_NAME;
            }
            case 128: {
                return "bt_a2dp";
            }
            case 256: {
                return DEVICE_OUT_BLUETOOTH_A2DP_HEADPHONES_NAME;
            }
            case 512: {
                return DEVICE_OUT_BLUETOOTH_A2DP_SPEAKER_NAME;
            }
            case 1024: {
                return DEVICE_OUT_HDMI_NAME;
            }
            case 2048: {
                return "analog_dock";
            }
            case 4096: {
                return "digital_dock";
            }
            case 8192: {
                return "usb_accessory";
            }
            case 16384: {
                return "usb_device";
            }
            case 32768: {
                return "remote_submix";
            }
            case 65536: {
                return DEVICE_OUT_TELEPHONY_TX_NAME;
            }
            case 131072: {
                return "line";
            }
            case 262144: {
                return DEVICE_OUT_HDMI_ARC_NAME;
            }
            case 524288: {
                return "spdif";
            }
            case 0x100000: {
                return DEVICE_OUT_FM_NAME;
            }
            case 0x200000: {
                return DEVICE_OUT_AUX_LINE_NAME;
            }
            case 0x400000: {
                return DEVICE_OUT_SPEAKER_SAFE_NAME;
            }
            case 0x800000: {
                return "ip";
            }
            case 0x1000000: {
                return "bus";
            }
            case 0x2000000: {
                return "proxy";
            }
            case 0x4000000: {
                return "usb_headset";
            }
            case 0x8000000: {
                return DEVICE_OUT_HEARING_AID_NAME;
            }
        }
        return Integer.toString(device);
    }

    public static String getInputDeviceName(int device) {
        switch (device) {
            case -2147483647: {
                return DEVICE_IN_COMMUNICATION_NAME;
            }
            case -2147483646: {
                return DEVICE_IN_AMBIENT_NAME;
            }
            case -2147483644: {
                return DEVICE_IN_BUILTIN_MIC_NAME;
            }
            case -2147483640: {
                return "bt_sco_hs";
            }
            case -2147483632: {
                return "headset";
            }
            case -2147483616: {
                return "aux_digital";
            }
            case -2147483584: {
                return DEVICE_IN_TELEPHONY_RX_NAME;
            }
            case -2147483520: {
                return DEVICE_IN_BACK_MIC_NAME;
            }
            case -2147483392: {
                return "remote_submix";
            }
            case -2147483136: {
                return "analog_dock";
            }
            case -2147482624: {
                return "digital_dock";
            }
            case -2147481600: {
                return "usb_accessory";
            }
            case -2147479552: {
                return "usb_device";
            }
            case -2147475456: {
                return DEVICE_IN_FM_TUNER_NAME;
            }
            case -2147467264: {
                return DEVICE_IN_TV_TUNER_NAME;
            }
            case -2147450880: {
                return "line";
            }
            case -2147418112: {
                return "spdif";
            }
            case -2147352576: {
                return "bt_a2dp";
            }
            case -2147221504: {
                return DEVICE_IN_LOOPBACK_NAME;
            }
            case -2146959360: {
                return "ip";
            }
            case -2146435072: {
                return "bus";
            }
            case -2130706432: {
                return "proxy";
            }
            case -2113929216: {
                return "usb_headset";
            }
            case -2080374784: {
                return DEVICE_IN_BLUETOOTH_BLE_NAME;
            }
            case -1879048192: {
                return DEVICE_IN_ECHO_REFERENCE_NAME;
            }
            case -2013265920: {
                return DEVICE_IN_HDMI_ARC_NAME;
            }
        }
        return Integer.toString(device);
    }

    public static String forceUseConfigToString(int config) {
        switch (config) {
            case 0: {
                return "FORCE_NONE";
            }
            case 1: {
                return "FORCE_SPEAKER";
            }
            case 2: {
                return "FORCE_HEADPHONES";
            }
            case 3: {
                return "FORCE_BT_SCO";
            }
            case 4: {
                return "FORCE_BT_A2DP";
            }
            case 5: {
                return "FORCE_WIRED_ACCESSORY";
            }
            case 6: {
                return "FORCE_BT_CAR_DOCK";
            }
            case 7: {
                return "FORCE_BT_DESK_DOCK";
            }
            case 8: {
                return "FORCE_ANALOG_DOCK";
            }
            case 9: {
                return "FORCE_DIGITAL_DOCK";
            }
            case 10: {
                return "FORCE_NO_BT_A2DP";
            }
            case 11: {
                return "FORCE_SYSTEM_ENFORCED";
            }
            case 12: {
                return "FORCE_HDMI_SYSTEM_AUDIO_ENFORCED";
            }
            case 13: {
                return "FORCE_ENCODED_SURROUND_NEVER";
            }
            case 14: {
                return "FORCE_ENCODED_SURROUND_ALWAYS";
            }
            case 15: {
                return "FORCE_ENCODED_SURROUND_MANUAL";
            }
        }
        return "unknown config (" + config + ")";
    }

    public static String forceUseUsageToString(int usage) {
        switch (usage) {
            case 0: {
                return "FOR_COMMUNICATION";
            }
            case 1: {
                return "FOR_MEDIA";
            }
            case 2: {
                return "FOR_RECORD";
            }
            case 3: {
                return "FOR_DOCK";
            }
            case 4: {
                return "FOR_SYSTEM";
            }
            case 5: {
                return "FOR_HDMI_SYSTEM_AUDIO";
            }
            case 6: {
                return "FOR_ENCODED_SURROUND";
            }
            case 7: {
                return "FOR_VIBRATE_RINGING";
            }
        }
        return "unknown usage (" + usage + ")";
    }

    public static int setStreamVolumeIndexAS(int stream, int index, int device) {
        return AudioSystem.setStreamVolumeIndex(stream, index, device);
    }

    @UnsupportedAppUsage
    public static native int setDeviceConnectionState(int var0, int var1, String var2, String var3, int var4);

    @UnsupportedAppUsage
    public static native int getDeviceConnectionState(int var0, String var1);

    public static native int handleDeviceConfigChange(int var0, String var1, String var2, int var3);

    @UnsupportedAppUsage
    public static native int setPhoneState(int var0);

    @UnsupportedAppUsage
    public static native int setForceUse(int var0, int var1);

    @UnsupportedAppUsage
    public static native int getForceUse(int var0);

    @UnsupportedAppUsage
    public static native int initStreamVolume(int var0, int var1, int var2);

    @UnsupportedAppUsage
    private static native int setStreamVolumeIndex(int var0, int var1, int var2);

    public static native int getStreamVolumeIndex(int var0, int var1);

    public static native int setVolumeIndexForAttributes(AudioAttributes var0, int var1, int var2);

    public static native int getVolumeIndexForAttributes(AudioAttributes var0, int var1);

    public static native int getMinVolumeIndexForAttributes(AudioAttributes var0);

    public static native int getMaxVolumeIndexForAttributes(AudioAttributes var0);

    public static native int setMasterVolume(float var0);

    public static native float getMasterVolume();

    @UnsupportedAppUsage
    public static native int setMasterMute(boolean var0);

    @UnsupportedAppUsage
    public static native boolean getMasterMute();

    @UnsupportedAppUsage
    public static native int getDevicesForStream(int var0);

    public static native boolean getMasterMono();

    public static native int setMasterMono(boolean var0);

    public static native int setRttEnabled(boolean var0);

    public static native float getMasterBalance();

    public static native int setMasterBalance(float var0);

    @UnsupportedAppUsage(trackingBug=134049522L)
    public static native int getPrimaryOutputSamplingRate();

    @UnsupportedAppUsage(trackingBug=134049522L)
    public static native int getPrimaryOutputFrameCount();

    @UnsupportedAppUsage
    public static native int getOutputLatency(int var0);

    public static native int setLowRamDevice(boolean var0, long var1);

    @UnsupportedAppUsage
    public static native int checkAudioFlinger();

    public static native int listAudioPorts(ArrayList<AudioPort> var0, int[] var1);

    public static native int createAudioPatch(AudioPatch[] var0, AudioPortConfig[] var1, AudioPortConfig[] var2);

    public static native int releaseAudioPatch(AudioPatch var0);

    public static native int listAudioPatches(ArrayList<AudioPatch> var0, int[] var1);

    public static native int setAudioPortConfig(AudioPortConfig var0);

    public static native int startAudioSource(AudioPortConfig var0, AudioAttributes var1);

    public static native int stopAudioSource(int var0);

    private static final native void native_register_dynamic_policy_callback();

    private static final native void native_register_recording_callback();

    public static native int getAudioHwSyncForSession(int var0);

    public static native int registerPolicyMixes(ArrayList<AudioMix> var0, boolean var1);

    public static native int setUidDeviceAffinities(int var0, int[] var1, String[] var2);

    public static native int removeUidDeviceAffinities(int var0);

    public static native int systemReady();

    public static native float getStreamVolumeDB(int var0, int var1, int var2);

    public static native int setAllowedCapturePolicy(int var0, int var1);

    static boolean isOffloadSupported(AudioFormat format, AudioAttributes attr2) {
        return AudioSystem.native_is_offload_supported(format.getEncoding(), format.getSampleRate(), format.getChannelMask(), format.getChannelIndexMask(), attr2.getVolumeControlStream());
    }

    private static native boolean native_is_offload_supported(int var0, int var1, int var2, int var3, int var4);

    public static native int getMicrophones(ArrayList<MicrophoneInfo> var0);

    public static native int getSurroundFormats(Map<Integer, Boolean> var0, boolean var1);

    public static native int getHwOffloadEncodingFormatsSupportedForA2DP(ArrayList<Integer> var0);

    public static native int setSurroundFormatEnabled(int var0, boolean var1);

    public static native int setAssistantUid(int var0);

    public static native int setA11yServicesUids(int[] var0);

    public static native boolean isHapticPlaybackSupported();

    public static int getValueForVibrateSetting(int existingValue, int vibrateType, int vibrateSetting) {
        existingValue &= ~(3 << vibrateType * 2);
        return existingValue |= (vibrateSetting & 3) << vibrateType * 2;
    }

    public static int getDefaultStreamVolume(int streamType) {
        return DEFAULT_STREAM_VOLUME[streamType];
    }

    public static String streamToString(int stream) {
        if (stream >= 0 && stream < STREAM_NAMES.length) {
            return STREAM_NAMES[stream];
        }
        if (stream == Integer.MIN_VALUE) {
            return "USE_DEFAULT_STREAM_TYPE";
        }
        return "UNKNOWN_STREAM_" + stream;
    }

    public static int getPlatformType(Context context) {
        if (context.getResources().getBoolean(17891570)) {
            return 1;
        }
        if (context.getPackageManager().hasSystemFeature("android.software.leanback")) {
            return 2;
        }
        return 0;
    }

    public static boolean isSingleVolume(Context context) {
        boolean forceSingleVolume = context.getResources().getBoolean(17891516);
        return AudioSystem.getPlatformType(context) == 2 || forceSingleVolume;
    }

    static {
        DEFAULT_STREAM_VOLUME = new int[]{4, 7, 5, 5, 6, 5, 7, 7, 5, 5, 5};
    }

    public static interface AudioRecordingCallback {
        public void onRecordingConfigurationChanged(int var1, int var2, int var3, int var4, int var5, int var6, boolean var7, int[] var8, AudioEffect.Descriptor[] var9, AudioEffect.Descriptor[] var10, int var11, String var12);
    }

    public static interface DynamicPolicyCallback {
        public void onDynamicPolicyMixStateUpdate(String var1, int var2);
    }

    public static interface ErrorCallback {
        public void onError(int var1);
    }
}

