/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.annotation.SystemApi;
import android.media.AudioAttributes;
import android.media.AudioDeviceInfo;
import android.media.AudioSystem;
import android.media.PlayerBase;
import android.media.VolumeShaper;
import com.android.internal.util.Preconditions;

@SystemApi
public class HwAudioSource
extends PlayerBase {
    private final AudioDeviceInfo mAudioDeviceInfo;
    private final AudioAttributes mAudioAttributes;
    private int mNativeHandle;

    private HwAudioSource(AudioDeviceInfo device, AudioAttributes attributes) {
        super(attributes, 14);
        Preconditions.checkNotNull(device);
        Preconditions.checkNotNull(attributes);
        Preconditions.checkArgument(device.isSource(), "Requires a source device");
        this.mAudioDeviceInfo = device;
        this.mAudioAttributes = attributes;
        this.baseRegisterPlayer();
    }

    @Override
    void playerSetVolume(boolean muting, float leftVolume, float rightVolume) {
    }

    @Override
    int playerApplyVolumeShaper(VolumeShaper.Configuration configuration, VolumeShaper.Operation operation) {
        return 0;
    }

    @Override
    VolumeShaper.State playerGetVolumeShaperState(int id2) {
        return new VolumeShaper.State(1.0f, 1.0f);
    }

    @Override
    int playerSetAuxEffectSendLevel(boolean muting, float level) {
        return 0;
    }

    @Override
    void playerStart() {
        this.start();
    }

    @Override
    void playerPause() {
        this.stop();
    }

    @Override
    void playerStop() {
        this.stop();
    }

    public void start() {
        Preconditions.checkState(!this.isPlaying(), "HwAudioSource is currently playing");
        this.baseStart();
        this.mNativeHandle = AudioSystem.startAudioSource(this.mAudioDeviceInfo.getPort().activeConfig(), this.mAudioAttributes);
    }

    public boolean isPlaying() {
        return this.mNativeHandle != 0;
    }

    public void stop() {
        this.baseStop();
        if (this.mNativeHandle > 0) {
            AudioSystem.stopAudioSource(this.mNativeHandle);
            this.mNativeHandle = 0;
        }
    }

    public static final class Builder {
        private AudioAttributes mAudioAttributes;
        private AudioDeviceInfo mAudioDeviceInfo;

        public Builder setAudioAttributes(AudioAttributes attributes) {
            Preconditions.checkNotNull(attributes);
            this.mAudioAttributes = attributes;
            return this;
        }

        public Builder setAudioDeviceInfo(AudioDeviceInfo info) {
            Preconditions.checkNotNull(info);
            Preconditions.checkArgument(info.isSource());
            this.mAudioDeviceInfo = info;
            return this;
        }

        public HwAudioSource build() {
            Preconditions.checkNotNull(this.mAudioDeviceInfo);
            if (this.mAudioAttributes == null) {
                this.mAudioAttributes = new AudioAttributes.Builder().setUsage(1).build();
            }
            return new HwAudioSource(this.mAudioDeviceInfo, this.mAudioAttributes);
        }
    }
}

