/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.annotation.UnsupportedAppUsage;
import android.content.res.AssetFileDescriptor;
import android.media.AudioFormat;
import android.media.AudioTrack;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.AndroidRuntimeException;
import android.util.Log;
import java.io.FileDescriptor;
import java.lang.ref.WeakReference;

public class JetPlayer {
    private static int MAXTRACKS = 32;
    private static final int JET_EVENT = 1;
    private static final int JET_USERID_UPDATE = 2;
    private static final int JET_NUMQUEUEDSEGMENT_UPDATE = 3;
    private static final int JET_PAUSE_UPDATE = 4;
    private static final int JET_EVENT_VAL_MASK = 127;
    private static final int JET_EVENT_CTRL_MASK = 16256;
    private static final int JET_EVENT_CHAN_MASK = 245760;
    private static final int JET_EVENT_TRACK_MASK = 0xFC0000;
    private static final int JET_EVENT_SEG_MASK = -16777216;
    private static final int JET_EVENT_CTRL_SHIFT = 7;
    private static final int JET_EVENT_CHAN_SHIFT = 14;
    private static final int JET_EVENT_TRACK_SHIFT = 18;
    private static final int JET_EVENT_SEG_SHIFT = 24;
    private static final int JET_OUTPUT_RATE = 22050;
    private static final int JET_OUTPUT_CHANNEL_CONFIG = 12;
    private NativeEventHandler mEventHandler = null;
    private Looper mInitializationLooper = null;
    private final Object mEventListenerLock = new Object();
    private OnJetEventListener mJetEventListener = null;
    private static JetPlayer singletonRef;
    @UnsupportedAppUsage
    private long mNativePlayerInJavaObj;
    private static final String TAG = "JetPlayer-J";

    public static JetPlayer getJetPlayer() {
        if (singletonRef == null) {
            singletonRef = new JetPlayer();
        }
        return singletonRef;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    private JetPlayer() {
        int buffSizeInBytes;
        this.mInitializationLooper = Looper.myLooper();
        if (this.mInitializationLooper == null) {
            this.mInitializationLooper = Looper.getMainLooper();
        }
        if ((buffSizeInBytes = AudioTrack.getMinBufferSize(22050, 12, 2)) != -1 && buffSizeInBytes != -2) {
            this.native_setup(new WeakReference<JetPlayer>(this), JetPlayer.getMaxTracks(), Math.max(1200, buffSizeInBytes / (AudioFormat.getBytesPerSample(2) * 2)));
        }
    }

    protected void finalize() {
        this.native_finalize();
    }

    public void release() {
        this.native_release();
        singletonRef = null;
    }

    public static int getMaxTracks() {
        return MAXTRACKS;
    }

    public boolean loadJetFile(String path) {
        return this.native_loadJetFromFile(path);
    }

    public boolean loadJetFile(AssetFileDescriptor afd) {
        long len = afd.getLength();
        if (len < 0L) {
            throw new AndroidRuntimeException("no length for fd");
        }
        return this.native_loadJetFromFileD(afd.getFileDescriptor(), afd.getStartOffset(), len);
    }

    public boolean closeJetFile() {
        return this.native_closeJetFile();
    }

    public boolean play() {
        return this.native_playJet();
    }

    public boolean pause() {
        return this.native_pauseJet();
    }

    public boolean queueJetSegment(int segmentNum, int libNum, int repeatCount, int transpose, int muteFlags, byte userID) {
        return this.native_queueJetSegment(segmentNum, libNum, repeatCount, transpose, muteFlags, userID);
    }

    public boolean queueJetSegmentMuteArray(int segmentNum, int libNum, int repeatCount, int transpose, boolean[] muteArray, byte userID) {
        if (muteArray.length != JetPlayer.getMaxTracks()) {
            return false;
        }
        return this.native_queueJetSegmentMuteArray(segmentNum, libNum, repeatCount, transpose, muteArray, userID);
    }

    public boolean setMuteFlags(int muteFlags, boolean sync) {
        return this.native_setMuteFlags(muteFlags, sync);
    }

    public boolean setMuteArray(boolean[] muteArray, boolean sync) {
        if (muteArray.length != JetPlayer.getMaxTracks()) {
            return false;
        }
        return this.native_setMuteArray(muteArray, sync);
    }

    public boolean setMuteFlag(int trackId, boolean muteFlag, boolean sync) {
        return this.native_setMuteFlag(trackId, muteFlag, sync);
    }

    public boolean triggerClip(int clipId) {
        return this.native_triggerClip(clipId);
    }

    public boolean clearQueue() {
        return this.native_clearQueue();
    }

    public void setEventListener(OnJetEventListener listener) {
        this.setEventListener(listener, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEventListener(OnJetEventListener listener, Handler handler) {
        Object object = this.mEventListenerLock;
        synchronized (object) {
            this.mJetEventListener = listener;
            this.mEventHandler = listener != null ? (handler != null ? new NativeEventHandler(this, handler.getLooper()) : new NativeEventHandler(this, this.mInitializationLooper)) : null;
        }
    }

    private final native boolean native_setup(Object var1, int var2, int var3);

    private final native void native_finalize();

    private final native void native_release();

    private final native boolean native_loadJetFromFile(String var1);

    private final native boolean native_loadJetFromFileD(FileDescriptor var1, long var2, long var4);

    private final native boolean native_closeJetFile();

    private final native boolean native_playJet();

    private final native boolean native_pauseJet();

    private final native boolean native_queueJetSegment(int var1, int var2, int var3, int var4, int var5, byte var6);

    private final native boolean native_queueJetSegmentMuteArray(int var1, int var2, int var3, int var4, boolean[] var5, byte var6);

    private final native boolean native_setMuteFlags(int var1, boolean var2);

    private final native boolean native_setMuteArray(boolean[] var1, boolean var2);

    private final native boolean native_setMuteFlag(int var1, boolean var2, boolean var3);

    private final native boolean native_triggerClip(int var1);

    private final native boolean native_clearQueue();

    @UnsupportedAppUsage
    private static void postEventFromNative(Object jetplayer_ref, int what, int arg1, int arg2) {
        JetPlayer jet = (JetPlayer)((WeakReference)jetplayer_ref).get();
        if (jet != null && jet.mEventHandler != null) {
            Message m = jet.mEventHandler.obtainMessage(what, arg1, arg2, null);
            jet.mEventHandler.sendMessage(m);
        }
    }

    private static void logd(String msg) {
        Log.d(TAG, "[ android.media.JetPlayer ] " + msg);
    }

    private static void loge(String msg) {
        Log.e(TAG, "[ android.media.JetPlayer ] " + msg);
    }

    public static interface OnJetEventListener {
        public void onJetEvent(JetPlayer var1, short var2, byte var3, byte var4, byte var5, byte var6);

        public void onJetUserIdUpdate(JetPlayer var1, int var2, int var3);

        public void onJetNumQueuedSegmentUpdate(JetPlayer var1, int var2);

        public void onJetPauseUpdate(JetPlayer var1, int var2);
    }

    private class NativeEventHandler
    extends Handler {
        private JetPlayer mJet;

        public NativeEventHandler(JetPlayer jet, Looper looper) {
            super(looper);
            this.mJet = jet;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            OnJetEventListener listener = null;
            Object object = JetPlayer.this.mEventListenerLock;
            synchronized (object) {
                listener = this.mJet.mJetEventListener;
            }
            switch (msg.what) {
                case 1: {
                    if (listener != null) {
                        JetPlayer.this.mJetEventListener.onJetEvent(this.mJet, (short)((msg.arg1 & 0xFF000000) >> 24), (byte)((msg.arg1 & 0xFC0000) >> 18), (byte)(((msg.arg1 & 0x3C000) >> 14) + 1), (byte)((msg.arg1 & 0x3F80) >> 7), (byte)(msg.arg1 & 0x7F));
                    }
                    return;
                }
                case 2: {
                    if (listener != null) {
                        listener.onJetUserIdUpdate(this.mJet, msg.arg1, msg.arg2);
                    }
                    return;
                }
                case 3: {
                    if (listener != null) {
                        listener.onJetNumQueuedSegmentUpdate(this.mJet, msg.arg1);
                    }
                    return;
                }
                case 4: {
                    if (listener != null) {
                        listener.onJetPauseUpdate(this.mJet, msg.arg1);
                    }
                    return;
                }
            }
            JetPlayer.loge("Unknown message type " + msg.what);
        }
    }
}

