/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.hardware.cas.V1_0.HidlCasPluginDescriptor;
import android.hardware.cas.V1_0.ICas;
import android.hardware.cas.V1_0.IMediaCasService;
import android.hardware.cas.V1_1.ICasListener;
import android.media.MediaCasException;
import android.media.MediaCasStateException;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IHwBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import android.util.Singleton;
import java.util.ArrayList;

public final class MediaCas
implements AutoCloseable {
    private static final String TAG = "MediaCas";
    private ICas mICas;
    private android.hardware.cas.V1_1.ICas mICasV11;
    private EventListener mListener;
    private HandlerThread mHandlerThread;
    private EventHandler mEventHandler;
    private static final Singleton<IMediaCasService> sService = new Singleton<IMediaCasService>(){

        @Override
        protected IMediaCasService create() {
            try {
                Log.d(MediaCas.TAG, "Tried to get cas@1.1 service");
                android.hardware.cas.V1_1.IMediaCasService serviceV11 = android.hardware.cas.V1_1.IMediaCasService.getService(true);
                if (serviceV11 != null) {
                    return serviceV11;
                }
            }
            catch (Exception eV1_1) {
                try {
                    Log.d(MediaCas.TAG, "Tried to get cas@1.0 service");
                    return IMediaCasService.getService(true);
                }
                catch (Exception eV1_0) {
                    Log.d(MediaCas.TAG, "Failed to get cas@1.0 service");
                }
            }
            return null;
        }
    };
    private final ICasListener.Stub mBinder;

    static IMediaCasService getService() {
        return sService.get();
    }

    private void validateInternalStates() {
        if (this.mICas == null) {
            throw new IllegalStateException();
        }
    }

    private void cleanupAndRethrowIllegalState() {
        this.mICas = null;
        this.mICasV11 = null;
        throw new IllegalStateException();
    }

    private ArrayList<Byte> toByteArray(byte[] data, int offset, int length) {
        ArrayList<Byte> byteArray = new ArrayList<Byte>(length);
        for (int i = 0; i < length; ++i) {
            byteArray.add(data[offset + i]);
        }
        return byteArray;
    }

    private ArrayList<Byte> toByteArray(byte[] data) {
        if (data == null) {
            return new ArrayList<Byte>();
        }
        return this.toByteArray(data, 0, data.length);
    }

    private byte[] toBytes(ArrayList<Byte> byteArray) {
        byte[] data = null;
        if (byteArray != null) {
            data = new byte[byteArray.size()];
            for (int i = 0; i < data.length; ++i) {
                data[i] = byteArray.get(i);
            }
        }
        return data;
    }

    Session createFromSessionId(ArrayList<Byte> sessionId) {
        if (sessionId == null || sessionId.size() == 0) {
            return null;
        }
        return new Session(sessionId);
    }

    public static boolean isSystemIdSupported(int CA_system_id) {
        IMediaCasService service = MediaCas.getService();
        if (service != null) {
            try {
                return service.isSystemIdSupported(CA_system_id);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return false;
    }

    public static PluginDescriptor[] enumeratePlugins() {
        IMediaCasService service = MediaCas.getService();
        if (service != null) {
            try {
                ArrayList<HidlCasPluginDescriptor> descriptors = service.enumeratePlugins();
                if (descriptors.size() == 0) {
                    return null;
                }
                PluginDescriptor[] results = new PluginDescriptor[descriptors.size()];
                for (int i = 0; i < results.length; ++i) {
                    results[i] = new PluginDescriptor(descriptors.get(i));
                }
                return results;
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaCas(int CA_system_id) throws MediaCasException.UnsupportedCasException {
        block7: {
            this.mBinder = new ICasListener.Stub(){

                @Override
                public void onEvent(int event, int arg, ArrayList<Byte> data) throws RemoteException {
                    MediaCas.this.mEventHandler.sendMessage(MediaCas.this.mEventHandler.obtainMessage(0, event, arg, data));
                }

                @Override
                public void onSessionEvent(ArrayList<Byte> sessionId, int event, int arg, ArrayList<Byte> data) throws RemoteException {
                    Message msg = MediaCas.this.mEventHandler.obtainMessage();
                    msg.what = 1;
                    msg.arg1 = event;
                    msg.arg2 = arg;
                    Bundle bundle = new Bundle();
                    bundle.putByteArray("sessionId", MediaCas.this.toBytes(sessionId));
                    bundle.putByteArray("data", MediaCas.this.toBytes(data));
                    msg.setData(bundle);
                    MediaCas.this.mEventHandler.sendMessage(msg);
                }
            };
            try {
                IMediaCasService service = MediaCas.getService();
                android.hardware.cas.V1_1.IMediaCasService serviceV11 = android.hardware.cas.V1_1.IMediaCasService.castFrom(service);
                if (serviceV11 == null) {
                    Log.d(TAG, "Used cas@1_0 interface to create plugin");
                    this.mICas = service.createPlugin(CA_system_id, this.mBinder);
                } else {
                    Log.d(TAG, "Used cas@1.1 interface to create plugin");
                    this.mICasV11 = serviceV11.createPluginExt(CA_system_id, this.mBinder);
                    this.mICas = this.mICasV11;
                }
            }
            catch (Exception e) {
                Log.e(TAG, "Failed to create plugin: " + e);
                this.mICas = null;
                return this.mICas;
            }
            finally {
                if (this.mICas != null) break block7;
                throw new MediaCasException.UnsupportedCasException("Unsupported CA_system_id " + CA_system_id);
            }
        }
    }

    IHwBinder getBinder() {
        this.validateInternalStates();
        return this.mICas.asBinder();
    }

    public void setEventListener(EventListener listener, Handler handler) {
        Looper looper;
        this.mListener = listener;
        if (this.mListener == null) {
            this.mEventHandler = null;
            return;
        }
        Looper looper2 = looper = handler != null ? handler.getLooper() : null;
        if (looper == null && (looper = Looper.myLooper()) == null && (looper = Looper.getMainLooper()) == null) {
            if (this.mHandlerThread == null || !this.mHandlerThread.isAlive()) {
                this.mHandlerThread = new HandlerThread("MediaCasEventThread", -2);
                this.mHandlerThread.start();
            }
            looper = this.mHandlerThread.getLooper();
        }
        this.mEventHandler = new EventHandler(looper);
    }

    public void setPrivateData(byte[] data) throws MediaCasException {
        this.validateInternalStates();
        try {
            MediaCasException.throwExceptionIfNeeded(this.mICas.setPrivateData(this.toByteArray(data, 0, data.length)));
        }
        catch (RemoteException e) {
            this.cleanupAndRethrowIllegalState();
        }
    }

    public Session openSession() throws MediaCasException {
        this.validateInternalStates();
        try {
            OpenSessionCallback cb = new OpenSessionCallback();
            this.mICas.openSession(cb);
            MediaCasException.throwExceptionIfNeeded(cb.mStatus);
            return cb.mSession;
        }
        catch (RemoteException e) {
            this.cleanupAndRethrowIllegalState();
            return null;
        }
    }

    public void processEmm(byte[] data, int offset, int length) throws MediaCasException {
        this.validateInternalStates();
        try {
            MediaCasException.throwExceptionIfNeeded(this.mICas.processEmm(this.toByteArray(data, offset, length)));
        }
        catch (RemoteException e) {
            this.cleanupAndRethrowIllegalState();
        }
    }

    public void processEmm(byte[] data) throws MediaCasException {
        this.processEmm(data, 0, data.length);
    }

    public void sendEvent(int event, int arg, byte[] data) throws MediaCasException {
        this.validateInternalStates();
        try {
            MediaCasException.throwExceptionIfNeeded(this.mICas.sendEvent(event, arg, this.toByteArray(data)));
        }
        catch (RemoteException e) {
            this.cleanupAndRethrowIllegalState();
        }
    }

    public void provision(String provisionString) throws MediaCasException {
        this.validateInternalStates();
        try {
            MediaCasException.throwExceptionIfNeeded(this.mICas.provision(provisionString));
        }
        catch (RemoteException e) {
            this.cleanupAndRethrowIllegalState();
        }
    }

    public void refreshEntitlements(int refreshType, byte[] refreshData) throws MediaCasException {
        this.validateInternalStates();
        try {
            MediaCasException.throwExceptionIfNeeded(this.mICas.refreshEntitlements(refreshType, this.toByteArray(refreshData)));
        }
        catch (RemoteException e) {
            this.cleanupAndRethrowIllegalState();
        }
    }

    @Override
    public void close() {
        if (this.mICas != null) {
            try {
                this.mICas.release();
            }
            catch (RemoteException remoteException) {
            }
            finally {
                this.mICas = null;
            }
        }
    }

    protected void finalize() {
        this.close();
    }

    private class OpenSessionCallback
    implements ICas.openSessionCallback {
        public Session mSession;
        public int mStatus;

        private OpenSessionCallback() {
        }

        @Override
        public void onValues(int status, ArrayList<Byte> sessionId) {
            this.mStatus = status;
            this.mSession = MediaCas.this.createFromSessionId(sessionId);
        }
    }

    public static interface EventListener {
        public void onEvent(MediaCas var1, int var2, int var3, byte[] var4);

        default public void onSessionEvent(MediaCas mediaCas, Session session, int event, int arg, byte[] data) {
            Log.d(MediaCas.TAG, "Received MediaCas Session event");
        }
    }

    public final class Session
    implements AutoCloseable {
        final ArrayList<Byte> mSessionId;

        Session(ArrayList<Byte> sessionId) {
            this.mSessionId = sessionId;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Session) {
                return this.mSessionId.equals(((Session)obj).mSessionId);
            }
            return false;
        }

        public void setPrivateData(byte[] data) throws MediaCasException {
            MediaCas.this.validateInternalStates();
            try {
                MediaCasException.throwExceptionIfNeeded(MediaCas.this.mICas.setSessionPrivateData(this.mSessionId, MediaCas.this.toByteArray(data, 0, data.length)));
            }
            catch (RemoteException e) {
                MediaCas.this.cleanupAndRethrowIllegalState();
            }
        }

        public void processEcm(byte[] data, int offset, int length) throws MediaCasException {
            MediaCas.this.validateInternalStates();
            try {
                MediaCasException.throwExceptionIfNeeded(MediaCas.this.mICas.processEcm(this.mSessionId, MediaCas.this.toByteArray(data, offset, length)));
            }
            catch (RemoteException e) {
                MediaCas.this.cleanupAndRethrowIllegalState();
            }
        }

        public void processEcm(byte[] data) throws MediaCasException {
            this.processEcm(data, 0, data.length);
        }

        public void sendSessionEvent(int event, int arg, byte[] data) throws MediaCasException {
            MediaCas.this.validateInternalStates();
            if (MediaCas.this.mICasV11 == null) {
                Log.d(MediaCas.TAG, "Send Session Event isn't supported by cas@1.0 interface");
                throw new MediaCasException.UnsupportedCasException("Send Session Event is not supported");
            }
            try {
                MediaCasException.throwExceptionIfNeeded(MediaCas.this.mICasV11.sendSessionEvent(this.mSessionId, event, arg, MediaCas.this.toByteArray(data)));
            }
            catch (RemoteException e) {
                MediaCas.this.cleanupAndRethrowIllegalState();
            }
        }

        @Override
        public void close() {
            MediaCas.this.validateInternalStates();
            try {
                MediaCasStateException.throwExceptionIfNeeded(MediaCas.this.mICas.closeSession(this.mSessionId));
            }
            catch (RemoteException e) {
                MediaCas.this.cleanupAndRethrowIllegalState();
            }
        }
    }

    public static class PluginDescriptor {
        private final int mCASystemId;
        private final String mName;

        private PluginDescriptor() {
            this.mCASystemId = 65535;
            this.mName = null;
        }

        PluginDescriptor(HidlCasPluginDescriptor descriptor) {
            this.mCASystemId = descriptor.caSystemId;
            this.mName = descriptor.name;
        }

        public int getSystemId() {
            return this.mCASystemId;
        }

        public String getName() {
            return this.mName;
        }

        public String toString() {
            return "PluginDescriptor {" + this.mCASystemId + ", " + this.mName + "}";
        }
    }

    private class EventHandler
    extends Handler {
        private static final int MSG_CAS_EVENT = 0;
        private static final int MSG_CAS_SESSION_EVENT = 1;
        private static final String SESSION_KEY = "sessionId";
        private static final String DATA_KEY = "data";

        public EventHandler(Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message msg) {
            if (msg.what == 0) {
                MediaCas.this.mListener.onEvent(MediaCas.this, msg.arg1, msg.arg2, MediaCas.this.toBytes((ArrayList)msg.obj));
            } else if (msg.what == 1) {
                Bundle bundle = msg.getData();
                ArrayList sessionId = MediaCas.this.toByteArray(bundle.getByteArray(SESSION_KEY));
                MediaCas.this.mListener.onSessionEvent(MediaCas.this, MediaCas.this.createFromSessionId(sessionId), msg.arg1, msg.arg2, bundle.getByteArray(DATA_KEY));
            }
        }
    }
}

