/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.annotation.UnsupportedAppUsage;
import android.content.ContentProviderClient;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.database.SQLException;
import android.drm.DrmManagerClient;
import android.graphics.BitmapFactory;
import android.media.ExifInterface;
import android.media.MediaFile;
import android.media.MediaInserter;
import android.media.MediaScannerClient;
import android.media.RingtoneManager;
import android.mtp.MtpConstants;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.RemoteException;
import android.os.SystemProperties;
import android.provider.MediaStore;
import android.provider.Settings;
import android.sax.Element;
import android.sax.ElementListener;
import android.sax.RootElement;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.text.TextUtils;
import android.util.Log;
import android.util.Xml;
import dalvik.system.CloseGuard;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicBoolean;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

@Deprecated
public class MediaScanner
implements AutoCloseable {
    private static final String TAG = "MediaScanner";
    @UnsupportedAppUsage
    private static final String[] FILES_PRESCAN_PROJECTION;
    private static final String[] ID_PROJECTION;
    private static final int FILES_PRESCAN_ID_COLUMN_INDEX = 0;
    private static final int FILES_PRESCAN_PATH_COLUMN_INDEX = 1;
    private static final int FILES_PRESCAN_FORMAT_COLUMN_INDEX = 2;
    private static final int FILES_PRESCAN_DATE_MODIFIED_COLUMN_INDEX = 3;
    private static final int FILES_PRESCAN_MEDIA_TYPE_COLUMN_INDEX = 4;
    private static final String[] PLAYLIST_MEMBERS_PROJECTION;
    private static final int ID_PLAYLISTS_COLUMN_INDEX = 0;
    private static final int PATH_PLAYLISTS_COLUMN_INDEX = 1;
    private static final int DATE_MODIFIED_PLAYLISTS_COLUMN_INDEX = 2;
    private static final String RINGTONES_DIR = "/ringtones/";
    private static final String NOTIFICATIONS_DIR = "/notifications/";
    private static final String ALARMS_DIR = "/alarms/";
    private static final String MUSIC_DIR = "/music/";
    private static final String PODCASTS_DIR = "/podcasts/";
    private static final String AUDIOBOOKS_DIR = "/audiobooks/";
    public static final String SCANNED_BUILD_PREFS_NAME = "MediaScanBuild";
    public static final String LAST_INTERNAL_SCAN_FINGERPRINT = "lastScanFingerprint";
    private static final String SYSTEM_SOUNDS_DIR;
    private static final String OEM_SOUNDS_DIR;
    private static final String PRODUCT_SOUNDS_DIR;
    private static String sLastInternalScanFingerprint;
    private static final String[] ID3_GENRES;
    private long mNativeContext;
    @UnsupportedAppUsage
    private final Context mContext;
    @UnsupportedAppUsage
    private final String mPackageName;
    private final String mVolumeName;
    private final ContentProviderClient mMediaProvider;
    @UnsupportedAppUsage
    private final Uri mAudioUri;
    private final Uri mVideoUri;
    private final Uri mImagesUri;
    private final Uri mPlaylistsUri;
    @UnsupportedAppUsage
    private final Uri mFilesUri;
    private final Uri mFilesFullUri;
    private final boolean mProcessPlaylists;
    private final boolean mProcessGenres;
    private int mMtpObjectHandle;
    private final AtomicBoolean mClosed = new AtomicBoolean();
    private final CloseGuard mCloseGuard = CloseGuard.get();
    private static final boolean ENABLE_BULK_INSERTS = true;
    private int mOriginalCount;
    private boolean mDefaultRingtoneSet;
    private boolean mDefaultNotificationSet;
    private boolean mDefaultAlarmSet;
    @UnsupportedAppUsage
    private String mDefaultRingtoneFilename;
    @UnsupportedAppUsage
    private String mDefaultNotificationFilename;
    @UnsupportedAppUsage
    private String mDefaultAlarmAlertFilename;
    private static final String DEFAULT_RINGTONE_PROPERTY_PREFIX = "ro.config.";
    private final BitmapFactory.Options mBitmapOptions = new BitmapFactory.Options();
    private final ArrayList<PlaylistEntry> mPlaylistEntries = new ArrayList();
    private final ArrayList<FileEntry> mPlayLists = new ArrayList();
    @UnsupportedAppUsage
    private MediaInserter mMediaInserter;
    private DrmManagerClient mDrmManagerClient = null;
    @UnsupportedAppUsage
    private final MyMediaScannerClient mClient = new MyMediaScannerClient();
    private static HashMap<String, String> mNoMediaPaths;
    private static HashMap<String, String> mMediaPaths;

    @UnsupportedAppUsage
    public MediaScanner(Context c, String volumeName) {
        this.native_setup();
        this.mContext = c;
        this.mPackageName = c.getPackageName();
        this.mVolumeName = volumeName;
        this.mBitmapOptions.inSampleSize = 1;
        this.mBitmapOptions.inJustDecodeBounds = true;
        this.setDefaultRingtoneFileNames();
        this.mMediaProvider = this.mContext.getContentResolver().acquireContentProviderClient("media");
        if (sLastInternalScanFingerprint == null) {
            SharedPreferences scanSettings = this.mContext.getSharedPreferences(SCANNED_BUILD_PREFS_NAME, 0);
            sLastInternalScanFingerprint = scanSettings.getString(LAST_INTERNAL_SCAN_FINGERPRINT, new String());
        }
        this.mAudioUri = MediaStore.Audio.Media.getContentUri(volumeName);
        this.mVideoUri = MediaStore.Video.Media.getContentUri(volumeName);
        this.mImagesUri = MediaStore.Images.Media.getContentUri(volumeName);
        this.mFilesUri = MediaStore.Files.getContentUri(volumeName);
        Uri filesFullUri = this.mFilesUri.buildUpon().appendQueryParameter("nonotify", "1").build();
        filesFullUri = MediaStore.setIncludePending(filesFullUri);
        this.mFilesFullUri = filesFullUri = MediaStore.setIncludeTrashed(filesFullUri);
        if (!volumeName.equals("internal")) {
            this.mProcessPlaylists = true;
            this.mProcessGenres = true;
            this.mPlaylistsUri = MediaStore.Audio.Playlists.getContentUri(volumeName);
        } else {
            this.mProcessPlaylists = false;
            this.mProcessGenres = false;
            this.mPlaylistsUri = null;
        }
        Locale locale = this.mContext.getResources().getConfiguration().locale;
        if (locale != null) {
            String language = locale.getLanguage();
            String country = locale.getCountry();
            if (language != null) {
                if (country != null) {
                    this.setLocale(language + "_" + country);
                } else {
                    this.setLocale(language);
                }
            }
        }
        this.mCloseGuard.open("close");
    }

    private void setDefaultRingtoneFileNames() {
        this.mDefaultRingtoneFilename = SystemProperties.get("ro.config.ringtone");
        this.mDefaultNotificationFilename = SystemProperties.get("ro.config.notification_sound");
        this.mDefaultAlarmAlertFilename = SystemProperties.get("ro.config.alarm_alert");
    }

    @UnsupportedAppUsage
    private boolean isDrmEnabled() {
        String prop = SystemProperties.get("drm.service.enabled");
        return prop != null && prop.equals("true");
    }

    private static boolean isSystemSoundWithMetadata(String path) {
        return path.startsWith(SYSTEM_SOUNDS_DIR + ALARMS_DIR) || path.startsWith(SYSTEM_SOUNDS_DIR + RINGTONES_DIR) || path.startsWith(SYSTEM_SOUNDS_DIR + NOTIFICATIONS_DIR) || path.startsWith(OEM_SOUNDS_DIR + ALARMS_DIR) || path.startsWith(OEM_SOUNDS_DIR + RINGTONES_DIR) || path.startsWith(OEM_SOUNDS_DIR + NOTIFICATIONS_DIR) || path.startsWith(PRODUCT_SOUNDS_DIR + ALARMS_DIR) || path.startsWith(PRODUCT_SOUNDS_DIR + RINGTONES_DIR) || path.startsWith(PRODUCT_SOUNDS_DIR + NOTIFICATIONS_DIR);
    }

    private String settingSetIndicatorName(String base) {
        return base + "_set";
    }

    private boolean wasRingtoneAlreadySet(String name) {
        ContentResolver cr = this.mContext.getContentResolver();
        String indicatorName = this.settingSetIndicatorName(name);
        try {
            return Settings.System.getInt(cr, indicatorName) != 0;
        }
        catch (Settings.SettingNotFoundException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    private void prescan(String filePath, boolean prescanFiles) throws RemoteException {
        Cursor c;
        block14: {
            c = null;
            String where = null;
            String[] selectionArgs = null;
            this.mPlayLists.clear();
            if (filePath != null) {
                where = "_id>? AND _data=?";
                selectionArgs = new String[]{"", filePath};
            } else {
                where = "_id>?";
                selectionArgs = new String[]{""};
            }
            this.mDefaultRingtoneSet = this.wasRingtoneAlreadySet("ringtone");
            this.mDefaultNotificationSet = this.wasRingtoneAlreadySet("notification_sound");
            this.mDefaultAlarmSet = this.wasRingtoneAlreadySet("alarm_alert");
            Uri.Builder builder = this.mFilesUri.buildUpon();
            builder.appendQueryParameter("deletedata", "false");
            MediaBulkDeleter deleter = new MediaBulkDeleter(this.mMediaProvider, builder.build());
            try {
                if (!prescanFiles) break block14;
                long lastId = Long.MIN_VALUE;
                Uri limitUri = this.mFilesUri.buildUpon().appendQueryParameter("limit", "1000").build();
                block5: while (true) {
                    selectionArgs[0] = "" + lastId;
                    if (c != null) {
                        c.close();
                        c = null;
                    }
                    if ((c = this.mMediaProvider.query(limitUri, FILES_PRESCAN_PROJECTION, where, selectionArgs, "_id", null)) == null) {
                        break;
                    }
                    int num = c.getCount();
                    if (num == 0) {
                        break;
                    }
                    while (true) {
                        String mimeType;
                        if (!c.moveToNext()) continue block5;
                        long rowId = c.getLong(0);
                        String path = c.getString(1);
                        int format = c.getInt(2);
                        long lastModified = c.getLong(3);
                        lastId = rowId;
                        if (path == null || !path.startsWith("/")) continue;
                        boolean exists = false;
                        try {
                            exists = Os.access(path, OsConstants.F_OK);
                        }
                        catch (ErrnoException errnoException) {
                            // empty catch block
                        }
                        if (exists || MtpConstants.isAbstractObject(format) || MediaFile.isPlayListMimeType(mimeType = MediaFile.getMimeTypeForFile(path))) continue;
                        deleter.delete(rowId);
                        if (!path.toLowerCase(Locale.US).endsWith("/.nomedia")) continue;
                        deleter.flush();
                        String parent = new File(path).getParent();
                        this.mMediaProvider.call("unhide", parent, null);
                    }
                    break;
                }
            }
            finally {
                if (c != null) {
                    c.close();
                }
                deleter.flush();
            }
        }
        this.mOriginalCount = 0;
        c = this.mMediaProvider.query(this.mImagesUri, ID_PROJECTION, null, null, null, null);
        if (c != null) {
            this.mOriginalCount = c.getCount();
            c.close();
        }
    }

    @UnsupportedAppUsage
    private void postscan(String[] directories) throws RemoteException {
        if (this.mProcessPlaylists) {
            this.processPlayLists();
        }
        this.mPlayLists.clear();
    }

    private void releaseResources() {
        if (this.mDrmManagerClient != null) {
            this.mDrmManagerClient.close();
            this.mDrmManagerClient = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scanDirectories(String[] directories) {
        try {
            long start = System.currentTimeMillis();
            this.prescan(null, true);
            long prescan = System.currentTimeMillis();
            this.mMediaInserter = new MediaInserter(this.mMediaProvider, 500);
            for (int i = 0; i < directories.length; ++i) {
                this.processDirectory(directories[i], this.mClient);
            }
            this.mMediaInserter.flushAll();
            this.mMediaInserter = null;
            long scan = System.currentTimeMillis();
            this.postscan(directories);
            long l = System.currentTimeMillis();
        }
        catch (SQLException e) {
            Log.e(TAG, "SQLException in MediaScanner.scan()", e);
        }
        catch (UnsupportedOperationException e) {
            Log.e(TAG, "UnsupportedOperationException in MediaScanner.scan()", e);
        }
        catch (RemoteException e) {
            Log.e(TAG, "RemoteException in MediaScanner.scan()", e);
        }
        finally {
            this.releaseResources();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public Uri scanSingleFile(String path, String mimeType) {
        try {
            this.prescan(path, true);
            File file = new File(path);
            if (!file.exists() || !file.canRead()) {
                Uri uri = null;
                return uri;
            }
            long lastModifiedSeconds = file.lastModified() / 1000L;
            Uri uri = this.mClient.doScanFile(path, mimeType, lastModifiedSeconds, file.length(), false, true, MediaScanner.isNoMediaPath(path));
            return uri;
        }
        catch (RemoteException e) {
            Log.e(TAG, "RemoteException in MediaScanner.scanFile()", e);
            Uri uri = null;
            return uri;
        }
        finally {
            this.releaseResources();
        }
    }

    private static boolean isNoMediaFile(String path) {
        File file = new File(path);
        if (file.isDirectory()) {
            return false;
        }
        int lastSlash = path.lastIndexOf(47);
        if (lastSlash >= 0 && lastSlash + 2 < path.length()) {
            if (path.regionMatches(lastSlash + 1, "._", 0, 2)) {
                return true;
            }
            if (path.regionMatches(true, path.length() - 4, ".jpg", 0, 4)) {
                if (path.regionMatches(true, lastSlash + 1, "AlbumArt_{", 0, 10) || path.regionMatches(true, lastSlash + 1, "AlbumArt.", 0, 9)) {
                    return true;
                }
                int length = path.length() - lastSlash - 1;
                if (length == 17 && path.regionMatches(true, lastSlash + 1, "AlbumArtSmall", 0, 13) || length == 10 && path.regionMatches(true, lastSlash + 1, "Folder", 0, 6)) {
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearMediaPathCache(boolean clearMediaPaths, boolean clearNoMediaPaths) {
        Class<MediaScanner> clazz = MediaScanner.class;
        synchronized (MediaScanner.class) {
            if (clearMediaPaths) {
                mMediaPaths.clear();
            }
            if (clearNoMediaPaths) {
                mNoMediaPaths.clear();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public static boolean isNoMediaPath(String path) {
        if (path == null) {
            return false;
        }
        if (path.indexOf("/.") >= 0) {
            return true;
        }
        int firstSlash = path.lastIndexOf(47);
        if (firstSlash <= 0) {
            return false;
        }
        String parent = path.substring(0, firstSlash);
        Class<MediaScanner> clazz = MediaScanner.class;
        synchronized (MediaScanner.class) {
            if (mNoMediaPaths.containsKey(parent)) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return true;
            }
            if (!mMediaPaths.containsKey(parent)) {
                int offset = 1;
                while (offset >= 0) {
                    File file;
                    int slashIndex = path.indexOf(47, offset);
                    if (slashIndex > offset && (file = new File(path.substring(0, ++slashIndex) + ".nomedia")).exists()) {
                        mNoMediaPaths.put(parent, "");
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        return true;
                    }
                    offset = slashIndex;
                }
                mMediaPaths.put(parent, "");
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return MediaScanner.isNoMediaFile(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scanMtpFile(String path, int objectHandle, int format) {
        String mimeType = MediaFile.getMimeType(path, format);
        File file = new File(path);
        long lastModifiedSeconds = file.lastModified() / 1000L;
        if (!(MediaFile.isAudioMimeType(mimeType) || MediaFile.isVideoMimeType(mimeType) || MediaFile.isImageMimeType(mimeType) || MediaFile.isPlayListMimeType(mimeType) || MediaFile.isDrmMimeType(mimeType))) {
            ContentValues values = new ContentValues();
            values.put("_size", file.length());
            values.put("date_modified", lastModifiedSeconds);
            try {
                String[] whereArgs = new String[]{Integer.toString(objectHandle)};
                this.mMediaProvider.update(MediaStore.Files.getMtpObjectsUri(this.mVolumeName), values, "_id=?", whereArgs);
            }
            catch (RemoteException e) {
                Log.e(TAG, "RemoteException in scanMtpFile", e);
            }
            return;
        }
        this.mMtpObjectHandle = objectHandle;
        Cursor fileList = null;
        try {
            if (MediaFile.isPlayListMimeType(mimeType)) {
                this.prescan(null, true);
                FileEntry entry = this.makeEntryFor(path);
                if (entry != null) {
                    fileList = this.mMediaProvider.query(this.mFilesUri, FILES_PRESCAN_PROJECTION, null, null, null, null);
                    this.processPlayList(entry, fileList);
                }
            } else {
                this.prescan(path, false);
                this.mClient.doScanFile(path, mimeType, lastModifiedSeconds, file.length(), format == 12289, true, MediaScanner.isNoMediaPath(path));
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "RemoteException in MediaScanner.scanFile()", e);
        }
        finally {
            this.mMtpObjectHandle = 0;
            if (fileList != null) {
                fileList.close();
            }
            this.releaseResources();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    FileEntry makeEntryFor(String path) {
        try (Cursor c = null;){
            String where = "_data=?";
            String[] selectionArgs = new String[]{path};
            c = this.mMediaProvider.query(this.mFilesFullUri, FILES_PRESCAN_PROJECTION, where, selectionArgs, null, null);
            if (c != null && c.moveToFirst()) {
                long rowId = c.getLong(0);
                long lastModified = c.getLong(3);
                int format = c.getInt(2);
                int mediaType = c.getInt(4);
                FileEntry fileEntry = new FileEntry(rowId, path, lastModified, format, mediaType);
                return fileEntry;
            }
        }
        return null;
    }

    private int matchPaths(String path1, String path2) {
        int result = 0;
        int end1 = path1.length();
        int end2 = path2.length();
        while (end1 > 0 && end2 > 0) {
            int start2;
            int slash1 = path1.lastIndexOf(47, end1 - 1);
            int slash2 = path2.lastIndexOf(47, end2 - 1);
            int backSlash1 = path1.lastIndexOf(92, end1 - 1);
            int backSlash2 = path2.lastIndexOf(92, end2 - 1);
            int start1 = slash1 > backSlash1 ? slash1 : backSlash1;
            int n = start2 = slash2 > backSlash2 ? slash2 : backSlash2;
            start1 = start1 < 0 ? 0 : ++start1;
            start2 = start2 < 0 ? 0 : ++start2;
            int length = end1 - start1;
            if (end2 - start2 != length || !path1.regionMatches(true, start1, path2, start2, length)) break;
            ++result;
            end1 = start1 - 1;
            end2 = start2 - 1;
        }
        return result;
    }

    private boolean matchEntries(long rowId, String data) {
        int len = this.mPlaylistEntries.size();
        boolean done = true;
        for (int i = 0; i < len; ++i) {
            PlaylistEntry entry = this.mPlaylistEntries.get(i);
            if (entry.bestmatchlevel == Integer.MAX_VALUE) continue;
            done = false;
            if (data.equalsIgnoreCase(entry.path)) {
                entry.bestmatchid = rowId;
                entry.bestmatchlevel = Integer.MAX_VALUE;
                continue;
            }
            int matchLength = this.matchPaths(data, entry.path);
            if (matchLength <= entry.bestmatchlevel) continue;
            entry.bestmatchid = rowId;
            entry.bestmatchlevel = matchLength;
        }
        return done;
    }

    private void cachePlaylistEntry(String line, String playListDirectory) {
        char ch1;
        boolean fullPath;
        int entryLength;
        PlaylistEntry entry = new PlaylistEntry();
        for (entryLength = line.length(); entryLength > 0 && Character.isWhitespace(line.charAt(entryLength - 1)); --entryLength) {
        }
        if (entryLength < 3) {
            return;
        }
        if (entryLength < line.length()) {
            line = line.substring(0, entryLength);
        }
        boolean bl = fullPath = (ch1 = line.charAt(0)) == '/' || Character.isLetter(ch1) && line.charAt(1) == ':' && line.charAt(2) == '\\';
        if (!fullPath) {
            line = playListDirectory + line;
        }
        entry.path = line;
        this.mPlaylistEntries.add(entry);
    }

    private void processCachedPlaylist(Cursor fileList, ContentValues values, Uri playlistUri) {
        String data;
        long rowId;
        fileList.moveToPosition(-1);
        while (fileList.moveToNext() && !this.matchEntries(rowId = fileList.getLong(0), data = fileList.getString(1))) {
        }
        int len = this.mPlaylistEntries.size();
        int index = 0;
        for (int i = 0; i < len; ++i) {
            PlaylistEntry entry = this.mPlaylistEntries.get(i);
            if (entry.bestmatchlevel <= 0) continue;
            try {
                values.clear();
                values.put("play_order", index);
                values.put("audio_id", entry.bestmatchid);
                this.mMediaProvider.insert(playlistUri, values);
                ++index;
                continue;
            }
            catch (RemoteException e) {
                Log.e(TAG, "RemoteException in MediaScanner.processCachedPlaylist()", e);
                return;
            }
        }
        this.mPlaylistEntries.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processM3uPlayList(String path, String playListDirectory, Uri uri, ContentValues values, Cursor fileList) {
        BufferedReader reader = null;
        try {
            File f = new File(path);
            if (f.exists()) {
                reader = new BufferedReader(new InputStreamReader(new FileInputStream(f)), 8192);
                String line = reader.readLine();
                this.mPlaylistEntries.clear();
                while (line != null) {
                    if (line.length() > 0 && line.charAt(0) != '#') {
                        this.cachePlaylistEntry(line, playListDirectory);
                    }
                    line = reader.readLine();
                }
                this.processCachedPlaylist(fileList, values, uri);
            }
        }
        catch (IOException e) {
            Log.e(TAG, "IOException in MediaScanner.processM3uPlayList()", e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                Log.e(TAG, "IOException in MediaScanner.processM3uPlayList()", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPlsPlayList(String path, String playListDirectory, Uri uri, ContentValues values, Cursor fileList) {
        BufferedReader reader = null;
        try {
            File f = new File(path);
            if (f.exists()) {
                reader = new BufferedReader(new InputStreamReader(new FileInputStream(f)), 8192);
                String line = reader.readLine();
                this.mPlaylistEntries.clear();
                while (line != null) {
                    int equals;
                    if (line.startsWith("File") && (equals = line.indexOf(61)) > 0) {
                        this.cachePlaylistEntry(line.substring(equals + 1), playListDirectory);
                    }
                    line = reader.readLine();
                }
                this.processCachedPlaylist(fileList, values, uri);
            }
        }
        catch (IOException e) {
            Log.e(TAG, "IOException in MediaScanner.processPlsPlayList()", e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                Log.e(TAG, "IOException in MediaScanner.processPlsPlayList()", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processWplPlayList(String path, String playListDirectory, Uri uri, ContentValues values, Cursor fileList) {
        FileInputStream fis = null;
        try {
            File f = new File(path);
            if (f.exists()) {
                fis = new FileInputStream(f);
                this.mPlaylistEntries.clear();
                Xml.parse(fis, Xml.findEncodingByName("UTF-8"), new WplHandler(playListDirectory, uri, fileList).getContentHandler());
                this.processCachedPlaylist(fileList, values, uri);
            }
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {
                Log.e(TAG, "IOException in MediaScanner.processWplPlayList()", e);
            }
        }
    }

    private void processPlayList(FileEntry entry, Cursor fileList) throws RemoteException {
        String mimeType;
        Uri membersUri;
        String path = entry.mPath;
        ContentValues values = new ContentValues();
        int lastSlash = path.lastIndexOf(47);
        if (lastSlash < 0) {
            throw new IllegalArgumentException("bad path " + path);
        }
        long rowId = entry.mRowId;
        String name = values.getAsString("name");
        if (name == null && (name = values.getAsString("title")) == null) {
            int lastDot = path.lastIndexOf(46);
            name = lastDot < 0 ? path.substring(lastSlash + 1) : path.substring(lastSlash + 1, lastDot);
        }
        values.put("name", name);
        values.put("date_modified", entry.mLastModified);
        if (rowId == 0L) {
            values.put("_data", path);
            Uri uri = this.mMediaProvider.insert(this.mPlaylistsUri, values);
            rowId = ContentUris.parseId(uri);
            membersUri = Uri.withAppendedPath(uri, "members");
        } else {
            Uri uri = ContentUris.withAppendedId(this.mPlaylistsUri, rowId);
            this.mMediaProvider.update(uri, values, null, null);
            membersUri = Uri.withAppendedPath(uri, "members");
            this.mMediaProvider.delete(membersUri, null, null);
        }
        String playListDirectory = path.substring(0, lastSlash + 1);
        switch (mimeType = MediaFile.getMimeTypeForFile(path)) {
            case "application/vnd.ms-wpl": {
                this.processWplPlayList(path, playListDirectory, membersUri, values, fileList);
                break;
            }
            case "audio/x-mpegurl": {
                this.processM3uPlayList(path, playListDirectory, membersUri, values, fileList);
                break;
            }
            case "audio/x-scpls": {
                this.processPlsPlayList(path, playListDirectory, membersUri, values, fileList);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPlayLists() throws RemoteException {
        Iterator<FileEntry> iterator = this.mPlayLists.iterator();
        try (Cursor fileList = null;){
            fileList = this.mMediaProvider.query(this.mFilesUri, FILES_PRESCAN_PROJECTION, "media_type=2", null, null, null);
            while (iterator.hasNext()) {
                FileEntry entry = iterator.next();
                if (!entry.mLastModifiedChanged) continue;
                this.processPlayList(entry, fileList);
            }
        }
    }

    private native void processDirectory(String var1, MediaScannerClient var2);

    private native boolean processFile(String var1, String var2, MediaScannerClient var3);

    @UnsupportedAppUsage
    private native void setLocale(String var1);

    public native byte[] extractAlbumArt(FileDescriptor var1);

    private static final native void native_init();

    private final native void native_setup();

    private final native void native_finalize();

    @Override
    public void close() {
        this.mCloseGuard.close();
        if (this.mClosed.compareAndSet(false, true)) {
            this.mMediaProvider.close();
            this.native_finalize();
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mCloseGuard != null) {
                this.mCloseGuard.warnIfOpen();
            }
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    static {
        System.loadLibrary("media_jni");
        MediaScanner.native_init();
        FILES_PRESCAN_PROJECTION = new String[]{"_id", "_data", "format", "date_modified", "media_type"};
        ID_PROJECTION = new String[]{"_id"};
        PLAYLIST_MEMBERS_PROJECTION = new String[]{"playlist_id"};
        SYSTEM_SOUNDS_DIR = Environment.getRootDirectory() + "/media/audio";
        OEM_SOUNDS_DIR = Environment.getOemDirectory() + "/media/audio";
        PRODUCT_SOUNDS_DIR = Environment.getProductDirectory() + "/media/audio";
        ID3_GENRES = new String[]{"Blues", "Classic Rock", "Country", "Dance", "Disco", "Funk", "Grunge", "Hip-Hop", "Jazz", "Metal", "New Age", "Oldies", "Other", "Pop", "R&B", "Rap", "Reggae", "Rock", "Techno", "Industrial", "Alternative", "Ska", "Death Metal", "Pranks", "Soundtrack", "Euro-Techno", "Ambient", "Trip-Hop", "Vocal", "Jazz+Funk", "Fusion", "Trance", "Classical", "Instrumental", "Acid", "House", "Game", "Sound Clip", "Gospel", "Noise", "AlternRock", "Bass", "Soul", "Punk", "Space", "Meditative", "Instrumental Pop", "Instrumental Rock", "Ethnic", "Gothic", "Darkwave", "Techno-Industrial", "Electronic", "Pop-Folk", "Eurodance", "Dream", "Southern Rock", "Comedy", "Cult", "Gangsta", "Top 40", "Christian Rap", "Pop/Funk", "Jungle", "Native American", "Cabaret", "New Wave", "Psychadelic", "Rave", "Showtunes", "Trailer", "Lo-Fi", "Tribal", "Acid Punk", "Acid Jazz", "Polka", "Retro", "Musical", "Rock & Roll", "Hard Rock", "Folk", "Folk-Rock", "National Folk", "Swing", "Fast Fusion", "Bebob", "Latin", "Revival", "Celtic", "Bluegrass", "Avantgarde", "Gothic Rock", "Progressive Rock", "Psychedelic Rock", "Symphonic Rock", "Slow Rock", "Big Band", "Chorus", "Easy Listening", "Acoustic", "Humour", "Speech", "Chanson", "Opera", "Chamber Music", "Sonata", "Symphony", "Booty Bass", "Primus", "Porn Groove", "Satire", "Slow Jam", "Club", "Tango", "Samba", "Folklore", "Ballad", "Power Ballad", "Rhythmic Soul", "Freestyle", "Duet", "Punk Rock", "Drum Solo", "A capella", "Euro-House", "Dance Hall", "Goa", "Drum & Bass", "Club-House", "Hardcore", "Terror", "Indie", "Britpop", null, "Polsk Punk", "Beat", "Christian Gangsta", "Heavy Metal", "Black Metal", "Crossover", "Contemporary Christian", "Christian Rock", "Merengue", "Salsa", "Thrash Metal", "Anime", "JPop", "Synthpop"};
        mNoMediaPaths = new HashMap();
        mMediaPaths = new HashMap();
    }

    class WplHandler
    implements ElementListener {
        final ContentHandler handler;
        String playListDirectory;

        public WplHandler(String playListDirectory, Uri uri, Cursor fileList) {
            this.playListDirectory = playListDirectory;
            RootElement root = new RootElement("smil");
            Element body = root.getChild("body");
            Element seq = body.getChild("seq");
            Element media = seq.getChild("media");
            media.setElementListener(this);
            this.handler = root.getContentHandler();
        }

        @Override
        public void start(Attributes attributes) {
            String path = attributes.getValue("", "src");
            if (path != null) {
                MediaScanner.this.cachePlaylistEntry(path, this.playListDirectory);
            }
        }

        @Override
        public void end() {
        }

        ContentHandler getContentHandler() {
            return this.handler;
        }
    }

    static class MediaBulkDeleter {
        StringBuilder whereClause = new StringBuilder();
        ArrayList<String> whereArgs = new ArrayList(100);
        final ContentProviderClient mProvider;
        final Uri mBaseUri;

        public MediaBulkDeleter(ContentProviderClient provider, Uri baseUri) {
            this.mProvider = provider;
            this.mBaseUri = baseUri;
        }

        public void delete(long id2) throws RemoteException {
            if (this.whereClause.length() != 0) {
                this.whereClause.append(",");
            }
            this.whereClause.append("?");
            this.whereArgs.add("" + id2);
            if (this.whereArgs.size() > 100) {
                this.flush();
            }
        }

        public void flush() throws RemoteException {
            int size = this.whereArgs.size();
            if (size > 0) {
                String[] foo = new String[size];
                foo = this.whereArgs.toArray(foo);
                int numrows = this.mProvider.delete(this.mBaseUri, "_id IN (" + this.whereClause.toString() + ")", foo);
                this.whereClause.setLength(0);
                this.whereArgs.clear();
            }
        }
    }

    private class MyMediaScannerClient
    implements MediaScannerClient {
        private final SimpleDateFormat mDateFormatter = new SimpleDateFormat("yyyyMMdd'T'HHmmss");
        private String mArtist;
        private String mAlbumArtist;
        private String mAlbum;
        private String mTitle;
        private String mComposer;
        private String mGenre;
        @UnsupportedAppUsage
        private String mMimeType;
        @Deprecated
        @UnsupportedAppUsage
        private int mFileType;
        private int mTrack;
        private int mYear;
        private int mDuration;
        @UnsupportedAppUsage
        private String mPath;
        private long mDate;
        private long mLastModified;
        private long mFileSize;
        private String mWriter;
        private int mCompilation;
        @UnsupportedAppUsage
        private boolean mIsDrm;
        @UnsupportedAppUsage
        private boolean mNoMedia;
        private boolean mScanSuccess;
        private int mWidth;
        private int mHeight;
        private int mColorStandard;
        private int mColorTransfer;
        private int mColorRange;

        public MyMediaScannerClient() {
            this.mDateFormatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        }

        @UnsupportedAppUsage
        public FileEntry beginFile(String path, String mimeType, long lastModified, long fileSize, boolean isDirectory, boolean noMedia) {
            boolean wasModified;
            FileEntry entry;
            this.mMimeType = mimeType;
            this.mFileSize = fileSize;
            this.mIsDrm = false;
            this.mScanSuccess = true;
            if (!isDirectory) {
                if (!noMedia && MediaScanner.isNoMediaFile(path)) {
                    noMedia = true;
                }
                this.mNoMedia = noMedia;
                if (this.mMimeType == null) {
                    this.mMimeType = MediaFile.getMimeTypeForFile(path);
                }
                if (MediaScanner.this.isDrmEnabled() && MediaFile.isDrmMimeType(this.mMimeType)) {
                    this.getMimeTypeFromDrm(path);
                }
            }
            long delta = (entry = MediaScanner.this.makeEntryFor(path)) != null ? lastModified - entry.mLastModified : 0L;
            boolean bl = wasModified = delta > 1L || delta < -1L;
            if (entry == null || wasModified) {
                if (wasModified) {
                    entry.mLastModified = lastModified;
                } else {
                    entry = new FileEntry(0L, path, lastModified, isDirectory ? 12289 : 0, 0);
                }
                entry.mLastModifiedChanged = true;
            }
            if (MediaScanner.this.mProcessPlaylists && MediaFile.isPlayListMimeType(this.mMimeType)) {
                MediaScanner.this.mPlayLists.add(entry);
                return null;
            }
            this.mArtist = null;
            this.mAlbumArtist = null;
            this.mAlbum = null;
            this.mTitle = null;
            this.mComposer = null;
            this.mGenre = null;
            this.mTrack = 0;
            this.mYear = 0;
            this.mDuration = 0;
            this.mPath = path;
            this.mDate = 0L;
            this.mLastModified = lastModified;
            this.mWriter = null;
            this.mCompilation = 0;
            this.mWidth = 0;
            this.mHeight = 0;
            this.mColorStandard = -1;
            this.mColorTransfer = -1;
            this.mColorRange = -1;
            return entry;
        }

        @Override
        @UnsupportedAppUsage
        public void scanFile(String path, long lastModified, long fileSize, boolean isDirectory, boolean noMedia) {
            this.doScanFile(path, null, lastModified, fileSize, isDirectory, false, noMedia);
        }

        @UnsupportedAppUsage
        public Uri doScanFile(String path, String mimeType, long lastModified, long fileSize, boolean isDirectory, boolean scanAlways, boolean noMedia) {
            Uri result = null;
            try {
                FileEntry entry = this.beginFile(path, mimeType, lastModified, fileSize, isDirectory, noMedia);
                if (entry == null) {
                    return null;
                }
                if (MediaScanner.this.mMtpObjectHandle != 0) {
                    entry.mRowId = 0L;
                }
                if (entry.mPath != null) {
                    if (!MediaScanner.this.mDefaultNotificationSet && this.doesPathHaveFilename(entry.mPath, MediaScanner.this.mDefaultNotificationFilename) || !MediaScanner.this.mDefaultRingtoneSet && this.doesPathHaveFilename(entry.mPath, MediaScanner.this.mDefaultRingtoneFilename) || !MediaScanner.this.mDefaultAlarmSet && this.doesPathHaveFilename(entry.mPath, MediaScanner.this.mDefaultAlarmAlertFilename)) {
                        Log.w(MediaScanner.TAG, "forcing rescan of " + entry.mPath + "since ringtone setting didn't finish");
                        scanAlways = true;
                    } else if (MediaScanner.isSystemSoundWithMetadata(entry.mPath) && !Build.FINGERPRINT.equals(sLastInternalScanFingerprint)) {
                        Log.i(MediaScanner.TAG, "forcing rescan of " + entry.mPath + " since build fingerprint changed");
                        scanAlways = true;
                    }
                }
                if (entry != null && (entry.mLastModifiedChanged || scanAlways)) {
                    if (noMedia) {
                        result = this.endFile(entry, false, false, false, false, false, false);
                    } else {
                        boolean isaudio = MediaFile.isAudioMimeType(this.mMimeType);
                        boolean isvideo = MediaFile.isVideoMimeType(this.mMimeType);
                        boolean isimage = MediaFile.isImageMimeType(this.mMimeType);
                        if (isaudio || isvideo || isimage) {
                            path = Environment.maybeTranslateEmulatedPathToInternal(new File(path)).getAbsolutePath();
                        }
                        if (isaudio || isvideo) {
                            this.mScanSuccess = MediaScanner.this.processFile(path, mimeType, this);
                        }
                        if (isimage) {
                            this.mScanSuccess = this.processImageFile(path);
                        }
                        String lowpath = path.toLowerCase(Locale.ROOT);
                        boolean ringtones = this.mScanSuccess && lowpath.indexOf(MediaScanner.RINGTONES_DIR) > 0;
                        boolean notifications = this.mScanSuccess && lowpath.indexOf(MediaScanner.NOTIFICATIONS_DIR) > 0;
                        boolean alarms = this.mScanSuccess && lowpath.indexOf(MediaScanner.ALARMS_DIR) > 0;
                        boolean podcasts = this.mScanSuccess && lowpath.indexOf(MediaScanner.PODCASTS_DIR) > 0;
                        boolean audiobooks = this.mScanSuccess && lowpath.indexOf(MediaScanner.AUDIOBOOKS_DIR) > 0;
                        boolean music = this.mScanSuccess && (lowpath.indexOf(MediaScanner.MUSIC_DIR) > 0 || !ringtones && !notifications && !alarms && !podcasts && !audiobooks);
                        result = this.endFile(entry, ringtones, notifications, alarms, podcasts, audiobooks, music);
                    }
                }
            }
            catch (RemoteException e) {
                Log.e(MediaScanner.TAG, "RemoteException in MediaScanner.scanFile()", e);
            }
            return result;
        }

        private long parseDate(String date) {
            try {
                return this.mDateFormatter.parse(date).getTime();
            }
            catch (ParseException e) {
                return 0L;
            }
        }

        private int parseSubstring(String s, int start, int defaultValue) {
            char ch;
            int length = s.length();
            if (start == length) {
                return defaultValue;
            }
            if ((ch = s.charAt(start++)) < '0' || ch > '9') {
                return defaultValue;
            }
            int result = ch - 48;
            while (start < length) {
                if ((ch = s.charAt(start++)) < '0' || ch > '9') {
                    return result;
                }
                result = result * 10 + (ch - 48);
            }
            return result;
        }

        @Override
        @UnsupportedAppUsage
        public void handleStringTag(String name, String value) {
            if (name.equalsIgnoreCase("title") || name.startsWith("title;")) {
                this.mTitle = value;
            } else if (name.equalsIgnoreCase("artist") || name.startsWith("artist;")) {
                this.mArtist = value.trim();
            } else if (name.equalsIgnoreCase("albumartist") || name.startsWith("albumartist;") || name.equalsIgnoreCase("band") || name.startsWith("band;")) {
                this.mAlbumArtist = value.trim();
            } else if (name.equalsIgnoreCase("album") || name.startsWith("album;")) {
                this.mAlbum = value.trim();
            } else if (name.equalsIgnoreCase("composer") || name.startsWith("composer;")) {
                this.mComposer = value.trim();
            } else if (MediaScanner.this.mProcessGenres && (name.equalsIgnoreCase("genre") || name.startsWith("genre;"))) {
                this.mGenre = this.getGenreName(value);
            } else if (name.equalsIgnoreCase("year") || name.startsWith("year;")) {
                this.mYear = this.parseSubstring(value, 0, 0);
            } else if (name.equalsIgnoreCase("tracknumber") || name.startsWith("tracknumber;")) {
                int num = this.parseSubstring(value, 0, 0);
                this.mTrack = this.mTrack / 1000 * 1000 + num;
            } else if (name.equalsIgnoreCase("discnumber") || name.equals("set") || name.startsWith("set;")) {
                int num = this.parseSubstring(value, 0, 0);
                this.mTrack = num * 1000 + this.mTrack % 1000;
            } else if (name.equalsIgnoreCase("duration")) {
                this.mDuration = this.parseSubstring(value, 0, 0);
            } else if (name.equalsIgnoreCase("writer") || name.startsWith("writer;")) {
                this.mWriter = value.trim();
            } else if (name.equalsIgnoreCase("compilation")) {
                this.mCompilation = this.parseSubstring(value, 0, 0);
            } else if (name.equalsIgnoreCase("isdrm")) {
                this.mIsDrm = this.parseSubstring(value, 0, 0) == 1;
            } else if (name.equalsIgnoreCase("date")) {
                this.mDate = this.parseDate(value);
            } else if (name.equalsIgnoreCase("width")) {
                this.mWidth = this.parseSubstring(value, 0, 0);
            } else if (name.equalsIgnoreCase("height")) {
                this.mHeight = this.parseSubstring(value, 0, 0);
            } else if (name.equalsIgnoreCase("colorstandard")) {
                this.mColorStandard = this.parseSubstring(value, 0, -1);
            } else if (name.equalsIgnoreCase("colortransfer")) {
                this.mColorTransfer = this.parseSubstring(value, 0, -1);
            } else if (name.equalsIgnoreCase("colorrange")) {
                this.mColorRange = this.parseSubstring(value, 0, -1);
            }
        }

        private boolean convertGenreCode(String input, String expected) {
            String output = this.getGenreName(input);
            if (output.equals(expected)) {
                return true;
            }
            Log.d(MediaScanner.TAG, "'" + input + "' -> '" + output + "', expected '" + expected + "'");
            return false;
        }

        private void testGenreNameConverter() {
            this.convertGenreCode("2", "Country");
            this.convertGenreCode("(2)", "Country");
            this.convertGenreCode("(2", "(2");
            this.convertGenreCode("2 Foo", "Country");
            this.convertGenreCode("(2) Foo", "Country");
            this.convertGenreCode("(2 Foo", "(2 Foo");
            this.convertGenreCode("2Foo", "2Foo");
            this.convertGenreCode("(2)Foo", "Country");
            this.convertGenreCode("200 Foo", "Foo");
            this.convertGenreCode("(200) Foo", "Foo");
            this.convertGenreCode("200Foo", "200Foo");
            this.convertGenreCode("(200)Foo", "Foo");
            this.convertGenreCode("200)Foo", "200)Foo");
            this.convertGenreCode("200) Foo", "200) Foo");
        }

        public String getGenreName(String genreTagValue) {
            block12: {
                if (genreTagValue == null) {
                    return null;
                }
                int length = genreTagValue.length();
                if (length > 0) {
                    char charAfterNumber;
                    int i;
                    boolean parenthesized = false;
                    StringBuffer number = new StringBuffer();
                    for (i = 0; i < length; ++i) {
                        char c = genreTagValue.charAt(i);
                        if (i == 0 && c == '(') {
                            parenthesized = true;
                            continue;
                        }
                        if (!Character.isDigit(c)) break;
                        number.append(c);
                    }
                    char c = charAfterNumber = i < length ? (char)genreTagValue.charAt(i) : (char)' ';
                    if (parenthesized && charAfterNumber == ')' || !parenthesized && Character.isWhitespace(charAfterNumber)) {
                        try {
                            short genreIndex = Short.parseShort(number.toString());
                            if (genreIndex < 0) break block12;
                            if (genreIndex < ID3_GENRES.length && ID3_GENRES[genreIndex] != null) {
                                return ID3_GENRES[genreIndex];
                            }
                            if (genreIndex == 255) {
                                return null;
                            }
                            if (genreIndex < 255 && i + 1 < length) {
                                String ret;
                                if (parenthesized && charAfterNumber == ')') {
                                    ++i;
                                }
                                if ((ret = genreTagValue.substring(i).trim()).length() != 0) {
                                    return ret;
                                }
                                break block12;
                            }
                            return number.toString();
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                }
            }
            return genreTagValue;
        }

        private boolean processImageFile(String path) {
            try {
                ((MediaScanner)MediaScanner.this).mBitmapOptions.outWidth = 0;
                ((MediaScanner)MediaScanner.this).mBitmapOptions.outHeight = 0;
                BitmapFactory.decodeFile(path, MediaScanner.this.mBitmapOptions);
                this.mWidth = ((MediaScanner)MediaScanner.this).mBitmapOptions.outWidth;
                this.mHeight = ((MediaScanner)MediaScanner.this).mBitmapOptions.outHeight;
                return this.mWidth > 0 && this.mHeight > 0;
            }
            catch (Throwable throwable) {
                return false;
            }
        }

        @Override
        @UnsupportedAppUsage
        public void setMimeType(String mimeType) {
            if ("audio/mp4".equals(this.mMimeType) && mimeType.startsWith("video")) {
                return;
            }
            this.mMimeType = mimeType;
        }

        @UnsupportedAppUsage
        private ContentValues toValues() {
            ContentValues map = new ContentValues();
            map.put("_data", this.mPath);
            map.put("title", this.mTitle);
            map.put("date_modified", this.mLastModified);
            map.put("_size", this.mFileSize);
            map.put("mime_type", this.mMimeType);
            map.put("is_drm", this.mIsDrm);
            map.putNull("_hash");
            String resolution = null;
            if (this.mWidth > 0 && this.mHeight > 0) {
                map.put("width", this.mWidth);
                map.put("height", this.mHeight);
                resolution = this.mWidth + "x" + this.mHeight;
            }
            if (!this.mNoMedia) {
                if (MediaFile.isVideoMimeType(this.mMimeType)) {
                    map.put("artist", this.mArtist != null && this.mArtist.length() > 0 ? this.mArtist : "<unknown>");
                    map.put("album", this.mAlbum != null && this.mAlbum.length() > 0 ? this.mAlbum : "<unknown>");
                    map.put("duration", this.mDuration);
                    if (resolution != null) {
                        map.put("resolution", resolution);
                    }
                    if (this.mColorStandard >= 0) {
                        map.put("color_standard", this.mColorStandard);
                    }
                    if (this.mColorTransfer >= 0) {
                        map.put("color_transfer", this.mColorTransfer);
                    }
                    if (this.mColorRange >= 0) {
                        map.put("color_range", this.mColorRange);
                    }
                    if (this.mDate > 0L) {
                        map.put("datetaken", this.mDate);
                    }
                } else if (!MediaFile.isImageMimeType(this.mMimeType) && MediaFile.isAudioMimeType(this.mMimeType)) {
                    map.put("artist", this.mArtist != null && this.mArtist.length() > 0 ? this.mArtist : "<unknown>");
                    map.put("album_artist", this.mAlbumArtist != null && this.mAlbumArtist.length() > 0 ? this.mAlbumArtist : null);
                    map.put("album", this.mAlbum != null && this.mAlbum.length() > 0 ? this.mAlbum : "<unknown>");
                    map.put("composer", this.mComposer);
                    map.put("genre", this.mGenre);
                    if (this.mYear != 0) {
                        map.put("year", this.mYear);
                    }
                    map.put("track", this.mTrack);
                    map.put("duration", this.mDuration);
                    map.put("compilation", this.mCompilation);
                }
            }
            return map;
        }

        @UnsupportedAppUsage
        private Uri endFile(FileEntry entry, boolean ringtones, boolean notifications, boolean alarms, boolean podcasts, boolean audiobooks, boolean music) throws RemoteException {
            int lastSlash;
            String album;
            ContentValues values;
            String title;
            if (this.mArtist == null || this.mArtist.length() == 0) {
                this.mArtist = this.mAlbumArtist;
            }
            if ((title = (values = this.toValues()).getAsString("title")) == null || TextUtils.isEmpty(title.trim())) {
                title = MediaFile.getFileTitle(values.getAsString("_data"));
                values.put("title", title);
            }
            if ("<unknown>".equals(album = values.getAsString("album")) && (lastSlash = (album = values.getAsString("_data")).lastIndexOf(47)) >= 0) {
                int idx;
                int previousSlash = 0;
                while ((idx = album.indexOf(47, previousSlash + 1)) >= 0 && idx < lastSlash) {
                    previousSlash = idx;
                }
                if (previousSlash != 0) {
                    album = album.substring(previousSlash + 1, lastSlash);
                    values.put("album", album);
                }
            }
            long rowId = entry.mRowId;
            if (MediaFile.isAudioMimeType(this.mMimeType) && (rowId == 0L || MediaScanner.this.mMtpObjectHandle != 0)) {
                values.put("is_ringtone", ringtones);
                values.put("is_notification", notifications);
                values.put("is_alarm", alarms);
                values.put("is_music", music);
                values.put("is_podcast", podcasts);
                values.put("is_audiobook", audiobooks);
            } else if (MediaFile.isExifMimeType(this.mMimeType) && !this.mNoMedia) {
                ExifInterface exif = null;
                try {
                    exif = new ExifInterface(entry.mPath);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (exif != null) {
                    long time = exif.getGpsDateTime();
                    if (time != -1L) {
                        values.put("datetaken", time);
                    } else {
                        time = exif.getDateTime();
                        if (time != -1L && Math.abs(this.mLastModified * 1000L - time) >= 86400000L) {
                            values.put("datetaken", time);
                        }
                    }
                    int orientation = exif.getAttributeInt("Orientation", -1);
                    if (orientation != -1) {
                        int degree;
                        switch (orientation) {
                            case 6: {
                                degree = 90;
                                break;
                            }
                            case 3: {
                                degree = 180;
                                break;
                            }
                            case 8: {
                                degree = 270;
                                break;
                            }
                            default: {
                                degree = 0;
                            }
                        }
                        values.put("orientation", degree);
                    }
                }
            }
            Uri tableUri = MediaScanner.this.mFilesUri;
            int mediaType = 0;
            MediaInserter inserter = MediaScanner.this.mMediaInserter;
            if (!this.mNoMedia) {
                if (MediaFile.isVideoMimeType(this.mMimeType)) {
                    tableUri = MediaScanner.this.mVideoUri;
                    mediaType = 3;
                } else if (MediaFile.isImageMimeType(this.mMimeType)) {
                    tableUri = MediaScanner.this.mImagesUri;
                    mediaType = 1;
                } else if (MediaFile.isAudioMimeType(this.mMimeType)) {
                    tableUri = MediaScanner.this.mAudioUri;
                    mediaType = 2;
                } else if (MediaFile.isPlayListMimeType(this.mMimeType)) {
                    tableUri = MediaScanner.this.mPlaylistsUri;
                    mediaType = 4;
                }
            }
            Uri result = null;
            boolean needToSetSettings = false;
            if (notifications && !MediaScanner.this.mDefaultNotificationSet) {
                if (TextUtils.isEmpty(MediaScanner.this.mDefaultNotificationFilename) || this.doesPathHaveFilename(entry.mPath, MediaScanner.this.mDefaultNotificationFilename)) {
                    needToSetSettings = true;
                }
            } else if (ringtones && !MediaScanner.this.mDefaultRingtoneSet) {
                if (TextUtils.isEmpty(MediaScanner.this.mDefaultRingtoneFilename) || this.doesPathHaveFilename(entry.mPath, MediaScanner.this.mDefaultRingtoneFilename)) {
                    needToSetSettings = true;
                }
            } else if (alarms && !MediaScanner.this.mDefaultAlarmSet && (TextUtils.isEmpty(MediaScanner.this.mDefaultAlarmAlertFilename) || this.doesPathHaveFilename(entry.mPath, MediaScanner.this.mDefaultAlarmAlertFilename))) {
                needToSetSettings = true;
            }
            if (rowId == 0L) {
                if (MediaScanner.this.mMtpObjectHandle != 0) {
                    values.put("media_scanner_new_object_id", MediaScanner.this.mMtpObjectHandle);
                }
                if (tableUri == MediaScanner.this.mFilesUri) {
                    int format = entry.mFormat;
                    if (format == 0) {
                        format = MediaFile.getFormatCode(entry.mPath, this.mMimeType);
                    }
                    values.put("format", format);
                }
                if (inserter == null || needToSetSettings) {
                    if (inserter != null) {
                        inserter.flushAll();
                    }
                    result = MediaScanner.this.mMediaProvider.insert(tableUri, values);
                } else if (entry.mFormat == 12289) {
                    inserter.insertwithPriority(tableUri, values);
                } else {
                    inserter.insert(tableUri, values);
                }
                if (result != null) {
                    entry.mRowId = rowId = ContentUris.parseId(result);
                }
            } else {
                result = ContentUris.withAppendedId(tableUri, rowId);
                values.remove("_data");
                if (!this.mNoMedia && mediaType != entry.mMediaType) {
                    ContentValues mediaTypeValues = new ContentValues();
                    mediaTypeValues.put("media_type", mediaType);
                    MediaScanner.this.mMediaProvider.update(ContentUris.withAppendedId(MediaScanner.this.mFilesUri, rowId), mediaTypeValues, null, null);
                }
                MediaScanner.this.mMediaProvider.update(result, values, null, null);
            }
            if (needToSetSettings) {
                if (notifications) {
                    this.setRingtoneIfNotSet("notification_sound", tableUri, rowId);
                    MediaScanner.this.mDefaultNotificationSet = true;
                } else if (ringtones) {
                    this.setRingtoneIfNotSet("ringtone", tableUri, rowId);
                    MediaScanner.this.mDefaultRingtoneSet = true;
                } else if (alarms) {
                    this.setRingtoneIfNotSet("alarm_alert", tableUri, rowId);
                    MediaScanner.this.mDefaultAlarmSet = true;
                }
            }
            return result;
        }

        private boolean doesPathHaveFilename(String path, String filename) {
            int filenameLength;
            int pathFilenameStart = path.lastIndexOf(File.separatorChar) + 1;
            return path.regionMatches(pathFilenameStart, filename, 0, filenameLength = filename.length()) && pathFilenameStart + filenameLength == path.length();
        }

        private void setRingtoneIfNotSet(String settingName, Uri uri, long rowId) {
            if (MediaScanner.this.wasRingtoneAlreadySet(settingName)) {
                return;
            }
            ContentResolver cr = MediaScanner.this.mContext.getContentResolver();
            String existingSettingValue = Settings.System.getString(cr, settingName);
            if (TextUtils.isEmpty(existingSettingValue)) {
                Uri settingUri = Settings.System.getUriFor(settingName);
                Uri ringtoneUri = ContentUris.withAppendedId(uri, rowId);
                RingtoneManager.setActualDefaultRingtoneUri(MediaScanner.this.mContext, RingtoneManager.getDefaultType(settingUri), ringtoneUri);
            }
            Settings.System.putInt(cr, MediaScanner.this.settingSetIndicatorName(settingName), 1);
        }

        @Deprecated
        @UnsupportedAppUsage
        private int getFileTypeFromDrm(String path) {
            return 0;
        }

        private void getMimeTypeFromDrm(String path) {
            this.mMimeType = null;
            if (MediaScanner.this.mDrmManagerClient == null) {
                MediaScanner.this.mDrmManagerClient = new DrmManagerClient(MediaScanner.this.mContext);
            }
            if (MediaScanner.this.mDrmManagerClient.canHandle(path, null)) {
                this.mIsDrm = true;
                this.mMimeType = MediaScanner.this.mDrmManagerClient.getOriginalMimeType(path);
            }
            if (this.mMimeType == null) {
                this.mMimeType = "application/octet-stream";
            }
        }
    }

    private static class PlaylistEntry {
        String path;
        long bestmatchid;
        int bestmatchlevel;

        private PlaylistEntry() {
        }
    }

    private static class FileEntry {
        @UnsupportedAppUsage
        long mRowId;
        String mPath;
        long mLastModified;
        int mFormat;
        int mMediaType;
        @UnsupportedAppUsage
        boolean mLastModifiedChanged;

        @Deprecated
        @UnsupportedAppUsage
        FileEntry(long rowId, String path, long lastModified, int format) {
            this(rowId, path, lastModified, format, 0);
        }

        FileEntry(long rowId, String path, long lastModified, int format, int mediaType) {
            this.mRowId = rowId;
            this.mPath = path;
            this.mLastModified = lastModified;
            this.mFormat = format;
            this.mMediaType = mediaType;
            this.mLastModifiedChanged = false;
        }

        public String toString() {
            return this.mPath + " mRowId: " + this.mRowId;
        }
    }
}

