/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.Service;
import android.content.Intent;
import android.media.Controller2Link;
import android.media.IMediaSession2Service;
import android.media.MediaSession2;
import android.media.session.MediaSessionManager;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.util.ArrayMap;
import android.util.Log;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class MediaSession2Service
extends Service {
    public static final String SERVICE_INTERFACE = "android.media.MediaSession2Service";
    private static final String TAG = "MediaSession2Service";
    private static final boolean DEBUG = Log.isLoggable("MediaSession2Service", 3);
    private final MediaSession2.ForegroundServiceEventCallback mForegroundServiceEventCallback = new MediaSession2.ForegroundServiceEventCallback(){

        @Override
        public void onPlaybackActiveChanged(MediaSession2 session, boolean playbackActive) {
            MediaSession2Service.this.onPlaybackActiveChanged(session, playbackActive);
        }

        @Override
        public void onSessionClosed(MediaSession2 session) {
            MediaSession2Service.this.removeSession(session);
        }
    };
    private final Object mLock = new Object();
    private NotificationManager mNotificationManager;
    private MediaSessionManager mMediaSessionManager;
    private Intent mStartSelfIntent;
    private Map<String, MediaSession2> mSessions = new ArrayMap<String, MediaSession2>();
    private Map<MediaSession2, MediaNotification> mNotifications = new ArrayMap<MediaSession2, MediaNotification>();
    private MediaSession2ServiceStub mStub;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCreate() {
        super.onCreate();
        Object object = this.mLock;
        synchronized (object) {
            this.mStub = new MediaSession2ServiceStub(this);
            this.mStartSelfIntent = new Intent(this, this.getClass());
            this.mNotificationManager = (NotificationManager)this.getSystemService("notification");
            this.mMediaSessionManager = (MediaSessionManager)this.getSystemService("media_session");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IBinder onBind(Intent intent) {
        if (SERVICE_INTERFACE.equals(intent.getAction())) {
            Object object = this.mLock;
            synchronized (object) {
                return this.mStub;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDestroy() {
        super.onDestroy();
        Object object = this.mLock;
        synchronized (object) {
            List<MediaSession2> sessions = this.getSessions();
            for (MediaSession2 session : sessions) {
                this.removeSession(session);
            }
            this.mSessions.clear();
            this.mNotifications.clear();
        }
        this.mStub.close();
    }

    public abstract MediaSession2 onGetSession(MediaSession2.ControllerInfo var1);

    public abstract MediaNotification onUpdateNotification(MediaSession2 var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addSession(MediaSession2 session) {
        if (session == null) {
            throw new IllegalArgumentException("session shouldn't be null");
        }
        if (session.isClosed()) {
            throw new IllegalArgumentException("session is already closed");
        }
        Object object = this.mLock;
        synchronized (object) {
            MediaSession2 previousSession = this.mSessions.get(session.getId());
            if (previousSession != null) {
                if (previousSession != session) {
                    Log.w(TAG, "Session ID should be unique, ID=" + session.getId() + ", previous=" + previousSession + ", session=" + session);
                }
                return;
            }
            this.mSessions.put(session.getId(), session);
            session.setForegroundServiceEventCallback(this.mForegroundServiceEventCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeSession(MediaSession2 session) {
        MediaNotification notification;
        if (session == null) {
            throw new IllegalArgumentException("session shouldn't be null");
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mSessions.get(session.getId()) != session) {
                return;
            }
            this.mSessions.remove(session.getId());
            notification = this.mNotifications.remove(session);
        }
        session.setForegroundServiceEventCallback(null);
        if (notification != null) {
            this.mNotificationManager.cancel(notification.getNotificationId());
        }
        if (this.getSessions().isEmpty()) {
            this.stopForeground(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<MediaSession2> getSessions() {
        ArrayList<MediaSession2> list = new ArrayList<MediaSession2>();
        Object object = this.mLock;
        synchronized (object) {
            list.addAll(this.mSessions.values());
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MediaSessionManager getMediaSessionManager() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mMediaSessionManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onPlaybackActiveChanged(MediaSession2 session, boolean playbackActive) {
        MediaNotification mediaNotification = this.onUpdateNotification(session);
        if (mediaNotification == null) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mNotifications.put(session, mediaNotification);
        }
        int id2 = mediaNotification.getNotificationId();
        Notification notification = mediaNotification.getNotification();
        if (!playbackActive) {
            this.mNotificationManager.notify(id2, notification);
            return;
        }
        this.startForegroundService(this.mStartSelfIntent);
        this.startForeground(id2, notification);
    }

    private static final class MediaSession2ServiceStub
    extends IMediaSession2Service.Stub
    implements AutoCloseable {
        final WeakReference<MediaSession2Service> mService;
        final Handler mHandler;

        MediaSession2ServiceStub(MediaSession2Service service) {
            this.mService = new WeakReference<MediaSession2Service>(service);
            this.mHandler = new Handler(service.getMainLooper());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void connect(Controller2Link caller, int seq, Bundle connectionRequest) {
            if (this.mService.get() == null) {
                if (DEBUG) {
                    Log.d(MediaSession2Service.TAG, "Service is already destroyed");
                }
                return;
            }
            if (caller == null || connectionRequest == null) {
                if (DEBUG) {
                    Log.d(MediaSession2Service.TAG, "Ignoring calls with illegal arguments, caller=" + caller + ", connectionRequest=" + connectionRequest);
                }
                return;
            }
            int pid = Binder.getCallingPid();
            int uid = Binder.getCallingUid();
            long token = Binder.clearCallingIdentity();
            try {
                this.mHandler.post(() -> {
                    boolean shouldNotifyDisconnected = true;
                    try {
                        MediaSession2 session;
                        MediaSession2Service service = (MediaSession2Service)this.mService.get();
                        if (service == null) {
                            if (!DEBUG) return;
                            Log.d(MediaSession2Service.TAG, "Service isn't available");
                            return;
                        }
                        String callingPkg = connectionRequest.getString("android.media.key.PACKAGE_NAME");
                        MediaSessionManager.RemoteUserInfo remoteUserInfo = new MediaSessionManager.RemoteUserInfo(callingPkg, pid == 0 ? connectionRequest.getInt("android.media.key.PID") : pid, uid);
                        Bundle connectionHints = connectionRequest.getBundle("android.media.key.CONNECTION_HINTS");
                        if (connectionHints == null) {
                            Log.w(MediaSession2Service.TAG, "connectionHints shouldn't be null.");
                            connectionHints = Bundle.EMPTY;
                        } else if (MediaSession2.hasCustomParcelable(connectionHints)) {
                            Log.w(MediaSession2Service.TAG, "connectionHints contain custom parcelable. Ignoring.");
                            connectionHints = Bundle.EMPTY;
                        }
                        MediaSession2.ControllerInfo controllerInfo = new MediaSession2.ControllerInfo(remoteUserInfo, service.getMediaSessionManager().isTrustedForMediaControl(remoteUserInfo), caller, connectionHints);
                        if (DEBUG) {
                            Log.d(MediaSession2Service.TAG, "Handling incoming connection request from the controller=" + controllerInfo);
                        }
                        if ((session = service.onGetSession(controllerInfo)) == null) {
                            if (!DEBUG) return;
                            Log.d(MediaSession2Service.TAG, "Rejecting incoming connection request from the controller=" + controllerInfo);
                            return;
                        }
                        service.addSession(session);
                        shouldNotifyDisconnected = false;
                        session.onConnect(caller, pid, uid, seq, connectionRequest);
                        return;
                    }
                    catch (Exception e) {
                        Log.w(MediaSession2Service.TAG, "Failed to add a session to session service", e);
                        return;
                    }
                    finally {
                        if (shouldNotifyDisconnected) {
                            if (DEBUG) {
                                Log.d(MediaSession2Service.TAG, "Notifying the controller of its disconnection");
                            }
                            try {
                                caller.notifyDisconnected(0);
                            }
                            catch (RuntimeException runtimeException) {}
                        }
                    }
                });
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        @Override
        public void close() {
            this.mHandler.removeCallbacksAndMessages(null);
            this.mService.clear();
        }
    }

    public static class MediaNotification {
        private final int mNotificationId;
        private final Notification mNotification;

        public MediaNotification(int notificationId, Notification notification) {
            if (notification == null) {
                throw new IllegalArgumentException("notification shouldn't be null");
            }
            this.mNotificationId = notificationId;
            this.mNotification = notification;
        }

        public int getNotificationId() {
            return this.mNotificationId;
        }

        public Notification getNotification() {
            return this.mNotification;
        }
    }
}

