/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import java.io.IOException;
import java.io.InputStream;

public final class ResampleInputStream
extends InputStream {
    private static final String TAG = "ResampleInputStream";
    private InputStream mInputStream;
    private final int mRateIn;
    private final int mRateOut;
    private byte[] mBuf;
    private int mBufCount;
    private static final int mFirLength = 29;
    private final byte[] mOneByte = new byte[1];

    public ResampleInputStream(InputStream inputStream, int rateIn, int rateOut) {
        if (rateIn != 2 * rateOut) {
            throw new IllegalArgumentException("only support 2:1 at the moment");
        }
        rateIn = 2;
        rateOut = 1;
        this.mInputStream = inputStream;
        this.mRateIn = rateIn;
        this.mRateOut = rateOut;
    }

    @Override
    public int read() throws IOException {
        int rtn = this.read(this.mOneByte, 0, 1);
        return rtn == 1 ? 0xFF & this.mOneByte[0] : -1;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int offset, int length) throws IOException {
        int len;
        if (this.mInputStream == null) {
            throw new IllegalStateException("not open");
        }
        int nIn = (length / 2 * this.mRateIn / this.mRateOut + 29) * 2;
        if (this.mBuf == null) {
            this.mBuf = new byte[nIn];
        } else if (nIn > this.mBuf.length) {
            byte[] bf = new byte[nIn];
            System.arraycopy(this.mBuf, 0, bf, 0, this.mBufCount);
            this.mBuf = bf;
        }
        while (true) {
            if ((len = (this.mBufCount / 2 - 29) * this.mRateOut / this.mRateIn * 2) > 0) break;
            int n = this.mInputStream.read(this.mBuf, this.mBufCount, this.mBuf.length - this.mBufCount);
            if (n == -1) {
                return -1;
            }
            this.mBufCount += n;
        }
        length = len < length ? len : length / 2 * 2;
        ResampleInputStream.fir21(this.mBuf, 0, b, offset, length / 2);
        int nFwd = length * this.mRateIn / this.mRateOut;
        this.mBufCount -= nFwd;
        if (this.mBufCount > 0) {
            System.arraycopy(this.mBuf, nFwd, this.mBuf, 0, this.mBufCount);
        }
        return length;
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.mInputStream != null) {
                this.mInputStream.close();
            }
        }
        finally {
            this.mInputStream = null;
        }
    }

    protected void finalize() throws Throwable {
        if (this.mInputStream != null) {
            this.close();
            throw new IllegalStateException("someone forgot to close ResampleInputStream");
        }
    }

    private static native void fir21(byte[] var0, int var1, byte[] var2, int var3, int var4);

    static {
        System.loadLibrary("media_jni");
    }
}

