/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.annotation.UnsupportedAppUsage;
import android.content.ContentResolver;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.ImageDecoder;
import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.Rect;
import android.media.ExifInterface;
import android.media.MediaFile;
import android.media.MediaMetadataRetriever;
import android.net.Uri;
import android.os.CancellationSignal;
import android.os.Environment;
import android.os.ParcelFileDescriptor;
import android.provider.MediaStore;
import android.util.Log;
import android.util.Size;
import com.android.internal.util.ArrayUtils;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.ToIntFunction;
import libcore.io.IoUtils;

public class ThumbnailUtils {
    private static final String TAG = "ThumbnailUtils";
    @Deprecated
    @UnsupportedAppUsage
    public static final int TARGET_SIZE_MICRO_THUMBNAIL = 96;
    private static final int OPTIONS_NONE = 0;
    private static final int OPTIONS_SCALE_UP = 1;
    public static final int OPTIONS_RECYCLE_INPUT = 2;

    private static Size convertKind(int kind) {
        if (kind == 3) {
            return Point.convert(MediaStore.ThumbnailConstants.MICRO_SIZE);
        }
        if (kind == 2) {
            return Point.convert(MediaStore.ThumbnailConstants.FULL_SCREEN_SIZE);
        }
        if (kind == 1) {
            return Point.convert(MediaStore.ThumbnailConstants.MINI_SIZE);
        }
        throw new IllegalArgumentException("Unsupported kind: " + kind);
    }

    @Deprecated
    public static Bitmap createAudioThumbnail(String filePath, int kind) {
        try {
            return ThumbnailUtils.createAudioThumbnail(new File(filePath), ThumbnailUtils.convertKind(kind), null);
        }
        catch (IOException e) {
            Log.w(TAG, e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Bitmap createAudioThumbnail(File file, Size size, CancellationSignal signal) throws IOException {
        File grandParent;
        if (signal != null) {
            signal.throwIfCanceled();
        }
        Resizer resizer = new Resizer(size, signal);
        try (MediaMetadataRetriever retriever = new MediaMetadataRetriever();){
            retriever.setDataSource(file.getAbsolutePath());
            byte[] raw2 = retriever.getEmbeddedPicture();
            if (raw2 != null) {
                Bitmap bitmap = ImageDecoder.decodeBitmap(ImageDecoder.createSource(raw2), resizer);
                return bitmap;
            }
        }
        catch (RuntimeException e) {
            throw new IOException("Failed to create thumbnail", e);
        }
        if ("unknown".equals(Environment.getExternalStorageState(file))) {
            throw new IOException("No embedded album art found");
        }
        File parent = file.getParentFile();
        File file2 = grandParent = parent != null ? parent.getParentFile() : null;
        if (parent != null && parent.getName().equals(Environment.DIRECTORY_DOWNLOADS)) {
            throw new IOException("No thumbnails in Downloads directories");
        }
        if (grandParent != null && "unknown".equals(Environment.getExternalStorageState(grandParent))) {
            throw new IOException("No thumbnails in top-level directories");
        }
        File[] found = ArrayUtils.defeatNullable(file.getParentFile().listFiles((dir, name) -> {
            String lower = name.toLowerCase();
            return lower.endsWith(".jpg") || lower.endsWith(".png");
        }));
        ToIntFunction<File> score = f -> {
            String lower = f.getName().toLowerCase();
            if (lower.equals("albumart.jpg")) {
                return 4;
            }
            if (lower.startsWith("albumart") && lower.endsWith(".jpg")) {
                return 3;
            }
            if (lower.contains("albumart") && lower.endsWith(".jpg")) {
                return 2;
            }
            if (lower.endsWith(".jpg")) {
                return 1;
            }
            return 0;
        };
        Comparator bestScore = (a, b) -> score.applyAsInt((File)a) - score.applyAsInt((File)b);
        File bestFile = Arrays.asList(found).stream().max(bestScore).orElse(null);
        if (bestFile == null) {
            throw new IOException("No album art found");
        }
        if (signal == null) return ImageDecoder.decodeBitmap(ImageDecoder.createSource(bestFile), resizer);
        signal.throwIfCanceled();
        return ImageDecoder.decodeBitmap(ImageDecoder.createSource(bestFile), resizer);
    }

    @Deprecated
    public static Bitmap createImageThumbnail(String filePath, int kind) {
        try {
            return ThumbnailUtils.createImageThumbnail(new File(filePath), ThumbnailUtils.convertKind(kind), null);
        }
        catch (IOException e) {
            Log.w(TAG, e);
            return null;
        }
    }

    public static Bitmap createImageThumbnail(File file, Size size, CancellationSignal signal) throws IOException {
        byte[] raw2;
        if (signal != null) {
            signal.throwIfCanceled();
        }
        Resizer resizer = new Resizer(size, signal);
        String mimeType = MediaFile.getMimeTypeForFile(file.getName());
        Bitmap bitmap = null;
        ExifInterface exif = null;
        int orientation = 0;
        if (MediaFile.isExifMimeType(mimeType)) {
            exif = new ExifInterface(file);
            switch (exif.getAttributeInt("Orientation", 0)) {
                case 6: {
                    orientation = 90;
                    break;
                }
                case 3: {
                    orientation = 180;
                    break;
                }
                case 8: {
                    orientation = 270;
                }
            }
        }
        if (mimeType.equals("image/heif") || mimeType.equals("image/heif-sequence") || mimeType.equals("image/heic") || mimeType.equals("image/heic-sequence")) {
            try (MediaMetadataRetriever retriever = new MediaMetadataRetriever();){
                retriever.setDataSource(file.getAbsolutePath());
                bitmap = retriever.getThumbnailImageAtIndex(-1, new MediaMetadataRetriever.BitmapParams(), size.getWidth(), size.getWidth() * size.getHeight());
            }
            catch (RuntimeException e) {
                throw new IOException("Failed to create thumbnail", e);
            }
        }
        if (bitmap == null && exif != null && (raw2 = exif.getThumbnailBytes()) != null) {
            try {
                bitmap = ImageDecoder.decodeBitmap(ImageDecoder.createSource(raw2), resizer);
            }
            catch (ImageDecoder.DecodeException e) {
                Log.w(TAG, e);
            }
        }
        if (signal != null) {
            signal.throwIfCanceled();
        }
        if (bitmap == null) {
            bitmap = ImageDecoder.decodeBitmap(ImageDecoder.createSource(file), resizer);
            return bitmap;
        }
        if (orientation != 0 && bitmap != null) {
            int width = bitmap.getWidth();
            int height = bitmap.getHeight();
            Matrix m = new Matrix();
            m.setRotate(orientation, width / 2, height / 2);
            bitmap = Bitmap.createBitmap(bitmap, 0, 0, width, height, m, false);
        }
        return bitmap;
    }

    @Deprecated
    public static Bitmap createVideoThumbnail(String filePath, int kind) {
        try {
            return ThumbnailUtils.createVideoThumbnail(new File(filePath), ThumbnailUtils.convertKind(kind), null);
        }
        catch (IOException e) {
            Log.w(TAG, e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Bitmap createVideoThumbnail(File file, Size size, CancellationSignal signal) throws IOException {
        if (signal != null) {
            signal.throwIfCanceled();
        }
        Resizer resizer = new Resizer(size, signal);
        try (MediaMetadataRetriever mmr = new MediaMetadataRetriever();){
            mmr.setDataSource(file.getAbsolutePath());
            byte[] raw2 = mmr.getEmbeddedPicture();
            if (raw2 != null) {
                Bitmap bitmap = ImageDecoder.decodeBitmap(ImageDecoder.createSource(raw2), resizer);
                return bitmap;
            }
            int width = Integer.parseInt(mmr.extractMetadata(18));
            int height = Integer.parseInt(mmr.extractMetadata(19));
            long duration = Long.parseLong(mmr.extractMetadata(9));
            if (size.getWidth() > width && size.getHeight() > height) {
                Bitmap bitmap = Objects.requireNonNull(mmr.getFrameAtTime(duration / 2L, 2));
                return bitmap;
            }
            Bitmap bitmap = Objects.requireNonNull(mmr.getScaledFrameAtTime(duration / 2L, 2, size.getWidth(), size.getHeight()));
            return bitmap;
        }
        catch (RuntimeException e) {
            throw new IOException("Failed to create thumbnail", e);
        }
    }

    public static Bitmap extractThumbnail(Bitmap source, int width, int height) {
        return ThumbnailUtils.extractThumbnail(source, width, height, 0);
    }

    public static Bitmap extractThumbnail(Bitmap source, int width, int height, int options) {
        if (source == null) {
            return null;
        }
        float scale = source.getWidth() < source.getHeight() ? (float)width / (float)source.getWidth() : (float)height / (float)source.getHeight();
        Matrix matrix = new Matrix();
        matrix.setScale(scale, scale);
        Bitmap thumbnail = ThumbnailUtils.transform(matrix, source, width, height, 1 | options);
        return thumbnail;
    }

    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private static int computeSampleSize(BitmapFactory.Options options, int minSideLength, int maxNumOfPixels) {
        return 1;
    }

    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private static int computeInitialSampleSize(BitmapFactory.Options options, int minSideLength, int maxNumOfPixels) {
        return 1;
    }

    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private static void closeSilently(ParcelFileDescriptor c) {
        IoUtils.closeQuietly(c);
    }

    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private static ParcelFileDescriptor makeInputStream(Uri uri, ContentResolver cr) {
        try {
            return cr.openFileDescriptor(uri, "r");
        }
        catch (IOException ex) {
            return null;
        }
    }

    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private static Bitmap transform(Matrix scaler, Bitmap source, int targetWidth, int targetHeight, int options) {
        int dy1;
        int dx1;
        Bitmap b2;
        float scale;
        float viewAspect;
        float bitmapHeightF;
        boolean scaleUp = (options & 1) != 0;
        boolean recycle = (options & 2) != 0;
        int deltaX = source.getWidth() - targetWidth;
        int deltaY = source.getHeight() - targetHeight;
        if (!(scaleUp || deltaX >= 0 && deltaY >= 0)) {
            Bitmap b22 = Bitmap.createBitmap(targetWidth, targetHeight, Bitmap.Config.ARGB_8888);
            Canvas c = new Canvas(b22);
            int deltaXHalf = Math.max(0, deltaX / 2);
            int deltaYHalf = Math.max(0, deltaY / 2);
            Rect src = new Rect(deltaXHalf, deltaYHalf, deltaXHalf + Math.min(targetWidth, source.getWidth()), deltaYHalf + Math.min(targetHeight, source.getHeight()));
            int dstX = (targetWidth - src.width()) / 2;
            int dstY = (targetHeight - src.height()) / 2;
            Rect dst = new Rect(dstX, dstY, targetWidth - dstX, targetHeight - dstY);
            c.drawBitmap(source, src, dst, null);
            if (recycle) {
                source.recycle();
            }
            c.setBitmap(null);
            return b22;
        }
        float bitmapWidthF = source.getWidth();
        float bitmapAspect = bitmapWidthF / (bitmapHeightF = (float)source.getHeight());
        if (bitmapAspect > (viewAspect = (float)targetWidth / (float)targetHeight)) {
            scale = (float)targetHeight / bitmapHeightF;
            if (scale < 0.9f || scale > 1.0f) {
                scaler.setScale(scale, scale);
            } else {
                scaler = null;
            }
        } else {
            scale = (float)targetWidth / bitmapWidthF;
            if (scale < 0.9f || scale > 1.0f) {
                scaler.setScale(scale, scale);
            } else {
                scaler = null;
            }
        }
        Bitmap b1 = scaler != null ? Bitmap.createBitmap(source, 0, 0, source.getWidth(), source.getHeight(), scaler, true) : source;
        if (recycle && b1 != source) {
            source.recycle();
        }
        if ((b2 = Bitmap.createBitmap(b1, (dx1 = Math.max(0, b1.getWidth() - targetWidth)) / 2, (dy1 = Math.max(0, b1.getHeight() - targetHeight)) / 2, targetWidth, targetHeight)) != b1 && (recycle || b1 != source)) {
            b1.recycle();
        }
        return b2;
    }

    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private static void createThumbnailFromEXIF(String filePath, int targetSize, int maxPixels, SizedThumbnailBitmap sizedThumbBitmap) {
    }

    @Deprecated
    private static class SizedThumbnailBitmap {
        public byte[] mThumbnailData;
        public Bitmap mBitmap;
        public int mThumbnailWidth;
        public int mThumbnailHeight;

        private SizedThumbnailBitmap() {
        }
    }

    private static class Resizer
    implements ImageDecoder.OnHeaderDecodedListener {
        private final Size size;
        private final CancellationSignal signal;

        public Resizer(Size size, CancellationSignal signal) {
            this.size = size;
            this.signal = signal;
        }

        @Override
        public void onHeaderDecoded(ImageDecoder decoder, ImageDecoder.ImageInfo info, ImageDecoder.Source source) {
            if (this.signal != null) {
                this.signal.throwIfCanceled();
            }
            decoder.setAllocator(1);
            int widthSample = info.getSize().getWidth() / this.size.getWidth();
            int heightSample = info.getSize().getHeight() / this.size.getHeight();
            int sample = Math.max(widthSample, heightSample);
            if (sample > 1) {
                decoder.setTargetSampleSize(sample);
            }
        }
    }
}

