/*
 * Decompiled with CFR 0.152.
 */
package android.media.audiofx;

import android.media.audiofx.AudioEffect;
import android.util.Log;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.StringTokenizer;

public final class DynamicsProcessing
extends AudioEffect {
    private static final String TAG = "DynamicsProcessing";
    private static final int PARAM_GET_CHANNEL_COUNT = 16;
    private static final int PARAM_INPUT_GAIN = 32;
    private static final int PARAM_ENGINE_ARCHITECTURE = 48;
    private static final int PARAM_PRE_EQ = 64;
    private static final int PARAM_PRE_EQ_BAND = 69;
    private static final int PARAM_MBC = 80;
    private static final int PARAM_MBC_BAND = 85;
    private static final int PARAM_POST_EQ = 96;
    private static final int PARAM_POST_EQ_BAND = 101;
    private static final int PARAM_LIMITER = 112;
    public static final int VARIANT_FAVOR_FREQUENCY_RESOLUTION = 0;
    public static final int VARIANT_FAVOR_TIME_RESOLUTION = 1;
    private static final int CHANNEL_COUNT_MAX = 32;
    private int mChannelCount = 0;
    private OnParameterChangeListener mParamListener = null;
    private BaseParameterListener mBaseParamListener = null;
    private final Object mParamListenerLock = new Object();
    private static final int CONFIG_DEFAULT_VARIANT = 0;
    private static final boolean CONFIG_DEFAULT_USE_PREEQ = true;
    private static final int CONFIG_DEFAULT_PREEQ_BANDS = 6;
    private static final boolean CONFIG_DEFAULT_USE_MBC = true;
    private static final int CONFIG_DEFAULT_MBC_BANDS = 6;
    private static final boolean CONFIG_DEFAULT_USE_POSTEQ = true;
    private static final int CONFIG_DEFAULT_POSTEQ_BANDS = 6;
    private static final boolean CONFIG_DEFAULT_USE_LIMITER = true;
    private static final float CHANNEL_DEFAULT_INPUT_GAIN = 0.0f;
    private static final float CONFIG_PREFERRED_FRAME_DURATION_MS = 10.0f;
    private static final float EQ_DEFAULT_GAIN = 0.0f;
    private static final boolean PREEQ_DEFAULT_ENABLED = true;
    private static final boolean POSTEQ_DEFAULT_ENABLED = true;
    private static final boolean MBC_DEFAULT_ENABLED = true;
    private static final float MBC_DEFAULT_ATTACK_TIME = 3.0f;
    private static final float MBC_DEFAULT_RELEASE_TIME = 80.0f;
    private static final float MBC_DEFAULT_RATIO = 1.0f;
    private static final float MBC_DEFAULT_THRESHOLD = -45.0f;
    private static final float MBC_DEFAULT_KNEE_WIDTH = 0.0f;
    private static final float MBC_DEFAULT_NOISE_GATE_THRESHOLD = -90.0f;
    private static final float MBC_DEFAULT_EXPANDER_RATIO = 1.0f;
    private static final float MBC_DEFAULT_PRE_GAIN = 0.0f;
    private static final float MBC_DEFAULT_POST_GAIN = 0.0f;
    private static final boolean LIMITER_DEFAULT_ENABLED = true;
    private static final int LIMITER_DEFAULT_LINK_GROUP = 0;
    private static final float LIMITER_DEFAULT_ATTACK_TIME = 1.0f;
    private static final float LIMITER_DEFAULT_RELEASE_TIME = 60.0f;
    private static final float LIMITER_DEFAULT_RATIO = 10.0f;
    private static final float LIMITER_DEFAULT_THRESHOLD = -2.0f;
    private static final float LIMITER_DEFAULT_POST_GAIN = 0.0f;
    private static final float DEFAULT_MIN_FREQUENCY = 220.0f;
    private static final float DEFAULT_MAX_FREQUENCY = 20000.0f;
    private static final float mMinFreqLog = (float)Math.log10(220.0);
    private static final float mMaxFreqLog = (float)Math.log10(20000.0);

    public DynamicsProcessing(int audioSession) {
        this(0, audioSession);
    }

    public DynamicsProcessing(int priority, int audioSession) {
        this(priority, audioSession, null);
    }

    public DynamicsProcessing(int priority, int audioSession, Config cfg) {
        super(EFFECT_TYPE_DYNAMICS_PROCESSING, EFFECT_TYPE_NULL, priority, audioSession);
        Config config;
        if (audioSession == 0) {
            Log.w(TAG, "WARNING: attaching a DynamicsProcessing to global output mix isdeprecated!");
        }
        this.mChannelCount = this.getChannelCount();
        if (cfg == null) {
            Config.Builder builder = new Config.Builder(0, this.mChannelCount, true, 6, true, 6, true, 6, true);
            config = builder.build();
        } else {
            config = new Config(this.mChannelCount, cfg);
        }
        this.setEngineArchitecture(config.getVariant(), config.getPreferredFrameDuration(), config.isPreEqInUse(), config.getPreEqBandCount(), config.isMbcInUse(), config.getMbcBandCount(), config.isPostEqInUse(), config.getPostEqBandCount(), config.isLimiterInUse());
        for (int ch = 0; ch < this.mChannelCount; ++ch) {
            this.updateEngineChannelByChannelIndex(ch, config.getChannelByChannelIndex(ch));
        }
    }

    public Config getConfig() {
        Number[] params = new Number[]{48};
        Number[] values = new Number[]{0, Float.valueOf(0.0f), 0, 0, 0, 0, 0, 0, 0};
        byte[] paramBytes = this.numberArrayToByteArray(params);
        byte[] valueBytes = this.numberArrayToByteArray(values);
        this.getParameter(paramBytes, valueBytes);
        this.byteArrayToNumberArray(valueBytes, values);
        Config.Builder builder = new Config.Builder(values[0].intValue(), this.mChannelCount, values[2].intValue() > 0, values[3].intValue(), values[4].intValue() > 0, values[5].intValue(), values[6].intValue() > 0, values[7].intValue(), values[8].intValue() > 0).setPreferredFrameDuration(values[1].floatValue());
        Config config = builder.build();
        for (int ch = 0; ch < this.mChannelCount; ++ch) {
            Channel channel = this.queryEngineByChannelIndex(ch);
            config.setChannelTo(ch, channel);
        }
        return config;
    }

    public Channel getChannelByChannelIndex(int channelIndex) {
        return this.queryEngineByChannelIndex(channelIndex);
    }

    public void setChannelTo(int channelIndex, Channel channel) {
        this.updateEngineChannelByChannelIndex(channelIndex, channel);
    }

    public void setAllChannelsTo(Channel channel) {
        for (int ch = 0; ch < this.mChannelCount; ++ch) {
            this.setChannelTo(ch, channel);
        }
    }

    public float getInputGainByChannelIndex(int channelIndex) {
        return this.getTwoFloat(32, channelIndex);
    }

    public void setInputGainbyChannel(int channelIndex, float inputGain) {
        this.setTwoFloat(32, channelIndex, inputGain);
    }

    public void setInputGainAllChannelsTo(float inputGain) {
        for (int ch = 0; ch < this.mChannelCount; ++ch) {
            this.setInputGainbyChannel(ch, inputGain);
        }
    }

    public Eq getPreEqByChannelIndex(int channelIndex) {
        return this.queryEngineEqByChannelIndex(64, channelIndex);
    }

    public void setPreEqByChannelIndex(int channelIndex, Eq preEq) {
        this.updateEngineEqByChannelIndex(64, channelIndex, preEq);
    }

    public void setPreEqAllChannelsTo(Eq preEq) {
        for (int ch = 0; ch < this.mChannelCount; ++ch) {
            this.setPreEqByChannelIndex(ch, preEq);
        }
    }

    public EqBand getPreEqBandByChannelIndex(int channelIndex, int band) {
        return this.queryEngineEqBandByChannelIndex(69, channelIndex, band);
    }

    public void setPreEqBandByChannelIndex(int channelIndex, int band, EqBand preEqBand) {
        this.updateEngineEqBandByChannelIndex(69, channelIndex, band, preEqBand);
    }

    public void setPreEqBandAllChannelsTo(int band, EqBand preEqBand) {
        for (int ch = 0; ch < this.mChannelCount; ++ch) {
            this.setPreEqBandByChannelIndex(ch, band, preEqBand);
        }
    }

    public Mbc getMbcByChannelIndex(int channelIndex) {
        return this.queryEngineMbcByChannelIndex(channelIndex);
    }

    public void setMbcByChannelIndex(int channelIndex, Mbc mbc) {
        this.updateEngineMbcByChannelIndex(channelIndex, mbc);
    }

    public void setMbcAllChannelsTo(Mbc mbc) {
        for (int ch = 0; ch < this.mChannelCount; ++ch) {
            this.setMbcByChannelIndex(ch, mbc);
        }
    }

    public MbcBand getMbcBandByChannelIndex(int channelIndex, int band) {
        return this.queryEngineMbcBandByChannelIndex(channelIndex, band);
    }

    public void setMbcBandByChannelIndex(int channelIndex, int band, MbcBand mbcBand) {
        this.updateEngineMbcBandByChannelIndex(channelIndex, band, mbcBand);
    }

    public void setMbcBandAllChannelsTo(int band, MbcBand mbcBand) {
        for (int ch = 0; ch < this.mChannelCount; ++ch) {
            this.setMbcBandByChannelIndex(ch, band, mbcBand);
        }
    }

    public Eq getPostEqByChannelIndex(int channelIndex) {
        return this.queryEngineEqByChannelIndex(96, channelIndex);
    }

    public void setPostEqByChannelIndex(int channelIndex, Eq postEq) {
        this.updateEngineEqByChannelIndex(96, channelIndex, postEq);
    }

    public void setPostEqAllChannelsTo(Eq postEq) {
        for (int ch = 0; ch < this.mChannelCount; ++ch) {
            this.setPostEqByChannelIndex(ch, postEq);
        }
    }

    public EqBand getPostEqBandByChannelIndex(int channelIndex, int band) {
        return this.queryEngineEqBandByChannelIndex(101, channelIndex, band);
    }

    public void setPostEqBandByChannelIndex(int channelIndex, int band, EqBand postEqBand) {
        this.updateEngineEqBandByChannelIndex(101, channelIndex, band, postEqBand);
    }

    public void setPostEqBandAllChannelsTo(int band, EqBand postEqBand) {
        for (int ch = 0; ch < this.mChannelCount; ++ch) {
            this.setPostEqBandByChannelIndex(ch, band, postEqBand);
        }
    }

    public Limiter getLimiterByChannelIndex(int channelIndex) {
        return this.queryEngineLimiterByChannelIndex(channelIndex);
    }

    public void setLimiterByChannelIndex(int channelIndex, Limiter limiter) {
        this.updateEngineLimiterByChannelIndex(channelIndex, limiter);
    }

    public void setLimiterAllChannelsTo(Limiter limiter) {
        for (int ch = 0; ch < this.mChannelCount; ++ch) {
            this.setLimiterByChannelIndex(ch, limiter);
        }
    }

    public int getChannelCount() {
        return this.getOneInt(16);
    }

    private void setEngineArchitecture(int variant, float preferredFrameDuration, boolean preEqInUse, int preEqBandCount, boolean mbcInUse, int mbcBandCount, boolean postEqInUse, int postEqBandCount, boolean limiterInUse) {
        Number[] params = new Number[]{48};
        Number[] values = new Number[]{variant, Float.valueOf(preferredFrameDuration), preEqInUse ? 1 : 0, preEqBandCount, mbcInUse ? 1 : 0, mbcBandCount, postEqInUse ? 1 : 0, postEqBandCount, limiterInUse ? 1 : 0};
        this.setNumberArray(params, values);
    }

    private void updateEngineEqBandByChannelIndex(int param, int channelIndex, int bandIndex, EqBand eqBand) {
        Number[] params = new Number[]{param, channelIndex, bandIndex};
        Number[] values = new Number[]{eqBand.isEnabled() ? 1 : 0, Float.valueOf(eqBand.getCutoffFrequency()), Float.valueOf(eqBand.getGain())};
        this.setNumberArray(params, values);
    }

    private Eq queryEngineEqByChannelIndex(int param, int channelIndex) {
        Number[] params = new Number[]{param == 64 ? 64 : 96, channelIndex};
        Number[] values = new Number[]{0, 0, 0};
        byte[] paramBytes = this.numberArrayToByteArray(params);
        byte[] valueBytes = this.numberArrayToByteArray(values);
        this.getParameter(paramBytes, valueBytes);
        this.byteArrayToNumberArray(valueBytes, values);
        int bandCount = values[2].intValue();
        Eq eq = new Eq(values[0].intValue() > 0, values[1].intValue() > 0, bandCount);
        for (int b = 0; b < bandCount; ++b) {
            EqBand eqBand = this.queryEngineEqBandByChannelIndex(param == 64 ? 69 : 101, channelIndex, b);
            eq.setBand(b, eqBand);
        }
        return eq;
    }

    private EqBand queryEngineEqBandByChannelIndex(int param, int channelIndex, int bandIndex) {
        Number[] params = new Number[]{param, channelIndex, bandIndex};
        Number[] values = new Number[]{0, Float.valueOf(0.0f), Float.valueOf(0.0f)};
        byte[] paramBytes = this.numberArrayToByteArray(params);
        byte[] valueBytes = this.numberArrayToByteArray(values);
        this.getParameter(paramBytes, valueBytes);
        this.byteArrayToNumberArray(valueBytes, values);
        return new EqBand(values[0].intValue() > 0, values[1].floatValue(), values[2].floatValue());
    }

    private void updateEngineEqByChannelIndex(int param, int channelIndex, Eq eq) {
        int bandCount = eq.getBandCount();
        Number[] params = new Number[]{param, channelIndex};
        Number[] values = new Number[]{eq.isInUse() ? 1 : 0, eq.isEnabled() ? 1 : 0, bandCount};
        this.setNumberArray(params, values);
        for (int b = 0; b < bandCount; ++b) {
            EqBand eqBand = eq.getBand(b);
            this.updateEngineEqBandByChannelIndex(param == 64 ? 69 : 101, channelIndex, b, eqBand);
        }
    }

    private Mbc queryEngineMbcByChannelIndex(int channelIndex) {
        Number[] params = new Number[]{80, channelIndex};
        Number[] values = new Number[]{0, 0, 0};
        byte[] paramBytes = this.numberArrayToByteArray(params);
        byte[] valueBytes = this.numberArrayToByteArray(values);
        this.getParameter(paramBytes, valueBytes);
        this.byteArrayToNumberArray(valueBytes, values);
        int bandCount = values[2].intValue();
        Mbc mbc = new Mbc(values[0].intValue() > 0, values[1].intValue() > 0, bandCount);
        for (int b = 0; b < bandCount; ++b) {
            MbcBand mbcBand = this.queryEngineMbcBandByChannelIndex(channelIndex, b);
            mbc.setBand(b, mbcBand);
        }
        return mbc;
    }

    private MbcBand queryEngineMbcBandByChannelIndex(int channelIndex, int bandIndex) {
        Number[] params = new Number[]{85, channelIndex, bandIndex};
        Number[] values = new Number[]{0, Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f)};
        byte[] paramBytes = this.numberArrayToByteArray(params);
        byte[] valueBytes = this.numberArrayToByteArray(values);
        this.getParameter(paramBytes, valueBytes);
        this.byteArrayToNumberArray(valueBytes, values);
        return new MbcBand(values[0].intValue() > 0, values[1].floatValue(), values[2].floatValue(), values[3].floatValue(), values[4].floatValue(), values[5].floatValue(), values[6].floatValue(), values[7].floatValue(), values[8].floatValue(), values[9].floatValue(), values[10].floatValue());
    }

    private void updateEngineMbcBandByChannelIndex(int channelIndex, int bandIndex, MbcBand mbcBand) {
        Number[] params = new Number[]{85, channelIndex, bandIndex};
        Number[] values = new Number[]{mbcBand.isEnabled() ? 1 : 0, Float.valueOf(mbcBand.getCutoffFrequency()), Float.valueOf(mbcBand.getAttackTime()), Float.valueOf(mbcBand.getReleaseTime()), Float.valueOf(mbcBand.getRatio()), Float.valueOf(mbcBand.getThreshold()), Float.valueOf(mbcBand.getKneeWidth()), Float.valueOf(mbcBand.getNoiseGateThreshold()), Float.valueOf(mbcBand.getExpanderRatio()), Float.valueOf(mbcBand.getPreGain()), Float.valueOf(mbcBand.getPostGain())};
        this.setNumberArray(params, values);
    }

    private void updateEngineMbcByChannelIndex(int channelIndex, Mbc mbc) {
        int bandCount = mbc.getBandCount();
        Number[] params = new Number[]{80, channelIndex};
        Number[] values = new Number[]{mbc.isInUse() ? 1 : 0, mbc.isEnabled() ? 1 : 0, bandCount};
        this.setNumberArray(params, values);
        for (int b = 0; b < bandCount; ++b) {
            MbcBand mbcBand = mbc.getBand(b);
            this.updateEngineMbcBandByChannelIndex(channelIndex, b, mbcBand);
        }
    }

    private void updateEngineLimiterByChannelIndex(int channelIndex, Limiter limiter) {
        Number[] params = new Number[]{112, channelIndex};
        Number[] values = new Number[]{limiter.isInUse() ? 1 : 0, limiter.isEnabled() ? 1 : 0, limiter.getLinkGroup(), Float.valueOf(limiter.getAttackTime()), Float.valueOf(limiter.getReleaseTime()), Float.valueOf(limiter.getRatio()), Float.valueOf(limiter.getThreshold()), Float.valueOf(limiter.getPostGain())};
        this.setNumberArray(params, values);
    }

    private Limiter queryEngineLimiterByChannelIndex(int channelIndex) {
        Number[] params = new Number[]{112, channelIndex};
        Number[] values = new Number[]{0, 0, 0, Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f)};
        byte[] paramBytes = this.numberArrayToByteArray(params);
        byte[] valueBytes = this.numberArrayToByteArray(values);
        this.getParameter(paramBytes, valueBytes);
        this.byteArrayToNumberArray(valueBytes, values);
        return new Limiter(values[0].intValue() > 0, values[1].intValue() > 0, values[2].intValue(), values[3].floatValue(), values[4].floatValue(), values[5].floatValue(), values[6].floatValue(), values[7].floatValue());
    }

    private Channel queryEngineByChannelIndex(int channelIndex) {
        float inputGain = this.getTwoFloat(32, channelIndex);
        Eq preEq = this.queryEngineEqByChannelIndex(64, channelIndex);
        Mbc mbc = this.queryEngineMbcByChannelIndex(channelIndex);
        Eq postEq = this.queryEngineEqByChannelIndex(96, channelIndex);
        Limiter limiter = this.queryEngineLimiterByChannelIndex(channelIndex);
        Channel channel = new Channel(inputGain, preEq.isInUse(), preEq.getBandCount(), mbc.isInUse(), mbc.getBandCount(), postEq.isInUse(), postEq.getBandCount(), limiter.isInUse());
        channel.setInputGain(inputGain);
        channel.setPreEq(preEq);
        channel.setMbc(mbc);
        channel.setPostEq(postEq);
        channel.setLimiter(limiter);
        return channel;
    }

    private void updateEngineChannelByChannelIndex(int channelIndex, Channel channel) {
        this.setTwoFloat(32, channelIndex, channel.getInputGain());
        Eq preEq = channel.getPreEq();
        this.updateEngineEqByChannelIndex(64, channelIndex, preEq);
        Mbc mbc = channel.getMbc();
        this.updateEngineMbcByChannelIndex(channelIndex, mbc);
        Eq postEq = channel.getPostEq();
        this.updateEngineEqByChannelIndex(96, channelIndex, postEq);
        Limiter limiter = channel.getLimiter();
        this.updateEngineLimiterByChannelIndex(channelIndex, limiter);
    }

    private int getOneInt(int param) {
        int[] params = new int[]{param};
        int[] result = new int[1];
        this.checkStatus(this.getParameter(params, result));
        return result[0];
    }

    private void setTwoFloat(int param, int paramA, float valueSet) {
        int[] params = new int[]{param, paramA};
        byte[] value = DynamicsProcessing.floatToByteArray(valueSet);
        this.checkStatus(this.setParameter(params, value));
    }

    private byte[] numberArrayToByteArray(Number[] values) {
        int expectedBytes = 0;
        for (int i = 0; i < values.length; ++i) {
            if (values[i] instanceof Integer) {
                expectedBytes += 4;
                continue;
            }
            if (values[i] instanceof Float) {
                expectedBytes += 4;
                continue;
            }
            throw new IllegalArgumentException("unknown value type " + values[i].getClass());
        }
        ByteBuffer converter = ByteBuffer.allocate(expectedBytes);
        converter.order(ByteOrder.nativeOrder());
        for (int i = 0; i < values.length; ++i) {
            if (values[i] instanceof Integer) {
                converter.putInt(values[i].intValue());
                continue;
            }
            if (!(values[i] instanceof Float)) continue;
            converter.putFloat(values[i].floatValue());
        }
        return converter.array();
    }

    private void byteArrayToNumberArray(byte[] valuesIn, Number[] valuesOut) {
        int inIndex = 0;
        int outIndex = 0;
        while (inIndex < valuesIn.length && outIndex < valuesOut.length) {
            if (valuesOut[outIndex] instanceof Integer) {
                valuesOut[outIndex++] = DynamicsProcessing.byteArrayToInt(valuesIn, inIndex);
                inIndex += 4;
                continue;
            }
            if (valuesOut[outIndex] instanceof Float) {
                valuesOut[outIndex++] = Float.valueOf(DynamicsProcessing.byteArrayToFloat(valuesIn, inIndex));
                inIndex += 4;
                continue;
            }
            throw new IllegalArgumentException("can't convert " + valuesOut[outIndex].getClass());
        }
        if (outIndex != valuesOut.length) {
            throw new IllegalArgumentException("only converted " + outIndex + " values out of " + valuesOut.length + " expected");
        }
    }

    private void setNumberArray(Number[] params, Number[] values) {
        byte[] paramBytes = this.numberArrayToByteArray(params);
        byte[] valueBytes = this.numberArrayToByteArray(values);
        this.checkStatus(this.setParameter(paramBytes, valueBytes));
    }

    private float getTwoFloat(int param, int paramA) {
        int[] params = new int[]{param, paramA};
        byte[] result = new byte[4];
        this.checkStatus(this.getParameter(params, result));
        return DynamicsProcessing.byteArrayToFloat(result);
    }

    private void updateEffectArchitecture() {
        this.mChannelCount = this.getChannelCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParameterListener(OnParameterChangeListener listener) {
        Object object = this.mParamListenerLock;
        synchronized (object) {
            if (this.mParamListener == null) {
                this.mBaseParamListener = new BaseParameterListener();
                super.setParameterListener(this.mBaseParamListener);
            }
            this.mParamListener = listener;
        }
    }

    public Settings getProperties() {
        Settings settings = new Settings();
        settings.channelCount = this.getChannelCount();
        if (settings.channelCount > 32) {
            throw new IllegalArgumentException("too many channels Settings:" + settings);
        }
        settings.inputGain = new float[settings.channelCount];
        for (int ch = 0; ch < settings.channelCount; ++ch) {
        }
        return settings;
    }

    public void setProperties(Settings settings) {
        if (settings.channelCount != settings.inputGain.length || settings.channelCount != this.mChannelCount) {
            throw new IllegalArgumentException("settings invalid channel count: " + settings.channelCount);
        }
        for (int ch = 0; ch < this.mChannelCount; ++ch) {
        }
    }

    public static class Settings {
        public int channelCount;
        public float[] inputGain;

        public Settings() {
        }

        public Settings(String settings) {
            StringTokenizer st = new StringTokenizer(settings, "=;");
            if (st.countTokens() != 3) {
                throw new IllegalArgumentException("settings: " + settings);
            }
            String key = st.nextToken();
            if (!key.equals(DynamicsProcessing.TAG)) {
                throw new IllegalArgumentException("invalid settings for DynamicsProcessing: " + key);
            }
            try {
                key = st.nextToken();
                if (!key.equals("channelCount")) {
                    throw new IllegalArgumentException("invalid key name: " + key);
                }
                this.channelCount = Short.parseShort(st.nextToken());
                if (this.channelCount > 32) {
                    throw new IllegalArgumentException("too many channels Settings:" + settings);
                }
                if (st.countTokens() != this.channelCount * 1) {
                    throw new IllegalArgumentException("settings: " + settings);
                }
                this.inputGain = new float[this.channelCount];
                for (int ch = 0; ch < this.channelCount; ++ch) {
                    key = st.nextToken();
                    if (!key.equals(ch + "_inputGain")) {
                        throw new IllegalArgumentException("invalid key name: " + key);
                    }
                    this.inputGain[ch] = Float.parseFloat(st.nextToken());
                }
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("invalid value for key: " + key);
            }
        }

        public String toString() {
            String str = new String("DynamicsProcessing;channelCount=" + Integer.toString(this.channelCount));
            for (int ch = 0; ch < this.channelCount; ++ch) {
                str = str.concat(";" + ch + "_inputGain=" + Float.toString(this.inputGain[ch]));
            }
            return str;
        }
    }

    private class BaseParameterListener
    implements AudioEffect.OnParameterChangeListener {
        private BaseParameterListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onParameterChange(AudioEffect effect, int status, byte[] param, byte[] value) {
            if (status != 0) {
                return;
            }
            OnParameterChangeListener l = null;
            Object object = DynamicsProcessing.this.mParamListenerLock;
            synchronized (object) {
                if (DynamicsProcessing.this.mParamListener != null) {
                    l = DynamicsProcessing.this.mParamListener;
                }
            }
            if (l != null) {
                int p = -1;
                int v = Integer.MIN_VALUE;
                if (param.length == 4) {
                    p = AudioEffect.byteArrayToInt(param, 0);
                }
                if (value.length == 4) {
                    v = AudioEffect.byteArrayToInt(value, 0);
                }
                if (p != -1 && v != Integer.MIN_VALUE) {
                    l.onParameterChange(DynamicsProcessing.this, p, v);
                }
            }
        }
    }

    public static interface OnParameterChangeListener {
        public void onParameterChange(DynamicsProcessing var1, int var2, int var3);
    }

    public static final class Config {
        private final int mVariant;
        private final int mChannelCount;
        private final boolean mPreEqInUse;
        private final int mPreEqBandCount;
        private final boolean mMbcInUse;
        private final int mMbcBandCount;
        private final boolean mPostEqInUse;
        private final int mPostEqBandCount;
        private final boolean mLimiterInUse;
        private final float mPreferredFrameDuration;
        private final Channel[] mChannel;

        public Config(int variant, float frameDurationMs, int channelCount, boolean preEqInUse, int preEqBandCount, boolean mbcInUse, int mbcBandCount, boolean postEqInUse, int postEqBandCount, boolean limiterInUse, Channel[] channel) {
            this.mVariant = variant;
            this.mPreferredFrameDuration = frameDurationMs;
            this.mChannelCount = channelCount;
            this.mPreEqInUse = preEqInUse;
            this.mPreEqBandCount = preEqBandCount;
            this.mMbcInUse = mbcInUse;
            this.mMbcBandCount = mbcBandCount;
            this.mPostEqInUse = postEqInUse;
            this.mPostEqBandCount = postEqBandCount;
            this.mLimiterInUse = limiterInUse;
            this.mChannel = new Channel[this.mChannelCount];
            for (int ch = 0; ch < this.mChannelCount; ++ch) {
                if (ch >= channel.length) continue;
                this.mChannel[ch] = new Channel(channel[ch]);
            }
        }

        public Config(int channelCount, Config cfg) {
            this.mVariant = cfg.mVariant;
            this.mPreferredFrameDuration = cfg.mPreferredFrameDuration;
            this.mChannelCount = cfg.mChannelCount;
            this.mPreEqInUse = cfg.mPreEqInUse;
            this.mPreEqBandCount = cfg.mPreEqBandCount;
            this.mMbcInUse = cfg.mMbcInUse;
            this.mMbcBandCount = cfg.mMbcBandCount;
            this.mPostEqInUse = cfg.mPostEqInUse;
            this.mPostEqBandCount = cfg.mPostEqBandCount;
            this.mLimiterInUse = cfg.mLimiterInUse;
            if (this.mChannelCount != cfg.mChannel.length) {
                throw new IllegalArgumentException("configuration channel counts differ " + this.mChannelCount + " !=" + cfg.mChannel.length);
            }
            if (channelCount < 1) {
                throw new IllegalArgumentException("channel resizing less than 1 not allowed");
            }
            this.mChannel = new Channel[channelCount];
            for (int ch = 0; ch < channelCount; ++ch) {
                this.mChannel[ch] = ch < this.mChannelCount ? new Channel(cfg.mChannel[ch]) : new Channel(cfg.mChannel[this.mChannelCount - 1]);
            }
        }

        public Config(Config cfg) {
            this(cfg.mChannelCount, cfg);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("Variant: %d\n", this.mVariant));
            sb.append(String.format("PreferredFrameDuration: %f\n", Float.valueOf(this.mPreferredFrameDuration)));
            sb.append(String.format("ChannelCount: %d\n", this.mChannelCount));
            sb.append(String.format("PreEq inUse: %b, bandCount:%d\n", this.mPreEqInUse, this.mPreEqBandCount));
            sb.append(String.format("Mbc inUse: %b, bandCount: %d\n", this.mMbcInUse, this.mMbcBandCount));
            sb.append(String.format("PostEq inUse: %b, bandCount: %d\n", this.mPostEqInUse, this.mPostEqBandCount));
            sb.append(String.format("Limiter inUse: %b\n", this.mLimiterInUse));
            for (int ch = 0; ch < this.mChannel.length; ++ch) {
                sb.append(String.format("==Channel %d\n", ch));
                sb.append(this.mChannel[ch].toString());
            }
            return sb.toString();
        }

        private void checkChannel(int channelIndex) {
            if (channelIndex < 0 || channelIndex >= this.mChannel.length) {
                throw new IllegalArgumentException("ChannelIndex out of bounds");
            }
        }

        public int getVariant() {
            return this.mVariant;
        }

        public float getPreferredFrameDuration() {
            return this.mPreferredFrameDuration;
        }

        public boolean isPreEqInUse() {
            return this.mPreEqInUse;
        }

        public int getPreEqBandCount() {
            return this.mPreEqBandCount;
        }

        public boolean isMbcInUse() {
            return this.mMbcInUse;
        }

        public int getMbcBandCount() {
            return this.mMbcBandCount;
        }

        public boolean isPostEqInUse() {
            return this.mPostEqInUse;
        }

        public int getPostEqBandCount() {
            return this.mPostEqBandCount;
        }

        public boolean isLimiterInUse() {
            return this.mLimiterInUse;
        }

        public Channel getChannelByChannelIndex(int channelIndex) {
            this.checkChannel(channelIndex);
            return this.mChannel[channelIndex];
        }

        public void setChannelTo(int channelIndex, Channel channel) {
            this.checkChannel(channelIndex);
            if (this.mMbcBandCount != channel.getMbc().getBandCount()) {
                throw new IllegalArgumentException("MbcBandCount changed from " + this.mMbcBandCount + " to " + channel.getPreEq().getBandCount());
            }
            if (this.mPreEqBandCount != channel.getPreEq().getBandCount()) {
                throw new IllegalArgumentException("PreEqBandCount changed from " + this.mPreEqBandCount + " to " + channel.getPreEq().getBandCount());
            }
            if (this.mPostEqBandCount != channel.getPostEq().getBandCount()) {
                throw new IllegalArgumentException("PostEqBandCount changed from " + this.mPostEqBandCount + " to " + channel.getPostEq().getBandCount());
            }
            this.mChannel[channelIndex] = new Channel(channel);
        }

        public void setAllChannelsTo(Channel channel) {
            for (int ch = 0; ch < this.mChannel.length; ++ch) {
                this.setChannelTo(ch, channel);
            }
        }

        public float getInputGainByChannelIndex(int channelIndex) {
            this.checkChannel(channelIndex);
            return this.mChannel[channelIndex].getInputGain();
        }

        public void setInputGainByChannelIndex(int channelIndex, float inputGain) {
            this.checkChannel(channelIndex);
            this.mChannel[channelIndex].setInputGain(inputGain);
        }

        public void setInputGainAllChannelsTo(float inputGain) {
            for (int ch = 0; ch < this.mChannel.length; ++ch) {
                this.mChannel[ch].setInputGain(inputGain);
            }
        }

        public Eq getPreEqByChannelIndex(int channelIndex) {
            this.checkChannel(channelIndex);
            return this.mChannel[channelIndex].getPreEq();
        }

        public void setPreEqByChannelIndex(int channelIndex, Eq preEq) {
            this.checkChannel(channelIndex);
            this.mChannel[channelIndex].setPreEq(preEq);
        }

        public void setPreEqAllChannelsTo(Eq preEq) {
            for (int ch = 0; ch < this.mChannel.length; ++ch) {
                this.mChannel[ch].setPreEq(preEq);
            }
        }

        public EqBand getPreEqBandByChannelIndex(int channelIndex, int band) {
            this.checkChannel(channelIndex);
            return this.mChannel[channelIndex].getPreEqBand(band);
        }

        public void setPreEqBandByChannelIndex(int channelIndex, int band, EqBand preEqBand) {
            this.checkChannel(channelIndex);
            this.mChannel[channelIndex].setPreEqBand(band, preEqBand);
        }

        public void setPreEqBandAllChannelsTo(int band, EqBand preEqBand) {
            for (int ch = 0; ch < this.mChannel.length; ++ch) {
                this.mChannel[ch].setPreEqBand(band, preEqBand);
            }
        }

        public Mbc getMbcByChannelIndex(int channelIndex) {
            this.checkChannel(channelIndex);
            return this.mChannel[channelIndex].getMbc();
        }

        public void setMbcByChannelIndex(int channelIndex, Mbc mbc) {
            this.checkChannel(channelIndex);
            this.mChannel[channelIndex].setMbc(mbc);
        }

        public void setMbcAllChannelsTo(Mbc mbc) {
            for (int ch = 0; ch < this.mChannel.length; ++ch) {
                this.mChannel[ch].setMbc(mbc);
            }
        }

        public MbcBand getMbcBandByChannelIndex(int channelIndex, int band) {
            this.checkChannel(channelIndex);
            return this.mChannel[channelIndex].getMbcBand(band);
        }

        public void setMbcBandByChannelIndex(int channelIndex, int band, MbcBand mbcBand) {
            this.checkChannel(channelIndex);
            this.mChannel[channelIndex].setMbcBand(band, mbcBand);
        }

        public void setMbcBandAllChannelsTo(int band, MbcBand mbcBand) {
            for (int ch = 0; ch < this.mChannel.length; ++ch) {
                this.mChannel[ch].setMbcBand(band, mbcBand);
            }
        }

        public Eq getPostEqByChannelIndex(int channelIndex) {
            this.checkChannel(channelIndex);
            return this.mChannel[channelIndex].getPostEq();
        }

        public void setPostEqByChannelIndex(int channelIndex, Eq postEq) {
            this.checkChannel(channelIndex);
            this.mChannel[channelIndex].setPostEq(postEq);
        }

        public void setPostEqAllChannelsTo(Eq postEq) {
            for (int ch = 0; ch < this.mChannel.length; ++ch) {
                this.mChannel[ch].setPostEq(postEq);
            }
        }

        public EqBand getPostEqBandByChannelIndex(int channelIndex, int band) {
            this.checkChannel(channelIndex);
            return this.mChannel[channelIndex].getPostEqBand(band);
        }

        public void setPostEqBandByChannelIndex(int channelIndex, int band, EqBand postEqBand) {
            this.checkChannel(channelIndex);
            this.mChannel[channelIndex].setPostEqBand(band, postEqBand);
        }

        public void setPostEqBandAllChannelsTo(int band, EqBand postEqBand) {
            for (int ch = 0; ch < this.mChannel.length; ++ch) {
                this.mChannel[ch].setPostEqBand(band, postEqBand);
            }
        }

        public Limiter getLimiterByChannelIndex(int channelIndex) {
            this.checkChannel(channelIndex);
            return this.mChannel[channelIndex].getLimiter();
        }

        public void setLimiterByChannelIndex(int channelIndex, Limiter limiter) {
            this.checkChannel(channelIndex);
            this.mChannel[channelIndex].setLimiter(limiter);
        }

        public void setLimiterAllChannelsTo(Limiter limiter) {
            for (int ch = 0; ch < this.mChannel.length; ++ch) {
                this.mChannel[ch].setLimiter(limiter);
            }
        }

        public static final class Builder {
            private int mVariant;
            private int mChannelCount;
            private boolean mPreEqInUse;
            private int mPreEqBandCount;
            private boolean mMbcInUse;
            private int mMbcBandCount;
            private boolean mPostEqInUse;
            private int mPostEqBandCount;
            private boolean mLimiterInUse;
            private float mPreferredFrameDuration = 10.0f;
            private Channel[] mChannel;

            public Builder(int variant, int channelCount, boolean preEqInUse, int preEqBandCount, boolean mbcInUse, int mbcBandCount, boolean postEqInUse, int postEqBandCount, boolean limiterInUse) {
                this.mVariant = variant;
                this.mChannelCount = channelCount;
                this.mPreEqInUse = preEqInUse;
                this.mPreEqBandCount = preEqBandCount;
                this.mMbcInUse = mbcInUse;
                this.mMbcBandCount = mbcBandCount;
                this.mPostEqInUse = postEqInUse;
                this.mPostEqBandCount = postEqBandCount;
                this.mLimiterInUse = limiterInUse;
                this.mChannel = new Channel[this.mChannelCount];
                for (int ch = 0; ch < this.mChannelCount; ++ch) {
                    this.mChannel[ch] = new Channel(0.0f, this.mPreEqInUse, this.mPreEqBandCount, this.mMbcInUse, this.mMbcBandCount, this.mPostEqInUse, this.mPostEqBandCount, this.mLimiterInUse);
                }
            }

            private void checkChannel(int channelIndex) {
                if (channelIndex < 0 || channelIndex >= this.mChannel.length) {
                    throw new IllegalArgumentException("ChannelIndex out of bounds");
                }
            }

            public Builder setPreferredFrameDuration(float frameDuration) {
                if (frameDuration < 0.0f) {
                    throw new IllegalArgumentException("Expected positive frameDuration");
                }
                this.mPreferredFrameDuration = frameDuration;
                return this;
            }

            public Builder setInputGainByChannelIndex(int channelIndex, float inputGain) {
                this.checkChannel(channelIndex);
                this.mChannel[channelIndex].setInputGain(inputGain);
                return this;
            }

            public Builder setInputGainAllChannelsTo(float inputGain) {
                for (int ch = 0; ch < this.mChannel.length; ++ch) {
                    this.mChannel[ch].setInputGain(inputGain);
                }
                return this;
            }

            public Builder setChannelTo(int channelIndex, Channel channel) {
                this.checkChannel(channelIndex);
                if (this.mMbcBandCount != channel.getMbc().getBandCount()) {
                    throw new IllegalArgumentException("MbcBandCount changed from " + this.mMbcBandCount + " to " + channel.getPreEq().getBandCount());
                }
                if (this.mPreEqBandCount != channel.getPreEq().getBandCount()) {
                    throw new IllegalArgumentException("PreEqBandCount changed from " + this.mPreEqBandCount + " to " + channel.getPreEq().getBandCount());
                }
                if (this.mPostEqBandCount != channel.getPostEq().getBandCount()) {
                    throw new IllegalArgumentException("PostEqBandCount changed from " + this.mPostEqBandCount + " to " + channel.getPostEq().getBandCount());
                }
                this.mChannel[channelIndex] = new Channel(channel);
                return this;
            }

            public Builder setAllChannelsTo(Channel channel) {
                for (int ch = 0; ch < this.mChannel.length; ++ch) {
                    this.setChannelTo(ch, channel);
                }
                return this;
            }

            public Builder setPreEqByChannelIndex(int channelIndex, Eq preEq) {
                this.checkChannel(channelIndex);
                this.mChannel[channelIndex].setPreEq(preEq);
                return this;
            }

            public Builder setPreEqAllChannelsTo(Eq preEq) {
                for (int ch = 0; ch < this.mChannel.length; ++ch) {
                    this.setPreEqByChannelIndex(ch, preEq);
                }
                return this;
            }

            public Builder setMbcByChannelIndex(int channelIndex, Mbc mbc) {
                this.checkChannel(channelIndex);
                this.mChannel[channelIndex].setMbc(mbc);
                return this;
            }

            public Builder setMbcAllChannelsTo(Mbc mbc) {
                for (int ch = 0; ch < this.mChannel.length; ++ch) {
                    this.setMbcByChannelIndex(ch, mbc);
                }
                return this;
            }

            public Builder setPostEqByChannelIndex(int channelIndex, Eq postEq) {
                this.checkChannel(channelIndex);
                this.mChannel[channelIndex].setPostEq(postEq);
                return this;
            }

            public Builder setPostEqAllChannelsTo(Eq postEq) {
                for (int ch = 0; ch < this.mChannel.length; ++ch) {
                    this.setPostEqByChannelIndex(ch, postEq);
                }
                return this;
            }

            public Builder setLimiterByChannelIndex(int channelIndex, Limiter limiter) {
                this.checkChannel(channelIndex);
                this.mChannel[channelIndex].setLimiter(limiter);
                return this;
            }

            public Builder setLimiterAllChannelsTo(Limiter limiter) {
                for (int ch = 0; ch < this.mChannel.length; ++ch) {
                    this.setLimiterByChannelIndex(ch, limiter);
                }
                return this;
            }

            public Config build() {
                return new Config(this.mVariant, this.mPreferredFrameDuration, this.mChannelCount, this.mPreEqInUse, this.mPreEqBandCount, this.mMbcInUse, this.mMbcBandCount, this.mPostEqInUse, this.mPostEqBandCount, this.mLimiterInUse, this.mChannel);
            }
        }
    }

    public static final class Channel {
        private float mInputGain;
        private Eq mPreEq;
        private Mbc mMbc;
        private Eq mPostEq;
        private Limiter mLimiter;

        public Channel(float inputGain, boolean preEqInUse, int preEqBandCount, boolean mbcInUse, int mbcBandCount, boolean postEqInUse, int postEqBandCount, boolean limiterInUse) {
            this.mInputGain = inputGain;
            this.mPreEq = new Eq(preEqInUse, true, preEqBandCount);
            this.mMbc = new Mbc(mbcInUse, true, mbcBandCount);
            this.mPostEq = new Eq(postEqInUse, true, postEqBandCount);
            this.mLimiter = new Limiter(limiterInUse, true, 0, 1.0f, 60.0f, 10.0f, -2.0f, 0.0f);
        }

        public Channel(Channel cfg) {
            this.mInputGain = cfg.mInputGain;
            this.mPreEq = new Eq(cfg.mPreEq);
            this.mMbc = new Mbc(cfg.mMbc);
            this.mPostEq = new Eq(cfg.mPostEq);
            this.mLimiter = new Limiter(cfg.mLimiter);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format(" InputGain: %f\n", Float.valueOf(this.mInputGain)));
            sb.append("-->PreEq\n");
            sb.append(this.mPreEq.toString());
            sb.append("-->MBC\n");
            sb.append(this.mMbc.toString());
            sb.append("-->PostEq\n");
            sb.append(this.mPostEq.toString());
            sb.append("-->Limiter\n");
            sb.append(this.mLimiter.toString());
            return sb.toString();
        }

        public float getInputGain() {
            return this.mInputGain;
        }

        public void setInputGain(float inputGain) {
            this.mInputGain = inputGain;
        }

        public Eq getPreEq() {
            return this.mPreEq;
        }

        public void setPreEq(Eq preEq) {
            if (preEq.getBandCount() != this.mPreEq.getBandCount()) {
                throw new IllegalArgumentException("PreEqBandCount changed from " + this.mPreEq.getBandCount() + " to " + preEq.getBandCount());
            }
            this.mPreEq = new Eq(preEq);
        }

        public EqBand getPreEqBand(int band) {
            return this.mPreEq.getBand(band);
        }

        public void setPreEqBand(int band, EqBand preEqBand) {
            this.mPreEq.setBand(band, preEqBand);
        }

        public Mbc getMbc() {
            return this.mMbc;
        }

        public void setMbc(Mbc mbc) {
            if (mbc.getBandCount() != this.mMbc.getBandCount()) {
                throw new IllegalArgumentException("MbcBandCount changed from " + this.mMbc.getBandCount() + " to " + mbc.getBandCount());
            }
            this.mMbc = new Mbc(mbc);
        }

        public MbcBand getMbcBand(int band) {
            return this.mMbc.getBand(band);
        }

        public void setMbcBand(int band, MbcBand mbcBand) {
            this.mMbc.setBand(band, mbcBand);
        }

        public Eq getPostEq() {
            return this.mPostEq;
        }

        public void setPostEq(Eq postEq) {
            if (postEq.getBandCount() != this.mPostEq.getBandCount()) {
                throw new IllegalArgumentException("PostEqBandCount changed from " + this.mPostEq.getBandCount() + " to " + postEq.getBandCount());
            }
            this.mPostEq = new Eq(postEq);
        }

        public EqBand getPostEqBand(int band) {
            return this.mPostEq.getBand(band);
        }

        public void setPostEqBand(int band, EqBand postEqBand) {
            this.mPostEq.setBand(band, postEqBand);
        }

        public Limiter getLimiter() {
            return this.mLimiter;
        }

        public void setLimiter(Limiter limiter) {
            this.mLimiter = new Limiter(limiter);
        }
    }

    public static final class Limiter
    extends Stage {
        private int mLinkGroup;
        private float mAttackTime;
        private float mReleaseTime;
        private float mRatio;
        private float mThreshold;
        private float mPostGain;

        public Limiter(boolean inUse, boolean enabled, int linkGroup, float attackTime, float releaseTime, float ratio, float threshold, float postGain) {
            super(inUse, enabled);
            this.mLinkGroup = linkGroup;
            this.mAttackTime = attackTime;
            this.mReleaseTime = releaseTime;
            this.mRatio = ratio;
            this.mThreshold = threshold;
            this.mPostGain = postGain;
        }

        public Limiter(Limiter cfg) {
            super(cfg.isInUse(), cfg.isEnabled());
            this.mLinkGroup = cfg.mLinkGroup;
            this.mAttackTime = cfg.mAttackTime;
            this.mReleaseTime = cfg.mReleaseTime;
            this.mRatio = cfg.mRatio;
            this.mThreshold = cfg.mThreshold;
            this.mPostGain = cfg.mPostGain;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(super.toString());
            if (this.isInUse()) {
                sb.append(String.format(" LinkGroup: %d (group)\n", this.mLinkGroup));
                sb.append(String.format(" AttackTime: %f (ms)\n", Float.valueOf(this.mAttackTime)));
                sb.append(String.format(" ReleaseTime: %f (ms)\n", Float.valueOf(this.mReleaseTime)));
                sb.append(String.format(" Ratio: 1:%f\n", Float.valueOf(this.mRatio)));
                sb.append(String.format(" Threshold: %f (dB)\n", Float.valueOf(this.mThreshold)));
                sb.append(String.format(" PostGain: %f (dB)\n", Float.valueOf(this.mPostGain)));
            }
            return sb.toString();
        }

        public int getLinkGroup() {
            return this.mLinkGroup;
        }

        public void setLinkGroup(int linkGroup) {
            this.mLinkGroup = linkGroup;
        }

        public float getAttackTime() {
            return this.mAttackTime;
        }

        public void setAttackTime(float attackTime) {
            this.mAttackTime = attackTime;
        }

        public float getReleaseTime() {
            return this.mReleaseTime;
        }

        public void setReleaseTime(float releaseTime) {
            this.mReleaseTime = releaseTime;
        }

        public float getRatio() {
            return this.mRatio;
        }

        public void setRatio(float ratio) {
            this.mRatio = ratio;
        }

        public float getThreshold() {
            return this.mThreshold;
        }

        public void setThreshold(float threshold) {
            this.mThreshold = threshold;
        }

        public float getPostGain() {
            return this.mPostGain;
        }

        public void setPostGain(float postGain) {
            this.mPostGain = postGain;
        }
    }

    public static final class Mbc
    extends BandStage {
        private final MbcBand[] mBands;

        public Mbc(boolean inUse, boolean enabled, int bandCount) {
            super(inUse, enabled, bandCount);
            if (this.isInUse()) {
                this.mBands = new MbcBand[bandCount];
                for (int b = 0; b < bandCount; ++b) {
                    float freq = 20000.0f;
                    if (bandCount > 1) {
                        freq = (float)Math.pow(10.0, mMinFreqLog + (float)b * (mMaxFreqLog - mMinFreqLog) / (float)(bandCount - 1));
                    }
                    this.mBands[b] = new MbcBand(true, freq, 3.0f, 80.0f, 1.0f, -45.0f, 0.0f, -90.0f, 1.0f, 0.0f, 0.0f);
                }
            } else {
                this.mBands = null;
            }
        }

        public Mbc(Mbc cfg) {
            super(cfg.isInUse(), cfg.isEnabled(), cfg.getBandCount());
            if (this.isInUse()) {
                this.mBands = new MbcBand[cfg.mBands.length];
                for (int b = 0; b < this.mBands.length; ++b) {
                    this.mBands[b] = new MbcBand(cfg.mBands[b]);
                }
            } else {
                this.mBands = null;
            }
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(super.toString());
            if (this.isInUse()) {
                sb.append("--->MbcBands: " + this.mBands.length + "\n");
                for (int b = 0; b < this.mBands.length; ++b) {
                    sb.append(String.format("  Band %d\n", b));
                    sb.append(this.mBands[b].toString());
                }
            }
            return sb.toString();
        }

        private void checkBand(int band) {
            if (this.mBands == null || band < 0 || band >= this.mBands.length) {
                throw new IllegalArgumentException("band index " + band + " out of bounds");
            }
        }

        public void setBand(int band, MbcBand bandCfg) {
            this.checkBand(band);
            this.mBands[band] = new MbcBand(bandCfg);
        }

        public MbcBand getBand(int band) {
            this.checkBand(band);
            return this.mBands[band];
        }
    }

    public static final class Eq
    extends BandStage {
        private final EqBand[] mBands;

        public Eq(boolean inUse, boolean enabled, int bandCount) {
            super(inUse, enabled, bandCount);
            if (this.isInUse()) {
                this.mBands = new EqBand[bandCount];
                for (int b = 0; b < bandCount; ++b) {
                    float freq = 20000.0f;
                    if (bandCount > 1) {
                        freq = (float)Math.pow(10.0, mMinFreqLog + (float)b * (mMaxFreqLog - mMinFreqLog) / (float)(bandCount - 1));
                    }
                    this.mBands[b] = new EqBand(true, freq, 0.0f);
                }
            } else {
                this.mBands = null;
            }
        }

        public Eq(Eq cfg) {
            super(cfg.isInUse(), cfg.isEnabled(), cfg.getBandCount());
            if (this.isInUse()) {
                this.mBands = new EqBand[cfg.mBands.length];
                for (int b = 0; b < this.mBands.length; ++b) {
                    this.mBands[b] = new EqBand(cfg.mBands[b]);
                }
            } else {
                this.mBands = null;
            }
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(super.toString());
            if (this.isInUse()) {
                sb.append("--->EqBands: " + this.mBands.length + "\n");
                for (int b = 0; b < this.mBands.length; ++b) {
                    sb.append(String.format("  Band %d\n", b));
                    sb.append(this.mBands[b].toString());
                }
            }
            return sb.toString();
        }

        private void checkBand(int band) {
            if (this.mBands == null || band < 0 || band >= this.mBands.length) {
                throw new IllegalArgumentException("band index " + band + " out of bounds");
            }
        }

        public void setBand(int band, EqBand bandCfg) {
            this.checkBand(band);
            this.mBands[band] = new EqBand(bandCfg);
        }

        public EqBand getBand(int band) {
            this.checkBand(band);
            return this.mBands[band];
        }
    }

    public static final class MbcBand
    extends BandBase {
        private float mAttackTime;
        private float mReleaseTime;
        private float mRatio;
        private float mThreshold;
        private float mKneeWidth;
        private float mNoiseGateThreshold;
        private float mExpanderRatio;
        private float mPreGain;
        private float mPostGain;

        public MbcBand(boolean enabled, float cutoffFrequency, float attackTime, float releaseTime, float ratio, float threshold, float kneeWidth, float noiseGateThreshold, float expanderRatio, float preGain, float postGain) {
            super(enabled, cutoffFrequency);
            this.mAttackTime = attackTime;
            this.mReleaseTime = releaseTime;
            this.mRatio = ratio;
            this.mThreshold = threshold;
            this.mKneeWidth = kneeWidth;
            this.mNoiseGateThreshold = noiseGateThreshold;
            this.mExpanderRatio = expanderRatio;
            this.mPreGain = preGain;
            this.mPostGain = postGain;
        }

        public MbcBand(MbcBand cfg) {
            super(cfg.isEnabled(), cfg.getCutoffFrequency());
            this.mAttackTime = cfg.mAttackTime;
            this.mReleaseTime = cfg.mReleaseTime;
            this.mRatio = cfg.mRatio;
            this.mThreshold = cfg.mThreshold;
            this.mKneeWidth = cfg.mKneeWidth;
            this.mNoiseGateThreshold = cfg.mNoiseGateThreshold;
            this.mExpanderRatio = cfg.mExpanderRatio;
            this.mPreGain = cfg.mPreGain;
            this.mPostGain = cfg.mPostGain;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(super.toString());
            sb.append(String.format(" AttackTime: %f (ms)\n", Float.valueOf(this.mAttackTime)));
            sb.append(String.format(" ReleaseTime: %f (ms)\n", Float.valueOf(this.mReleaseTime)));
            sb.append(String.format(" Ratio: 1:%f\n", Float.valueOf(this.mRatio)));
            sb.append(String.format(" Threshold: %f (dB)\n", Float.valueOf(this.mThreshold)));
            sb.append(String.format(" NoiseGateThreshold: %f(dB)\n", Float.valueOf(this.mNoiseGateThreshold)));
            sb.append(String.format(" ExpanderRatio: %f:1\n", Float.valueOf(this.mExpanderRatio)));
            sb.append(String.format(" PreGain: %f (dB)\n", Float.valueOf(this.mPreGain)));
            sb.append(String.format(" PostGain: %f (dB)\n", Float.valueOf(this.mPostGain)));
            return sb.toString();
        }

        public float getAttackTime() {
            return this.mAttackTime;
        }

        public void setAttackTime(float attackTime) {
            this.mAttackTime = attackTime;
        }

        public float getReleaseTime() {
            return this.mReleaseTime;
        }

        public void setReleaseTime(float releaseTime) {
            this.mReleaseTime = releaseTime;
        }

        public float getRatio() {
            return this.mRatio;
        }

        public void setRatio(float ratio) {
            this.mRatio = ratio;
        }

        public float getThreshold() {
            return this.mThreshold;
        }

        public void setThreshold(float threshold) {
            this.mThreshold = threshold;
        }

        public float getKneeWidth() {
            return this.mKneeWidth;
        }

        public void setKneeWidth(float kneeWidth) {
            this.mKneeWidth = kneeWidth;
        }

        public float getNoiseGateThreshold() {
            return this.mNoiseGateThreshold;
        }

        public void setNoiseGateThreshold(float noiseGateThreshold) {
            this.mNoiseGateThreshold = noiseGateThreshold;
        }

        public float getExpanderRatio() {
            return this.mExpanderRatio;
        }

        public void setExpanderRatio(float expanderRatio) {
            this.mExpanderRatio = expanderRatio;
        }

        public float getPreGain() {
            return this.mPreGain;
        }

        public void setPreGain(float preGain) {
            this.mPreGain = preGain;
        }

        public float getPostGain() {
            return this.mPostGain;
        }

        public void setPostGain(float postGain) {
            this.mPostGain = postGain;
        }
    }

    public static final class EqBand
    extends BandBase {
        private float mGain;

        public EqBand(boolean enabled, float cutoffFrequency, float gain) {
            super(enabled, cutoffFrequency);
            this.mGain = gain;
        }

        public EqBand(EqBand cfg) {
            super(cfg.isEnabled(), cfg.getCutoffFrequency());
            this.mGain = cfg.mGain;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(super.toString());
            sb.append(String.format(" Gain: %f\n", Float.valueOf(this.mGain)));
            return sb.toString();
        }

        public float getGain() {
            return this.mGain;
        }

        public void setGain(float gain) {
            this.mGain = gain;
        }
    }

    public static class BandBase {
        private boolean mEnabled;
        private float mCutoffFrequency;

        public BandBase(boolean enabled, float cutoffFrequency) {
            this.mEnabled = enabled;
            this.mCutoffFrequency = cutoffFrequency;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format(" Enabled: %b\n", this.mEnabled));
            sb.append(String.format(" CutoffFrequency: %f\n", Float.valueOf(this.mCutoffFrequency)));
            return sb.toString();
        }

        public boolean isEnabled() {
            return this.mEnabled;
        }

        public void setEnabled(boolean enabled) {
            this.mEnabled = enabled;
        }

        public float getCutoffFrequency() {
            return this.mCutoffFrequency;
        }

        public void setCutoffFrequency(float frequency) {
            this.mCutoffFrequency = frequency;
        }
    }

    public static class BandStage
    extends Stage {
        private int mBandCount;

        public BandStage(boolean inUse, boolean enabled, int bandCount) {
            super(inUse, enabled);
            this.mBandCount = this.isInUse() ? bandCount : 0;
        }

        public int getBandCount() {
            return this.mBandCount;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(super.toString());
            if (this.isInUse()) {
                sb.append(String.format(" Band Count: %d\n", this.mBandCount));
            }
            return sb.toString();
        }
    }

    public static class Stage {
        private boolean mInUse;
        private boolean mEnabled;

        public Stage(boolean inUse, boolean enabled) {
            this.mInUse = inUse;
            this.mEnabled = enabled;
        }

        public boolean isEnabled() {
            return this.mEnabled;
        }

        public void setEnabled(boolean enabled) {
            this.mEnabled = enabled;
        }

        public boolean isInUse() {
            return this.mInUse;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format(" Stage InUse: %b\n", this.isInUse()));
            if (this.isInUse()) {
                sb.append(String.format(" Stage Enabled: %b\n", this.mEnabled));
            }
            return sb.toString();
        }
    }
}

