/*
 * Decompiled with CFR 0.152.
 */
package android.media.audiofx;

import android.app.ActivityThread;
import android.media.audiofx.DefaultEffect;
import android.util.Log;
import java.util.UUID;

public class StreamDefaultEffect
extends DefaultEffect {
    private static final String TAG = "StreamDefaultEffect-JAVA";

    public StreamDefaultEffect(UUID type, UUID uuid, int priority, int streamUsage) {
        int[] id2 = new int[1];
        int initResult = this.native_setup(type.toString(), uuid.toString(), priority, streamUsage, ActivityThread.currentOpPackageName(), id2);
        if (initResult != 0) {
            Log.e(TAG, "Error code " + initResult + " when initializing StreamDefaultEffect");
            switch (initResult) {
                case -4: {
                    throw new IllegalArgumentException("Stream usage, type uuid, or implementation uuid not supported.");
                }
                case -5: {
                    throw new UnsupportedOperationException("Effect library not loaded");
                }
            }
            throw new RuntimeException("Cannot initialize effect engine for type: " + type + " Error: " + initResult);
        }
        this.mId = id2[0];
    }

    public void release() {
        this.native_release(this.mId);
    }

    protected void finalize() {
        this.release();
    }

    private final native int native_setup(String var1, String var2, int var3, int var4, String var5, int[] var6);

    private final native void native_release(int var1);

    static {
        System.loadLibrary("audioeffect_jni");
    }
}

