/*
 * Decompiled with CFR 0.152.
 */
package android.media.audiofx;

import android.media.AudioDeviceInfo;
import android.media.AudioFormat;
import android.media.audiofx.AudioEffect;
import android.util.Log;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.StringTokenizer;

public class Virtualizer
extends AudioEffect {
    private static final String TAG = "Virtualizer";
    private static final boolean DEBUG = false;
    public static final int PARAM_STRENGTH_SUPPORTED = 0;
    public static final int PARAM_STRENGTH = 1;
    public static final int PARAM_VIRTUAL_SPEAKER_ANGLES = 2;
    public static final int PARAM_FORCE_VIRTUALIZATION_MODE = 3;
    public static final int PARAM_VIRTUALIZATION_MODE = 4;
    private boolean mStrengthSupported = false;
    private OnParameterChangeListener mParamListener = null;
    private BaseParameterListener mBaseParamListener = null;
    private final Object mParamListenerLock = new Object();
    public static final int VIRTUALIZATION_MODE_OFF = 0;
    public static final int VIRTUALIZATION_MODE_AUTO = 1;
    public static final int VIRTUALIZATION_MODE_BINAURAL = 2;
    public static final int VIRTUALIZATION_MODE_TRANSAURAL = 3;

    public Virtualizer(int priority, int audioSession) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException, RuntimeException {
        super(EFFECT_TYPE_VIRTUALIZER, EFFECT_TYPE_NULL, priority, audioSession);
        if (audioSession == 0) {
            Log.w(TAG, "WARNING: attaching a Virtualizer to global output mix is deprecated!");
        }
        int[] value = new int[1];
        this.checkStatus(this.getParameter(0, value));
        this.mStrengthSupported = value[0] != 0;
    }

    public boolean getStrengthSupported() {
        return this.mStrengthSupported;
    }

    public void setStrength(short strength) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        this.checkStatus(this.setParameter(1, strength));
    }

    public short getRoundedStrength() throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        short[] value = new short[1];
        this.checkStatus(this.getParameter(1, value));
        return value[0];
    }

    private boolean getAnglesInt(int inputChannelMask, int deviceType, int[] angles) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        if (inputChannelMask == 0) {
            throw new IllegalArgumentException("Virtualizer: illegal CHANNEL_INVALID channel mask");
        }
        int channelMask = inputChannelMask == 1 ? 12 : inputChannelMask;
        int nbChannels = AudioFormat.channelCountFromOutChannelMask(channelMask);
        if (angles != null && angles.length < nbChannels * 3) {
            Log.e(TAG, "Size of array for angles cannot accomodate number of channels in mask (" + nbChannels + ")");
            throw new IllegalArgumentException("Virtualizer: array for channel / angle pairs is too small: is " + angles.length + ", should be " + nbChannels * 3);
        }
        ByteBuffer paramsConverter = ByteBuffer.allocate(12);
        paramsConverter.order(ByteOrder.nativeOrder());
        paramsConverter.putInt(2);
        paramsConverter.putInt(AudioFormat.convertChannelOutMaskToNativeMask(channelMask));
        paramsConverter.putInt(AudioDeviceInfo.convertDeviceTypeToInternalDevice(deviceType));
        byte[] result = new byte[nbChannels * 4 * 3];
        int status = this.getParameter(paramsConverter.array(), result);
        if (status >= 0) {
            if (angles != null) {
                ByteBuffer resultConverter = ByteBuffer.wrap(result);
                resultConverter.order(ByteOrder.nativeOrder());
                for (int i = 0; i < nbChannels; ++i) {
                    angles[3 * i] = AudioFormat.convertNativeChannelMaskToOutMask(resultConverter.getInt(i * 4 * 3));
                    angles[3 * i + 1] = resultConverter.getInt(i * 4 * 3 + 4);
                    angles[3 * i + 2] = resultConverter.getInt(i * 4 * 3 + 8);
                }
            }
            return true;
        }
        if (status == -4) {
            return false;
        }
        this.checkStatus(status);
        Log.e(TAG, "unexpected status code " + status + " after getParameter(PARAM_VIRTUAL_SPEAKER_ANGLES)");
        return false;
    }

    private static int getDeviceForModeQuery(int virtualizationMode) throws IllegalArgumentException {
        switch (virtualizationMode) {
            case 2: {
                return 4;
            }
            case 3: {
                return 2;
            }
        }
        throw new IllegalArgumentException("Virtualizer: illegal virtualization mode " + virtualizationMode);
    }

    private static int getDeviceForModeForce(int virtualizationMode) throws IllegalArgumentException {
        if (virtualizationMode == 1) {
            return 0;
        }
        return Virtualizer.getDeviceForModeQuery(virtualizationMode);
    }

    private static int deviceToMode(int deviceType) {
        switch (deviceType) {
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 22: {
                return 2;
            }
            case 2: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 19: {
                return 3;
            }
        }
        return 0;
    }

    public boolean canVirtualize(int inputChannelMask, int virtualizationMode) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        return this.getAnglesInt(inputChannelMask, Virtualizer.getDeviceForModeQuery(virtualizationMode), null);
    }

    public boolean getSpeakerAngles(int inputChannelMask, int virtualizationMode, int[] angles) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        if (angles == null) {
            throw new IllegalArgumentException("Virtualizer: illegal null channel / angle array");
        }
        return this.getAnglesInt(inputChannelMask, Virtualizer.getDeviceForModeQuery(virtualizationMode), angles);
    }

    public boolean forceVirtualizationMode(int virtualizationMode) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        int deviceType = Virtualizer.getDeviceForModeForce(virtualizationMode);
        int internalDevice = AudioDeviceInfo.convertDeviceTypeToInternalDevice(deviceType);
        int status = this.setParameter(3, internalDevice);
        if (status >= 0) {
            return true;
        }
        if (status == -4) {
            return false;
        }
        this.checkStatus(status);
        Log.e(TAG, "unexpected status code " + status + " after setParameter(PARAM_FORCE_VIRTUALIZATION_MODE)");
        return false;
    }

    public int getVirtualizationMode() throws IllegalStateException, UnsupportedOperationException {
        int[] value = new int[1];
        int status = this.getParameter(4, value);
        if (status >= 0) {
            return Virtualizer.deviceToMode(AudioDeviceInfo.convertInternalDeviceToDeviceType(value[0]));
        }
        if (status == -4) {
            return 0;
        }
        this.checkStatus(status);
        Log.e(TAG, "unexpected status code " + status + " after getParameter(PARAM_VIRTUALIZATION_MODE)");
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParameterListener(OnParameterChangeListener listener) {
        Object object = this.mParamListenerLock;
        synchronized (object) {
            if (this.mParamListener == null) {
                this.mParamListener = listener;
                this.mBaseParamListener = new BaseParameterListener();
                super.setParameterListener(this.mBaseParamListener);
            }
        }
    }

    public Settings getProperties() throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        Settings settings = new Settings();
        short[] value = new short[1];
        this.checkStatus(this.getParameter(1, value));
        settings.strength = value[0];
        return settings;
    }

    public void setProperties(Settings settings) throws IllegalStateException, IllegalArgumentException, UnsupportedOperationException {
        this.checkStatus(this.setParameter(1, settings.strength));
    }

    public static class Settings {
        public short strength;

        public Settings() {
        }

        public Settings(String settings) {
            StringTokenizer st = new StringTokenizer(settings, "=;");
            int tokens = st.countTokens();
            if (st.countTokens() != 3) {
                throw new IllegalArgumentException("settings: " + settings);
            }
            String key = st.nextToken();
            if (!key.equals(Virtualizer.TAG)) {
                throw new IllegalArgumentException("invalid settings for Virtualizer: " + key);
            }
            try {
                key = st.nextToken();
                if (!key.equals("strength")) {
                    throw new IllegalArgumentException("invalid key name: " + key);
                }
                this.strength = Short.parseShort(st.nextToken());
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("invalid value for key: " + key);
            }
        }

        public String toString() {
            String str = new String("Virtualizer;strength=" + Short.toString(this.strength));
            return str;
        }
    }

    private class BaseParameterListener
    implements AudioEffect.OnParameterChangeListener {
        private BaseParameterListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onParameterChange(AudioEffect effect, int status, byte[] param, byte[] value) {
            OnParameterChangeListener l = null;
            Object object = Virtualizer.this.mParamListenerLock;
            synchronized (object) {
                if (Virtualizer.this.mParamListener != null) {
                    l = Virtualizer.this.mParamListener;
                }
            }
            if (l != null) {
                int p = -1;
                short v = -1;
                if (param.length == 4) {
                    p = AudioEffect.byteArrayToInt(param, 0);
                }
                if (value.length == 2) {
                    v = AudioEffect.byteArrayToShort(value, 0);
                }
                if (p != -1 && v != -1) {
                    l.onParameterChange(Virtualizer.this, status, p, v);
                }
            }
        }
    }

    public static interface OnParameterChangeListener {
        public void onParameterChange(Virtualizer var1, int var2, int var3, short var4);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ForceVirtualizationMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface VirtualizationMode {
    }
}

