/*
 * Decompiled with CFR 0.152.
 */
package android.media.audiopolicy;

import android.media.AudioManager;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import com.android.internal.util.Preconditions;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

public class AudioVolumeGroupChangeHandler {
    private Handler mHandler;
    private HandlerThread mHandlerThread;
    private final ArrayList<AudioManager.VolumeGroupCallback> mListeners = new ArrayList();
    private static final String TAG = "AudioVolumeGroupChangeHandler";
    private static final int AUDIOVOLUMEGROUP_EVENT_VOLUME_CHANGED = 1000;
    private static final int AUDIOVOLUMEGROUP_EVENT_NEW_LISTENER = 4;
    private long mJniCallback;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        AudioVolumeGroupChangeHandler audioVolumeGroupChangeHandler = this;
        synchronized (audioVolumeGroupChangeHandler) {
            if (this.mHandler != null) {
                return;
            }
            this.mHandlerThread = new HandlerThread(TAG);
            this.mHandlerThread.start();
            if (this.mHandlerThread.getLooper() == null) {
                this.mHandler = null;
                return;
            }
            this.mHandler = new Handler(this.mHandlerThread.getLooper()){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void handleMessage(Message msg) {
                    ArrayList listeners;
                    1 var2_2 = this;
                    synchronized (var2_2) {
                        if (msg.what == 4) {
                            listeners = new ArrayList();
                            if (AudioVolumeGroupChangeHandler.this.mListeners.contains(msg.obj)) {
                                listeners.add((AudioManager.VolumeGroupCallback)msg.obj);
                            }
                        } else {
                            listeners = AudioVolumeGroupChangeHandler.this.mListeners;
                        }
                    }
                    if (listeners.isEmpty()) {
                        return;
                    }
                    switch (msg.what) {
                        case 1000: {
                            for (int i = 0; i < listeners.size(); ++i) {
                                ((AudioManager.VolumeGroupCallback)listeners.get(i)).onAudioVolumeGroupChanged(msg.arg1, msg.arg2);
                            }
                            break;
                        }
                    }
                }
            };
            this.native_setup(new WeakReference<AudioVolumeGroupChangeHandler>(this));
        }
    }

    private native void native_setup(Object var1);

    protected void finalize() {
        this.native_finalize();
        if (this.mHandlerThread.isAlive()) {
            this.mHandlerThread.quit();
        }
    }

    private native void native_finalize();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListener(AudioManager.VolumeGroupCallback cb) {
        Preconditions.checkNotNull(cb, "volume group callback shall not be null");
        AudioVolumeGroupChangeHandler audioVolumeGroupChangeHandler = this;
        synchronized (audioVolumeGroupChangeHandler) {
            this.mListeners.add(cb);
        }
        if (this.mHandler != null) {
            Message m = this.mHandler.obtainMessage(4, 0, 0, cb);
            this.mHandler.sendMessage(m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterListener(AudioManager.VolumeGroupCallback cb) {
        Preconditions.checkNotNull(cb, "volume group callback shall not be null");
        AudioVolumeGroupChangeHandler audioVolumeGroupChangeHandler = this;
        synchronized (audioVolumeGroupChangeHandler) {
            this.mListeners.remove(cb);
        }
    }

    Handler handler() {
        return this.mHandler;
    }

    private static void postEventFromNative(Object moduleRef, int what, int arg1, int arg2, Object obj) {
        Handler handler;
        AudioVolumeGroupChangeHandler eventHandler = (AudioVolumeGroupChangeHandler)((WeakReference)moduleRef).get();
        if (eventHandler == null) {
            return;
        }
        if (eventHandler != null && (handler = eventHandler.handler()) != null) {
            Message m = handler.obtainMessage(what, arg1, arg2, obj);
            if (what != 4) {
                handler.removeMessages(what);
            }
            handler.sendMessage(m);
        }
    }
}

