/*
 * Decompiled with CFR 0.152.
 */
package android.media.midi;

import android.media.midi.IMidiDeviceServer;
import android.media.midi.MidiPortImpl;
import android.media.midi.MidiReceiver;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import dalvik.system.CloseGuard;
import java.io.Closeable;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import libcore.io.IoUtils;

public final class MidiInputPort
extends MidiReceiver
implements Closeable {
    private static final String TAG = "MidiInputPort";
    private IMidiDeviceServer mDeviceServer;
    private final IBinder mToken;
    private final int mPortNumber;
    private FileDescriptor mFileDescriptor;
    private FileOutputStream mOutputStream;
    private final CloseGuard mGuard = CloseGuard.get();
    private boolean mIsClosed;
    private final byte[] mBuffer = new byte[1024];

    MidiInputPort(IMidiDeviceServer server, IBinder token, FileDescriptor fd, int portNumber) {
        super(1015);
        this.mDeviceServer = server;
        this.mToken = token;
        this.mFileDescriptor = fd;
        this.mPortNumber = portNumber;
        this.mOutputStream = new FileOutputStream(fd);
        this.mGuard.open("close");
    }

    MidiInputPort(FileDescriptor fd, int portNumber) {
        this(null, null, fd, portNumber);
    }

    public final int getPortNumber() {
        return this.mPortNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSend(byte[] msg, int offset, int count, long timestamp) throws IOException {
        if (offset < 0 || count < 0 || offset + count > msg.length) {
            throw new IllegalArgumentException("offset or count out of range");
        }
        if (count > 1015) {
            throw new IllegalArgumentException("count exceeds max message size");
        }
        byte[] byArray = this.mBuffer;
        synchronized (this.mBuffer) {
            if (this.mOutputStream == null) {
                throw new IOException("MidiInputPort is closed");
            }
            int length = MidiPortImpl.packData(msg, offset, count, timestamp, this.mBuffer);
            this.mOutputStream.write(this.mBuffer, 0, length);
            // ** MonitorExit[var6_5] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFlush() throws IOException {
        byte[] byArray = this.mBuffer;
        synchronized (this.mBuffer) {
            if (this.mOutputStream == null) {
                throw new IOException("MidiInputPort is closed");
            }
            int length = MidiPortImpl.packFlush(this.mBuffer);
            this.mOutputStream.write(this.mBuffer, 0, length);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FileDescriptor claimFileDescriptor() {
        CloseGuard closeGuard = this.mGuard;
        synchronized (closeGuard) {
            byte[] byArray = this.mBuffer;
            synchronized (this.mBuffer) {
                FileDescriptor fd = this.mFileDescriptor;
                if (fd == null) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return null;
                }
                IoUtils.closeQuietly(this.mOutputStream);
                this.mFileDescriptor = null;
                this.mOutputStream = null;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                this.mIsClosed = true;
                return fd;
            }
        }
    }

    IBinder getToken() {
        return this.mToken;
    }

    IMidiDeviceServer getDeviceServer() {
        return this.mDeviceServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        CloseGuard closeGuard = this.mGuard;
        synchronized (closeGuard) {
            if (this.mIsClosed) {
                return;
            }
            this.mGuard.close();
            byte[] byArray = this.mBuffer;
            synchronized (this.mBuffer) {
                if (this.mFileDescriptor != null) {
                    IoUtils.closeQuietly(this.mFileDescriptor);
                    this.mFileDescriptor = null;
                }
                if (this.mOutputStream != null) {
                    this.mOutputStream.close();
                    this.mOutputStream = null;
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                if (this.mDeviceServer != null) {
                    try {
                        this.mDeviceServer.closePort(this.mToken);
                    }
                    catch (RemoteException e) {
                        Log.e(TAG, "RemoteException in MidiInputPort.close()");
                    }
                }
                this.mIsClosed = true;
            }
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mGuard != null) {
                this.mGuard.warnIfOpen();
            }
            this.mDeviceServer = null;
            this.close();
        }
        finally {
            super.finalize();
        }
    }
}

