/*
 * Decompiled with CFR 0.152.
 */
package android.media.soundtrigger;

import android.annotation.SystemApi;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.hardware.soundtrigger.SoundTrigger;
import android.media.soundtrigger.ISoundTriggerDetectionService;
import android.media.soundtrigger.ISoundTriggerDetectionServiceClient;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.ParcelUuid;
import android.os.RemoteException;
import android.util.ArrayMap;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.function.pooled.PooledLambda;
import java.util.UUID;

@SystemApi
public abstract class SoundTriggerDetectionService
extends Service {
    private static final String LOG_TAG = SoundTriggerDetectionService.class.getSimpleName();
    private static final boolean DEBUG = false;
    private final Object mLock = new Object();
    @GuardedBy(value={"mLock"})
    private final ArrayMap<UUID, ISoundTriggerDetectionServiceClient> mClients = new ArrayMap();
    private Handler mHandler;

    @Override
    protected final void attachBaseContext(Context base) {
        super.attachBaseContext(base);
        this.mHandler = new Handler(base.getMainLooper());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setClient(UUID uuid, Bundle params, ISoundTriggerDetectionServiceClient client) {
        Object object = this.mLock;
        synchronized (object) {
            this.mClients.put(uuid, client);
        }
        this.onConnected(uuid, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeClient(UUID uuid, Bundle params) {
        Object object = this.mLock;
        synchronized (object) {
            this.mClients.remove(uuid);
        }
        this.onDisconnected(uuid, params);
    }

    public void onConnected(UUID uuid, Bundle params) {
    }

    public void onDisconnected(UUID uuid, Bundle params) {
    }

    public void onGenericRecognitionEvent(UUID uuid, Bundle params, int opId, SoundTrigger.RecognitionEvent event) {
        this.operationFinished(uuid, opId);
    }

    public void onError(UUID uuid, Bundle params, int opId, int status) {
        this.operationFinished(uuid, opId);
    }

    public abstract void onStopOperation(UUID var1, Bundle var2, int var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void operationFinished(UUID uuid, int opId) {
        try {
            ISoundTriggerDetectionServiceClient client;
            Object object = this.mLock;
            synchronized (object) {
                client = this.mClients.get(uuid);
                if (client == null) {
                    Log.w(LOG_TAG, "operationFinished called, but no client for " + uuid + ". Was this called after onDisconnected?");
                    return;
                }
            }
            client.onOpFinished(opId);
        }
        catch (RemoteException e) {
            Log.e(LOG_TAG, "operationFinished, remote exception for client " + uuid, e);
        }
    }

    @Override
    public final IBinder onBind(Intent intent) {
        return new ISoundTriggerDetectionService.Stub(){
            private final Object mBinderLock = new Object();
            @GuardedBy(value={"mBinderLock"})
            public final ArrayMap<UUID, Bundle> mParams = new ArrayMap();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setClient(ParcelUuid puuid, Bundle params, ISoundTriggerDetectionServiceClient client) {
                UUID uuid = puuid.getUuid();
                Object object = this.mBinderLock;
                synchronized (object) {
                    this.mParams.put(uuid, params);
                }
                SoundTriggerDetectionService.this.mHandler.sendMessage(PooledLambda.obtainMessage((rec$, x$0, x$1, x$2) -> ((SoundTriggerDetectionService)rec$).setClient(x$0, x$1, x$2), SoundTriggerDetectionService.this, uuid, params, client));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeClient(ParcelUuid puuid) {
                Bundle params;
                UUID uuid = puuid.getUuid();
                Object object = this.mBinderLock;
                synchronized (object) {
                    params = this.mParams.remove(uuid);
                }
                SoundTriggerDetectionService.this.mHandler.sendMessage(PooledLambda.obtainMessage((rec$, x$0, x$1) -> ((SoundTriggerDetectionService)rec$).removeClient(x$0, x$1), SoundTriggerDetectionService.this, uuid, params));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onGenericRecognitionEvent(ParcelUuid puuid, int opId, SoundTrigger.GenericRecognitionEvent event) {
                Bundle params;
                UUID uuid = puuid.getUuid();
                Object object = this.mBinderLock;
                synchronized (object) {
                    params = this.mParams.get(uuid);
                }
                SoundTriggerDetectionService.this.mHandler.sendMessage(PooledLambda.obtainMessage(SoundTriggerDetectionService::onGenericRecognitionEvent, SoundTriggerDetectionService.this, uuid, params, opId, event));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onError(ParcelUuid puuid, int opId, int status) {
                Bundle params;
                UUID uuid = puuid.getUuid();
                Object object = this.mBinderLock;
                synchronized (object) {
                    params = this.mParams.get(uuid);
                }
                SoundTriggerDetectionService.this.mHandler.sendMessage(PooledLambda.obtainMessage(SoundTriggerDetectionService::onError, SoundTriggerDetectionService.this, uuid, params, opId, status));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onStopOperation(ParcelUuid puuid, int opId) {
                Bundle params;
                UUID uuid = puuid.getUuid();
                Object object = this.mBinderLock;
                synchronized (object) {
                    params = this.mParams.get(uuid);
                }
                SoundTriggerDetectionService.this.mHandler.sendMessage(PooledLambda.obtainMessage(SoundTriggerDetectionService::onStopOperation, SoundTriggerDetectionService.this, uuid, params, opId));
            }
        };
    }

    @Override
    public boolean onUnbind(Intent intent) {
        this.mClients.clear();
        return false;
    }
}

