/*
 * Decompiled with CFR 0.152.
 */
package android.media.tv;

import android.graphics.Rect;
import android.media.PlaybackParams;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.view.Surface;

public interface ITvInputSession
extends IInterface {
    public void release() throws RemoteException;

    public void setMain(boolean var1) throws RemoteException;

    public void setSurface(Surface var1) throws RemoteException;

    public void dispatchSurfaceChanged(int var1, int var2, int var3) throws RemoteException;

    public void setVolume(float var1) throws RemoteException;

    public void tune(Uri var1, Bundle var2) throws RemoteException;

    public void setCaptionEnabled(boolean var1) throws RemoteException;

    public void selectTrack(int var1, String var2) throws RemoteException;

    public void appPrivateCommand(String var1, Bundle var2) throws RemoteException;

    public void createOverlayView(IBinder var1, Rect var2) throws RemoteException;

    public void relayoutOverlayView(Rect var1) throws RemoteException;

    public void removeOverlayView() throws RemoteException;

    public void unblockContent(String var1) throws RemoteException;

    public void timeShiftPlay(Uri var1) throws RemoteException;

    public void timeShiftPause() throws RemoteException;

    public void timeShiftResume() throws RemoteException;

    public void timeShiftSeekTo(long var1) throws RemoteException;

    public void timeShiftSetPlaybackParams(PlaybackParams var1) throws RemoteException;

    public void timeShiftEnablePositionTracking(boolean var1) throws RemoteException;

    public void startRecording(Uri var1) throws RemoteException;

    public void stopRecording() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ITvInputSession {
        private static final String DESCRIPTOR = "android.media.tv.ITvInputSession";
        static final int TRANSACTION_release = 1;
        static final int TRANSACTION_setMain = 2;
        static final int TRANSACTION_setSurface = 3;
        static final int TRANSACTION_dispatchSurfaceChanged = 4;
        static final int TRANSACTION_setVolume = 5;
        static final int TRANSACTION_tune = 6;
        static final int TRANSACTION_setCaptionEnabled = 7;
        static final int TRANSACTION_selectTrack = 8;
        static final int TRANSACTION_appPrivateCommand = 9;
        static final int TRANSACTION_createOverlayView = 10;
        static final int TRANSACTION_relayoutOverlayView = 11;
        static final int TRANSACTION_removeOverlayView = 12;
        static final int TRANSACTION_unblockContent = 13;
        static final int TRANSACTION_timeShiftPlay = 14;
        static final int TRANSACTION_timeShiftPause = 15;
        static final int TRANSACTION_timeShiftResume = 16;
        static final int TRANSACTION_timeShiftSeekTo = 17;
        static final int TRANSACTION_timeShiftSetPlaybackParams = 18;
        static final int TRANSACTION_timeShiftEnablePositionTracking = 19;
        static final int TRANSACTION_startRecording = 20;
        static final int TRANSACTION_stopRecording = 21;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static ITvInputSession asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof ITvInputSession) {
                return (ITvInputSession)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "release";
                }
                case 2: {
                    return "setMain";
                }
                case 3: {
                    return "setSurface";
                }
                case 4: {
                    return "dispatchSurfaceChanged";
                }
                case 5: {
                    return "setVolume";
                }
                case 6: {
                    return "tune";
                }
                case 7: {
                    return "setCaptionEnabled";
                }
                case 8: {
                    return "selectTrack";
                }
                case 9: {
                    return "appPrivateCommand";
                }
                case 10: {
                    return "createOverlayView";
                }
                case 11: {
                    return "relayoutOverlayView";
                }
                case 12: {
                    return "removeOverlayView";
                }
                case 13: {
                    return "unblockContent";
                }
                case 14: {
                    return "timeShiftPlay";
                }
                case 15: {
                    return "timeShiftPause";
                }
                case 16: {
                    return "timeShiftResume";
                }
                case 17: {
                    return "timeShiftSeekTo";
                }
                case 18: {
                    return "timeShiftSetPlaybackParams";
                }
                case 19: {
                    return "timeShiftEnablePositionTracking";
                }
                case 20: {
                    return "startRecording";
                }
                case 21: {
                    return "stopRecording";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
                case 1: {
                    data.enforceInterface(descriptor);
                    this.release();
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    this.setMain(_arg0);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    Surface _arg0 = 0 != data.readInt() ? Surface.CREATOR.createFromParcel(data) : null;
                    this.setSurface(_arg0);
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    this.dispatchSurfaceChanged(_arg0, _arg1, _arg2);
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    float _arg0 = data.readFloat();
                    this.setVolume(_arg0);
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    Uri _arg0 = 0 != data.readInt() ? Uri.CREATOR.createFromParcel(data) : null;
                    Bundle _arg1 = 0 != data.readInt() ? Bundle.CREATOR.createFromParcel(data) : null;
                    this.tune(_arg0, _arg1);
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    this.setCaptionEnabled(_arg0);
                    return true;
                }
                case 8: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    this.selectTrack(_arg0, _arg1);
                    return true;
                }
                case 9: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    Bundle _arg1 = 0 != data.readInt() ? Bundle.CREATOR.createFromParcel(data) : null;
                    this.appPrivateCommand(_arg0, _arg1);
                    return true;
                }
                case 10: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    Rect _arg1 = 0 != data.readInt() ? Rect.CREATOR.createFromParcel(data) : null;
                    this.createOverlayView(_arg0, _arg1);
                    return true;
                }
                case 11: {
                    data.enforceInterface(descriptor);
                    Rect _arg0 = 0 != data.readInt() ? Rect.CREATOR.createFromParcel(data) : null;
                    this.relayoutOverlayView(_arg0);
                    return true;
                }
                case 12: {
                    data.enforceInterface(descriptor);
                    this.removeOverlayView();
                    return true;
                }
                case 13: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    this.unblockContent(_arg0);
                    return true;
                }
                case 14: {
                    data.enforceInterface(descriptor);
                    Uri _arg0 = 0 != data.readInt() ? Uri.CREATOR.createFromParcel(data) : null;
                    this.timeShiftPlay(_arg0);
                    return true;
                }
                case 15: {
                    data.enforceInterface(descriptor);
                    this.timeShiftPause();
                    return true;
                }
                case 16: {
                    data.enforceInterface(descriptor);
                    this.timeShiftResume();
                    return true;
                }
                case 17: {
                    data.enforceInterface(descriptor);
                    long _arg0 = data.readLong();
                    this.timeShiftSeekTo(_arg0);
                    return true;
                }
                case 18: {
                    data.enforceInterface(descriptor);
                    PlaybackParams _arg0 = 0 != data.readInt() ? PlaybackParams.CREATOR.createFromParcel(data) : null;
                    this.timeShiftSetPlaybackParams(_arg0);
                    return true;
                }
                case 19: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    this.timeShiftEnablePositionTracking(_arg0);
                    return true;
                }
                case 20: {
                    data.enforceInterface(descriptor);
                    Uri _arg0 = 0 != data.readInt() ? Uri.CREATOR.createFromParcel(data) : null;
                    this.startRecording(_arg0);
                    return true;
                }
                case 21: {
                    data.enforceInterface(descriptor);
                    this.stopRecording();
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(ITvInputSession impl) {
            if (Proxy.sDefaultImpl == null && impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static ITvInputSession getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements ITvInputSession {
            private IBinder mRemote;
            public static ITvInputSession sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            @Override
            public void release() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().release();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setMain(boolean isMain) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(isMain ? 1 : 0);
                    boolean _status = this.mRemote.transact(2, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setMain(isMain);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setSurface(Surface surface) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (surface != null) {
                        _data.writeInt(1);
                        surface.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(3, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setSurface(surface);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dispatchSurfaceChanged(int format, int width, int height) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(format);
                    _data.writeInt(width);
                    _data.writeInt(height);
                    boolean _status = this.mRemote.transact(4, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().dispatchSurfaceChanged(format, width, height);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setVolume(float volume) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeFloat(volume);
                    boolean _status = this.mRemote.transact(5, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setVolume(volume);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void tune(Uri channelUri, Bundle params) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (channelUri != null) {
                        _data.writeInt(1);
                        channelUri.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (params != null) {
                        _data.writeInt(1);
                        params.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(6, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().tune(channelUri, params);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setCaptionEnabled(boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(enabled ? 1 : 0);
                    boolean _status = this.mRemote.transact(7, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setCaptionEnabled(enabled);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void selectTrack(int type, String trackId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(type);
                    _data.writeString(trackId);
                    boolean _status = this.mRemote.transact(8, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().selectTrack(type, trackId);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void appPrivateCommand(String action, Bundle data) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(action);
                    if (data != null) {
                        _data.writeInt(1);
                        data.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(9, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().appPrivateCommand(action, data);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void createOverlayView(IBinder windowToken, Rect frame) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(windowToken);
                    if (frame != null) {
                        _data.writeInt(1);
                        frame.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(10, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().createOverlayView(windowToken, frame);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void relayoutOverlayView(Rect frame) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (frame != null) {
                        _data.writeInt(1);
                        frame.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(11, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().relayoutOverlayView(frame);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void removeOverlayView() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(12, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().removeOverlayView();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unblockContent(String unblockedRating) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(unblockedRating);
                    boolean _status = this.mRemote.transact(13, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().unblockContent(unblockedRating);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void timeShiftPlay(Uri recordedProgramUri) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (recordedProgramUri != null) {
                        _data.writeInt(1);
                        recordedProgramUri.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(14, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().timeShiftPlay(recordedProgramUri);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void timeShiftPause() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(15, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().timeShiftPause();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void timeShiftResume() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(16, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().timeShiftResume();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void timeShiftSeekTo(long timeMs) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(timeMs);
                    boolean _status = this.mRemote.transact(17, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().timeShiftSeekTo(timeMs);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void timeShiftSetPlaybackParams(PlaybackParams params) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (params != null) {
                        _data.writeInt(1);
                        params.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(18, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().timeShiftSetPlaybackParams(params);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void timeShiftEnablePositionTracking(boolean enable) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(enable ? 1 : 0);
                    boolean _status = this.mRemote.transact(19, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().timeShiftEnablePositionTracking(enable);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startRecording(Uri programUri) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (programUri != null) {
                        _data.writeInt(1);
                        programUri.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(20, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().startRecording(programUri);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void stopRecording() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(21, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().stopRecording();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ITvInputSession {
        @Override
        public void release() throws RemoteException {
        }

        @Override
        public void setMain(boolean isMain) throws RemoteException {
        }

        @Override
        public void setSurface(Surface surface) throws RemoteException {
        }

        @Override
        public void dispatchSurfaceChanged(int format, int width, int height) throws RemoteException {
        }

        @Override
        public void setVolume(float volume) throws RemoteException {
        }

        @Override
        public void tune(Uri channelUri, Bundle params) throws RemoteException {
        }

        @Override
        public void setCaptionEnabled(boolean enabled) throws RemoteException {
        }

        @Override
        public void selectTrack(int type, String trackId) throws RemoteException {
        }

        @Override
        public void appPrivateCommand(String action, Bundle data) throws RemoteException {
        }

        @Override
        public void createOverlayView(IBinder windowToken, Rect frame) throws RemoteException {
        }

        @Override
        public void relayoutOverlayView(Rect frame) throws RemoteException {
        }

        @Override
        public void removeOverlayView() throws RemoteException {
        }

        @Override
        public void unblockContent(String unblockedRating) throws RemoteException {
        }

        @Override
        public void timeShiftPlay(Uri recordedProgramUri) throws RemoteException {
        }

        @Override
        public void timeShiftPause() throws RemoteException {
        }

        @Override
        public void timeShiftResume() throws RemoteException {
        }

        @Override
        public void timeShiftSeekTo(long timeMs) throws RemoteException {
        }

        @Override
        public void timeShiftSetPlaybackParams(PlaybackParams params) throws RemoteException {
        }

        @Override
        public void timeShiftEnablePositionTracking(boolean enable) throws RemoteException {
        }

        @Override
        public void startRecording(Uri programUri) throws RemoteException {
        }

        @Override
        public void stopRecording() throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

