/*
 * Decompiled with CFR 0.152.
 */
package android.mtp;

import android.content.BroadcastReceiver;
import android.content.ContentProviderClient;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.mtp.MtpPropertyGroup;
import android.mtp.MtpPropertyList;
import android.mtp.MtpServer;
import android.mtp.MtpStorage;
import android.mtp.MtpStorageManager;
import android.net.Uri;
import android.os.RemoteException;
import android.os.SystemProperties;
import android.os.storage.StorageVolume;
import android.provider.MediaStore;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.util.Log;
import android.util.SparseArray;
import android.view.Display;
import android.view.WindowManager;
import com.android.internal.annotations.VisibleForNative;
import com.google.android.collect.Sets;
import dalvik.system.CloseGuard;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.IntStream;

public class MtpDatabase
implements AutoCloseable {
    private static final String TAG = MtpDatabase.class.getSimpleName();
    private final Context mContext;
    private final ContentProviderClient mMediaProvider;
    private final AtomicBoolean mClosed = new AtomicBoolean();
    private final CloseGuard mCloseGuard = CloseGuard.get();
    private final HashMap<String, MtpStorage> mStorageMap = new HashMap();
    private final SparseArray<MtpPropertyGroup> mPropertyGroupsByProperty = new SparseArray();
    private final SparseArray<MtpPropertyGroup> mPropertyGroupsByFormat = new SparseArray();
    private SharedPreferences mDeviceProperties;
    private int mBatteryLevel;
    private int mBatteryScale;
    private int mDeviceType;
    private MtpServer mServer;
    private MtpStorageManager mManager;
    private static final String PATH_WHERE = "_data=?";
    private static final String[] ID_PROJECTION = new String[]{"_id"};
    private static final String[] PATH_PROJECTION = new String[]{"_data"};
    private static final String NO_MEDIA = ".nomedia";
    private static final int[] PLAYBACK_FORMATS;
    private static final int[] FILE_PROPERTIES;
    private static final int[] AUDIO_PROPERTIES;
    private static final int[] VIDEO_PROPERTIES;
    private static final int[] IMAGE_PROPERTIES;
    private static final int[] DEVICE_PROPERTIES;
    private BroadcastReceiver mBatteryReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (action.equals("android.intent.action.BATTERY_CHANGED")) {
                MtpDatabase.this.mBatteryScale = intent.getIntExtra("scale", 0);
                int newLevel = intent.getIntExtra("level", 0);
                if (newLevel != MtpDatabase.this.mBatteryLevel) {
                    MtpDatabase.this.mBatteryLevel = newLevel;
                    if (MtpDatabase.this.mServer != null) {
                        MtpDatabase.this.mServer.sendDevicePropertyChanged(20481);
                    }
                }
            }
        }
    };
    @VisibleForNative
    private long mNativeContext;

    @VisibleForNative
    private int[] getSupportedObjectProperties(int format) {
        switch (format) {
            case 12296: 
            case 12297: 
            case 47361: 
            case 47362: 
            case 47363: {
                return IntStream.concat(Arrays.stream(FILE_PROPERTIES), Arrays.stream(AUDIO_PROPERTIES)).toArray();
            }
            case 12299: 
            case 47489: 
            case 47492: {
                return IntStream.concat(Arrays.stream(FILE_PROPERTIES), Arrays.stream(VIDEO_PROPERTIES)).toArray();
            }
            case 14337: 
            case 14340: 
            case 14343: 
            case 14347: 
            case 14353: 
            case 14354: {
                return IntStream.concat(Arrays.stream(FILE_PROPERTIES), Arrays.stream(IMAGE_PROPERTIES)).toArray();
            }
        }
        return FILE_PROPERTIES;
    }

    public static Uri getObjectPropertiesUri(int format, String volumeName) {
        switch (format) {
            case 12296: 
            case 12297: 
            case 47361: 
            case 47362: 
            case 47363: {
                return MediaStore.Audio.Media.getContentUri(volumeName);
            }
            case 12299: 
            case 47489: 
            case 47492: {
                return MediaStore.Video.Media.getContentUri(volumeName);
            }
            case 14337: 
            case 14340: 
            case 14343: 
            case 14347: 
            case 14353: 
            case 14354: {
                return MediaStore.Images.Media.getContentUri(volumeName);
            }
        }
        return MediaStore.Files.getContentUri(volumeName);
    }

    @VisibleForNative
    private int[] getSupportedDeviceProperties() {
        return DEVICE_PROPERTIES;
    }

    @VisibleForNative
    private int[] getSupportedPlaybackFormats() {
        return PLAYBACK_FORMATS;
    }

    @VisibleForNative
    private int[] getSupportedCaptureFormats() {
        return null;
    }

    public MtpDatabase(Context context, String[] subDirectories) {
        this.native_setup();
        this.mContext = Objects.requireNonNull(context);
        this.mMediaProvider = context.getContentResolver().acquireContentProviderClient("media");
        this.mManager = new MtpStorageManager(new MtpStorageManager.MtpNotifier(){

            @Override
            public void sendObjectAdded(int id2) {
                if (MtpDatabase.this.mServer != null) {
                    MtpDatabase.this.mServer.sendObjectAdded(id2);
                }
            }

            @Override
            public void sendObjectRemoved(int id2) {
                if (MtpDatabase.this.mServer != null) {
                    MtpDatabase.this.mServer.sendObjectRemoved(id2);
                }
            }

            @Override
            public void sendObjectInfoChanged(int id2) {
                if (MtpDatabase.this.mServer != null) {
                    MtpDatabase.this.mServer.sendObjectInfoChanged(id2);
                }
            }
        }, subDirectories == null ? null : Sets.newHashSet(subDirectories));
        this.initDeviceProperties(context);
        this.mDeviceType = SystemProperties.getInt("sys.usb.mtp.device_type", 0);
        this.mCloseGuard.open("close");
    }

    public void setServer(MtpServer server) {
        this.mServer = server;
        try {
            this.mContext.unregisterReceiver(this.mBatteryReceiver);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (server != null) {
            this.mContext.registerReceiver(this.mBatteryReceiver, new IntentFilter("android.intent.action.BATTERY_CHANGED"));
        }
    }

    public Context getContext() {
        return this.mContext;
    }

    @Override
    public void close() {
        this.mManager.close();
        this.mCloseGuard.close();
        if (this.mClosed.compareAndSet(false, true)) {
            if (this.mMediaProvider != null) {
                this.mMediaProvider.close();
            }
            this.native_finalize();
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mCloseGuard != null) {
                this.mCloseGuard.warnIfOpen();
            }
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    public void addStorage(StorageVolume storage) {
        MtpStorage mtpStorage = this.mManager.addMtpStorage(storage);
        this.mStorageMap.put(storage.getPath(), mtpStorage);
        if (this.mServer != null) {
            this.mServer.addStorage(mtpStorage);
        }
    }

    public void removeStorage(StorageVolume storage) {
        MtpStorage mtpStorage = this.mStorageMap.get(storage.getPath());
        if (mtpStorage == null) {
            return;
        }
        if (this.mServer != null) {
            this.mServer.removeStorage(mtpStorage);
        }
        this.mManager.removeMtpStorage(mtpStorage);
        this.mStorageMap.remove(storage.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDeviceProperties(Context context) {
        String devicePropertiesName = "device-properties";
        this.mDeviceProperties = context.getSharedPreferences("device-properties", 0);
        File databaseFile = context.getDatabasePath("device-properties");
        if (databaseFile.exists()) {
            SQLiteDatabase db = null;
            Cursor c = null;
            try {
                db = context.openOrCreateDatabase("device-properties", 0, null);
                if (db != null && (c = db.query("properties", new String[]{"_id", "code", "value"}, null, null, null, null, null)) != null) {
                    SharedPreferences.Editor e = this.mDeviceProperties.edit();
                    while (c.moveToNext()) {
                        String name = c.getString(1);
                        String value = c.getString(2);
                        e.putString(name, value);
                    }
                    e.commit();
                }
            }
            catch (Exception e) {
                Log.e(TAG, "failed to migrate device properties", e);
            }
            finally {
                if (c != null) {
                    c.close();
                }
                if (db != null) {
                    db.close();
                }
            }
            context.deleteDatabase("device-properties");
        }
    }

    @VisibleForNative
    private int beginSendObject(String path, int format, int parent, int storageId) {
        MtpStorageManager.MtpObject parentObj;
        MtpStorageManager.MtpObject mtpObject = parentObj = parent == 0 ? this.mManager.getStorageRoot(storageId) : this.mManager.getObject(parent);
        if (parentObj == null) {
            return -1;
        }
        Path objPath = Paths.get(path, new String[0]);
        return this.mManager.beginSendObject(parentObj, objPath.getFileName().toString(), format);
    }

    @VisibleForNative
    private void endSendObject(int handle, boolean succeeded) {
        MtpStorageManager.MtpObject obj = this.mManager.getObject(handle);
        if (obj == null || !this.mManager.endSendObject(obj, succeeded)) {
            Log.e(TAG, "Failed to successfully end send object");
            return;
        }
        if (succeeded) {
            MediaStore.scanFile(this.mContext, obj.getPath().toFile());
        }
    }

    @VisibleForNative
    private void rescanFile(String path, int handle, int format) {
        MediaStore.scanFile(this.mContext, new File(path));
    }

    @VisibleForNative
    private int[] getObjectList(int storageID, int format, int parent) {
        List<MtpStorageManager.MtpObject> objs = this.mManager.getObjects(parent, format, storageID);
        if (objs == null) {
            return null;
        }
        int[] ret = new int[objs.size()];
        for (int i = 0; i < objs.size(); ++i) {
            ret[i] = objs.get(i).getId();
        }
        return ret;
    }

    @VisibleForNative
    private int getNumObjects(int storageID, int format, int parent) {
        List<MtpStorageManager.MtpObject> objs = this.mManager.getObjects(parent, format, storageID);
        if (objs == null) {
            return -1;
        }
        return objs.size();
    }

    @VisibleForNative
    private MtpPropertyList getObjectPropertyList(int handle, int format, int property, int groupCode, int depth) {
        if (property == 0) {
            if (groupCode == 0) {
                return new MtpPropertyList(8198);
            }
            return new MtpPropertyList(43015);
        }
        if (depth == -1 && (handle == 0 || handle == -1)) {
            handle = -1;
            depth = 0;
        }
        if (depth != 0 && depth != 1) {
            return new MtpPropertyList(43016);
        }
        List<MtpStorageManager.MtpObject> objs = null;
        MtpStorageManager.MtpObject thisObj = null;
        if (handle == -1) {
            objs = this.mManager.getObjects(0, format, -1);
            if (objs == null) {
                return new MtpPropertyList(8201);
            }
        } else if (handle != 0) {
            MtpStorageManager.MtpObject obj = this.mManager.getObject(handle);
            if (obj == null) {
                return new MtpPropertyList(8201);
            }
            if (obj.getFormat() == format || format == 0) {
                thisObj = obj;
            }
        }
        if (handle == 0 || depth == 1) {
            if (handle == 0) {
                handle = -1;
            }
            if ((objs = this.mManager.getObjects(handle, format, -1)) == null) {
                return new MtpPropertyList(8201);
            }
        }
        if (objs == null) {
            objs = new ArrayList<MtpStorageManager.MtpObject>();
        }
        if (thisObj != null) {
            objs.add(thisObj);
        }
        MtpPropertyList ret = new MtpPropertyList(8193);
        for (MtpStorageManager.MtpObject obj : objs) {
            int err;
            MtpPropertyGroup propertyGroup;
            if (property == -1) {
                if (format == 0 && handle != 0 && handle != -1) {
                    format = obj.getFormat();
                }
                if ((propertyGroup = this.mPropertyGroupsByFormat.get(format)) == null) {
                    int[] propertyList = this.getSupportedObjectProperties(format);
                    propertyGroup = new MtpPropertyGroup(propertyList);
                    this.mPropertyGroupsByFormat.put(format, propertyGroup);
                }
            } else {
                propertyGroup = this.mPropertyGroupsByProperty.get(property);
                if (propertyGroup == null) {
                    int[] propertyList = new int[]{property};
                    propertyGroup = new MtpPropertyGroup(propertyList);
                    this.mPropertyGroupsByProperty.put(property, propertyGroup);
                }
            }
            if ((err = propertyGroup.getPropertyList(this.mMediaProvider, obj.getVolumeName(), obj, ret)) == 8193) continue;
            return new MtpPropertyList(err);
        }
        return ret;
    }

    private int renameFile(int handle, String newName) {
        MtpStorageManager.MtpObject obj = this.mManager.getObject(handle);
        if (obj == null) {
            return 8201;
        }
        Path oldPath = obj.getPath();
        if (!this.mManager.beginRenameObject(obj, newName)) {
            return 8194;
        }
        Path newPath = obj.getPath();
        boolean success = oldPath.toFile().renameTo(newPath.toFile());
        try {
            Os.access(oldPath.toString(), OsConstants.F_OK);
            Os.access(newPath.toString(), OsConstants.F_OK);
        }
        catch (ErrnoException errnoException) {
            // empty catch block
        }
        if (!this.mManager.endRenameObject(obj, oldPath.getFileName().toString(), success)) {
            Log.e(TAG, "Failed to end rename object");
        }
        if (!success) {
            return 8194;
        }
        ContentValues values = new ContentValues();
        values.put("_data", newPath.toString());
        String[] whereArgs = new String[]{oldPath.toString()};
        try {
            Uri objectsUri = MediaStore.Files.getMtpObjectsUri(obj.getVolumeName());
            this.mMediaProvider.update(objectsUri, values, PATH_WHERE, whereArgs);
        }
        catch (RemoteException e) {
            Log.e(TAG, "RemoteException in mMediaProvider.update", e);
        }
        if (obj.isDir()) {
            if (oldPath.getFileName().startsWith(".") && !newPath.startsWith(".")) {
                MediaStore.scanFile(this.mContext, newPath.toFile());
            }
        } else if (oldPath.getFileName().toString().toLowerCase(Locale.US).equals(NO_MEDIA) && !newPath.getFileName().toString().toLowerCase(Locale.US).equals(NO_MEDIA)) {
            MediaStore.scanFile(this.mContext, newPath.getParent().toFile());
        }
        return 8193;
    }

    @VisibleForNative
    private int beginMoveObject(int handle, int newParent, int newStorage) {
        MtpStorageManager.MtpObject parent;
        MtpStorageManager.MtpObject obj = this.mManager.getObject(handle);
        MtpStorageManager.MtpObject mtpObject = parent = newParent == 0 ? this.mManager.getStorageRoot(newStorage) : this.mManager.getObject(newParent);
        if (obj == null || parent == null) {
            return 8201;
        }
        boolean allowed = this.mManager.beginMoveObject(obj, parent);
        return allowed ? 8193 : 8194;
    }

    @VisibleForNative
    private void endMoveObject(int oldParent, int newParent, int oldStorage, int newStorage, int objId, boolean success) {
        MtpStorageManager.MtpObject oldParentObj = oldParent == 0 ? this.mManager.getStorageRoot(oldStorage) : this.mManager.getObject(oldParent);
        MtpStorageManager.MtpObject newParentObj = newParent == 0 ? this.mManager.getStorageRoot(newStorage) : this.mManager.getObject(newParent);
        MtpStorageManager.MtpObject obj = this.mManager.getObject(objId);
        String name = obj.getName();
        if (newParentObj == null || oldParentObj == null || !this.mManager.endMoveObject(oldParentObj, newParentObj, name, success)) {
            Log.e(TAG, "Failed to end move object");
            return;
        }
        obj = this.mManager.getObject(objId);
        if (!success || obj == null) {
            return;
        }
        ContentValues values = new ContentValues();
        Path path = newParentObj.getPath().resolve(name);
        Path oldPath = oldParentObj.getPath().resolve(name);
        values.put("_data", path.toString());
        if (obj.getParent().isRoot()) {
            values.put("parent", 0);
        } else {
            int parentId = this.findInMedia(newParentObj, path.getParent());
            if (parentId != -1) {
                values.put("parent", parentId);
            } else {
                this.deleteFromMedia(obj, oldPath, obj.isDir());
                return;
            }
        }
        Object c = null;
        String[] whereArgs = new String[]{oldPath.toString()};
        try {
            int parentId = -1;
            if (!oldParentObj.isRoot()) {
                parentId = this.findInMedia(oldParentObj, oldPath.getParent());
            }
            if (oldParentObj.isRoot() || parentId != -1) {
                Uri objectsUri = MediaStore.Files.getMtpObjectsUri(obj.getVolumeName());
                this.mMediaProvider.update(objectsUri, values, PATH_WHERE, whereArgs);
            } else {
                MediaStore.scanFile(this.mContext, path.toFile());
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "RemoteException in mMediaProvider.update", e);
        }
    }

    @VisibleForNative
    private int beginCopyObject(int handle, int newParent, int newStorage) {
        MtpStorageManager.MtpObject parent;
        MtpStorageManager.MtpObject obj = this.mManager.getObject(handle);
        MtpStorageManager.MtpObject mtpObject = parent = newParent == 0 ? this.mManager.getStorageRoot(newStorage) : this.mManager.getObject(newParent);
        if (obj == null || parent == null) {
            return 8201;
        }
        return this.mManager.beginCopyObject(obj, parent);
    }

    @VisibleForNative
    private void endCopyObject(int handle, boolean success) {
        MtpStorageManager.MtpObject obj = this.mManager.getObject(handle);
        if (obj == null || !this.mManager.endCopyObject(obj, success)) {
            Log.e(TAG, "Failed to end copy object");
            return;
        }
        if (!success) {
            return;
        }
        MediaStore.scanFile(this.mContext, obj.getPath().toFile());
    }

    @VisibleForNative
    private int setObjectProperty(int handle, int property, long intValue, String stringValue) {
        switch (property) {
            case 56327: {
                return this.renameFile(handle, stringValue);
            }
        }
        return 43018;
    }

    @VisibleForNative
    private int getDeviceProperty(int property, long[] outIntValue, char[] outStringValue) {
        switch (property) {
            case 54273: 
            case 54274: {
                String value = this.mDeviceProperties.getString(Integer.toString(property), "");
                int length = value.length();
                if (length > 255) {
                    length = 255;
                }
                value.getChars(0, length, outStringValue, 0);
                outStringValue[length] = '\u0000';
                return 8193;
            }
            case 20483: {
                Display display = ((WindowManager)this.mContext.getSystemService("window")).getDefaultDisplay();
                int width = display.getMaximumSizeDimension();
                int height = display.getMaximumSizeDimension();
                String imageSize = Integer.toString(width) + "x" + Integer.toString(height);
                imageSize.getChars(0, imageSize.length(), outStringValue, 0);
                outStringValue[imageSize.length()] = '\u0000';
                return 8193;
            }
            case 54279: {
                outIntValue[0] = this.mDeviceType;
                return 8193;
            }
            case 20481: {
                outIntValue[0] = this.mBatteryLevel;
                outIntValue[1] = this.mBatteryScale;
                return 8193;
            }
        }
        return 8202;
    }

    @VisibleForNative
    private int setDeviceProperty(int property, long intValue, String stringValue) {
        switch (property) {
            case 54273: 
            case 54274: {
                SharedPreferences.Editor e = this.mDeviceProperties.edit();
                e.putString(Integer.toString(property), stringValue);
                return e.commit() ? 8193 : 8194;
            }
        }
        return 8202;
    }

    @VisibleForNative
    private boolean getObjectInfo(int handle, int[] outStorageFormatParent, char[] outName, long[] outCreatedModified) {
        MtpStorageManager.MtpObject obj = this.mManager.getObject(handle);
        if (obj == null) {
            return false;
        }
        outStorageFormatParent[0] = obj.getStorageId();
        outStorageFormatParent[1] = obj.getFormat();
        outStorageFormatParent[2] = obj.getParent().isRoot() ? 0 : obj.getParent().getId();
        int nameLen = Integer.min(obj.getName().length(), 255);
        obj.getName().getChars(0, nameLen, outName, 0);
        outName[nameLen] = '\u0000';
        outCreatedModified[0] = obj.getModifiedTime();
        outCreatedModified[1] = obj.getModifiedTime();
        return true;
    }

    @VisibleForNative
    private int getObjectFilePath(int handle, char[] outFilePath, long[] outFileLengthFormat) {
        MtpStorageManager.MtpObject obj = this.mManager.getObject(handle);
        if (obj == null) {
            return 8201;
        }
        String path = obj.getPath().toString();
        int pathLen = Integer.min(path.length(), 4096);
        path.getChars(0, pathLen, outFilePath, 0);
        outFilePath[pathLen] = '\u0000';
        outFileLengthFormat[0] = obj.getSize();
        outFileLengthFormat[1] = obj.getFormat();
        return 8193;
    }

    private int getObjectFormat(int handle) {
        MtpStorageManager.MtpObject obj = this.mManager.getObject(handle);
        if (obj == null) {
            return -1;
        }
        return obj.getFormat();
    }

    @VisibleForNative
    private int beginDeleteObject(int handle) {
        MtpStorageManager.MtpObject obj = this.mManager.getObject(handle);
        if (obj == null) {
            return 8201;
        }
        if (!this.mManager.beginRemoveObject(obj)) {
            return 8194;
        }
        return 8193;
    }

    @VisibleForNative
    private void endDeleteObject(int handle, boolean success) {
        MtpStorageManager.MtpObject obj = this.mManager.getObject(handle);
        if (obj == null) {
            return;
        }
        if (!this.mManager.endRemoveObject(obj, success)) {
            Log.e(TAG, "Failed to end remove object");
        }
        if (success) {
            this.deleteFromMedia(obj, obj.getPath(), obj.isDir());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int findInMedia(MtpStorageManager.MtpObject obj, Path path) {
        Uri objectsUri = MediaStore.Files.getMtpObjectsUri(obj.getVolumeName());
        int ret = -1;
        try (Cursor c = null;){
            c = this.mMediaProvider.query(objectsUri, ID_PROJECTION, PATH_WHERE, new String[]{path.toString()}, null, null);
            if (c != null && c.moveToNext()) {
                ret = c.getInt(0);
            }
        }
        return ret;
    }

    private void deleteFromMedia(MtpStorageManager.MtpObject obj, Path path, boolean isDir) {
        Uri objectsUri = MediaStore.Files.getMtpObjectsUri(obj.getVolumeName());
        try {
            String[] whereArgs;
            if (isDir) {
                this.mMediaProvider.delete(objectsUri, "_data LIKE ?1 AND lower(substr(_data,1,?2))=lower(?3)", new String[]{path + "/%", Integer.toString(path.toString().length() + 1), path.toString() + "/"});
            }
            if (this.mMediaProvider.delete(objectsUri, PATH_WHERE, whereArgs = new String[]{path.toString()}) > 0) {
                if (!isDir && path.toString().toLowerCase(Locale.US).endsWith(NO_MEDIA)) {
                    MediaStore.scanFile(this.mContext, path.getParent().toFile());
                }
            } else {
                Log.i(TAG, "Mediaprovider didn't delete " + path);
            }
        }
        catch (Exception e) {
            Log.d(TAG, "Failed to delete " + path + " from MediaProvider");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForNative
    private int[] getObjectReferences(int handle) {
        MtpStorageManager.MtpObject obj = this.mManager.getObject(handle);
        if (obj == null) {
            return null;
        }
        handle = this.findInMedia(obj, obj.getPath());
        if (handle == -1) {
            return null;
        }
        Uri uri = MediaStore.Files.getMtpReferencesUri(obj.getVolumeName(), handle);
        try (Cursor c = null;){
            c = this.mMediaProvider.query(uri, PATH_PROJECTION, null, null, null, null);
            if (c == null) {
                int[] nArray = null;
                return nArray;
            }
            ArrayList<Integer> result = new ArrayList<Integer>();
            while (c.moveToNext()) {
                String refPath = c.getString(0);
                MtpStorageManager.MtpObject refObj = this.mManager.getByPath(refPath);
                if (refObj == null) continue;
                result.add(refObj.getId());
            }
            int[] nArray = result.stream().mapToInt(Integer::intValue).toArray();
            return nArray;
        }
        return null;
    }

    @VisibleForNative
    private int setObjectReferences(int handle, int[] references) {
        MtpStorageManager.MtpObject obj = this.mManager.getObject(handle);
        if (obj == null) {
            return 8201;
        }
        handle = this.findInMedia(obj, obj.getPath());
        if (handle == -1) {
            return 8194;
        }
        Uri uri = MediaStore.Files.getMtpReferencesUri(obj.getVolumeName(), handle);
        ArrayList<ContentValues> valuesList = new ArrayList<ContentValues>();
        for (int id2 : references) {
            int refHandle;
            MtpStorageManager.MtpObject refObj = this.mManager.getObject(id2);
            if (refObj == null || (refHandle = this.findInMedia(refObj, refObj.getPath())) == -1) continue;
            ContentValues values = new ContentValues();
            values.put("_id", refHandle);
            valuesList.add(values);
        }
        try {
            if (this.mMediaProvider.bulkInsert(uri, valuesList.toArray(new ContentValues[0])) > 0) {
                return 8193;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "RemoteException in setObjectReferences", e);
        }
        return 8194;
    }

    private final native void native_setup();

    private final native void native_finalize();

    static {
        System.loadLibrary("media_jni");
        PLAYBACK_FORMATS = new int[]{12288, 12289, 12292, 12293, 12296, 12297, 12299, 14337, 14338, 14340, 14343, 14344, 14347, 14349, 47361, 47362, 47363, 47490, 47491, 47492, 47621, 47632, 47633, 47636, 47746, 47366, 14353, 14354};
        FILE_PROPERTIES = new int[]{56321, 56322, 56323, 56324, 56327, 56329, 56385, 56331, 56388, 56544, 56398};
        AUDIO_PROPERTIES = new int[]{56390, 56474, 56475, 56459, 56473, 56457, 56470, 56985, 56978, 56986, 56980, 56979};
        VIDEO_PROPERTIES = new int[]{56390, 56474, 56457, 56392};
        IMAGE_PROPERTIES = new int[]{56392};
        DEVICE_PROPERTIES = new int[]{54273, 54274, 20483, 20481, 54279};
    }
}

