/*
 * Decompiled with CFR 0.152.
 */
package android.mtp;

import android.content.ContentProviderClient;
import android.database.Cursor;
import android.mtp.MtpDatabase;
import android.mtp.MtpPropertyList;
import android.mtp.MtpStorageManager;
import android.net.Uri;
import android.os.RemoteException;
import android.util.Log;
import java.util.ArrayList;

class MtpPropertyGroup {
    private static final String TAG = MtpPropertyGroup.class.getSimpleName();
    private final Property[] mProperties;
    private String[] mColumns;
    private static final String PATH_WHERE = "_data=?";

    public MtpPropertyGroup(int[] properties) {
        int i;
        int count = properties.length;
        ArrayList<String> columns = new ArrayList<String>(count);
        columns.add("_id");
        this.mProperties = new Property[count];
        for (i = 0; i < count; ++i) {
            this.mProperties[i] = this.createProperty(properties[i], columns);
        }
        count = columns.size();
        this.mColumns = new String[count];
        for (i = 0; i < count; ++i) {
            this.mColumns[i] = columns.get(i);
        }
    }

    private Property createProperty(int code, ArrayList<String> columns) {
        int type;
        String column = null;
        switch (code) {
            case 56321: {
                type = 6;
                break;
            }
            case 56322: {
                type = 4;
                break;
            }
            case 56323: {
                type = 4;
                break;
            }
            case 56324: {
                type = 8;
                break;
            }
            case 56327: {
                type = 65535;
                break;
            }
            case 56388: {
                type = 65535;
                break;
            }
            case 56329: {
                type = 65535;
                break;
            }
            case 56398: {
                type = 65535;
                break;
            }
            case 56473: {
                column = "year";
                type = 65535;
                break;
            }
            case 56331: {
                type = 6;
                break;
            }
            case 56385: {
                type = 10;
                break;
            }
            case 56457: {
                column = "duration";
                type = 6;
                break;
            }
            case 56459: {
                column = "track";
                type = 4;
                break;
            }
            case 56544: {
                type = 65535;
                break;
            }
            case 56390: {
                type = 65535;
                break;
            }
            case 56474: {
                type = 65535;
                break;
            }
            case 56475: {
                column = "album_artist";
                type = 65535;
                break;
            }
            case 56470: {
                column = "composer";
                type = 65535;
                break;
            }
            case 56392: {
                column = "description";
                type = 65535;
                break;
            }
            case 56979: 
            case 56985: 
            case 56986: {
                type = 6;
                break;
            }
            case 56978: 
            case 56980: {
                type = 4;
                break;
            }
            default: {
                type = 0;
                Log.e(TAG, "unsupported property " + code);
            }
        }
        if (column != null) {
            columns.add(column);
            return new Property(code, type, columns.size() - 1);
        }
        return new Property(code, type, -1);
    }

    public int getPropertyList(ContentProviderClient provider, String volumeName, MtpStorageManager.MtpObject object, MtpPropertyList list) {
        Cursor c = null;
        int id2 = object.getId();
        String path = object.getPath().toString();
        block21: for (Property property : this.mProperties) {
            if (property.column != -1 && c == null) {
                try {
                    Uri uri = MtpDatabase.getObjectPropertiesUri(object.getFormat(), volumeName);
                    c = provider.query(uri, this.mColumns, PATH_WHERE, new String[]{path}, null, null);
                    if (c != null && !c.moveToNext()) {
                        c.close();
                        c = null;
                    }
                }
                catch (IllegalArgumentException e) {
                    return 43009;
                }
                catch (RemoteException e) {
                    Log.e(TAG, "Mediaprovider lookup failed");
                }
            }
            switch (property.code) {
                case 56323: {
                    list.append(id2, property.code, property.type, 0L);
                    continue block21;
                }
                case 56327: 
                case 56388: 
                case 56544: {
                    list.append(id2, property.code, object.getName());
                    continue block21;
                }
                case 56329: 
                case 56398: {
                    list.append(id2, property.code, this.format_date_time(object.getModifiedTime()));
                    continue block21;
                }
                case 56321: {
                    list.append(id2, property.code, property.type, object.getStorageId());
                    continue block21;
                }
                case 56322: {
                    list.append(id2, property.code, property.type, object.getFormat());
                    continue block21;
                }
                case 56324: {
                    list.append(id2, property.code, property.type, object.getSize());
                    continue block21;
                }
                case 56331: {
                    list.append(id2, property.code, property.type, object.getParent().isRoot() ? 0L : (long)object.getParent().getId());
                    continue block21;
                }
                case 56385: {
                    long puid = (long)(object.getPath().toString().hashCode() << 32) + object.getModifiedTime();
                    list.append(id2, property.code, property.type, puid);
                    continue block21;
                }
                case 56473: {
                    int year = 0;
                    if (c != null) {
                        year = c.getInt(property.column);
                    }
                    String dateTime = Integer.toString(year) + "0101T000000";
                    list.append(id2, property.code, dateTime);
                    continue block21;
                }
                case 56459: {
                    int track = 0;
                    if (c != null) {
                        track = c.getInt(property.column);
                    }
                    list.append(id2, property.code, 4, track % 1000);
                    continue block21;
                }
                case 56979: 
                case 56985: 
                case 56986: {
                    list.append(id2, property.code, 6, 0L);
                    continue block21;
                }
                case 56978: 
                case 56980: {
                    list.append(id2, property.code, 4, 0L);
                    continue block21;
                }
                default: {
                    switch (property.type) {
                        case 0: {
                            list.append(id2, property.code, property.type, 0L);
                            continue block21;
                        }
                        case 65535: {
                            String value = "";
                            if (c != null) {
                                value = c.getString(property.column);
                            }
                            list.append(id2, property.code, value);
                            continue block21;
                        }
                    }
                    long longValue = 0L;
                    if (c != null) {
                        longValue = c.getLong(property.column);
                    }
                    list.append(id2, property.code, property.type, longValue);
                }
            }
        }
        if (c != null) {
            c.close();
        }
        return 8193;
    }

    private native String format_date_time(long var1);

    private class Property {
        int code;
        int type;
        int column;

        Property(int code, int type, int column) {
            this.code = code;
            this.type = type;
            this.column = column;
        }
    }
}

