/*
 * Decompiled with CFR 0.152.
 */
package android.mtp;

import android.content.Context;
import android.content.SharedPreferences;
import android.mtp.MtpDatabase;
import android.mtp.MtpStorage;
import android.util.ByteStringUtils;
import com.android.internal.util.Preconditions;
import java.io.FileDescriptor;
import java.util.Random;

public class MtpServer
implements Runnable {
    private long mNativeContext;
    private final MtpDatabase mDatabase;
    private final Runnable mOnTerminate;
    private final Context mContext;
    private static final int sID_LEN_BYTES = 16;
    private static final int sID_LEN_STR = 32;

    public MtpServer(MtpDatabase database, FileDescriptor controlFd, boolean usePtp, Runnable onTerminate, String deviceInfoManufacturer, String deviceInfoModel, String deviceInfoDeviceVersion) {
        this.mDatabase = Preconditions.checkNotNull(database);
        this.mOnTerminate = Preconditions.checkNotNull(onTerminate);
        this.mContext = this.mDatabase.getContext();
        String strID_PREFS_NAME = "mtp-cfg";
        String strID_PREFS_KEY = "mtp-id";
        String strRandomId = null;
        SharedPreferences sharedPref = this.mContext.getSharedPreferences("mtp-cfg", 0);
        if (sharedPref.contains("mtp-id")) {
            strRandomId = sharedPref.getString("mtp-id", null);
            if (strRandomId.length() != 32) {
                strRandomId = null;
            } else {
                for (int ii = 0; ii < strRandomId.length(); ++ii) {
                    if (Character.digit(strRandomId.charAt(ii), 16) != -1) continue;
                    strRandomId = null;
                    break;
                }
            }
        }
        if (strRandomId == null) {
            strRandomId = this.getRandId();
            sharedPref.edit().putString("mtp-id", strRandomId).apply();
        }
        String deviceInfoSerialNumber = strRandomId;
        this.native_setup(database, controlFd, usePtp, deviceInfoManufacturer, deviceInfoModel, deviceInfoDeviceVersion, deviceInfoSerialNumber);
        database.setServer(this);
    }

    private String getRandId() {
        Random randomVal = new Random();
        byte[] randomBytes = new byte[16];
        randomVal.nextBytes(randomBytes);
        return ByteStringUtils.toHexString(randomBytes);
    }

    public void start() {
        Thread thread = new Thread((Runnable)this, "MtpServer");
        thread.start();
    }

    @Override
    public void run() {
        this.native_run();
        this.native_cleanup();
        this.mDatabase.close();
        this.mOnTerminate.run();
    }

    public void sendObjectAdded(int handle) {
        this.native_send_object_added(handle);
    }

    public void sendObjectRemoved(int handle) {
        this.native_send_object_removed(handle);
    }

    public void sendObjectInfoChanged(int handle) {
        this.native_send_object_info_changed(handle);
    }

    public void sendDevicePropertyChanged(int property) {
        this.native_send_device_property_changed(property);
    }

    public void addStorage(MtpStorage storage) {
        this.native_add_storage(storage);
    }

    public void removeStorage(MtpStorage storage) {
        this.native_remove_storage(storage.getStorageId());
    }

    public static void configure(boolean usePtp) {
        MtpServer.native_configure(usePtp);
    }

    public static final native void native_configure(boolean var0);

    private final native void native_setup(MtpDatabase var1, FileDescriptor var2, boolean var3, String var4, String var5, String var6, String var7);

    private final native void native_run();

    private final native void native_cleanup();

    private final native void native_send_object_added(int var1);

    private final native void native_send_object_removed(int var1);

    private final native void native_send_object_info_changed(int var1);

    private final native void native_send_device_property_changed(int var1);

    private final native void native_add_storage(MtpStorage var1);

    private final native void native_remove_storage(int var1);

    static {
        System.loadLibrary("media_jni");
    }
}

