/*
 * Decompiled with CFR 0.152.
 */
package android.mtp;

import android.annotation.UnsupportedAppUsage;
import android.os.storage.StorageVolume;

public class MtpStorage {
    private final int mStorageId;
    private final String mPath;
    private final String mDescription;
    private final boolean mRemovable;
    private final long mMaxFileSize;
    private final String mVolumeName;

    public MtpStorage(StorageVolume volume, int storageId) {
        this.mStorageId = storageId;
        this.mPath = volume.getInternalPath();
        this.mDescription = volume.getDescription(null);
        this.mRemovable = volume.isRemovable();
        this.mMaxFileSize = volume.getMaxFileSize();
        this.mVolumeName = volume.isPrimary() ? "external_primary" : volume.getNormalizedUuid();
    }

    @UnsupportedAppUsage
    public final int getStorageId() {
        return this.mStorageId;
    }

    @UnsupportedAppUsage
    public final String getPath() {
        return this.mPath;
    }

    public final String getDescription() {
        return this.mDescription;
    }

    public final boolean isRemovable() {
        return this.mRemovable;
    }

    public long getMaxFileSize() {
        return this.mMaxFileSize;
    }

    public String getVolumeName() {
        return this.mVolumeName;
    }
}

