/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.os.Parcel;
import android.os.Parcelable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;

public final class ConnectionInfo
implements Parcelable {
    public final int protocol;
    public final InetSocketAddress local;
    public final InetSocketAddress remote;
    public static final Parcelable.Creator<ConnectionInfo> CREATOR = new Parcelable.Creator<ConnectionInfo>(){

        @Override
        public ConnectionInfo createFromParcel(Parcel in) {
            InetAddress remoteAddress;
            InetAddress localAddress;
            int protocol = in.readInt();
            try {
                localAddress = InetAddress.getByAddress(in.createByteArray());
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException("Invalid InetAddress");
            }
            int localPort = in.readInt();
            try {
                remoteAddress = InetAddress.getByAddress(in.createByteArray());
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException("Invalid InetAddress");
            }
            int remotePort = in.readInt();
            InetSocketAddress local = new InetSocketAddress(localAddress, localPort);
            InetSocketAddress remote = new InetSocketAddress(remoteAddress, remotePort);
            return new ConnectionInfo(protocol, local, remote);
        }

        public ConnectionInfo[] newArray(int size) {
            return new ConnectionInfo[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }

    public ConnectionInfo(int protocol, InetSocketAddress local, InetSocketAddress remote) {
        this.protocol = protocol;
        this.local = local;
        this.remote = remote;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(this.protocol);
        out.writeByteArray(this.local.getAddress().getAddress());
        out.writeInt(this.local.getPort());
        out.writeByteArray(this.remote.getAddress().getAddress());
        out.writeInt(this.remote.getPort());
    }
}

