/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.NetworkCapabilities;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.BitUtils;

public final class ConnectivityMetricsEvent
implements Parcelable {
    public long timestamp;
    public long transports;
    public int netId;
    public String ifname;
    public Parcelable data;
    public static final Parcelable.Creator<ConnectivityMetricsEvent> CREATOR = new Parcelable.Creator<ConnectivityMetricsEvent>(){

        @Override
        public ConnectivityMetricsEvent createFromParcel(Parcel source) {
            return new ConnectivityMetricsEvent(source);
        }

        public ConnectivityMetricsEvent[] newArray(int size) {
            return new ConnectivityMetricsEvent[size];
        }
    };

    public ConnectivityMetricsEvent() {
    }

    private ConnectivityMetricsEvent(Parcel in) {
        this.timestamp = in.readLong();
        this.transports = in.readLong();
        this.netId = in.readInt();
        this.ifname = in.readString();
        this.data = in.readParcelable(null);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.timestamp);
        dest.writeLong(this.transports);
        dest.writeInt(this.netId);
        dest.writeString(this.ifname);
        dest.writeParcelable(this.data, 0);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("ConnectivityMetricsEvent(");
        buffer.append(String.format("%tT.%tL", this.timestamp, this.timestamp));
        if (this.netId != 0) {
            buffer.append(", ").append("netId=").append(this.netId);
        }
        if (this.ifname != null) {
            buffer.append(", ").append(this.ifname);
        }
        for (int t : BitUtils.unpackBits(this.transports)) {
            buffer.append(", ").append(NetworkCapabilities.transportNameOf(t));
        }
        buffer.append("): ").append(this.data.toString());
        return buffer.toString();
    }
}

