/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.annotation.UnsupportedAppUsage;
import android.net.InetAddresses;
import android.net.LinkAddress;
import android.net.RouteInfo;
import android.net.StaticIpConfiguration;
import android.net.shared.InetAddressUtils;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class DhcpResults
implements Parcelable {
    private static final String TAG = "DhcpResults";
    @UnsupportedAppUsage
    public LinkAddress ipAddress;
    @UnsupportedAppUsage
    public InetAddress gateway;
    @UnsupportedAppUsage
    public final ArrayList<InetAddress> dnsServers = new ArrayList();
    @UnsupportedAppUsage
    public String domains;
    @UnsupportedAppUsage
    public Inet4Address serverAddress;
    @UnsupportedAppUsage
    public String vendorInfo;
    @UnsupportedAppUsage
    public int leaseDuration;
    @UnsupportedAppUsage
    public int mtu;
    public String serverHostName;
    public static final Parcelable.Creator<DhcpResults> CREATOR = new Parcelable.Creator<DhcpResults>(){

        @Override
        public DhcpResults createFromParcel(Parcel in) {
            return DhcpResults.readFromParcel(in);
        }

        public DhcpResults[] newArray(int size) {
            return new DhcpResults[size];
        }
    };

    public DhcpResults() {
    }

    public StaticIpConfiguration toStaticIpConfiguration() {
        return new StaticIpConfiguration.Builder().setIpAddress(this.ipAddress).setGateway(this.gateway).setDnsServers(this.dnsServers).setDomains(this.domains).build();
    }

    public DhcpResults(StaticIpConfiguration source) {
        if (source != null) {
            this.ipAddress = source.getIpAddress();
            this.gateway = source.getGateway();
            this.dnsServers.addAll(source.getDnsServers());
            this.domains = source.getDomains();
        }
    }

    public DhcpResults(DhcpResults source) {
        this(source == null ? null : source.toStaticIpConfiguration());
        if (source != null) {
            this.serverAddress = source.serverAddress;
            this.vendorInfo = source.vendorInfo;
            this.leaseDuration = source.leaseDuration;
            this.mtu = source.mtu;
            this.serverHostName = source.serverHostName;
        }
    }

    public List<RouteInfo> getRoutes(String iface) {
        return this.toStaticIpConfiguration().getRoutes(iface);
    }

    public boolean hasMeteredHint() {
        if (this.vendorInfo != null) {
            return this.vendorInfo.contains("ANDROID_METERED");
        }
        return false;
    }

    public void clear() {
        this.ipAddress = null;
        this.gateway = null;
        this.dnsServers.clear();
        this.domains = null;
        this.serverAddress = null;
        this.vendorInfo = null;
        this.leaseDuration = 0;
        this.mtu = 0;
        this.serverHostName = null;
    }

    public String toString() {
        StringBuffer str = new StringBuffer(super.toString());
        str.append(" DHCP server ").append(this.serverAddress);
        str.append(" Vendor info ").append(this.vendorInfo);
        str.append(" lease ").append(this.leaseDuration).append(" seconds");
        if (this.mtu != 0) {
            str.append(" MTU ").append(this.mtu);
        }
        str.append(" Servername ").append(this.serverHostName);
        return str.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DhcpResults)) {
            return false;
        }
        DhcpResults target = (DhcpResults)obj;
        return this.toStaticIpConfiguration().equals(target.toStaticIpConfiguration()) && Objects.equals(this.serverAddress, target.serverAddress) && Objects.equals(this.vendorInfo, target.vendorInfo) && Objects.equals(this.serverHostName, target.serverHostName) && this.leaseDuration == target.leaseDuration && this.mtu == target.mtu;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        this.toStaticIpConfiguration().writeToParcel(dest, flags);
        dest.writeInt(this.leaseDuration);
        dest.writeInt(this.mtu);
        InetAddressUtils.parcelInetAddress(dest, this.serverAddress, flags);
        dest.writeString(this.vendorInfo);
        dest.writeString(this.serverHostName);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    private static DhcpResults readFromParcel(Parcel in) {
        StaticIpConfiguration s = StaticIpConfiguration.CREATOR.createFromParcel(in);
        DhcpResults dhcpResults = new DhcpResults(s);
        dhcpResults.leaseDuration = in.readInt();
        dhcpResults.mtu = in.readInt();
        dhcpResults.serverAddress = (Inet4Address)InetAddressUtils.unparcelInetAddress(in);
        dhcpResults.vendorInfo = in.readString();
        dhcpResults.serverHostName = in.readString();
        return dhcpResults;
    }

    public boolean setIpAddress(String addrString, int prefixLength) {
        try {
            Inet4Address addr = (Inet4Address)InetAddresses.parseNumericAddress(addrString);
            this.ipAddress = new LinkAddress(addr, prefixLength);
        }
        catch (ClassCastException | IllegalArgumentException e) {
            Log.e(TAG, "setIpAddress failed with addrString " + addrString + "/" + prefixLength);
            return true;
        }
        return false;
    }

    public boolean setGateway(String addrString) {
        try {
            this.gateway = InetAddresses.parseNumericAddress(addrString);
        }
        catch (IllegalArgumentException e) {
            Log.e(TAG, "setGateway failed with addrString " + addrString);
            return true;
        }
        return false;
    }

    public boolean addDns(String addrString) {
        if (!TextUtils.isEmpty(addrString)) {
            try {
                this.dnsServers.add(InetAddresses.parseNumericAddress(addrString));
            }
            catch (IllegalArgumentException e) {
                Log.e(TAG, "addDns failed with addrString " + addrString);
                return true;
            }
        }
        return false;
    }

    public LinkAddress getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(LinkAddress ipAddress) {
        this.ipAddress = ipAddress;
    }

    public InetAddress getGateway() {
        return this.gateway;
    }

    public void setGateway(InetAddress gateway) {
        this.gateway = gateway;
    }

    public List<InetAddress> getDnsServers() {
        return this.dnsServers;
    }

    public void addDnsServer(InetAddress server) {
        this.dnsServers.add(server);
    }

    public String getDomains() {
        return this.domains;
    }

    public void setDomains(String domains) {
        this.domains = domains;
    }

    public Inet4Address getServerAddress() {
        return this.serverAddress;
    }

    public void setServerAddress(Inet4Address addr) {
        this.serverAddress = addr;
    }

    public int getLeaseDuration() {
        return this.leaseDuration;
    }

    public void setLeaseDuration(int duration) {
        this.leaseDuration = duration;
    }

    public String getVendorInfo() {
        return this.vendorInfo;
    }

    public void setVendorInfo(String info) {
        this.vendorInfo = info;
    }

    public int getMtu() {
        return this.mtu;
    }

    public void setMtu(int mtu) {
        this.mtu = mtu;
    }
}

