/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.ParseException;
import android.text.TextUtils;
import com.android.internal.util.BitUtils;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.util.ArrayList;
import java.util.List;

public abstract class DnsPacket {
    public static final int QDSECTION = 0;
    public static final int ANSECTION = 1;
    public static final int NSSECTION = 2;
    public static final int ARSECTION = 3;
    private static final int NUM_SECTIONS = 4;
    private static final String TAG = DnsPacket.class.getSimpleName();
    protected final DnsHeader mHeader;
    protected final List<DnsRecord>[] mRecords;

    protected DnsPacket(byte[] data) throws ParseException {
        ByteBuffer buffer;
        if (null == data) {
            throw new ParseException("Parse header failed, null input data");
        }
        try {
            buffer = ByteBuffer.wrap(data);
            this.mHeader = new DnsHeader(buffer);
        }
        catch (BufferUnderflowException e) {
            throw new ParseException("Parse Header fail, bad input data", e);
        }
        this.mRecords = new ArrayList[4];
        for (int i = 0; i < 4; ++i) {
            int count = this.mHeader.getRecordCount(i);
            if (count > 0) {
                this.mRecords[i] = new ArrayList<DnsRecord>(count);
            }
            for (int j = 0; j < count; ++j) {
                try {
                    this.mRecords[i].add(new DnsRecord(i, buffer));
                    continue;
                }
                catch (BufferUnderflowException e) {
                    throw new ParseException("Parse record fail", e);
                }
            }
        }
    }

    public class DnsRecord {
        private static final int MAXNAMESIZE = 255;
        private static final int MAXLABELSIZE = 63;
        private static final int MAXLABELCOUNT = 128;
        private static final int NAME_NORMAL = 0;
        private static final int NAME_COMPRESSION = 192;
        private final DecimalFormat byteFormat = new DecimalFormat();
        private final FieldPosition pos = new FieldPosition(0);
        private static final String TAG = "DnsRecord";
        public final String dName;
        public final int nsType;
        public final int nsClass;
        public final long ttl;
        private final byte[] mRdata;

        DnsRecord(int recordType, ByteBuffer buf) throws BufferUnderflowException, ParseException {
            this.dName = this.parseName(buf, 0);
            if (this.dName.length() > 255) {
                throw new ParseException("Parse name fail, name size is too long: " + this.dName.length());
            }
            this.nsType = BitUtils.uint16(buf.getShort());
            this.nsClass = BitUtils.uint16(buf.getShort());
            if (recordType != 0) {
                this.ttl = BitUtils.uint32(buf.getInt());
                int length = BitUtils.uint16(buf.getShort());
                this.mRdata = new byte[length];
                buf.get(this.mRdata);
            } else {
                this.ttl = 0L;
                this.mRdata = null;
            }
        }

        public byte[] getRR() {
            return this.mRdata == null ? null : (byte[])this.mRdata.clone();
        }

        private String labelToString(byte[] label) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < label.length; ++i) {
                int b = BitUtils.uint8(label[i]);
                if (b <= 32 || b >= 127) {
                    sb.append('\\');
                    this.byteFormat.format((long)b, sb, this.pos);
                    continue;
                }
                if (b == 34 || b == 46 || b == 59 || b == 92 || b == 40 || b == 41 || b == 64 || b == 36) {
                    sb.append('\\');
                    sb.append((char)b);
                    continue;
                }
                sb.append((char)b);
            }
            return sb.toString();
        }

        private String parseName(ByteBuffer buf, int depth) throws BufferUnderflowException, ParseException {
            if (depth > 128) {
                throw new ParseException("Failed to parse name, too many labels");
            }
            int len = BitUtils.uint8(buf.get());
            int mask = len & 0xC0;
            if (0 == len) {
                return "";
            }
            if (mask != 0 && mask != 192) {
                throw new ParseException("Parse name fail, bad label type");
            }
            if (mask == 192) {
                int oldPos;
                int offset = ((len & 0xFFFFFF3F) << 8) + BitUtils.uint8(buf.get());
                if (offset >= (oldPos = buf.position()) - 2) {
                    throw new ParseException("Parse compression name fail, invalid compression");
                }
                buf.position(offset);
                String pointed = this.parseName(buf, depth + 1);
                buf.position(oldPos);
                return pointed;
            }
            byte[] label = new byte[len];
            buf.get(label);
            String head = this.labelToString(label);
            if (head.length() > 63) {
                throw new ParseException("Parse name fail, invalid label length");
            }
            String tail = this.parseName(buf, depth + 1);
            return TextUtils.isEmpty(tail) ? head : head + "." + tail;
        }
    }

    public class DnsHeader {
        private static final String TAG = "DnsHeader";
        public final int id;
        public final int flags;
        public final int rcode;
        private final int[] mRecordCount;

        DnsHeader(ByteBuffer buf) throws BufferUnderflowException {
            this.id = BitUtils.uint16(buf.getShort());
            this.flags = BitUtils.uint16(buf.getShort());
            this.rcode = this.flags & 0xF;
            this.mRecordCount = new int[4];
            for (int i = 0; i < 4; ++i) {
                this.mRecordCount[i] = BitUtils.uint16(buf.getShort());
            }
        }

        public int getRecordCount(int type) {
            return this.mRecordCount[type];
        }
    }
}

