/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.DnsPacket;
import android.net.Network;
import android.net.NetworkUtils;
import android.net.ParseException;
import android.net.util.DnsUtils;
import android.os.CancellationSignal;
import android.os.Looper;
import android.os.MessageQueue;
import android.system.ErrnoException;
import android.system.OsConstants;
import android.util.Log;
import java.io.FileDescriptor;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;

public final class DnsResolver {
    private static final String TAG = "DnsResolver";
    private static final int FD_EVENTS = 5;
    private static final int MAXPACKET = 8192;
    private static final int SLEEP_TIME_MS = 2;
    public static final int CLASS_IN = 1;
    public static final int TYPE_A = 1;
    public static final int TYPE_AAAA = 28;
    public static final int FLAG_EMPTY = 0;
    public static final int FLAG_NO_RETRY = 1;
    public static final int FLAG_NO_CACHE_STORE = 2;
    public static final int FLAG_NO_CACHE_LOOKUP = 4;
    public static final int ERROR_PARSE = 0;
    public static final int ERROR_SYSTEM = 1;
    private static final int NETID_UNSET = 0;
    private static final DnsResolver sInstance = new DnsResolver();

    public static DnsResolver getInstance() {
        return sInstance;
    }

    private DnsResolver() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rawQuery(Network network, byte[] query, int flags, Executor executor, CancellationSignal cancellationSignal, Callback<? super byte[]> callback) {
        FileDescriptor queryfd;
        if (cancellationSignal != null && cancellationSignal.isCanceled()) {
            return;
        }
        Object lock = new Object();
        try {
            queryfd = NetworkUtils.resNetworkSend(network != null ? network.getNetIdForResolv() : 0, query, query.length, flags);
        }
        catch (ErrnoException e) {
            executor.execute(() -> callback.onError(new DnsException(1, (Throwable)e)));
            return;
        }
        Object object = lock;
        synchronized (object) {
            this.registerFDListener(executor, queryfd, callback, cancellationSignal, lock);
            if (cancellationSignal == null) {
                return;
            }
            this.addCancellationSignal(cancellationSignal, queryfd, lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rawQuery(Network network, String domain, int nsClass, int nsType, int flags, Executor executor, CancellationSignal cancellationSignal, Callback<? super byte[]> callback) {
        FileDescriptor queryfd;
        if (cancellationSignal != null && cancellationSignal.isCanceled()) {
            return;
        }
        Object lock = new Object();
        try {
            queryfd = NetworkUtils.resNetworkQuery(network != null ? network.getNetIdForResolv() : 0, domain, nsClass, nsType, flags);
        }
        catch (ErrnoException e) {
            executor.execute(() -> callback.onError(new DnsException(1, (Throwable)e)));
            return;
        }
        Object object = lock;
        synchronized (object) {
            this.registerFDListener(executor, queryfd, callback, cancellationSignal, lock);
            if (cancellationSignal == null) {
                return;
            }
            this.addCancellationSignal(cancellationSignal, queryfd, lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void query(Network network, String domain, int flags, Executor executor, CancellationSignal cancellationSignal, Callback<? super List<InetAddress>> callback) {
        FileDescriptor v4fd;
        FileDescriptor v6fd;
        Network queryNetwork;
        if (cancellationSignal != null && cancellationSignal.isCanceled()) {
            return;
        }
        Object lock = new Object();
        try {
            queryNetwork = network != null ? network : NetworkUtils.getDnsNetwork();
        }
        catch (ErrnoException e) {
            executor.execute(() -> callback.onError(new DnsException(1, (Throwable)e)));
            return;
        }
        boolean queryIpv6 = DnsUtils.haveIpv6(queryNetwork);
        boolean queryIpv4 = DnsUtils.haveIpv4(queryNetwork);
        if (!queryIpv6 && !queryIpv4) {
            executor.execute(() -> callback.onError(new DnsException(1, (Throwable)new ErrnoException("resNetworkQuery", OsConstants.ENONET))));
            return;
        }
        int queryCount = 0;
        if (queryIpv6) {
            try {
                v6fd = NetworkUtils.resNetworkQuery(queryNetwork.getNetIdForResolv(), domain, 1, 28, flags);
            }
            catch (ErrnoException e) {
                executor.execute(() -> callback.onError(new DnsException(1, (Throwable)e)));
                return;
            }
            ++queryCount;
        } else {
            v6fd = null;
        }
        try {
            Thread.sleep(2L);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        if (queryIpv4) {
            try {
                v4fd = NetworkUtils.resNetworkQuery(queryNetwork.getNetIdForResolv(), domain, 1, 1, flags);
            }
            catch (ErrnoException e) {
                if (queryIpv6) {
                    NetworkUtils.resNetworkCancel(v6fd);
                }
                executor.execute(() -> callback.onError(new DnsException(1, (Throwable)e)));
                return;
            }
            ++queryCount;
        } else {
            v4fd = null;
        }
        InetAddressAnswerAccumulator accumulator = new InetAddressAnswerAccumulator(queryNetwork, queryCount, callback);
        Object object = lock;
        synchronized (object) {
            if (queryIpv6) {
                this.registerFDListener(executor, v6fd, accumulator, cancellationSignal, lock);
            }
            if (queryIpv4) {
                this.registerFDListener(executor, v4fd, accumulator, cancellationSignal, lock);
            }
            if (cancellationSignal == null) {
                return;
            }
            cancellationSignal.setOnCancelListener(() -> {
                Object object = lock;
                synchronized (object) {
                    if (queryIpv4) {
                        this.cancelQuery(v4fd);
                    }
                    if (queryIpv6) {
                        this.cancelQuery(v6fd);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void query(Network network, String domain, int nsType, int flags, Executor executor, CancellationSignal cancellationSignal, Callback<? super List<InetAddress>> callback) {
        FileDescriptor queryfd;
        Network queryNetwork;
        if (cancellationSignal != null && cancellationSignal.isCanceled()) {
            return;
        }
        Object lock = new Object();
        try {
            queryNetwork = network != null ? network : NetworkUtils.getDnsNetwork();
            queryfd = NetworkUtils.resNetworkQuery(queryNetwork.getNetIdForResolv(), domain, 1, nsType, flags);
        }
        catch (ErrnoException e) {
            executor.execute(() -> callback.onError(new DnsException(1, (Throwable)e)));
            return;
        }
        InetAddressAnswerAccumulator accumulator = new InetAddressAnswerAccumulator(queryNetwork, 1, callback);
        Object object = lock;
        synchronized (object) {
            this.registerFDListener(executor, queryfd, accumulator, cancellationSignal, lock);
            if (cancellationSignal == null) {
                return;
            }
            this.addCancellationSignal(cancellationSignal, queryfd, lock);
        }
    }

    private void registerFDListener(Executor executor, FileDescriptor queryfd, Callback<? super byte[]> answerCallback, CancellationSignal cancellationSignal, Object lock) {
        MessageQueue mainThreadMessageQueue = Looper.getMainLooper().getQueue();
        mainThreadMessageQueue.addOnFileDescriptorEventListener(queryfd, 5, (fd, events) -> {
            mainThreadMessageQueue.removeOnFileDescriptorEventListener(fd);
            executor.execute(() -> {
                DnsResponse resp = null;
                ErrnoException exception = null;
                Object object = lock;
                synchronized (object) {
                    if (cancellationSignal != null && cancellationSignal.isCanceled()) {
                        return;
                    }
                    try {
                        resp = NetworkUtils.resNetworkResult(fd);
                    }
                    catch (ErrnoException e) {
                        Log.e(TAG, "resNetworkResult:" + e.toString());
                        exception = e;
                    }
                }
                if (exception != null) {
                    answerCallback.onError(new DnsException(1, exception));
                    return;
                }
                answerCallback.onAnswer(resp.answerbuf, resp.rcode);
            });
            return 0;
        });
    }

    private void cancelQuery(FileDescriptor queryfd) {
        if (!queryfd.valid()) {
            return;
        }
        Looper.getMainLooper().getQueue().removeOnFileDescriptorEventListener(queryfd);
        NetworkUtils.resNetworkCancel(queryfd);
    }

    private void addCancellationSignal(CancellationSignal cancellationSignal, FileDescriptor queryfd, Object lock) {
        cancellationSignal.setOnCancelListener(() -> {
            Object object = lock;
            synchronized (object) {
                this.cancelQuery(queryfd);
            }
        });
    }

    private static class DnsAddressAnswer
    extends DnsPacket {
        private static final String TAG = "DnsResolver.DnsAddressAnswer";
        private static final boolean DBG = false;
        private final int mQueryType;

        DnsAddressAnswer(byte[] data) throws ParseException {
            super(data);
            if ((this.mHeader.flags & 0x8000) == 0) {
                throw new ParseException("Not an answer packet");
            }
            if (this.mHeader.getRecordCount(0) == 0) {
                throw new ParseException("No question found");
            }
            this.mQueryType = ((DnsPacket.DnsRecord)this.mRecords[0].get((int)0)).nsType;
        }

        public List<InetAddress> getAddresses() {
            ArrayList<InetAddress> results = new ArrayList<InetAddress>();
            if (this.mHeader.getRecordCount(1) == 0) {
                return results;
            }
            for (DnsPacket.DnsRecord ansSec : this.mRecords[1]) {
                int nsType = ansSec.nsType;
                if (nsType != this.mQueryType || nsType != 1 && nsType != 28) continue;
                try {
                    results.add(InetAddress.getByAddress(ansSec.getRR()));
                }
                catch (UnknownHostException unknownHostException) {}
            }
            return results;
        }
    }

    public static final class DnsResponse {
        public final byte[] answerbuf;
        public final int rcode;

        public DnsResponse(byte[] answerbuf, int rcode) {
            this.answerbuf = answerbuf;
            this.rcode = rcode;
        }
    }

    private class InetAddressAnswerAccumulator
    implements Callback<byte[]> {
        private final List<InetAddress> mAllAnswers;
        private final Network mNetwork;
        private int mRcode;
        private DnsException mDnsException;
        private final Callback<? super List<InetAddress>> mUserCallback;
        private final int mTargetAnswerCount;
        private int mReceivedAnswerCount = 0;

        InetAddressAnswerAccumulator(Network network, int size, Callback<? super List<InetAddress>> callback) {
            this.mNetwork = network;
            this.mTargetAnswerCount = size;
            this.mAllAnswers = new ArrayList<InetAddress>();
            this.mUserCallback = callback;
        }

        private boolean maybeReportError() {
            if (this.mRcode != 0) {
                this.mUserCallback.onAnswer(this.mAllAnswers, this.mRcode);
                return true;
            }
            if (this.mDnsException != null) {
                this.mUserCallback.onError(this.mDnsException);
                return true;
            }
            return false;
        }

        private void maybeReportAnswer() {
            if (++this.mReceivedAnswerCount != this.mTargetAnswerCount) {
                return;
            }
            if (this.mAllAnswers.isEmpty() && this.maybeReportError()) {
                return;
            }
            this.mUserCallback.onAnswer(DnsUtils.rfc6724Sort(this.mNetwork, this.mAllAnswers), this.mRcode);
        }

        @Override
        public void onAnswer(byte[] answer, int rcode) {
            if (this.mReceivedAnswerCount == 0 || rcode == 0) {
                this.mRcode = rcode;
            }
            try {
                this.mAllAnswers.addAll(new DnsAddressAnswer(answer).getAddresses());
            }
            catch (ParseException e) {
                this.mDnsException = new DnsException(0, (Throwable)e);
            }
            this.maybeReportAnswer();
        }

        @Override
        public void onError(DnsException error) {
            this.mDnsException = error;
            this.maybeReportAnswer();
        }
    }

    public static class DnsException
    extends Exception {
        public final int code;

        DnsException(int code, Throwable cause) {
            super(cause);
            this.code = code;
        }
    }

    public static interface Callback<T> {
        public void onAnswer(T var1, int var2);

        public void onError(DnsException var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface DnsError {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface QueryFlag {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface QueryType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface QueryClass {
    }
}

