/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.ResolverParamsParcel;
import android.net.metrics.INetdEventListener;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IDnsResolver
extends IInterface {
    public static final int VERSION = 2;
    public static final int RESOLVER_PARAMS_SAMPLE_VALIDITY = 0;
    public static final int RESOLVER_PARAMS_SUCCESS_THRESHOLD = 1;
    public static final int RESOLVER_PARAMS_MIN_SAMPLES = 2;
    public static final int RESOLVER_PARAMS_MAX_SAMPLES = 3;
    public static final int RESOLVER_PARAMS_BASE_TIMEOUT_MSEC = 4;
    public static final int RESOLVER_PARAMS_RETRY_COUNT = 5;
    public static final int RESOLVER_PARAMS_COUNT = 6;
    public static final int RESOLVER_STATS_SUCCESSES = 0;
    public static final int RESOLVER_STATS_ERRORS = 1;
    public static final int RESOLVER_STATS_TIMEOUTS = 2;
    public static final int RESOLVER_STATS_INTERNAL_ERRORS = 3;
    public static final int RESOLVER_STATS_RTT_AVG = 4;
    public static final int RESOLVER_STATS_LAST_SAMPLE_TIME = 5;
    public static final int RESOLVER_STATS_USABLE = 6;
    public static final int RESOLVER_STATS_COUNT = 7;
    public static final int DNS_RESOLVER_LOG_VERBOSE = 0;
    public static final int DNS_RESOLVER_LOG_DEBUG = 1;
    public static final int DNS_RESOLVER_LOG_INFO = 2;
    public static final int DNS_RESOLVER_LOG_WARNING = 3;
    public static final int DNS_RESOLVER_LOG_ERROR = 4;

    public boolean isAlive() throws RemoteException;

    public void registerEventListener(INetdEventListener var1) throws RemoteException;

    public void setResolverConfiguration(ResolverParamsParcel var1) throws RemoteException;

    public void getResolverInfo(int var1, String[] var2, String[] var3, String[] var4, int[] var5, int[] var6, int[] var7) throws RemoteException;

    public void startPrefix64Discovery(int var1) throws RemoteException;

    public void stopPrefix64Discovery(int var1) throws RemoteException;

    public String getPrefix64(int var1) throws RemoteException;

    public void createNetworkCache(int var1) throws RemoteException;

    public void destroyNetworkCache(int var1) throws RemoteException;

    public void setLogSeverity(int var1) throws RemoteException;

    public int getInterfaceVersion() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IDnsResolver {
        private static final String DESCRIPTOR = "android.net.IDnsResolver";
        static final int TRANSACTION_isAlive = 1;
        static final int TRANSACTION_registerEventListener = 2;
        static final int TRANSACTION_setResolverConfiguration = 3;
        static final int TRANSACTION_getResolverInfo = 4;
        static final int TRANSACTION_startPrefix64Discovery = 5;
        static final int TRANSACTION_stopPrefix64Discovery = 6;
        static final int TRANSACTION_getPrefix64 = 7;
        static final int TRANSACTION_createNetworkCache = 8;
        static final int TRANSACTION_destroyNetworkCache = 9;
        static final int TRANSACTION_setLogSeverity = 10;
        static final int TRANSACTION_getInterfaceVersion = 0xFFFFFF;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IDnsResolver asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IDnsResolver) {
                return (IDnsResolver)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
                case 1: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.isAlive();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    INetdEventListener _arg0 = INetdEventListener.Stub.asInterface(data.readStrongBinder());
                    this.registerEventListener(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    ResolverParamsParcel _arg0 = 0 != data.readInt() ? ResolverParamsParcel.CREATOR.createFromParcel(data) : null;
                    this.setResolverConfiguration(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1_length = data.readInt();
                    String[] _arg1 = _arg1_length < 0 ? null : new String[_arg1_length];
                    int _arg2_length = data.readInt();
                    String[] _arg2 = _arg2_length < 0 ? null : new String[_arg2_length];
                    int _arg3_length = data.readInt();
                    String[] _arg3 = _arg3_length < 0 ? null : new String[_arg3_length];
                    int _arg4_length = data.readInt();
                    int[] _arg4 = _arg4_length < 0 ? null : new int[_arg4_length];
                    int _arg5_length = data.readInt();
                    int[] _arg5 = _arg5_length < 0 ? null : new int[_arg5_length];
                    int _arg6_length = data.readInt();
                    int[] _arg6 = _arg6_length < 0 ? null : new int[_arg6_length];
                    this.getResolverInfo(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6);
                    reply.writeNoException();
                    reply.writeStringArray(_arg1);
                    reply.writeStringArray(_arg2);
                    reply.writeStringArray(_arg3);
                    reply.writeIntArray(_arg4);
                    reply.writeIntArray(_arg5);
                    reply.writeIntArray(_arg6);
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.startPrefix64Discovery(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.stopPrefix64Discovery(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _result = this.getPrefix64(_arg0);
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 8: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.createNetworkCache(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 9: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.destroyNetworkCache(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 10: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.setLogSeverity(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 0xFFFFFF: {
                    data.enforceInterface(descriptor);
                    reply.writeNoException();
                    reply.writeInt(this.getInterfaceVersion());
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IDnsResolver impl) {
            if (Proxy.sDefaultImpl == null && impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IDnsResolver getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IDnsResolver {
            private IBinder mRemote;
            private int mCachedVersion = -1;
            public static IDnsResolver sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isAlive() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isAlive();
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerEventListener(INetdEventListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().registerEventListener(listener);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setResolverConfiguration(ResolverParamsParcel resolverParams) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (resolverParams != null) {
                        _data.writeInt(1);
                        resolverParams.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setResolverConfiguration(resolverParams);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getResolverInfo(int netId, String[] servers, String[] domains, String[] tlsServers, int[] params, int[] stats, int[] wait_for_pending_req_timeout_count) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(netId);
                    if (servers == null) {
                        _data.writeInt(-1);
                    } else {
                        _data.writeInt(servers.length);
                    }
                    if (domains == null) {
                        _data.writeInt(-1);
                    } else {
                        _data.writeInt(domains.length);
                    }
                    if (tlsServers == null) {
                        _data.writeInt(-1);
                    } else {
                        _data.writeInt(tlsServers.length);
                    }
                    if (params == null) {
                        _data.writeInt(-1);
                    } else {
                        _data.writeInt(params.length);
                    }
                    if (stats == null) {
                        _data.writeInt(-1);
                    } else {
                        _data.writeInt(stats.length);
                    }
                    if (wait_for_pending_req_timeout_count == null) {
                        _data.writeInt(-1);
                    } else {
                        _data.writeInt(wait_for_pending_req_timeout_count.length);
                    }
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().getResolverInfo(netId, servers, domains, tlsServers, params, stats, wait_for_pending_req_timeout_count);
                        return;
                    }
                    _reply.readException();
                    _reply.readStringArray(servers);
                    _reply.readStringArray(domains);
                    _reply.readStringArray(tlsServers);
                    _reply.readIntArray(params);
                    _reply.readIntArray(stats);
                    _reply.readIntArray(wait_for_pending_req_timeout_count);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startPrefix64Discovery(int netId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(netId);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().startPrefix64Discovery(netId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopPrefix64Discovery(int netId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(netId);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().stopPrefix64Discovery(netId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getPrefix64(int netId) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(netId);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        String string2 = Stub.getDefaultImpl().getPrefix64(netId);
                        return string2;
                    }
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void createNetworkCache(int netId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(netId);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().createNetworkCache(netId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void destroyNetworkCache(int netId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(netId);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().destroyNetworkCache(netId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setLogSeverity(int logSeverity) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(logSeverity);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setLogSeverity(logSeverity);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            @Override
            public int getInterfaceVersion() throws RemoteException {
                if (this.mCachedVersion == -1) {
                    Parcel data = Parcel.obtain();
                    Parcel reply = Parcel.obtain();
                    try {
                        data.writeInterfaceToken(Stub.DESCRIPTOR);
                        this.mRemote.transact(0xFFFFFF, data, reply, 0);
                        reply.readException();
                        this.mCachedVersion = reply.readInt();
                    }
                    finally {
                        reply.recycle();
                        data.recycle();
                    }
                }
                return this.mCachedVersion;
            }
        }
    }

    public static class Default
    implements IDnsResolver {
        @Override
        public boolean isAlive() throws RemoteException {
            return false;
        }

        @Override
        public void registerEventListener(INetdEventListener listener) throws RemoteException {
        }

        @Override
        public void setResolverConfiguration(ResolverParamsParcel resolverParams) throws RemoteException {
        }

        @Override
        public void getResolverInfo(int netId, String[] servers, String[] domains, String[] tlsServers, int[] params, int[] stats, int[] wait_for_pending_req_timeout_count) throws RemoteException {
        }

        @Override
        public void startPrefix64Discovery(int netId) throws RemoteException {
        }

        @Override
        public void stopPrefix64Discovery(int netId) throws RemoteException {
        }

        @Override
        public String getPrefix64(int netId) throws RemoteException {
            return null;
        }

        @Override
        public void createNetworkCache(int netId) throws RemoteException {
        }

        @Override
        public void destroyNetworkCache(int netId) throws RemoteException {
        }

        @Override
        public void setLogSeverity(int logSeverity) throws RemoteException {
        }

        @Override
        public int getInterfaceVersion() {
            return -1;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

