/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.ipmemorystore.Blob;
import android.net.ipmemorystore.IOnBlobRetrievedListener;
import android.net.ipmemorystore.IOnL2KeyResponseListener;
import android.net.ipmemorystore.IOnNetworkAttributesRetrievedListener;
import android.net.ipmemorystore.IOnSameL3NetworkResponseListener;
import android.net.ipmemorystore.IOnStatusListener;
import android.net.ipmemorystore.NetworkAttributesParcelable;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IIpMemoryStore
extends IInterface {
    public static final int VERSION = 3;

    public void storeNetworkAttributes(String var1, NetworkAttributesParcelable var2, IOnStatusListener var3) throws RemoteException;

    public void storeBlob(String var1, String var2, String var3, Blob var4, IOnStatusListener var5) throws RemoteException;

    public void findL2Key(NetworkAttributesParcelable var1, IOnL2KeyResponseListener var2) throws RemoteException;

    public void isSameNetwork(String var1, String var2, IOnSameL3NetworkResponseListener var3) throws RemoteException;

    public void retrieveNetworkAttributes(String var1, IOnNetworkAttributesRetrievedListener var2) throws RemoteException;

    public void retrieveBlob(String var1, String var2, String var3, IOnBlobRetrievedListener var4) throws RemoteException;

    public void factoryReset() throws RemoteException;

    public int getInterfaceVersion() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IIpMemoryStore {
        private static final String DESCRIPTOR = "android.net.IIpMemoryStore";
        static final int TRANSACTION_storeNetworkAttributes = 1;
        static final int TRANSACTION_storeBlob = 2;
        static final int TRANSACTION_findL2Key = 3;
        static final int TRANSACTION_isSameNetwork = 4;
        static final int TRANSACTION_retrieveNetworkAttributes = 5;
        static final int TRANSACTION_retrieveBlob = 6;
        static final int TRANSACTION_factoryReset = 7;
        static final int TRANSACTION_getInterfaceVersion = 0xFFFFFF;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IIpMemoryStore asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IIpMemoryStore) {
                return (IIpMemoryStore)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
                case 1: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    NetworkAttributesParcelable _arg1 = 0 != data.readInt() ? NetworkAttributesParcelable.CREATOR.createFromParcel(data) : null;
                    IOnStatusListener _arg2 = IOnStatusListener.Stub.asInterface(data.readStrongBinder());
                    this.storeNetworkAttributes(_arg0, _arg1, _arg2);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    Blob _arg3 = 0 != data.readInt() ? Blob.CREATOR.createFromParcel(data) : null;
                    IOnStatusListener _arg4 = IOnStatusListener.Stub.asInterface(data.readStrongBinder());
                    this.storeBlob(_arg0, _arg1, _arg2, _arg3, _arg4);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    NetworkAttributesParcelable _arg0 = 0 != data.readInt() ? NetworkAttributesParcelable.CREATOR.createFromParcel(data) : null;
                    IOnL2KeyResponseListener _arg1 = IOnL2KeyResponseListener.Stub.asInterface(data.readStrongBinder());
                    this.findL2Key(_arg0, _arg1);
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    IOnSameL3NetworkResponseListener _arg2 = IOnSameL3NetworkResponseListener.Stub.asInterface(data.readStrongBinder());
                    this.isSameNetwork(_arg0, _arg1, _arg2);
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    IOnNetworkAttributesRetrievedListener _arg1 = IOnNetworkAttributesRetrievedListener.Stub.asInterface(data.readStrongBinder());
                    this.retrieveNetworkAttributes(_arg0, _arg1);
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    IOnBlobRetrievedListener _arg3 = IOnBlobRetrievedListener.Stub.asInterface(data.readStrongBinder());
                    this.retrieveBlob(_arg0, _arg1, _arg2, _arg3);
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    this.factoryReset();
                    return true;
                }
                case 0xFFFFFF: {
                    data.enforceInterface(descriptor);
                    reply.writeNoException();
                    reply.writeInt(this.getInterfaceVersion());
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IIpMemoryStore impl) {
            if (Proxy.sDefaultImpl == null && impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IIpMemoryStore getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IIpMemoryStore {
            private IBinder mRemote;
            private int mCachedVersion = -1;
            public static IIpMemoryStore sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void storeNetworkAttributes(String l2Key, NetworkAttributesParcelable attributes, IOnStatusListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(l2Key);
                    if (attributes != null) {
                        _data.writeInt(1);
                        attributes.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().storeNetworkAttributes(l2Key, attributes, listener);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void storeBlob(String l2Key, String clientId, String name, Blob data, IOnStatusListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(l2Key);
                    _data.writeString(clientId);
                    _data.writeString(name);
                    if (data != null) {
                        _data.writeInt(1);
                        data.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    boolean _status = this.mRemote.transact(2, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().storeBlob(l2Key, clientId, name, data, listener);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void findL2Key(NetworkAttributesParcelable attributes, IOnL2KeyResponseListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (attributes != null) {
                        _data.writeInt(1);
                        attributes.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    boolean _status = this.mRemote.transact(3, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().findL2Key(attributes, listener);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void isSameNetwork(String l2Key1, String l2Key2, IOnSameL3NetworkResponseListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(l2Key1);
                    _data.writeString(l2Key2);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    boolean _status = this.mRemote.transact(4, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().isSameNetwork(l2Key1, l2Key2, listener);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void retrieveNetworkAttributes(String l2Key, IOnNetworkAttributesRetrievedListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(l2Key);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    boolean _status = this.mRemote.transact(5, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().retrieveNetworkAttributes(l2Key, listener);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void retrieveBlob(String l2Key, String clientId, String name, IOnBlobRetrievedListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(l2Key);
                    _data.writeString(clientId);
                    _data.writeString(name);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    boolean _status = this.mRemote.transact(6, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().retrieveBlob(l2Key, clientId, name, listener);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void factoryReset() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(7, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().factoryReset();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public int getInterfaceVersion() throws RemoteException {
                if (this.mCachedVersion == -1) {
                    Parcel data = Parcel.obtain();
                    Parcel reply = Parcel.obtain();
                    try {
                        data.writeInterfaceToken(Stub.DESCRIPTOR);
                        this.mRemote.transact(0xFFFFFF, data, reply, 0);
                        reply.readException();
                        this.mCachedVersion = reply.readInt();
                    }
                    finally {
                        reply.recycle();
                        data.recycle();
                    }
                }
                return this.mCachedVersion;
            }
        }
    }

    public static class Default
    implements IIpMemoryStore {
        @Override
        public void storeNetworkAttributes(String l2Key, NetworkAttributesParcelable attributes, IOnStatusListener listener) throws RemoteException {
        }

        @Override
        public void storeBlob(String l2Key, String clientId, String name, Blob data, IOnStatusListener listener) throws RemoteException {
        }

        @Override
        public void findL2Key(NetworkAttributesParcelable attributes, IOnL2KeyResponseListener listener) throws RemoteException {
        }

        @Override
        public void isSameNetwork(String l2Key1, String l2Key2, IOnSameL3NetworkResponseListener listener) throws RemoteException {
        }

        @Override
        public void retrieveNetworkAttributes(String l2Key, IOnNetworkAttributesRetrievedListener listener) throws RemoteException {
        }

        @Override
        public void retrieveBlob(String l2Key, String clientId, String name, IOnBlobRetrievedListener listener) throws RemoteException {
        }

        @Override
        public void factoryReset() throws RemoteException {
        }

        @Override
        public int getInterfaceVersion() {
            return -1;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

