/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.LinkProperties;
import android.net.NetworkCapabilities;
import android.net.PrivateDnsConfigParcel;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface INetworkMonitor
extends IInterface {
    public static final int VERSION = 3;
    public static final int NETWORK_TEST_RESULT_VALID = 0;
    public static final int NETWORK_TEST_RESULT_INVALID = 1;
    public static final int NETWORK_TEST_RESULT_PARTIAL_CONNECTIVITY = 2;
    public static final int NETWORK_VALIDATION_RESULT_VALID = 1;
    public static final int NETWORK_VALIDATION_RESULT_PARTIAL = 2;
    public static final int NETWORK_VALIDATION_PROBE_DNS = 4;
    public static final int NETWORK_VALIDATION_PROBE_HTTP = 8;
    public static final int NETWORK_VALIDATION_PROBE_HTTPS = 16;
    public static final int NETWORK_VALIDATION_PROBE_FALLBACK = 32;
    public static final int NETWORK_VALIDATION_PROBE_PRIVDNS = 64;

    public void start() throws RemoteException;

    public void launchCaptivePortalApp() throws RemoteException;

    public void notifyCaptivePortalAppFinished(int var1) throws RemoteException;

    public void setAcceptPartialConnectivity() throws RemoteException;

    public void forceReevaluation(int var1) throws RemoteException;

    public void notifyPrivateDnsChanged(PrivateDnsConfigParcel var1) throws RemoteException;

    public void notifyDnsResponse(int var1) throws RemoteException;

    public void notifyNetworkConnected(LinkProperties var1, NetworkCapabilities var2) throws RemoteException;

    public void notifyNetworkDisconnected() throws RemoteException;

    public void notifyLinkPropertiesChanged(LinkProperties var1) throws RemoteException;

    public void notifyNetworkCapabilitiesChanged(NetworkCapabilities var1) throws RemoteException;

    public int getInterfaceVersion() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements INetworkMonitor {
        private static final String DESCRIPTOR = "android.net.INetworkMonitor";
        static final int TRANSACTION_start = 1;
        static final int TRANSACTION_launchCaptivePortalApp = 2;
        static final int TRANSACTION_notifyCaptivePortalAppFinished = 3;
        static final int TRANSACTION_setAcceptPartialConnectivity = 4;
        static final int TRANSACTION_forceReevaluation = 5;
        static final int TRANSACTION_notifyPrivateDnsChanged = 6;
        static final int TRANSACTION_notifyDnsResponse = 7;
        static final int TRANSACTION_notifyNetworkConnected = 8;
        static final int TRANSACTION_notifyNetworkDisconnected = 9;
        static final int TRANSACTION_notifyLinkPropertiesChanged = 10;
        static final int TRANSACTION_notifyNetworkCapabilitiesChanged = 11;
        static final int TRANSACTION_getInterfaceVersion = 0xFFFFFF;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static INetworkMonitor asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof INetworkMonitor) {
                return (INetworkMonitor)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
                case 1: {
                    data.enforceInterface(descriptor);
                    this.start();
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    this.launchCaptivePortalApp();
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.notifyCaptivePortalAppFinished(_arg0);
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    this.setAcceptPartialConnectivity();
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.forceReevaluation(_arg0);
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    PrivateDnsConfigParcel _arg0 = 0 != data.readInt() ? PrivateDnsConfigParcel.CREATOR.createFromParcel(data) : null;
                    this.notifyPrivateDnsChanged(_arg0);
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.notifyDnsResponse(_arg0);
                    return true;
                }
                case 8: {
                    data.enforceInterface(descriptor);
                    LinkProperties _arg0 = 0 != data.readInt() ? LinkProperties.CREATOR.createFromParcel(data) : null;
                    NetworkCapabilities _arg1 = 0 != data.readInt() ? NetworkCapabilities.CREATOR.createFromParcel(data) : null;
                    this.notifyNetworkConnected(_arg0, _arg1);
                    return true;
                }
                case 9: {
                    data.enforceInterface(descriptor);
                    this.notifyNetworkDisconnected();
                    return true;
                }
                case 10: {
                    data.enforceInterface(descriptor);
                    LinkProperties _arg0 = 0 != data.readInt() ? LinkProperties.CREATOR.createFromParcel(data) : null;
                    this.notifyLinkPropertiesChanged(_arg0);
                    return true;
                }
                case 11: {
                    data.enforceInterface(descriptor);
                    NetworkCapabilities _arg0 = 0 != data.readInt() ? NetworkCapabilities.CREATOR.createFromParcel(data) : null;
                    this.notifyNetworkCapabilitiesChanged(_arg0);
                    return true;
                }
                case 0xFFFFFF: {
                    data.enforceInterface(descriptor);
                    reply.writeNoException();
                    reply.writeInt(this.getInterfaceVersion());
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(INetworkMonitor impl) {
            if (Proxy.sDefaultImpl == null && impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static INetworkMonitor getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements INetworkMonitor {
            private IBinder mRemote;
            private int mCachedVersion = -1;
            public static INetworkMonitor sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            @Override
            public void start() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().start();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void launchCaptivePortalApp() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(2, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().launchCaptivePortalApp();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyCaptivePortalAppFinished(int response) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(response);
                    boolean _status = this.mRemote.transact(3, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().notifyCaptivePortalAppFinished(response);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void setAcceptPartialConnectivity() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(4, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setAcceptPartialConnectivity();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void forceReevaluation(int uid) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uid);
                    boolean _status = this.mRemote.transact(5, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().forceReevaluation(uid);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyPrivateDnsChanged(PrivateDnsConfigParcel config) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (config != null) {
                        _data.writeInt(1);
                        config.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(6, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().notifyPrivateDnsChanged(config);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyDnsResponse(int returnCode) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(returnCode);
                    boolean _status = this.mRemote.transact(7, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().notifyDnsResponse(returnCode);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyNetworkConnected(LinkProperties lp, NetworkCapabilities nc) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (lp != null) {
                        _data.writeInt(1);
                        lp.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (nc != null) {
                        _data.writeInt(1);
                        nc.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(8, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().notifyNetworkConnected(lp, nc);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void notifyNetworkDisconnected() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(9, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().notifyNetworkDisconnected();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyLinkPropertiesChanged(LinkProperties lp) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (lp != null) {
                        _data.writeInt(1);
                        lp.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(10, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().notifyLinkPropertiesChanged(lp);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyNetworkCapabilitiesChanged(NetworkCapabilities nc) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (nc != null) {
                        _data.writeInt(1);
                        nc.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(11, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().notifyNetworkCapabilitiesChanged(nc);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public int getInterfaceVersion() throws RemoteException {
                if (this.mCachedVersion == -1) {
                    Parcel data = Parcel.obtain();
                    Parcel reply = Parcel.obtain();
                    try {
                        data.writeInterfaceToken(Stub.DESCRIPTOR);
                        this.mRemote.transact(0xFFFFFF, data, reply, 0);
                        reply.readException();
                        this.mCachedVersion = reply.readInt();
                    }
                    finally {
                        reply.recycle();
                        data.recycle();
                    }
                }
                return this.mCachedVersion;
            }
        }
    }

    public static class Default
    implements INetworkMonitor {
        @Override
        public void start() throws RemoteException {
        }

        @Override
        public void launchCaptivePortalApp() throws RemoteException {
        }

        @Override
        public void notifyCaptivePortalAppFinished(int response) throws RemoteException {
        }

        @Override
        public void setAcceptPartialConnectivity() throws RemoteException {
        }

        @Override
        public void forceReevaluation(int uid) throws RemoteException {
        }

        @Override
        public void notifyPrivateDnsChanged(PrivateDnsConfigParcel config) throws RemoteException {
        }

        @Override
        public void notifyDnsResponse(int returnCode) throws RemoteException {
        }

        @Override
        public void notifyNetworkConnected(LinkProperties lp, NetworkCapabilities nc) throws RemoteException {
        }

        @Override
        public void notifyNetworkDisconnected() throws RemoteException {
        }

        @Override
        public void notifyLinkPropertiesChanged(LinkProperties lp) throws RemoteException {
        }

        @Override
        public void notifyNetworkCapabilitiesChanged(NetworkCapabilities nc) throws RemoteException {
        }

        @Override
        public int getInterfaceVersion() {
            return -1;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

