/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.content.Context;
import android.net.IIpMemoryStore;
import android.net.IIpMemoryStoreCallbacks;
import android.net.IpMemoryStoreClient;
import android.net.NetworkStackClient;
import android.util.Log;
import com.android.internal.annotations.VisibleForTesting;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

public class IpMemoryStore
extends IpMemoryStoreClient {
    private static final String TAG = IpMemoryStore.class.getSimpleName();
    private final CompletableFuture<IIpMemoryStore> mService = new CompletableFuture();
    private final AtomicReference<CompletableFuture<IIpMemoryStore>> mTailNode = new AtomicReference<CompletableFuture<IIpMemoryStore>>(this.mService);

    public IpMemoryStore(Context context) {
        super(context);
        this.getNetworkStackClient().fetchIpMemoryStore(new IIpMemoryStoreCallbacks.Stub(){

            @Override
            public void onIpMemoryStoreFetched(IIpMemoryStore memoryStore) {
                IpMemoryStore.this.mService.complete(memoryStore);
            }

            @Override
            public int getInterfaceVersion() {
                return 3;
            }
        });
    }

    @Override
    protected void runWhenServiceReady(Consumer<IIpMemoryStore> cb) throws ExecutionException {
        this.mTailNode.getAndUpdate(future -> future.handle((store, exception) -> {
            if (exception != null) {
                Log.wtf(TAG, "Error fetching IpMemoryStore", exception);
                return store;
            }
            try {
                cb.accept((IIpMemoryStore)store);
            }
            catch (Exception e) {
                Log.wtf(TAG, "Exception occured: " + e.getMessage());
            }
            return store;
        }));
    }

    @VisibleForTesting
    protected NetworkStackClient getNetworkStackClient() {
        return NetworkStackClient.getInstance();
    }

    public static IpMemoryStore getMemoryStore(Context context) {
        return new IpMemoryStore(context);
    }
}

