/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.content.Context;
import android.net.IIpMemoryStore;
import android.net.ipmemorystore.Blob;
import android.net.ipmemorystore.NetworkAttributes;
import android.net.ipmemorystore.OnBlobRetrievedListener;
import android.net.ipmemorystore.OnL2KeyResponseListener;
import android.net.ipmemorystore.OnNetworkAttributesRetrievedListener;
import android.net.ipmemorystore.OnSameL3NetworkResponseListener;
import android.net.ipmemorystore.OnStatusListener;
import android.net.ipmemorystore.Status;
import android.os.RemoteException;
import android.util.Log;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;

public abstract class IpMemoryStoreClient {
    private static final String TAG = IpMemoryStoreClient.class.getSimpleName();
    private final Context mContext;

    public IpMemoryStoreClient(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("missing context");
        }
        this.mContext = context;
    }

    protected abstract void runWhenServiceReady(Consumer<IIpMemoryStore> var1) throws ExecutionException;

    private void ignoringRemoteException(ThrowingRunnable r) {
        this.ignoringRemoteException("Failed to execute remote procedure call", r);
    }

    private void ignoringRemoteException(String message, ThrowingRunnable r) {
        try {
            r.run();
        }
        catch (RemoteException e) {
            Log.e(TAG, message, e);
        }
    }

    public void storeNetworkAttributes(String l2Key, NetworkAttributes attributes, OnStatusListener listener) {
        try {
            this.runWhenServiceReady(service -> this.ignoringRemoteException(() -> service.storeNetworkAttributes(l2Key, attributes.toParcelable(), OnStatusListener.toAIDL(listener))));
        }
        catch (ExecutionException m) {
            this.ignoringRemoteException("Error storing network attributes", () -> listener.onComplete(new Status(-5)));
        }
    }

    public void storeBlob(String l2Key, String clientId, String name, Blob data, OnStatusListener listener) {
        try {
            this.runWhenServiceReady(service -> this.ignoringRemoteException(() -> service.storeBlob(l2Key, clientId, name, data, OnStatusListener.toAIDL(listener))));
        }
        catch (ExecutionException m) {
            this.ignoringRemoteException("Error storing blob", () -> listener.onComplete(new Status(-5)));
        }
    }

    public void findL2Key(NetworkAttributes attributes, OnL2KeyResponseListener listener) {
        try {
            this.runWhenServiceReady(service -> this.ignoringRemoteException(() -> service.findL2Key(attributes.toParcelable(), OnL2KeyResponseListener.toAIDL(listener))));
        }
        catch (ExecutionException m) {
            this.ignoringRemoteException("Error finding L2 Key", () -> listener.onL2KeyResponse(new Status(-5), null));
        }
    }

    public void isSameNetwork(String l2Key1, String l2Key2, OnSameL3NetworkResponseListener listener) {
        try {
            this.runWhenServiceReady(service -> this.ignoringRemoteException(() -> service.isSameNetwork(l2Key1, l2Key2, OnSameL3NetworkResponseListener.toAIDL(listener))));
        }
        catch (ExecutionException m) {
            this.ignoringRemoteException("Error checking for network sameness", () -> listener.onSameL3NetworkResponse(new Status(-5), null));
        }
    }

    public void retrieveNetworkAttributes(String l2Key, OnNetworkAttributesRetrievedListener listener) {
        try {
            this.runWhenServiceReady(service -> this.ignoringRemoteException(() -> service.retrieveNetworkAttributes(l2Key, OnNetworkAttributesRetrievedListener.toAIDL(listener))));
        }
        catch (ExecutionException m) {
            this.ignoringRemoteException("Error retrieving network attributes", () -> listener.onNetworkAttributesRetrieved(new Status(-5), null, null));
        }
    }

    public void retrieveBlob(String l2Key, String clientId, String name, OnBlobRetrievedListener listener) {
        try {
            this.runWhenServiceReady(service -> this.ignoringRemoteException(() -> service.retrieveBlob(l2Key, clientId, name, OnBlobRetrievedListener.toAIDL(listener))));
        }
        catch (ExecutionException m) {
            this.ignoringRemoteException("Error retrieving blob", () -> listener.onBlobRetrieved(new Status(-5), null, null, null));
        }
    }

    public void factoryReset() {
        try {
            this.runWhenServiceReady(service -> this.ignoringRemoteException(() -> service.factoryReset()));
        }
        catch (ExecutionException m) {
            Log.e(TAG, "Error executing factory reset", m);
        }
    }

    @FunctionalInterface
    private static interface ThrowingRunnable {
        public void run() throws RemoteException;
    }
}

