/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.HexDump;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;

public final class IpSecAlgorithm
implements Parcelable {
    private static final String TAG = "IpSecAlgorithm";
    public static final String CRYPT_NULL = "ecb(cipher_null)";
    public static final String CRYPT_AES_CBC = "cbc(aes)";
    public static final String AUTH_HMAC_MD5 = "hmac(md5)";
    public static final String AUTH_HMAC_SHA1 = "hmac(sha1)";
    public static final String AUTH_HMAC_SHA256 = "hmac(sha256)";
    public static final String AUTH_HMAC_SHA384 = "hmac(sha384)";
    public static final String AUTH_HMAC_SHA512 = "hmac(sha512)";
    public static final String AUTH_CRYPT_AES_GCM = "rfc4106(gcm(aes))";
    private final String mName;
    private final byte[] mKey;
    private final int mTruncLenBits;
    public static final Parcelable.Creator<IpSecAlgorithm> CREATOR = new Parcelable.Creator<IpSecAlgorithm>(){

        @Override
        public IpSecAlgorithm createFromParcel(Parcel in) {
            String name = in.readString();
            byte[] key = in.createByteArray();
            int truncLenBits = in.readInt();
            return new IpSecAlgorithm(name, key, truncLenBits);
        }

        public IpSecAlgorithm[] newArray(int size) {
            return new IpSecAlgorithm[size];
        }
    };

    public IpSecAlgorithm(String algorithm, byte[] key) {
        this(algorithm, key, 0);
    }

    public IpSecAlgorithm(String algorithm, byte[] key, int truncLenBits) {
        this.mName = algorithm;
        this.mKey = (byte[])key.clone();
        this.mTruncLenBits = truncLenBits;
        IpSecAlgorithm.checkValidOrThrow(this.mName, this.mKey.length * 8, this.mTruncLenBits);
    }

    public String getName() {
        return this.mName;
    }

    public byte[] getKey() {
        return (byte[])this.mKey.clone();
    }

    public int getTruncationLengthBits() {
        return this.mTruncLenBits;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeString(this.mName);
        out.writeByteArray(this.mKey);
        out.writeInt(this.mTruncLenBits);
    }

    private static void checkValidOrThrow(String name, int keyLen, int truncLen) {
        boolean isValidLen = true;
        boolean isValidTruncLen = true;
        switch (name) {
            case "cbc(aes)": {
                isValidLen = keyLen == 128 || keyLen == 192 || keyLen == 256;
                break;
            }
            case "hmac(md5)": {
                isValidLen = keyLen == 128;
                isValidTruncLen = truncLen >= 96 && truncLen <= 128;
                break;
            }
            case "hmac(sha1)": {
                isValidLen = keyLen == 160;
                isValidTruncLen = truncLen >= 96 && truncLen <= 160;
                break;
            }
            case "hmac(sha256)": {
                isValidLen = keyLen == 256;
                isValidTruncLen = truncLen >= 96 && truncLen <= 256;
                break;
            }
            case "hmac(sha384)": {
                isValidLen = keyLen == 384;
                isValidTruncLen = truncLen >= 192 && truncLen <= 384;
                break;
            }
            case "hmac(sha512)": {
                isValidLen = keyLen == 512;
                isValidTruncLen = truncLen >= 256 && truncLen <= 512;
                break;
            }
            case "rfc4106(gcm(aes))": {
                isValidLen = keyLen == 160 || keyLen == 224 || keyLen == 288;
                isValidTruncLen = truncLen == 64 || truncLen == 96 || truncLen == 128;
                break;
            }
            default: {
                throw new IllegalArgumentException("Couldn't find an algorithm: " + name);
            }
        }
        if (!isValidLen) {
            throw new IllegalArgumentException("Invalid key material keyLength: " + keyLen);
        }
        if (!isValidTruncLen) {
            throw new IllegalArgumentException("Invalid truncation keyLength: " + truncLen);
        }
    }

    public boolean isAuthentication() {
        switch (this.getName()) {
            case "hmac(md5)": 
            case "hmac(sha1)": 
            case "hmac(sha256)": 
            case "hmac(sha384)": 
            case "hmac(sha512)": {
                return true;
            }
        }
        return false;
    }

    public boolean isEncryption() {
        return this.getName().equals(CRYPT_AES_CBC);
    }

    public boolean isAead() {
        return this.getName().equals(AUTH_CRYPT_AES_GCM);
    }

    private static boolean isUnsafeBuild() {
        return Build.IS_DEBUGGABLE && Build.IS_ENG;
    }

    public String toString() {
        return "{mName=" + this.mName + ", mKey=" + (IpSecAlgorithm.isUnsafeBuild() ? HexDump.toHexString(this.mKey) : "<hidden>") + ", mTruncLenBits=" + this.mTruncLenBits + "}";
    }

    @VisibleForTesting
    public static boolean equals(IpSecAlgorithm lhs, IpSecAlgorithm rhs) {
        if (lhs == null || rhs == null) {
            return lhs == rhs;
        }
        return lhs.mName.equals(rhs.mName) && Arrays.equals(lhs.mKey, rhs.mKey) && lhs.mTruncLenBits == rhs.mTruncLenBits;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AlgorithmName {
    }
}

