/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.annotation.UnsupportedAppUsage;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.BitUtils;
import com.android.internal.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.net.Inet6Address;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Random;

public final class MacAddress
implements Parcelable {
    private static final int ETHER_ADDR_LEN = 6;
    private static final byte[] ETHER_ADDR_BROADCAST = MacAddress.addr(255, 255, 255, 255, 255, 255);
    public static final MacAddress BROADCAST_ADDRESS = MacAddress.fromBytes(ETHER_ADDR_BROADCAST);
    @UnsupportedAppUsage
    public static final MacAddress ALL_ZEROS_ADDRESS = new MacAddress(0L);
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_UNICAST = 1;
    public static final int TYPE_MULTICAST = 2;
    public static final int TYPE_BROADCAST = 3;
    private static final long VALID_LONG_MASK = 0xFFFFFFFFFFFFL;
    private static final long LOCALLY_ASSIGNED_MASK = MacAddress.fromString((String)"2:0:0:0:0:0").mAddr;
    private static final long MULTICAST_MASK = MacAddress.fromString((String)"1:0:0:0:0:0").mAddr;
    private static final long OUI_MASK = MacAddress.fromString((String)"ff:ff:ff:0:0:0").mAddr;
    private static final long NIC_MASK = MacAddress.fromString((String)"0:0:0:ff:ff:ff").mAddr;
    private static final MacAddress BASE_GOOGLE_MAC = MacAddress.fromString("da:a1:19:0:0:0");
    private final long mAddr;
    public static final Parcelable.Creator<MacAddress> CREATOR = new Parcelable.Creator<MacAddress>(){

        @Override
        public MacAddress createFromParcel(Parcel in) {
            return new MacAddress(in.readLong());
        }

        public MacAddress[] newArray(int size) {
            return new MacAddress[size];
        }
    };

    private MacAddress(long addr) {
        this.mAddr = 0xFFFFFFFFFFFFL & addr;
    }

    public int getAddressType() {
        if (this.equals(BROADCAST_ADDRESS)) {
            return 3;
        }
        if (this.isMulticastAddress()) {
            return 2;
        }
        return 1;
    }

    public boolean isMulticastAddress() {
        return (this.mAddr & MULTICAST_MASK) != 0L;
    }

    public boolean isLocallyAssigned() {
        return (this.mAddr & LOCALLY_ASSIGNED_MASK) != 0L;
    }

    public byte[] toByteArray() {
        return MacAddress.byteAddrFromLongAddr(this.mAddr);
    }

    public String toString() {
        return MacAddress.stringAddrFromLongAddr(this.mAddr);
    }

    public String toOuiString() {
        return String.format("%02x:%02x:%02x", this.mAddr >> 40 & 0xFFL, this.mAddr >> 32 & 0xFFL, this.mAddr >> 24 & 0xFFL);
    }

    public int hashCode() {
        return (int)(this.mAddr >> 32 ^ this.mAddr);
    }

    public boolean equals(Object o) {
        return o instanceof MacAddress && ((MacAddress)o).mAddr == this.mAddr;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeLong(this.mAddr);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static boolean isMacAddress(byte[] addr) {
        return addr != null && addr.length == 6;
    }

    public static int macAddressType(byte[] addr) {
        if (!MacAddress.isMacAddress(addr)) {
            return 0;
        }
        return MacAddress.fromBytes(addr).getAddressType();
    }

    public static byte[] byteAddrFromStringAddr(String addr) {
        Preconditions.checkNotNull(addr);
        String[] parts = addr.split(":");
        if (parts.length != 6) {
            throw new IllegalArgumentException(addr + " was not a valid MAC address");
        }
        byte[] bytes = new byte[6];
        for (int i = 0; i < 6; ++i) {
            int x = Integer.valueOf(parts[i], 16);
            if (x < 0 || 255 < x) {
                throw new IllegalArgumentException(addr + "was not a valid MAC address");
            }
            bytes[i] = (byte)x;
        }
        return bytes;
    }

    public static String stringAddrFromByteAddr(byte[] addr) {
        if (!MacAddress.isMacAddress(addr)) {
            return null;
        }
        return String.format("%02x:%02x:%02x:%02x:%02x:%02x", addr[0], addr[1], addr[2], addr[3], addr[4], addr[5]);
    }

    private static byte[] byteAddrFromLongAddr(long addr) {
        byte[] bytes = new byte[6];
        int index = 6;
        while (index-- > 0) {
            bytes[index] = (byte)addr;
            addr >>= 8;
        }
        return bytes;
    }

    private static long longAddrFromByteAddr(byte[] addr) {
        Preconditions.checkNotNull(addr);
        if (!MacAddress.isMacAddress(addr)) {
            throw new IllegalArgumentException(Arrays.toString(addr) + " was not a valid MAC address");
        }
        long longAddr = 0L;
        for (byte b : addr) {
            longAddr = (longAddr << 8) + (long)BitUtils.uint8(b);
        }
        return longAddr;
    }

    private static long longAddrFromStringAddr(String addr) {
        Preconditions.checkNotNull(addr);
        String[] parts = addr.split(":");
        if (parts.length != 6) {
            throw new IllegalArgumentException(addr + " was not a valid MAC address");
        }
        long longAddr = 0L;
        for (int i = 0; i < parts.length; ++i) {
            int x = Integer.valueOf(parts[i], 16);
            if (x < 0 || 255 < x) {
                throw new IllegalArgumentException(addr + "was not a valid MAC address");
            }
            longAddr = (long)x + (longAddr << 8);
        }
        return longAddr;
    }

    private static String stringAddrFromLongAddr(long addr) {
        return String.format("%02x:%02x:%02x:%02x:%02x:%02x", addr >> 40 & 0xFFL, addr >> 32 & 0xFFL, addr >> 24 & 0xFFL, addr >> 16 & 0xFFL, addr >> 8 & 0xFFL, addr & 0xFFL);
    }

    public static MacAddress fromString(String addr) {
        return new MacAddress(MacAddress.longAddrFromStringAddr(addr));
    }

    public static MacAddress fromBytes(byte[] addr) {
        return new MacAddress(MacAddress.longAddrFromByteAddr(addr));
    }

    public static MacAddress createRandomUnicastAddressWithGoogleBase() {
        return MacAddress.createRandomUnicastAddress(BASE_GOOGLE_MAC, new SecureRandom());
    }

    public static MacAddress createRandomUnicastAddress() {
        SecureRandom r = new SecureRandom();
        long addr = r.nextLong() & 0xFFFFFFFFFFFFL;
        addr |= LOCALLY_ASSIGNED_MASK;
        return new MacAddress(addr &= MULTICAST_MASK ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static MacAddress createRandomUnicastAddress(MacAddress base, Random r) {
        long addr = base.mAddr & OUI_MASK | NIC_MASK & r.nextLong();
        addr |= LOCALLY_ASSIGNED_MASK;
        return new MacAddress(addr &= MULTICAST_MASK ^ 0xFFFFFFFFFFFFFFFFL);
    }

    private static byte[] addr(int ... in) {
        if (in.length != 6) {
            throw new IllegalArgumentException(Arrays.toString(in) + " was not an array with length equal to " + 6);
        }
        byte[] out = new byte[6];
        for (int i = 0; i < 6; ++i) {
            out[i] = (byte)in[i];
        }
        return out;
    }

    public boolean matches(MacAddress baseAddress, MacAddress mask) {
        Preconditions.checkNotNull(baseAddress);
        Preconditions.checkNotNull(mask);
        return (this.mAddr & mask.mAddr) == (baseAddress.mAddr & mask.mAddr);
    }

    public Inet6Address getLinkLocalIpv6FromEui48Mac() {
        byte[] macEui48Bytes = this.toByteArray();
        byte[] addr = new byte[16];
        addr[0] = -2;
        addr[1] = -128;
        addr[8] = (byte)(macEui48Bytes[0] ^ 2);
        addr[9] = macEui48Bytes[1];
        addr[10] = macEui48Bytes[2];
        addr[11] = -1;
        addr[12] = -2;
        addr[13] = macEui48Bytes[3];
        addr[14] = macEui48Bytes[4];
        addr[15] = macEui48Bytes[5];
        try {
            return Inet6Address.getByAddress(null, addr, 0);
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MacAddressType {
    }
}

