/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.LinkProperties;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.NetworkMisc;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.util.Log;
import com.android.internal.util.AsyncChannel;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class NetworkAgent
extends Handler {
    public final int netId;
    private volatile AsyncChannel mAsyncChannel;
    private final String LOG_TAG;
    private static final boolean DBG = true;
    private static final boolean VDBG = false;
    private final Context mContext;
    private final ArrayList<Message> mPreConnectedQueue = new ArrayList();
    private volatile long mLastBwRefreshTime = 0L;
    private static final long BW_REFRESH_MIN_WIN_MS = 500L;
    private boolean mPollLceScheduled = false;
    private AtomicBoolean mPollLcePending = new AtomicBoolean(false);
    public final int mFactorySerialNumber;
    private static final int BASE = 528384;
    public static final int CMD_SUSPECT_BAD = 528384;
    public static final int EVENT_NETWORK_INFO_CHANGED = 528385;
    public static final int EVENT_NETWORK_CAPABILITIES_CHANGED = 528386;
    public static final int EVENT_NETWORK_PROPERTIES_CHANGED = 528387;
    public static final int WIFI_BASE_SCORE = 60;
    public static final int EVENT_NETWORK_SCORE_CHANGED = 528388;
    public static final int CMD_REPORT_NETWORK_STATUS = 528391;
    public static final int VALID_NETWORK = 1;
    public static final int INVALID_NETWORK = 2;
    public static String REDIRECT_URL_KEY = "redirect URL";
    public static final int EVENT_SET_EXPLICITLY_SELECTED = 528392;
    public static final int CMD_SAVE_ACCEPT_UNVALIDATED = 528393;
    public static final int CMD_REQUEST_BANDWIDTH_UPDATE = 528394;
    public static final int CMD_START_SOCKET_KEEPALIVE = 528395;
    public static final int CMD_STOP_SOCKET_KEEPALIVE = 528396;
    public static final int EVENT_SOCKET_KEEPALIVE = 528397;
    public static final int CMD_ADD_KEEPALIVE_PACKET_FILTER = 528400;
    public static final int CMD_REMOVE_KEEPALIVE_PACKET_FILTER = 528401;
    public static final int CMD_SET_SIGNAL_STRENGTH_THRESHOLDS = 528398;
    public static final int CMD_PREVENT_AUTOMATIC_RECONNECT = 528399;

    public NetworkAgent(Looper looper, Context context, String logTag, NetworkInfo ni, NetworkCapabilities nc, LinkProperties lp, int score) {
        this(looper, context, logTag, ni, nc, lp, score, null, -1);
    }

    public NetworkAgent(Looper looper, Context context, String logTag, NetworkInfo ni, NetworkCapabilities nc, LinkProperties lp, int score, NetworkMisc misc) {
        this(looper, context, logTag, ni, nc, lp, score, misc, -1);
    }

    public NetworkAgent(Looper looper, Context context, String logTag, NetworkInfo ni, NetworkCapabilities nc, LinkProperties lp, int score, int factorySerialNumber) {
        this(looper, context, logTag, ni, nc, lp, score, null, factorySerialNumber);
    }

    public NetworkAgent(Looper looper, Context context, String logTag, NetworkInfo ni, NetworkCapabilities nc, LinkProperties lp, int score, NetworkMisc misc, int factorySerialNumber) {
        super(looper);
        this.LOG_TAG = logTag;
        this.mContext = context;
        this.mFactorySerialNumber = factorySerialNumber;
        if (ni == null || nc == null || lp == null) {
            throw new IllegalArgumentException();
        }
        ConnectivityManager cm = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        this.netId = cm.registerNetworkAgent(new Messenger(this), new NetworkInfo(ni), new LinkProperties(lp), new NetworkCapabilities(nc), score, misc, factorySerialNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 69633: {
                if (this.mAsyncChannel != null) {
                    this.log("Received new connection while already connected!");
                    break;
                }
                AsyncChannel ac = new AsyncChannel();
                ac.connected(null, this, msg.replyTo);
                ac.replyToMessage(msg, 69634, 0);
                ArrayList<Message> arrayList = this.mPreConnectedQueue;
                synchronized (arrayList) {
                    this.mAsyncChannel = ac;
                    for (Message m : this.mPreConnectedQueue) {
                        ac.sendMessage(m);
                    }
                    this.mPreConnectedQueue.clear();
                    break;
                }
            }
            case 69635: {
                if (this.mAsyncChannel == null) break;
                this.mAsyncChannel.disconnect();
                break;
            }
            case 69636: {
                this.log("NetworkAgent channel lost");
                this.unwanted();
                ArrayList<Message> ac = this.mPreConnectedQueue;
                synchronized (ac) {
                    this.mAsyncChannel = null;
                    break;
                }
            }
            case 528384: {
                this.log("Unhandled Message " + msg);
                break;
            }
            case 528394: {
                long currentTimeMs = System.currentTimeMillis();
                if (currentTimeMs >= this.mLastBwRefreshTime + 500L) {
                    this.mPollLceScheduled = false;
                    if (this.mPollLcePending.getAndSet(true)) break;
                    this.pollLceData();
                    break;
                }
                if (this.mPollLceScheduled) break;
                long waitTime = this.mLastBwRefreshTime + 500L - currentTimeMs + 1L;
                this.mPollLceScheduled = this.sendEmptyMessageDelayed(528394, waitTime);
                break;
            }
            case 528391: {
                String redirectUrl = ((Bundle)msg.obj).getString(REDIRECT_URL_KEY);
                this.networkStatus(msg.arg1, redirectUrl);
                break;
            }
            case 528393: {
                this.saveAcceptUnvalidated(msg.arg1 != 0);
                break;
            }
            case 528395: {
                this.startSocketKeepalive(msg);
                break;
            }
            case 528396: {
                this.stopSocketKeepalive(msg);
                break;
            }
            case 528398: {
                ArrayList<Integer> thresholds = ((Bundle)msg.obj).getIntegerArrayList("thresholds");
                int[] intThresholds = new int[thresholds != null ? thresholds.size() : 0];
                for (int i = 0; i < intThresholds.length; ++i) {
                    intThresholds[i] = thresholds.get(i);
                }
                this.setSignalStrengthThresholds(intThresholds);
                break;
            }
            case 528399: {
                this.preventAutomaticReconnect();
                break;
            }
            case 528400: {
                this.addKeepalivePacketFilter(msg);
                break;
            }
            case 528401: {
                this.removeKeepalivePacketFilter(msg);
            }
        }
    }

    private void queueOrSendMessage(int what, Object obj) {
        this.queueOrSendMessage(what, 0, 0, obj);
    }

    private void queueOrSendMessage(int what, int arg1, int arg2) {
        this.queueOrSendMessage(what, arg1, arg2, null);
    }

    private void queueOrSendMessage(int what, int arg1, int arg2, Object obj) {
        Message msg = Message.obtain();
        msg.what = what;
        msg.arg1 = arg1;
        msg.arg2 = arg2;
        msg.obj = obj;
        this.queueOrSendMessage(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueOrSendMessage(Message msg) {
        ArrayList<Message> arrayList = this.mPreConnectedQueue;
        synchronized (arrayList) {
            if (this.mAsyncChannel != null) {
                this.mAsyncChannel.sendMessage(msg);
            } else {
                this.mPreConnectedQueue.add(msg);
            }
        }
    }

    public void sendLinkProperties(LinkProperties linkProperties) {
        this.queueOrSendMessage(528387, new LinkProperties(linkProperties));
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public void sendNetworkInfo(NetworkInfo networkInfo) {
        this.queueOrSendMessage(528385, new NetworkInfo(networkInfo));
    }

    public void sendNetworkCapabilities(NetworkCapabilities networkCapabilities) {
        this.mPollLcePending.set(false);
        this.mLastBwRefreshTime = System.currentTimeMillis();
        this.queueOrSendMessage(528386, new NetworkCapabilities(networkCapabilities));
    }

    public void sendNetworkScore(int score) {
        if (score < 0) {
            throw new IllegalArgumentException("Score must be >= 0");
        }
        this.queueOrSendMessage(528388, score, 0);
    }

    public void explicitlySelected(boolean acceptUnvalidated) {
        this.explicitlySelected(true, acceptUnvalidated);
    }

    public void explicitlySelected(boolean explicitlySelected, boolean acceptUnvalidated) {
        this.queueOrSendMessage(528392, explicitlySelected ? 1 : 0, acceptUnvalidated ? 1 : 0);
    }

    protected abstract void unwanted();

    protected void pollLceData() {
    }

    protected void networkStatus(int status, String redirectUrl) {
    }

    protected void saveAcceptUnvalidated(boolean accept) {
    }

    protected void startSocketKeepalive(Message msg) {
        this.onSocketKeepaliveEvent(msg.arg1, -30);
    }

    protected void stopSocketKeepalive(Message msg) {
        this.onSocketKeepaliveEvent(msg.arg1, -30);
    }

    public void onSocketKeepaliveEvent(int slot, int reason) {
        this.queueOrSendMessage(528397, slot, reason);
    }

    protected void addKeepalivePacketFilter(Message msg) {
    }

    protected void removeKeepalivePacketFilter(Message msg) {
    }

    protected void setSignalStrengthThresholds(int[] thresholds) {
    }

    protected void preventAutomaticReconnect() {
    }

    protected void log(String s) {
        Log.d(this.LOG_TAG, "NetworkAgent: " + s);
    }
}

