/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.annotation.SystemApi;
import android.annotation.UnsupportedAppUsage;
import android.net.MatchAllNetworkSpecifier;
import android.net.NetworkSpecifier;
import android.net.TransportInfo;
import android.net.UidRange;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.ArraySet;
import android.util.proto.ProtoOutputStream;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.BitUtils;
import com.android.internal.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;

public final class NetworkCapabilities
implements Parcelable {
    private static final String TAG = "NetworkCapabilities";
    private static final int INVALID_UID = -1;
    @UnsupportedAppUsage
    private long mNetworkCapabilities;
    private long mUnwantedNetworkCapabilities;
    public static final int NET_CAPABILITY_MMS = 0;
    public static final int NET_CAPABILITY_SUPL = 1;
    public static final int NET_CAPABILITY_DUN = 2;
    public static final int NET_CAPABILITY_FOTA = 3;
    public static final int NET_CAPABILITY_IMS = 4;
    public static final int NET_CAPABILITY_CBS = 5;
    public static final int NET_CAPABILITY_WIFI_P2P = 6;
    public static final int NET_CAPABILITY_IA = 7;
    public static final int NET_CAPABILITY_RCS = 8;
    public static final int NET_CAPABILITY_XCAP = 9;
    public static final int NET_CAPABILITY_EIMS = 10;
    public static final int NET_CAPABILITY_NOT_METERED = 11;
    public static final int NET_CAPABILITY_INTERNET = 12;
    public static final int NET_CAPABILITY_NOT_RESTRICTED = 13;
    public static final int NET_CAPABILITY_TRUSTED = 14;
    public static final int NET_CAPABILITY_NOT_VPN = 15;
    public static final int NET_CAPABILITY_VALIDATED = 16;
    public static final int NET_CAPABILITY_CAPTIVE_PORTAL = 17;
    public static final int NET_CAPABILITY_NOT_ROAMING = 18;
    public static final int NET_CAPABILITY_FOREGROUND = 19;
    public static final int NET_CAPABILITY_NOT_CONGESTED = 20;
    public static final int NET_CAPABILITY_NOT_SUSPENDED = 21;
    @SystemApi
    public static final int NET_CAPABILITY_OEM_PAID = 22;
    public static final int NET_CAPABILITY_MCX = 23;
    @SystemApi
    public static final int NET_CAPABILITY_PARTIAL_CONNECTIVITY = 24;
    private static final int MIN_NET_CAPABILITY = 0;
    private static final int MAX_NET_CAPABILITY = 24;
    private static final long MUTABLE_CAPABILITIES = 20922368L;
    private static final long NON_REQUESTABLE_CAPABILITIES = 20905984L;
    private static final long DEFAULT_CAPABILITIES = 57344L;
    @VisibleForTesting
    static final long RESTRICTED_CAPABILITIES = 8390588L;
    private static final long FORCE_RESTRICTED_CAPABILITIES = 0x400000L;
    @VisibleForTesting
    static final long UNRESTRICTED_CAPABILITIES = 4163L;
    private static final long CONNECTIVITY_MANAGED_CAPABILITIES = 0x10B0000L;
    private long mTransportTypes;
    public static final int TRANSPORT_CELLULAR = 0;
    public static final int TRANSPORT_WIFI = 1;
    public static final int TRANSPORT_BLUETOOTH = 2;
    public static final int TRANSPORT_ETHERNET = 3;
    public static final int TRANSPORT_VPN = 4;
    public static final int TRANSPORT_WIFI_AWARE = 5;
    public static final int TRANSPORT_LOWPAN = 6;
    public static final int TRANSPORT_TEST = 7;
    public static final int MIN_TRANSPORT = 0;
    public static final int MAX_TRANSPORT = 7;
    private static final String[] TRANSPORT_NAMES = new String[]{"CELLULAR", "WIFI", "BLUETOOTH", "ETHERNET", "VPN", "WIFI_AWARE", "LOWPAN", "TEST"};
    private int mEstablishingVpnAppUid = -1;
    public static final int LINK_BANDWIDTH_UNSPECIFIED = 0;
    private int mLinkUpBandwidthKbps = 0;
    private int mLinkDownBandwidthKbps = 0;
    private NetworkSpecifier mNetworkSpecifier = null;
    private TransportInfo mTransportInfo = null;
    public static final int SIGNAL_STRENGTH_UNSPECIFIED = Integer.MIN_VALUE;
    @UnsupportedAppUsage(maxTargetSdk=28)
    private int mSignalStrength = Integer.MIN_VALUE;
    private ArraySet<UidRange> mUids = null;
    private String mSSID;
    public static final Parcelable.Creator<NetworkCapabilities> CREATOR = new Parcelable.Creator<NetworkCapabilities>(){

        @Override
        public NetworkCapabilities createFromParcel(Parcel in) {
            NetworkCapabilities netCap = new NetworkCapabilities();
            netCap.mNetworkCapabilities = in.readLong();
            netCap.mUnwantedNetworkCapabilities = in.readLong();
            netCap.mTransportTypes = in.readLong();
            netCap.mLinkUpBandwidthKbps = in.readInt();
            netCap.mLinkDownBandwidthKbps = in.readInt();
            netCap.mNetworkSpecifier = (NetworkSpecifier)in.readParcelable(null);
            netCap.mTransportInfo = (TransportInfo)in.readParcelable(null);
            netCap.mSignalStrength = in.readInt();
            netCap.mUids = in.readArraySet(null);
            netCap.mSSID = in.readString();
            return netCap;
        }

        public NetworkCapabilities[] newArray(int size) {
            return new NetworkCapabilities[size];
        }
    };

    @UnsupportedAppUsage
    public NetworkCapabilities() {
        this.clearAll();
        this.mNetworkCapabilities = 57344L;
    }

    public NetworkCapabilities(NetworkCapabilities nc) {
        if (nc != null) {
            this.set(nc);
        }
    }

    public void clearAll() {
        this.mUnwantedNetworkCapabilities = 0L;
        this.mTransportTypes = 0L;
        this.mNetworkCapabilities = 0L;
        this.mLinkDownBandwidthKbps = 0;
        this.mLinkUpBandwidthKbps = 0;
        this.mNetworkSpecifier = null;
        this.mTransportInfo = null;
        this.mSignalStrength = Integer.MIN_VALUE;
        this.mUids = null;
        this.mEstablishingVpnAppUid = -1;
        this.mSSID = null;
    }

    public void set(NetworkCapabilities nc) {
        this.mNetworkCapabilities = nc.mNetworkCapabilities;
        this.mTransportTypes = nc.mTransportTypes;
        this.mLinkUpBandwidthKbps = nc.mLinkUpBandwidthKbps;
        this.mLinkDownBandwidthKbps = nc.mLinkDownBandwidthKbps;
        this.mNetworkSpecifier = nc.mNetworkSpecifier;
        this.mTransportInfo = nc.mTransportInfo;
        this.mSignalStrength = nc.mSignalStrength;
        this.setUids(nc.mUids);
        this.mEstablishingVpnAppUid = nc.mEstablishingVpnAppUid;
        this.mUnwantedNetworkCapabilities = nc.mUnwantedNetworkCapabilities;
        this.mSSID = nc.mSSID;
    }

    @UnsupportedAppUsage
    public NetworkCapabilities addCapability(int capability) {
        NetworkCapabilities.checkValidCapability(capability);
        this.mNetworkCapabilities |= (long)(1 << capability);
        this.mUnwantedNetworkCapabilities &= (long)(~(1 << capability));
        return this;
    }

    public void addUnwantedCapability(int capability) {
        NetworkCapabilities.checkValidCapability(capability);
        this.mUnwantedNetworkCapabilities |= (long)(1 << capability);
        this.mNetworkCapabilities &= (long)(~(1 << capability));
    }

    @UnsupportedAppUsage
    public NetworkCapabilities removeCapability(int capability) {
        NetworkCapabilities.checkValidCapability(capability);
        long mask = ~(1 << capability);
        this.mNetworkCapabilities &= mask;
        this.mUnwantedNetworkCapabilities &= mask;
        return this;
    }

    public NetworkCapabilities setCapability(int capability, boolean value) {
        if (value) {
            this.addCapability(capability);
        } else {
            this.removeCapability(capability);
        }
        return this;
    }

    public int[] getCapabilities() {
        return BitUtils.unpackBits(this.mNetworkCapabilities);
    }

    public int[] getUnwantedCapabilities() {
        return BitUtils.unpackBits(this.mUnwantedNetworkCapabilities);
    }

    public void setCapabilities(int[] capabilities, int[] unwantedCapabilities) {
        this.mNetworkCapabilities = BitUtils.packBits(capabilities);
        this.mUnwantedNetworkCapabilities = BitUtils.packBits(unwantedCapabilities);
    }

    @Deprecated
    public void setCapabilities(int[] capabilities) {
        this.setCapabilities(capabilities, new int[0]);
    }

    public boolean hasCapability(int capability) {
        return NetworkCapabilities.isValidCapability(capability) && (this.mNetworkCapabilities & (long)(1 << capability)) != 0L;
    }

    public boolean hasUnwantedCapability(int capability) {
        return NetworkCapabilities.isValidCapability(capability) && (this.mUnwantedNetworkCapabilities & (long)(1 << capability)) != 0L;
    }

    public boolean hasConnectivityManagedCapability() {
        return (this.mNetworkCapabilities & 0x10B0000L) != 0L;
    }

    private void combineNetCapabilities(NetworkCapabilities nc) {
        this.mNetworkCapabilities |= nc.mNetworkCapabilities;
        this.mUnwantedNetworkCapabilities |= nc.mUnwantedNetworkCapabilities;
    }

    public String describeFirstNonRequestableCapability() {
        long nonRequestable = (this.mNetworkCapabilities | this.mUnwantedNetworkCapabilities) & 0x13F0000L;
        if (nonRequestable != 0L) {
            return NetworkCapabilities.capabilityNameOf(BitUtils.unpackBits(nonRequestable)[0]);
        }
        if (this.mLinkUpBandwidthKbps != 0 || this.mLinkDownBandwidthKbps != 0) {
            return "link bandwidth";
        }
        if (this.hasSignalStrength()) {
            return "signalStrength";
        }
        return null;
    }

    private boolean satisfiedByNetCapabilities(NetworkCapabilities nc, boolean onlyImmutable) {
        long requestedCapabilities = this.mNetworkCapabilities;
        long requestedUnwantedCapabilities = this.mUnwantedNetworkCapabilities;
        long providedCapabilities = nc.mNetworkCapabilities;
        if (onlyImmutable) {
            requestedCapabilities &= 0xFFFFFFFFFEC0BFFFL;
            requestedUnwantedCapabilities &= 0xFFFFFFFFFEC0BFFFL;
        }
        return (providedCapabilities & requestedCapabilities) == requestedCapabilities && (requestedUnwantedCapabilities & providedCapabilities) == 0L;
    }

    public boolean equalsNetCapabilities(NetworkCapabilities nc) {
        return nc.mNetworkCapabilities == this.mNetworkCapabilities && nc.mUnwantedNetworkCapabilities == this.mUnwantedNetworkCapabilities;
    }

    private boolean equalsNetCapabilitiesRequestable(NetworkCapabilities that) {
        return (this.mNetworkCapabilities & 0xFFFFFFFFFEC0FFFFL) == (that.mNetworkCapabilities & 0xFFFFFFFFFEC0FFFFL) && (this.mUnwantedNetworkCapabilities & 0xFFFFFFFFFEC0FFFFL) == (that.mUnwantedNetworkCapabilities & 0xFFFFFFFFFEC0FFFFL);
    }

    public void maybeMarkCapabilitiesRestricted() {
        boolean hasRestrictedCapabilities;
        boolean forceRestrictedCapability = (this.mNetworkCapabilities & 0x400000L) != 0L;
        boolean hasUnrestrictedCapabilities = (this.mNetworkCapabilities & 0x1043L) != 0L;
        boolean bl = hasRestrictedCapabilities = (this.mNetworkCapabilities & 0x8007BCL) != 0L;
        if (forceRestrictedCapability || hasRestrictedCapabilities && !hasUnrestrictedCapabilities) {
            this.removeCapability(13);
        }
    }

    public static boolean isValidTransport(int transportType) {
        return 0 <= transportType && transportType <= 7;
    }

    @UnsupportedAppUsage
    public NetworkCapabilities addTransportType(int transportType) {
        NetworkCapabilities.checkValidTransportType(transportType);
        this.mTransportTypes |= (long)(1 << transportType);
        this.setNetworkSpecifier(this.mNetworkSpecifier);
        return this;
    }

    public NetworkCapabilities removeTransportType(int transportType) {
        NetworkCapabilities.checkValidTransportType(transportType);
        this.mTransportTypes &= (long)(~(1 << transportType));
        this.setNetworkSpecifier(this.mNetworkSpecifier);
        return this;
    }

    public NetworkCapabilities setTransportType(int transportType, boolean value) {
        if (value) {
            this.addTransportType(transportType);
        } else {
            this.removeTransportType(transportType);
        }
        return this;
    }

    @SystemApi
    public int[] getTransportTypes() {
        return BitUtils.unpackBits(this.mTransportTypes);
    }

    public void setTransportTypes(int[] transportTypes) {
        this.mTransportTypes = BitUtils.packBits(transportTypes);
    }

    public boolean hasTransport(int transportType) {
        return NetworkCapabilities.isValidTransport(transportType) && (this.mTransportTypes & (long)(1 << transportType)) != 0L;
    }

    private void combineTransportTypes(NetworkCapabilities nc) {
        this.mTransportTypes |= nc.mTransportTypes;
    }

    private boolean satisfiedByTransportTypes(NetworkCapabilities nc) {
        return this.mTransportTypes == 0L || (this.mTransportTypes & nc.mTransportTypes) != 0L;
    }

    public boolean equalsTransportTypes(NetworkCapabilities nc) {
        return nc.mTransportTypes == this.mTransportTypes;
    }

    public void setEstablishingVpnAppUid(int uid) {
        this.mEstablishingVpnAppUid = uid;
    }

    public int getEstablishingVpnAppUid() {
        return this.mEstablishingVpnAppUid;
    }

    public NetworkCapabilities setLinkUpstreamBandwidthKbps(int upKbps) {
        this.mLinkUpBandwidthKbps = upKbps;
        return this;
    }

    public int getLinkUpstreamBandwidthKbps() {
        return this.mLinkUpBandwidthKbps;
    }

    public NetworkCapabilities setLinkDownstreamBandwidthKbps(int downKbps) {
        this.mLinkDownBandwidthKbps = downKbps;
        return this;
    }

    public int getLinkDownstreamBandwidthKbps() {
        return this.mLinkDownBandwidthKbps;
    }

    private void combineLinkBandwidths(NetworkCapabilities nc) {
        this.mLinkUpBandwidthKbps = Math.max(this.mLinkUpBandwidthKbps, nc.mLinkUpBandwidthKbps);
        this.mLinkDownBandwidthKbps = Math.max(this.mLinkDownBandwidthKbps, nc.mLinkDownBandwidthKbps);
    }

    private boolean satisfiedByLinkBandwidths(NetworkCapabilities nc) {
        return this.mLinkUpBandwidthKbps <= nc.mLinkUpBandwidthKbps && this.mLinkDownBandwidthKbps <= nc.mLinkDownBandwidthKbps;
    }

    private boolean equalsLinkBandwidths(NetworkCapabilities nc) {
        return this.mLinkUpBandwidthKbps == nc.mLinkUpBandwidthKbps && this.mLinkDownBandwidthKbps == nc.mLinkDownBandwidthKbps;
    }

    public static int minBandwidth(int a, int b) {
        if (a == 0) {
            return b;
        }
        if (b == 0) {
            return a;
        }
        return Math.min(a, b);
    }

    public static int maxBandwidth(int a, int b) {
        return Math.max(a, b);
    }

    public NetworkCapabilities setNetworkSpecifier(NetworkSpecifier networkSpecifier) {
        if (networkSpecifier != null && Long.bitCount(this.mTransportTypes) != 1) {
            throw new IllegalStateException("Must have a single transport specified to use setNetworkSpecifier");
        }
        this.mNetworkSpecifier = networkSpecifier;
        return this;
    }

    public NetworkCapabilities setTransportInfo(TransportInfo transportInfo) {
        this.mTransportInfo = transportInfo;
        return this;
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public NetworkSpecifier getNetworkSpecifier() {
        return this.mNetworkSpecifier;
    }

    public TransportInfo getTransportInfo() {
        return this.mTransportInfo;
    }

    private void combineSpecifiers(NetworkCapabilities nc) {
        if (this.mNetworkSpecifier != null && !this.mNetworkSpecifier.equals(nc.mNetworkSpecifier)) {
            throw new IllegalStateException("Can't combine two networkSpecifiers");
        }
        this.setNetworkSpecifier(nc.mNetworkSpecifier);
    }

    private boolean satisfiedBySpecifier(NetworkCapabilities nc) {
        return this.mNetworkSpecifier == null || this.mNetworkSpecifier.satisfiedBy(nc.mNetworkSpecifier) || nc.mNetworkSpecifier instanceof MatchAllNetworkSpecifier;
    }

    private boolean equalsSpecifier(NetworkCapabilities nc) {
        return Objects.equals(this.mNetworkSpecifier, nc.mNetworkSpecifier);
    }

    private void combineTransportInfos(NetworkCapabilities nc) {
        if (this.mTransportInfo != null && !this.mTransportInfo.equals(nc.mTransportInfo)) {
            throw new IllegalStateException("Can't combine two TransportInfos");
        }
        this.setTransportInfo(nc.mTransportInfo);
    }

    private boolean equalsTransportInfo(NetworkCapabilities nc) {
        return Objects.equals(this.mTransportInfo, nc.mTransportInfo);
    }

    @UnsupportedAppUsage
    public NetworkCapabilities setSignalStrength(int signalStrength) {
        this.mSignalStrength = signalStrength;
        return this;
    }

    @UnsupportedAppUsage
    public boolean hasSignalStrength() {
        return this.mSignalStrength > Integer.MIN_VALUE;
    }

    public int getSignalStrength() {
        return this.mSignalStrength;
    }

    private void combineSignalStrength(NetworkCapabilities nc) {
        this.mSignalStrength = Math.max(this.mSignalStrength, nc.mSignalStrength);
    }

    private boolean satisfiedBySignalStrength(NetworkCapabilities nc) {
        return this.mSignalStrength <= nc.mSignalStrength;
    }

    private boolean equalsSignalStrength(NetworkCapabilities nc) {
        return this.mSignalStrength == nc.mSignalStrength;
    }

    public NetworkCapabilities setSingleUid(int uid) {
        ArraySet<UidRange> identity = new ArraySet<UidRange>(1);
        identity.add(new UidRange(uid, uid));
        this.setUids(identity);
        return this;
    }

    public NetworkCapabilities setUids(Set<UidRange> uids) {
        this.mUids = null == uids ? null : new ArraySet<UidRange>(uids);
        return this;
    }

    public Set<UidRange> getUids() {
        return null == this.mUids ? null : new ArraySet<UidRange>(this.mUids);
    }

    public boolean appliesToUid(int uid) {
        if (null == this.mUids) {
            return true;
        }
        for (UidRange range : this.mUids) {
            if (!range.contains(uid)) continue;
            return true;
        }
        return false;
    }

    @VisibleForTesting
    public boolean equalsUids(NetworkCapabilities nc) {
        ArraySet<UidRange> comparedUids = nc.mUids;
        if (null == comparedUids) {
            return null == this.mUids;
        }
        if (null == this.mUids) {
            return false;
        }
        ArraySet<UidRange> uids = new ArraySet<UidRange>(this.mUids);
        for (UidRange range : comparedUids) {
            if (!uids.contains(range)) {
                return false;
            }
            uids.remove(range);
        }
        return uids.isEmpty();
    }

    public boolean satisfiedByUids(NetworkCapabilities nc) {
        if (null == nc.mUids || null == this.mUids) {
            return true;
        }
        for (UidRange requiredRange : this.mUids) {
            if (requiredRange.contains(nc.mEstablishingVpnAppUid)) {
                return true;
            }
            if (nc.appliesToUidRange(requiredRange)) continue;
            return false;
        }
        return true;
    }

    @VisibleForTesting
    public boolean appliesToUidRange(UidRange requiredRange) {
        if (null == this.mUids) {
            return true;
        }
        for (UidRange uidRange : this.mUids) {
            if (!uidRange.containsRange(requiredRange)) continue;
            return true;
        }
        return false;
    }

    private void combineUids(NetworkCapabilities nc) {
        if (null == nc.mUids || null == this.mUids) {
            this.mUids = null;
            return;
        }
        this.mUids.addAll(nc.mUids);
    }

    public NetworkCapabilities setSSID(String ssid) {
        this.mSSID = ssid;
        return this;
    }

    public String getSSID() {
        return this.mSSID;
    }

    public boolean equalsSSID(NetworkCapabilities nc) {
        return Objects.equals(this.mSSID, nc.mSSID);
    }

    public boolean satisfiedBySSID(NetworkCapabilities nc) {
        return this.mSSID == null || this.mSSID.equals(nc.mSSID);
    }

    private void combineSSIDs(NetworkCapabilities nc) {
        if (this.mSSID != null && !this.mSSID.equals(nc.mSSID)) {
            throw new IllegalStateException("Can't combine two SSIDs");
        }
        this.setSSID(nc.mSSID);
    }

    public void combineCapabilities(NetworkCapabilities nc) {
        this.combineNetCapabilities(nc);
        this.combineTransportTypes(nc);
        this.combineLinkBandwidths(nc);
        this.combineSpecifiers(nc);
        this.combineTransportInfos(nc);
        this.combineSignalStrength(nc);
        this.combineUids(nc);
        this.combineSSIDs(nc);
    }

    private boolean satisfiedByNetworkCapabilities(NetworkCapabilities nc, boolean onlyImmutable) {
        return !(nc == null || !this.satisfiedByNetCapabilities(nc, onlyImmutable) || !this.satisfiedByTransportTypes(nc) || !onlyImmutable && !this.satisfiedByLinkBandwidths(nc) || !this.satisfiedBySpecifier(nc) || !onlyImmutable && !this.satisfiedBySignalStrength(nc) || !onlyImmutable && !this.satisfiedByUids(nc) || !onlyImmutable && !this.satisfiedBySSID(nc));
    }

    @SystemApi
    public boolean satisfiedByNetworkCapabilities(NetworkCapabilities nc) {
        return this.satisfiedByNetworkCapabilities(nc, false);
    }

    public boolean satisfiedByImmutableNetworkCapabilities(NetworkCapabilities nc) {
        return this.satisfiedByNetworkCapabilities(nc, true);
    }

    public String describeImmutableDifferences(NetworkCapabilities that) {
        Object after;
        Object before;
        if (that == null) {
            return "other NetworkCapabilities was null";
        }
        StringJoiner joiner = new StringJoiner(", ");
        long mask = -20924417L;
        long oldImmutableCapabilities = this.mNetworkCapabilities & 0xFFFFFFFFFEC0B7FFL;
        long newImmutableCapabilities = that.mNetworkCapabilities & 0xFFFFFFFFFEC0B7FFL;
        if (oldImmutableCapabilities != newImmutableCapabilities) {
            before = NetworkCapabilities.capabilityNamesOf(BitUtils.unpackBits(oldImmutableCapabilities));
            after = NetworkCapabilities.capabilityNamesOf(BitUtils.unpackBits(newImmutableCapabilities));
            joiner.add(String.format("immutable capabilities changed: %s -> %s", before, after));
        }
        if (!this.equalsSpecifier(that)) {
            before = this.getNetworkSpecifier();
            after = that.getNetworkSpecifier();
            joiner.add(String.format("specifier changed: %s -> %s", before, after));
        }
        if (!this.equalsTransportTypes(that)) {
            before = NetworkCapabilities.transportNamesOf(this.getTransportTypes());
            after = NetworkCapabilities.transportNamesOf(that.getTransportTypes());
            joiner.add(String.format("transports changed: %s -> %s", before, after));
        }
        return joiner.toString();
    }

    public boolean equalRequestableCapabilities(NetworkCapabilities nc) {
        if (nc == null) {
            return false;
        }
        return this.equalsNetCapabilitiesRequestable(nc) && this.equalsTransportTypes(nc) && this.equalsSpecifier(nc);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof NetworkCapabilities)) {
            return false;
        }
        NetworkCapabilities that = (NetworkCapabilities)obj;
        return this.equalsNetCapabilities(that) && this.equalsTransportTypes(that) && this.equalsLinkBandwidths(that) && this.equalsSignalStrength(that) && this.equalsSpecifier(that) && this.equalsTransportInfo(that) && this.equalsUids(that) && this.equalsSSID(that);
    }

    public int hashCode() {
        return (int)(this.mNetworkCapabilities & 0xFFFFFFFFFFFFFFFFL) + (int)(this.mNetworkCapabilities >> 32) * 3 + (int)(this.mUnwantedNetworkCapabilities & 0xFFFFFFFFFFFFFFFFL) * 5 + (int)(this.mUnwantedNetworkCapabilities >> 32) * 7 + (int)(this.mTransportTypes & 0xFFFFFFFFFFFFFFFFL) * 11 + (int)(this.mTransportTypes >> 32) * 13 + this.mLinkUpBandwidthKbps * 17 + this.mLinkDownBandwidthKbps * 19 + Objects.hashCode(this.mNetworkSpecifier) * 23 + this.mSignalStrength * 29 + Objects.hashCode(this.mUids) * 31 + Objects.hashCode(this.mSSID) * 37 + Objects.hashCode(this.mTransportInfo) * 41;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.mNetworkCapabilities);
        dest.writeLong(this.mUnwantedNetworkCapabilities);
        dest.writeLong(this.mTransportTypes);
        dest.writeInt(this.mLinkUpBandwidthKbps);
        dest.writeInt(this.mLinkDownBandwidthKbps);
        dest.writeParcelable((Parcelable)((Object)this.mNetworkSpecifier), flags);
        dest.writeParcelable((Parcelable)((Object)this.mTransportInfo), flags);
        dest.writeInt(this.mSignalStrength);
        dest.writeArraySet(this.mUids);
        dest.writeString(this.mSSID);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        if (0L != this.mTransportTypes) {
            sb.append(" Transports: ");
            NetworkCapabilities.appendStringRepresentationOfBitMaskToStringBuilder(sb, this.mTransportTypes, NetworkCapabilities::transportNameOf, "|");
        }
        if (0L != this.mNetworkCapabilities) {
            sb.append(" Capabilities: ");
            NetworkCapabilities.appendStringRepresentationOfBitMaskToStringBuilder(sb, this.mNetworkCapabilities, NetworkCapabilities::capabilityNameOf, "&");
        }
        if (0L != this.mUnwantedNetworkCapabilities) {
            sb.append(" Unwanted: ");
            NetworkCapabilities.appendStringRepresentationOfBitMaskToStringBuilder(sb, this.mUnwantedNetworkCapabilities, NetworkCapabilities::capabilityNameOf, "&");
        }
        if (this.mLinkUpBandwidthKbps > 0) {
            sb.append(" LinkUpBandwidth>=").append(this.mLinkUpBandwidthKbps).append("Kbps");
        }
        if (this.mLinkDownBandwidthKbps > 0) {
            sb.append(" LinkDnBandwidth>=").append(this.mLinkDownBandwidthKbps).append("Kbps");
        }
        if (this.mNetworkSpecifier != null) {
            sb.append(" Specifier: <").append(this.mNetworkSpecifier).append(">");
        }
        if (this.mTransportInfo != null) {
            sb.append(" TransportInfo: <").append(this.mTransportInfo).append(">");
        }
        if (this.hasSignalStrength()) {
            sb.append(" SignalStrength: ").append(this.mSignalStrength);
        }
        if (null != this.mUids) {
            if (1 == this.mUids.size() && this.mUids.valueAt(0).count() == 1) {
                sb.append(" Uid: ").append(this.mUids.valueAt((int)0).start);
            } else {
                sb.append(" Uids: <").append(this.mUids).append(">");
            }
        }
        if (this.mEstablishingVpnAppUid != -1) {
            sb.append(" EstablishingAppUid: ").append(this.mEstablishingVpnAppUid);
        }
        if (null != this.mSSID) {
            sb.append(" SSID: ").append(this.mSSID);
        }
        sb.append("]");
        return sb.toString();
    }

    public static void appendStringRepresentationOfBitMaskToStringBuilder(StringBuilder sb, long bitMask, NameOf nameFetcher, String separator) {
        int bitPos = 0;
        boolean firstElementAdded = false;
        while (bitMask != 0L) {
            if ((bitMask & 1L) != 0L) {
                if (firstElementAdded) {
                    sb.append(separator);
                } else {
                    firstElementAdded = true;
                }
                sb.append(nameFetcher.nameOf(bitPos));
            }
            bitMask >>= 1;
            ++bitPos;
        }
    }

    public void writeToProto(ProtoOutputStream proto, long fieldId) {
        long token = proto.start(fieldId);
        for (int transport : this.getTransportTypes()) {
            proto.write(2259152797697L, transport);
        }
        for (int capability : this.getCapabilities()) {
            proto.write(0x20E00000002L, capability);
        }
        proto.write(1120986464259L, this.mLinkUpBandwidthKbps);
        proto.write(1120986464260L, this.mLinkDownBandwidthKbps);
        if (this.mNetworkSpecifier != null) {
            proto.write(1138166333445L, this.mNetworkSpecifier.toString());
        }
        if (this.mTransportInfo != null) {
            // empty if block
        }
        proto.write(1133871366150L, this.hasSignalStrength());
        proto.write(0x11100000007L, this.mSignalStrength);
        proto.end(token);
    }

    public static String capabilityNamesOf(int[] capabilities) {
        StringJoiner joiner = new StringJoiner("|");
        if (capabilities != null) {
            for (int c : capabilities) {
                joiner.add(NetworkCapabilities.capabilityNameOf(c));
            }
        }
        return joiner.toString();
    }

    public static String capabilityNameOf(int capability) {
        switch (capability) {
            case 0: {
                return "MMS";
            }
            case 1: {
                return "SUPL";
            }
            case 2: {
                return "DUN";
            }
            case 3: {
                return "FOTA";
            }
            case 4: {
                return "IMS";
            }
            case 5: {
                return "CBS";
            }
            case 6: {
                return "WIFI_P2P";
            }
            case 7: {
                return "IA";
            }
            case 8: {
                return "RCS";
            }
            case 9: {
                return "XCAP";
            }
            case 10: {
                return "EIMS";
            }
            case 11: {
                return "NOT_METERED";
            }
            case 12: {
                return "INTERNET";
            }
            case 13: {
                return "NOT_RESTRICTED";
            }
            case 14: {
                return "TRUSTED";
            }
            case 15: {
                return "NOT_VPN";
            }
            case 16: {
                return "VALIDATED";
            }
            case 17: {
                return "CAPTIVE_PORTAL";
            }
            case 18: {
                return "NOT_ROAMING";
            }
            case 19: {
                return "FOREGROUND";
            }
            case 20: {
                return "NOT_CONGESTED";
            }
            case 21: {
                return "NOT_SUSPENDED";
            }
            case 22: {
                return "OEM_PAID";
            }
            case 23: {
                return "MCX";
            }
            case 24: {
                return "PARTIAL_CONNECTIVITY";
            }
        }
        return Integer.toString(capability);
    }

    @UnsupportedAppUsage
    public static String transportNamesOf(int[] types) {
        StringJoiner joiner = new StringJoiner("|");
        if (types != null) {
            for (int t : types) {
                joiner.add(NetworkCapabilities.transportNameOf(t));
            }
        }
        return joiner.toString();
    }

    public static String transportNameOf(int transport) {
        if (!NetworkCapabilities.isValidTransport(transport)) {
            return "UNKNOWN";
        }
        return TRANSPORT_NAMES[transport];
    }

    private static void checkValidTransportType(int transport) {
        Preconditions.checkArgument(NetworkCapabilities.isValidTransport(transport), "Invalid TransportType " + transport);
    }

    private static boolean isValidCapability(int capability) {
        return capability >= 0 && capability <= 24;
    }

    private static void checkValidCapability(int capability) {
        Preconditions.checkArgument(NetworkCapabilities.isValidCapability(capability), "NetworkCapability " + capability + "out of range");
    }

    public boolean isMetered() {
        return !this.hasCapability(11);
    }

    private static interface NameOf {
        public String nameOf(int var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Transport {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface NetCapability {
    }
}

