/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkCapabilities;
import android.net.NetworkRequest;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.util.Log;
import android.util.SparseArray;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.AsyncChannel;
import com.android.internal.util.IndentingPrintWriter;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public class NetworkFactory
extends Handler {
    private static final boolean DBG = true;
    private static final boolean VDBG = false;
    private static final int BASE = 536576;
    public static final int CMD_REQUEST_NETWORK = 536576;
    public static final int CMD_CANCEL_REQUEST = 536577;
    private static final int CMD_SET_SCORE = 536578;
    private static final int CMD_SET_FILTER = 536579;
    public static final int EVENT_UNFULFILLABLE_REQUEST = 536580;
    private final Context mContext;
    private final ArrayList<Message> mPreConnectedQueue = new ArrayList();
    private AsyncChannel mAsyncChannel;
    private final String LOG_TAG;
    private final SparseArray<NetworkRequestInfo> mNetworkRequests = new SparseArray();
    private int mScore;
    private NetworkCapabilities mCapabilityFilter;
    private int mRefCount = 0;
    private Messenger mMessenger = null;
    private int mSerialNumber;

    @UnsupportedAppUsage
    public NetworkFactory(Looper looper, Context context, String logTag, NetworkCapabilities filter) {
        super(looper);
        this.LOG_TAG = logTag;
        this.mContext = context;
        this.mCapabilityFilter = filter;
    }

    public void register() {
        this.log("Registering NetworkFactory");
        if (this.mMessenger == null) {
            this.mMessenger = new Messenger(this);
            this.mSerialNumber = ConnectivityManager.from(this.mContext).registerNetworkFactory(this.mMessenger, this.LOG_TAG);
        }
    }

    public void unregister() {
        this.log("Unregistering NetworkFactory");
        if (this.mMessenger != null) {
            ConnectivityManager.from(this.mContext).unregisterNetworkFactory(this.mMessenger);
            this.mMessenger = null;
        }
    }

    @Override
    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 69633: {
                if (this.mAsyncChannel != null) {
                    this.log("Received new connection while already connected!");
                    break;
                }
                AsyncChannel ac = new AsyncChannel();
                ac.connected(null, this, msg.replyTo);
                ac.replyToMessage(msg, 69634, 0);
                this.mAsyncChannel = ac;
                for (Message m : this.mPreConnectedQueue) {
                    ac.sendMessage(m);
                }
                this.mPreConnectedQueue.clear();
                break;
            }
            case 69635: {
                if (this.mAsyncChannel == null) break;
                this.mAsyncChannel.disconnect();
                this.mAsyncChannel = null;
                break;
            }
            case 69636: {
                this.log("NetworkFactory channel lost");
                this.mAsyncChannel = null;
                break;
            }
            case 536576: {
                this.handleAddRequest((NetworkRequest)msg.obj, msg.arg1, msg.arg2);
                break;
            }
            case 536577: {
                this.handleRemoveRequest((NetworkRequest)msg.obj);
                break;
            }
            case 536578: {
                this.handleSetScore(msg.arg1);
                break;
            }
            case 536579: {
                this.handleSetFilter((NetworkCapabilities)msg.obj);
            }
        }
    }

    @VisibleForTesting
    protected void handleAddRequest(NetworkRequest request, int score) {
        this.handleAddRequest(request, score, -1);
    }

    @VisibleForTesting
    protected void handleAddRequest(NetworkRequest request, int score, int servingFactorySerialNumber) {
        NetworkRequestInfo n = this.mNetworkRequests.get(request.requestId);
        if (n == null) {
            this.log("got request " + request + " with score " + score + " and serial " + servingFactorySerialNumber);
            n = new NetworkRequestInfo(request, score, servingFactorySerialNumber);
            this.mNetworkRequests.put(n.request.requestId, n);
        } else {
            n.score = score;
            n.factorySerialNumber = servingFactorySerialNumber;
        }
        this.evalRequest(n);
    }

    @VisibleForTesting
    protected void handleRemoveRequest(NetworkRequest request) {
        NetworkRequestInfo n = this.mNetworkRequests.get(request.requestId);
        if (n != null) {
            this.mNetworkRequests.remove(request.requestId);
            if (n.requested) {
                this.releaseNetworkFor(n.request);
            }
        }
    }

    private void handleSetScore(int score) {
        this.mScore = score;
        this.evalRequests();
    }

    private void handleSetFilter(NetworkCapabilities netCap) {
        this.mCapabilityFilter = netCap;
        this.evalRequests();
    }

    public boolean acceptRequest(NetworkRequest request, int score) {
        return true;
    }

    private void evalRequest(NetworkRequestInfo n) {
        if (this.shouldNeedNetworkFor(n)) {
            this.needNetworkFor(n.request, n.score);
            n.requested = true;
        } else if (this.shouldReleaseNetworkFor(n)) {
            this.releaseNetworkFor(n.request);
            n.requested = false;
        }
    }

    private boolean shouldNeedNetworkFor(NetworkRequestInfo n) {
        return !n.requested && (n.score < this.mScore || n.factorySerialNumber == this.mSerialNumber) && n.request.networkCapabilities.satisfiedByNetworkCapabilities(this.mCapabilityFilter) && this.acceptRequest(n.request, n.score);
    }

    private boolean shouldReleaseNetworkFor(NetworkRequestInfo n) {
        return n.requested && (n.score > this.mScore && n.factorySerialNumber != this.mSerialNumber || !n.request.networkCapabilities.satisfiedByNetworkCapabilities(this.mCapabilityFilter) || !this.acceptRequest(n.request, n.score));
    }

    private void evalRequests() {
        for (int i = 0; i < this.mNetworkRequests.size(); ++i) {
            NetworkRequestInfo n = this.mNetworkRequests.valueAt(i);
            this.evalRequest(n);
        }
    }

    protected void reevaluateAllRequests() {
        this.post(() -> this.evalRequests());
    }

    protected void releaseRequestAsUnfulfillableByAnyFactory(NetworkRequest r) {
        this.post(() -> {
            this.log("releaseRequestAsUnfulfillableByAnyFactory: " + r);
            Message msg = this.obtainMessage(536580, r);
            if (this.mAsyncChannel != null) {
                this.mAsyncChannel.sendMessage(msg);
            } else {
                this.mPreConnectedQueue.add(msg);
            }
        });
    }

    protected void startNetwork() {
    }

    protected void stopNetwork() {
    }

    protected void needNetworkFor(NetworkRequest networkRequest, int score) {
        if (++this.mRefCount == 1) {
            this.startNetwork();
        }
    }

    protected void releaseNetworkFor(NetworkRequest networkRequest) {
        if (--this.mRefCount == 0) {
            this.stopNetwork();
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public void setScoreFilter(int score) {
        this.sendMessage(this.obtainMessage(536578, score, 0));
    }

    public void setCapabilityFilter(NetworkCapabilities netCap) {
        this.sendMessage(this.obtainMessage(536579, new NetworkCapabilities(netCap)));
    }

    @VisibleForTesting
    protected int getRequestCount() {
        return this.mNetworkRequests.size();
    }

    public int getSerialNumber() {
        return this.mSerialNumber;
    }

    protected void log(String s) {
        Log.d(this.LOG_TAG, s);
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public void dump(FileDescriptor fd, PrintWriter writer, String[] args) {
        IndentingPrintWriter pw = new IndentingPrintWriter((Writer)writer, "  ");
        pw.println(this.toString());
        pw.increaseIndent();
        for (int i = 0; i < this.mNetworkRequests.size(); ++i) {
            pw.println(this.mNetworkRequests.valueAt(i));
        }
        pw.decreaseIndent();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{").append(this.LOG_TAG).append(" - mSerialNumber=").append(this.mSerialNumber).append(", ScoreFilter=").append(this.mScore).append(", Filter=").append(this.mCapabilityFilter).append(", requests=").append(this.mNetworkRequests.size()).append(", refCount=").append(this.mRefCount).append("}");
        return sb.toString();
    }

    private class NetworkRequestInfo {
        public final NetworkRequest request;
        public int score;
        public boolean requested;
        public int factorySerialNumber;

        NetworkRequestInfo(NetworkRequest request, int score, int factorySerialNumber) {
            this.request = request;
            this.score = score;
            this.requested = false;
            this.factorySerialNumber = factorySerialNumber;
        }

        public String toString() {
            return "{" + this.request + ", score=" + this.score + ", requested=" + this.requested + "}";
        }
    }

    public static class SerialNumber {
        public static final int NONE = -1;
        public static final int VPN = -2;
        private static final AtomicInteger sNetworkFactorySerialNumber = new AtomicInteger(1);

        public static final int nextSerialNumber() {
            return sNetworkFactorySerialNumber.getAndIncrement();
        }
    }
}

