/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.INetworkMonitor;
import android.net.LinkProperties;
import android.net.NetworkCapabilities;
import android.net.PrivateDnsConfigParcel;
import android.os.Binder;
import android.os.RemoteException;
import android.util.Log;

public class NetworkMonitorManager {
    private final INetworkMonitor mNetworkMonitor;
    private final String mTag;

    public NetworkMonitorManager(INetworkMonitor networkMonitorManager, String tag) {
        this.mNetworkMonitor = networkMonitorManager;
        this.mTag = tag;
    }

    public NetworkMonitorManager(INetworkMonitor networkMonitorManager) {
        this(networkMonitorManager, NetworkMonitorManager.class.getSimpleName());
    }

    private void log(String s, Throwable e) {
        Log.e(this.mTag, s, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean start() {
        long token = Binder.clearCallingIdentity();
        try {
            this.mNetworkMonitor.start();
            boolean bl = true;
            return bl;
        }
        catch (RemoteException e) {
            this.log("Error in start", e);
            boolean bl = false;
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean launchCaptivePortalApp() {
        long token = Binder.clearCallingIdentity();
        try {
            this.mNetworkMonitor.launchCaptivePortalApp();
            boolean bl = true;
            return bl;
        }
        catch (RemoteException e) {
            this.log("Error in launchCaptivePortalApp", e);
            boolean bl = false;
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean notifyCaptivePortalAppFinished(int response) {
        long token = Binder.clearCallingIdentity();
        try {
            this.mNetworkMonitor.notifyCaptivePortalAppFinished(response);
            boolean bl = true;
            return bl;
        }
        catch (RemoteException e) {
            this.log("Error in notifyCaptivePortalAppFinished", e);
            boolean bl = false;
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setAcceptPartialConnectivity() {
        long token = Binder.clearCallingIdentity();
        try {
            this.mNetworkMonitor.setAcceptPartialConnectivity();
            boolean bl = true;
            return bl;
        }
        catch (RemoteException e) {
            this.log("Error in setAcceptPartialConnectivity", e);
            boolean bl = false;
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean forceReevaluation(int uid) {
        long token = Binder.clearCallingIdentity();
        try {
            this.mNetworkMonitor.forceReevaluation(uid);
            boolean bl = true;
            return bl;
        }
        catch (RemoteException e) {
            this.log("Error in forceReevaluation", e);
            boolean bl = false;
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean notifyPrivateDnsChanged(PrivateDnsConfigParcel config) {
        long token = Binder.clearCallingIdentity();
        try {
            this.mNetworkMonitor.notifyPrivateDnsChanged(config);
            boolean bl = true;
            return bl;
        }
        catch (RemoteException e) {
            this.log("Error in notifyPrivateDnsChanged", e);
            boolean bl = false;
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean notifyDnsResponse(int returnCode) {
        long token = Binder.clearCallingIdentity();
        try {
            this.mNetworkMonitor.notifyDnsResponse(returnCode);
            boolean bl = true;
            return bl;
        }
        catch (RemoteException e) {
            this.log("Error in notifyDnsResponse", e);
            boolean bl = false;
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean notifyNetworkConnected(LinkProperties lp, NetworkCapabilities nc) {
        long token = Binder.clearCallingIdentity();
        try {
            this.mNetworkMonitor.notifyNetworkConnected(lp, nc);
            boolean bl = true;
            return bl;
        }
        catch (RemoteException e) {
            this.log("Error in notifyNetworkConnected", e);
            boolean bl = false;
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean notifyNetworkDisconnected() {
        long token = Binder.clearCallingIdentity();
        try {
            this.mNetworkMonitor.notifyNetworkDisconnected();
            boolean bl = true;
            return bl;
        }
        catch (RemoteException e) {
            this.log("Error in notifyNetworkDisconnected", e);
            boolean bl = false;
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean notifyLinkPropertiesChanged(LinkProperties lp) {
        long token = Binder.clearCallingIdentity();
        try {
            this.mNetworkMonitor.notifyLinkPropertiesChanged(lp);
            boolean bl = true;
            return bl;
        }
        catch (RemoteException e) {
            this.log("Error in notifyLinkPropertiesChanged", e);
            boolean bl = false;
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean notifyNetworkCapabilitiesChanged(NetworkCapabilities nc) {
        long token = Binder.clearCallingIdentity();
        try {
            this.mNetworkMonitor.notifyNetworkCapabilitiesChanged(nc);
            boolean bl = true;
            return bl;
        }
        catch (RemoteException e) {
            this.log("Error in notifyNetworkCapabilitiesChanged", e);
            boolean bl = false;
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }
}

