/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.annotation.SystemApi;
import android.content.Context;
import java.util.ArrayList;
import java.util.Arrays;

@SystemApi
public class NetworkStack {
    @SystemApi
    public static final String PERMISSION_MAINLINE_NETWORK_STACK = "android.permission.MAINLINE_NETWORK_STACK";

    private NetworkStack() {
    }

    public static void checkNetworkStackPermission(Context context) {
        NetworkStack.checkNetworkStackPermissionOr(context, new String[0]);
    }

    public static void checkNetworkStackPermissionOr(Context context, String ... otherPermissions) {
        ArrayList<String> permissions = new ArrayList<String>(Arrays.asList(otherPermissions));
        permissions.add("android.permission.NETWORK_STACK");
        permissions.add(PERMISSION_MAINLINE_NETWORK_STACK);
        NetworkStack.enforceAnyPermissionOf(context, permissions.toArray(new String[0]));
    }

    private static void enforceAnyPermissionOf(Context context, String ... permissions) {
        if (!NetworkStack.checkAnyPermissionOf(context, permissions)) {
            throw new SecurityException("Requires one of the following permissions: " + String.join((CharSequence)", ", permissions) + ".");
        }
    }

    private static boolean checkAnyPermissionOf(Context context, String ... permissions) {
        for (String permission2 : permissions) {
            if (context.checkCallingOrSelfPermission(permission2) != 0) continue;
            return true;
        }
        return false;
    }
}

