/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.net.IIpMemoryStoreCallbacks;
import android.net.INetworkMonitorCallbacks;
import android.net.INetworkStackConnector;
import android.net.Network;
import android.net.dhcp.DhcpServingParamsParcel;
import android.net.dhcp.IDhcpServerCallbacks;
import android.net.ip.IIpClientCallbacks;
import android.net.util.SharedLog;
import android.os.Binder;
import android.os.Build;
import android.os.Environment;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.UserHandle;
import android.provider.DeviceConfig;
import android.util.ArraySet;
import android.util.Slog;
import com.android.internal.annotations.GuardedBy;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;

public class NetworkStackClient {
    private static final String TAG = NetworkStackClient.class.getSimpleName();
    private static final int NETWORKSTACK_TIMEOUT_MS = 10000;
    private static final String IN_PROCESS_SUFFIX = ".InProcess";
    private static final String PREFS_FILE = "NetworkStackClientPrefs.xml";
    private static final String PREF_KEY_LAST_CRASH_TIME = "lastcrash_time";
    private static final String CONFIG_MIN_CRASH_INTERVAL_MS = "min_crash_interval";
    private static final String CONFIG_MIN_UPTIME_BEFORE_CRASH_MS = "min_uptime_before_crash";
    private static final String CONFIG_ALWAYS_RATELIMIT_NETWORKSTACK_CRASH = "always_ratelimit_networkstack_crash";
    private static final long DEFAULT_MIN_CRASH_INTERVAL_MS = 21600000L;
    private static final long DEFAULT_MIN_UPTIME_BEFORE_CRASH_MS = 1800000L;
    private static NetworkStackClient sInstance;
    @GuardedBy(value={"mPendingNetStackRequests"})
    private final ArrayList<NetworkStackCallback> mPendingNetStackRequests = new ArrayList();
    @GuardedBy(value={"mPendingNetStackRequests"})
    private INetworkStackConnector mConnector;
    @GuardedBy(value={"mLog"})
    private final SharedLog mLog = new SharedLog(TAG);
    private volatile boolean mWasSystemServerInitialized = false;
    @GuardedBy(value={"mHealthListeners"})
    private final ArraySet<NetworkStackHealthListener> mHealthListeners = new ArraySet();

    private NetworkStackClient() {
    }

    public static synchronized NetworkStackClient getInstance() {
        if (sInstance == null) {
            sInstance = new NetworkStackClient();
        }
        return sInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerHealthListener(NetworkStackHealthListener listener) {
        ArraySet<NetworkStackHealthListener> arraySet = this.mHealthListeners;
        synchronized (arraySet) {
            this.mHealthListeners.add(listener);
        }
    }

    public void makeDhcpServer(String ifName, DhcpServingParamsParcel params, IDhcpServerCallbacks cb) {
        this.requestConnector(connector -> {
            try {
                connector.makeDhcpServer(ifName, params, cb);
            }
            catch (RemoteException e) {
                e.rethrowFromSystemServer();
            }
        });
    }

    public void makeIpClient(String ifName, IIpClientCallbacks cb) {
        this.requestConnector(connector -> {
            try {
                connector.makeIpClient(ifName, cb);
            }
            catch (RemoteException e) {
                e.rethrowFromSystemServer();
            }
        });
    }

    public void makeNetworkMonitor(Network network, String name, INetworkMonitorCallbacks cb) {
        this.requestConnector(connector -> {
            try {
                connector.makeNetworkMonitor(network, name, cb);
            }
            catch (RemoteException e) {
                e.rethrowFromSystemServer();
            }
        });
    }

    public void fetchIpMemoryStore(IIpMemoryStoreCallbacks cb) {
        this.requestConnector(connector -> {
            try {
                connector.fetchIpMemoryStore(cb);
            }
            catch (RemoteException e) {
                e.rethrowFromSystemServer();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerNetworkStackService(IBinder service) {
        ArrayList<NetworkStackCallback> requests;
        INetworkStackConnector connector = INetworkStackConnector.Stub.asInterface(service);
        ServiceManager.addService("network_stack", service, false, 6);
        this.log("Network stack service registered");
        ArrayList<NetworkStackCallback> arrayList = this.mPendingNetStackRequests;
        synchronized (arrayList) {
            requests = new ArrayList<NetworkStackCallback>(this.mPendingNetStackRequests);
            this.mPendingNetStackRequests.clear();
            this.mConnector = connector;
        }
        for (NetworkStackCallback r : requests) {
            r.onNetworkStackConnected(connector);
        }
    }

    public void init() {
        this.log("Network stack init");
        this.mWasSystemServerInitialized = true;
    }

    public void start(Context context) {
        this.log("Starting network stack");
        PackageManager pm = context.getPackageManager();
        Intent intent = this.getNetworkStackIntent(pm, true);
        if (intent == null) {
            intent = this.getNetworkStackIntent(pm, false);
            this.log("Starting network stack process");
        } else {
            this.log("Starting network stack in-process");
        }
        if (intent == null) {
            this.maybeCrashWithTerribleFailure("Could not resolve the network stack", context, null);
            return;
        }
        String packageName = intent.getComponent().getPackageName();
        if (!context.bindServiceAsUser(intent, new NetworkStackConnection(context, packageName), 65, UserHandle.SYSTEM)) {
            this.maybeCrashWithTerribleFailure("Could not bind to network stack in-process, or in app with " + intent, context, packageName);
            return;
        }
        this.log("Network stack service start requested");
    }

    private Intent getNetworkStackIntent(PackageManager pm, boolean inSystemProcess) {
        int expectedUid;
        String baseAction = INetworkStackConnector.class.getName();
        Intent intent = new Intent(inSystemProcess ? baseAction + IN_PROCESS_SUFFIX : baseAction);
        ComponentName comp = intent.resolveSystemService(pm, 0);
        if (comp == null) {
            return null;
        }
        intent.setComponent(comp);
        int uid = -1;
        try {
            uid = pm.getPackageUidAsUser(comp.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            this.logWtf("Network stack package not found", e);
        }
        int n = expectedUid = inSystemProcess ? 1000 : 1073;
        if (uid != expectedUid) {
            throw new SecurityException("Invalid network stack UID: " + uid);
        }
        if (!inSystemProcess) {
            this.checkNetworkStackPermission(pm, comp);
        }
        return intent;
    }

    private void checkNetworkStackPermission(PackageManager pm, ComponentName comp) {
        int hasPermission = pm.checkPermission("android.permission.MAINLINE_NETWORK_STACK", comp.getPackageName());
        if (hasPermission != 0) {
            throw new SecurityException("Network stack does not have permission android.permission.MAINLINE_NETWORK_STACK");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeCrashWithTerribleFailure(String message, Context context, String packageName) {
        boolean haveKnownRecentCrash;
        this.logWtf(message, null);
        long uptime = SystemClock.elapsedRealtime();
        long now = System.currentTimeMillis();
        long minCrashIntervalMs = DeviceConfig.getLong("connectivity", CONFIG_MIN_CRASH_INTERVAL_MS, 21600000L);
        long minUptimeBeforeCrash = DeviceConfig.getLong("connectivity", CONFIG_MIN_UPTIME_BEFORE_CRASH_MS, 1800000L);
        boolean alwaysRatelimit = DeviceConfig.getBoolean("connectivity", CONFIG_ALWAYS_RATELIMIT_NETWORKSTACK_CRASH, false);
        SharedPreferences prefs = this.getSharedPreferences(context);
        long lastCrashTime = this.tryGetLastCrashTime(prefs);
        boolean alwaysCrash = Build.IS_DEBUGGABLE && !alwaysRatelimit;
        boolean justBooted = uptime < minUptimeBeforeCrash;
        boolean haveLastCrashTime = lastCrashTime != 0L && lastCrashTime < now;
        boolean bl = haveKnownRecentCrash = haveLastCrashTime && now < lastCrashTime + minCrashIntervalMs;
        if (alwaysCrash || !justBooted && !haveKnownRecentCrash) {
            this.tryWriteLastCrashTime(prefs, now);
            throw new IllegalStateException(message);
        }
        if (packageName != null) {
            ArraySet<NetworkStackHealthListener> listeners;
            ArraySet<NetworkStackHealthListener> arraySet = this.mHealthListeners;
            synchronized (arraySet) {
                listeners = new ArraySet<NetworkStackHealthListener>(this.mHealthListeners);
            }
            for (NetworkStackHealthListener listener : listeners) {
                listener.onNetworkStackFailure(packageName);
            }
        }
    }

    private SharedPreferences getSharedPreferences(Context context) {
        try {
            File prefsFile = new File(Environment.getDataSystemDeDirectory(0), PREFS_FILE);
            return context.createDeviceProtectedStorageContext().getSharedPreferences(prefsFile, 0);
        }
        catch (Throwable e) {
            this.logWtf("Error loading shared preferences", e);
            return null;
        }
    }

    private long tryGetLastCrashTime(SharedPreferences prefs) {
        if (prefs == null) {
            return 0L;
        }
        try {
            return prefs.getLong(PREF_KEY_LAST_CRASH_TIME, 0L);
        }
        catch (Throwable e) {
            this.logWtf("Error getting last crash time", e);
            return 0L;
        }
    }

    private void tryWriteLastCrashTime(SharedPreferences prefs, long value) {
        if (prefs == null) {
            return;
        }
        try {
            prefs.edit().putLong(PREF_KEY_LAST_CRASH_TIME, value).commit();
        }
        catch (Throwable e) {
            this.logWtf("Error writing last crash time", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void log(String message) {
        SharedLog sharedLog = this.mLog;
        synchronized (sharedLog) {
            this.mLog.log(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logWtf(String message, Throwable e) {
        Slog.wtf(TAG, message);
        SharedLog sharedLog = this.mLog;
        synchronized (sharedLog) {
            this.mLog.e(message, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loge(String message, Throwable e) {
        SharedLog sharedLog = this.mLog;
        synchronized (sharedLog) {
            this.mLog.e(message, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logi(String message) {
        SharedLog sharedLog = this.mLog;
        synchronized (sharedLog) {
            this.mLog.i(message);
        }
    }

    private INetworkStackConnector getRemoteConnector() {
        IBinder connector;
        try {
            long before = System.currentTimeMillis();
            while ((connector = ServiceManager.getService("network_stack")) == null) {
                Thread.sleep(20L);
                if (System.currentTimeMillis() - before <= 10000L) continue;
                this.loge("Timeout waiting for NetworkStack connector", null);
                return null;
            }
        }
        catch (InterruptedException e) {
            this.loge("Error waiting for NetworkStack connector", e);
            return null;
        }
        return INetworkStackConnector.Stub.asInterface(connector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestConnector(NetworkStackCallback request) {
        INetworkStackConnector connector;
        int caller = Binder.getCallingUid();
        if (caller != 1000 && !UserHandle.isSameApp(caller, 1002) && !UserHandle.isSameApp(caller, 1001)) {
            throw new SecurityException("Only the system server should try to bind to the network stack.");
        }
        if (!this.mWasSystemServerInitialized) {
            INetworkStackConnector connector2 = this.getRemoteConnector();
            ArrayList<NetworkStackCallback> arrayList = this.mPendingNetStackRequests;
            synchronized (arrayList) {
                this.mConnector = connector2;
            }
            request.onNetworkStackConnected(connector2);
            return;
        }
        ArrayList<NetworkStackCallback> arrayList = this.mPendingNetStackRequests;
        synchronized (arrayList) {
            connector = this.mConnector;
            if (connector == null) {
                this.mPendingNetStackRequests.add(request);
                return;
            }
        }
        request.onNetworkStackConnected(connector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(PrintWriter pw) {
        int requestsQueueLength;
        this.mLog.dump(null, pw, null);
        ArrayList<NetworkStackCallback> arrayList = this.mPendingNetStackRequests;
        synchronized (arrayList) {
            requestsQueueLength = this.mPendingNetStackRequests.size();
        }
        pw.println();
        pw.println("pendingNetStackRequests length: " + requestsQueueLength);
    }

    private class NetworkStackConnection
    implements ServiceConnection {
        private final Context mContext;
        private final String mPackageName;

        private NetworkStackConnection(Context context, String packageName) {
            this.mContext = context;
            this.mPackageName = packageName;
        }

        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
            NetworkStackClient.this.logi("Network stack service connected");
            NetworkStackClient.this.registerNetworkStackService(service);
        }

        @Override
        public void onServiceDisconnected(ComponentName name) {
            NetworkStackClient.this.maybeCrashWithTerribleFailure("Lost network stack", this.mContext, this.mPackageName);
        }
    }

    public static interface NetworkStackHealthListener {
        public void onNetworkStackFailure(String var1);
    }

    private static interface NetworkStackCallback {
        public void onNetworkStackConnected(INetworkStackConnector var1);
    }
}

